/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium;

import com.falsepattern.triangulator.api.ToggleableTessellator;
import cpw.mods.fml.common.Loader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import makamys.neodymium.Constants;
import makamys.neodymium.config.Config;
import makamys.neodymium.util.virtualjar.IVirtualJar;
import makamys.neodymium.util.virtualjar.VirtualJar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.settings.GameSettings;
import org.lwjgl.opengl.GLContext;

public class Compat {
    private static boolean isGL33Supported;
    private static boolean wasAdvancedOpenGLEnabled;
    private static int notEnoughVRAMAmountMB;
    private static boolean IS_RPLE_PRESENT;
    private static boolean IS_FALSE_TWEAKS_PRESENT;
    private static boolean IS_HODGEPODGE_SPEEDUP_ANIMATIONS_ENABLED;
    private static boolean IS_ANGELICA_SPEEDUP_ANIMATIONS_ENABLED;
    private static boolean isShadersEnabled;

    public static void init() {
        isGL33Supported = GLContext.getCapabilities().OpenGL33;
        if (Loader.isModLoaded((String)"triangulator")) {
            Compat.disableTriangulator();
        }
        if (Loader.isModLoaded((String)"rple")) {
            IS_RPLE_PRESENT = true;
        }
        if (Loader.isModLoaded((String)"falsetweaks")) {
            IS_FALSE_TWEAKS_PRESENT = true;
        }
        IS_HODGEPODGE_SPEEDUP_ANIMATIONS_ENABLED = Compat.checkIfHodgepodgeSpeedupAnimationsIsEnabled();
        IS_ANGELICA_SPEEDUP_ANIMATIONS_ENABLED = Compat.checkIfAngelicaSpeedupAnimationsIsEnabled();
        Constants.LOGGER.debug("speedupAnimations compat fix will " + (Compat.isSpeedupAnimationsEnabled() ? "" : "not ") + "be enabled");
    }

    public static boolean enableVanillaChunkMeshes() {
        return Config.enableVanillaChunkMeshes && !Compat.isFalseTweaksModPresent();
    }

    public static boolean keepRenderListLogic() {
        return Compat.enableVanillaChunkMeshes() || Constants.KEEP_RENDER_LIST_LOGIC;
    }

    private static boolean checkIfHodgepodgeSpeedupAnimationsIsEnabled() {
        Boolean result = null;
        if (Loader.isModLoaded((String)"hodgepodge")) {
            try {
                Boolean speedupAnimations;
                Class<?> FixesConfigCls = Class.forName("com.mitchej123.hodgepodge.config.FixesConfig");
                result = speedupAnimations = (Boolean)FixesConfigCls.getField("speedupAnimations").get(null);
            }
            catch (Exception e) {
                Constants.LOGGER.debug("Failed to determine if Hodgepodge's speedupAnimations is enabled using new config class, trying old one.", (Throwable)e);
            }
            if (result == null) {
                try {
                    Class<?> CommonCls = Class.forName("com.mitchej123.hodgepodge.Common");
                    Object config = CommonCls.getField("config").get(null);
                    Class<?> configCls = config.getClass();
                    boolean speedupAnimations = (Boolean)configCls.getField("speedupAnimations").get(config);
                    result = speedupAnimations;
                }
                catch (Exception e) {
                    Constants.LOGGER.debug("Failed to determine if Hodgepodge's speedupAnimations is enabled using old config class.", (Throwable)e);
                }
            }
            if (result != null) {
                Constants.LOGGER.debug("Hodgepodge's speedupAnimations is set to " + result);
            } else {
                Constants.LOGGER.warn("Failed to determine if Hodgepodge's speedupAnimations is enabled, assuming false");
                result = false;
            }
        } else {
            Constants.LOGGER.debug("Hodgepodge is missing, treating its speedupAnimations as false");
            result = false;
        }
        return result;
    }

    private static boolean checkIfAngelicaSpeedupAnimationsIsEnabled() {
        Boolean result = null;
        if (Loader.isModLoaded((String)"angelica")) {
            try {
                Boolean speedupAnimations;
                Class<?> AngelicaConfigCls = Class.forName("com.gtnewhorizons.angelica.config.AngelicaConfig");
                result = speedupAnimations = (Boolean)AngelicaConfigCls.getField("speedupAnimations").get(null);
            }
            catch (Exception e) {
                Constants.LOGGER.debug("Failed to determine if Angelica's speedupAnimations is enabled.", (Throwable)e);
            }
            if (result != null) {
                Constants.LOGGER.debug("Angelica's speedupAnimations is set to " + result);
            } else {
                Constants.LOGGER.warn("Failed to determine if Angelica's speedupAnimations is enabled, assuming false");
                result = false;
            }
        } else {
            Constants.LOGGER.debug("Angelica is missing, treating its speedupAnimations as false");
            result = false;
        }
        return result;
    }

    public static boolean isRPLEModPresent() {
        return IS_RPLE_PRESENT;
    }

    public static boolean isFalseTweaksModPresent() {
        return IS_FALSE_TWEAKS_PRESENT;
    }

    public static boolean isSpeedupAnimationsEnabled() {
        return IS_HODGEPODGE_SPEEDUP_ANIMATIONS_ENABLED || IS_ANGELICA_SPEEDUP_ANIMATIONS_ENABLED;
    }

    public static boolean isOptiFineShadersEnabled() {
        return isShadersEnabled;
    }

    public static void updateOptiFineShadersState() {
        try {
            Class<?> shaders = Class.forName("shadersmod.client.Shaders");
            try {
                String shaderPack = (String)shaders.getMethod("getShaderPackName", new Class[0]).invoke(null, new Object[0]);
                if (shaderPack != null) {
                    isShadersEnabled = true;
                    return;
                }
            }
            catch (Exception e) {
                Constants.LOGGER.warn("Failed to get shader pack name");
                e.printStackTrace();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        isShadersEnabled = false;
    }

    private static void disableTriangulator() {
        ((ToggleableTessellator)Tessellator.field_78398_a).disableTriangulator();
    }

    public static void getCompatibilityWarnings(List<Warning> warns, List<Warning> criticalWarns, boolean statusCommand) {
        if (Minecraft.func_71410_x().field_71474_y.field_74349_h) {
            warns.add(new Warning("Advanced OpenGL is enabled, performance may be poor." + (statusCommand ? " Click here to disable it." : "")).chatAction("neodymium disable_advanced_opengl"));
        }
        if (!isGL33Supported) {
            criticalWarns.add(new Warning("OpenGL 3.3 is not supported."));
        }
        if (Compat.detectedNotEnoughVRAM()) {
            criticalWarns.add(new Warning("Not enough VRAM"));
        }
    }

    public static boolean hasChanged() {
        boolean changed = false;
        boolean advGL = Minecraft.func_71410_x().field_71474_y.field_74349_h;
        if (advGL != wasAdvancedOpenGLEnabled) {
            changed = true;
        }
        wasAdvancedOpenGLEnabled = advGL;
        return changed;
    }

    public static void onNotEnoughVRAM(int amountMB) {
        notEnoughVRAMAmountMB = amountMB;
    }

    public static void reset() {
        notEnoughVRAMAmountMB = -1;
    }

    private static boolean detectedNotEnoughVRAM() {
        return Config.VRAMSize == notEnoughVRAMAmountMB;
    }

    public static void forceEnableOptiFineDetectionOfFastCraft() {
        if (Compat.class.getResource("/fastcraft/Tweaker.class") != null) {
            Constants.LOGGER.info("FastCraft is present, applying hack to forcingly enable FastCraft's OptiFine compat");
            VirtualJar.add(new OptiFineStubVirtualJar());
        }
    }

    public static boolean disableAdvancedOpenGL() {
        GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
        if (gameSettings.field_74349_h) {
            gameSettings.field_74349_h = false;
            gameSettings.func_74303_b();
            return true;
        }
        return false;
    }

    static {
        notEnoughVRAMAmountMB = -1;
    }

    public static class Warning {
        public String text;
        public String chatAction;

        public Warning(String text) {
            this.text = text;
        }

        public Warning chatAction(String command) {
            this.chatAction = command;
            return this;
        }
    }

    private static class OptiFineStubVirtualJar
    implements IVirtualJar {
        private OptiFineStubVirtualJar() {
        }

        @Override
        public String getName() {
            return "optifine-stub";
        }

        @Override
        public InputStream getInputStream(String path) {
            if (path.equals("/optifine/OptiFineForgeTweaker.class")) {
                Constants.LOGGER.debug("Returning a dummy /optifine/OptiFineForgeTweaker.class to force FastCraft compat.");
                return new ByteArrayInputStream(new byte[0]);
            }
            return null;
        }
    }
}

