/*
 * Decompiled with CFR 0.152.
 */
package net.moecraft.nechar;

import net.moecraft.nechar.NotEnoughCharacters;
import net.vfyjxf.nechar.NechConfig;

public class NecharUtils {
    private static String[] voltageListWithLetterV = new String[]{"ulv", "lv", "mv", "hv", "ev", "iv", "luv", "uv", "uhv", "uev", "uiv", "umv", "uxv"};

    private static String deleteComma(String str) {
        return str.replaceAll("(?<=[0-9]),(?=[0-9])", "");
    }

    private static String replaceExtraChars(String str) {
        if (str.contains("\ud872")) {
            str = str.replaceAll("\ud872\udf3b", "\ue900").replaceAll("\ud872\udf4a", "\ue901").replaceAll("\ud872\udf73", "\ue902").replaceAll("\ud872\udf5b", "\ue903").replaceAll("\ud872\udf76", "\ue904").replaceAll("\ud872\udf2d", "\ue907");
        }
        if (str.contains("\ud86d")) {
            str = str.replaceAll("\ud86d\udffc", "\ue906").replaceAll("\ud86d\udce7", "\ue90a").replaceAll("\ud86d\udff7", "\ue90c");
        }
        return str;
    }

    private static boolean containWithVoltage(String voltage, String sourseText, String searchText) {
        if (!searchText.contains(voltage)) {
            return false;
        }
        if (!sourseText.contains(voltage)) {
            return false;
        }
        String[] sList = searchText.split(voltage, 2);
        if (sList.length == 2 && !NotEnoughCharacters.CONTEXT.contains(sourseText, sList[1])) {
            return false;
        }
        return NotEnoughCharacters.CONTEXT.contains(sourseText, sList[0]);
    }

    public static boolean contain(String sourseText, String searchText, Boolean enableSpecialSearch) {
        sourseText = NecharUtils.replaceExtraChars(sourseText);
        searchText = NecharUtils.replaceExtraChars(searchText);
        if (NechConfig.enableIgnoreComma && !searchText.contains(",")) {
            sourseText = NecharUtils.deleteComma(sourseText);
            searchText = NecharUtils.deleteComma(searchText);
        }
        if (NotEnoughCharacters.CONTEXT.contains(sourseText, searchText)) {
            return true;
        }
        if (!enableSpecialSearch.booleanValue()) {
            return false;
        }
        if (NecharUtils.containWithVoltage("zpm", sourseText = sourseText.toLowerCase(), searchText = searchText.toLowerCase()) || NecharUtils.containWithVoltage("max", sourseText, searchText)) {
            return true;
        }
        if (!sourseText.contains("v") && !searchText.contains("v")) {
            return false;
        }
        for (String name : voltageListWithLetterV) {
            if (!NecharUtils.containWithVoltage(name, sourseText, searchText)) continue;
            return true;
        }
        return false;
    }
}

