/*
 * Decompiled with CFR 0.152.
 */
package net.moecraft.nechar;

import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.SearchField;
import codechicken.nei.SearchTokenParser;
import codechicken.nei.api.ItemFilter;
import java.util.List;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import net.minecraft.client.resources.Language;
import net.minecraft.util.EnumChatFormatting;

public class NecharSearchParserProvider
implements SearchTokenParser.ISearchParserProvider {
    protected final List<Language> matchingLanguages;
    protected final BiFunction<String, Pattern, ItemFilter> createFilter;
    protected final String name;
    protected final char prefix;
    protected final EnumChatFormatting highlightedColor;

    public NecharSearchParserProvider(char prefix, String name, EnumChatFormatting highlightedColor, BiFunction<String, Pattern, ItemFilter> createFilter, List<Language> matchingLanguages) {
        this.prefix = prefix;
        this.name = name;
        this.highlightedColor = highlightedColor;
        this.createFilter = createFilter;
        this.matchingLanguages = matchingLanguages;
    }

    public ItemFilter getFilter(String searchText) {
        Pattern pattern = SearchField.getPattern((String)searchText);
        if (pattern != null) {
            ItemFilter filter = this.createFilter.apply(searchText, pattern);
            return filter == null ? new ItemList.NothingItemFilter() : filter;
        }
        return new ItemList.NothingItemFilter();
    }

    public List<Language> getMatchingLanguages() {
        return this.matchingLanguages;
    }

    public char getPrefix() {
        return this.prefix;
    }

    public EnumChatFormatting getHighlightedColor() {
        return this.highlightedColor;
    }

    public SearchTokenParser.SearchMode getSearchMode() {
        return SearchTokenParser.SearchMode.fromInt((int)NEIClientConfig.getIntSetting((String)("inventory.search." + this.name + "SearchMode")));
    }
}

