/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.internal;

import com.gtnewhorizons.modularui.ModularUI;
import com.gtnewhorizons.modularui.api.screen.IContainerCreator;
import com.gtnewhorizons.modularui.api.screen.IGuiCreator;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class InternalUIMapper
implements IGuiHandler {
    private static InternalUIMapper INSTANCE;
    private int id;
    private final List<IContainerCreator> serverContainers;
    private final List<IGuiCreator> clientGuis;

    public static InternalUIMapper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InternalUIMapper();
        }
        return INSTANCE;
    }

    public InternalUIMapper() {
        if (ModularUI.INSTANCE == null) {
            throw new NullPointerException("Something went wrong! Mod instance should not be null!");
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)ModularUI.INSTANCE, (IGuiHandler)this);
        this.serverContainers = new ArrayList<IContainerCreator>();
        this.clientGuis = new ArrayList<IGuiCreator>();
    }

    public <CC extends IContainerCreator, GC extends IGuiCreator> int register(CC containerCreator, GC guiCreator) {
        this.serverContainers.add(containerCreator);
        this.clientGuis.add(guiCreator);
        return this.id++;
    }

    @Nullable
    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        return this.serverContainers.get(id).create(player, world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        Object screen = this.clientGuis.get(id).create(player, world, x, y, z);
        if (screen != null && !(screen instanceof GuiScreen)) {
            throw new RuntimeException("The returned Object of IGuiCreator must be a instance of GuiScreen!");
        }
        return screen;
    }
}

