/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.minigame.gol;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;

public class Timer {
    private int ticks;
    private boolean isActive;

    public Timer(int ticks) {
        if (ticks < 0) {
            throw new IllegalArgumentException("Provided number '" + ticks + "' should be greater or equal to 0");
        }
        this.ticks = ticks;
    }

    public void update() {
        if (this.isActive() && !this.ended()) {
            --this.ticks;
        }
    }

    public void reset(int ticks) {
        if (ticks < 0) {
            throw new IllegalArgumentException("Provided number '" + ticks + "' should be greater or equal to 0");
        }
        this.ticks = ticks;
    }

    public int ticksLeft() {
        return this.ticks;
    }

    public boolean ended() {
        return this.ticks == 0;
    }

    public void enable() {
        this.isActive = true;
    }

    public void disable() {
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public static Timer fromNBT(NBTBase nbt) {
        return new Timer(((NBTTagInt)nbt).func_150287_d());
    }

    public static NBTBase toNBT(Timer timer) {
        return new NBTTagInt(timer.ticksLeft());
    }
}

