/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.client.render.tile;

import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.lootgames.api.block.tile.BoardGameMasterTile;
import ru.timeconqueror.lootgames.api.minigame.BoardLootGame;
import ru.timeconqueror.lootgames.api.util.Pos2i;
import ru.timeconqueror.lootgames.common.block.tile.GOLMasterTile;
import ru.timeconqueror.lootgames.minigame.gol.DisplayedSymbol;
import ru.timeconqueror.lootgames.minigame.gol.GameOfLight;
import ru.timeconqueror.lootgames.minigame.gol.QMarkAppearance;
import ru.timeconqueror.lootgames.minigame.gol.Symbol;
import ru.timeconqueror.timecore.animation.Ease;
import ru.timeconqueror.timecore.api.util.MathUtils;
import ru.timeconqueror.timecore.api.util.client.DrawHelper;

public class GOLMasterRenderer
extends TileEntitySpecialRenderer {
    public static final ResourceLocation BOARD = LootGames.rl("textures/game/gol_board.png");
    private static final ResourceLocation BOARD_ACTIVE = LootGames.rl("textures/game/gol_board_active.png");
    private static final ResourceLocation MARKS = LootGames.rl("textures/game/gol_marks.png");

    public void func_147500_a(TileEntity tileEntityIn, double x, double y, double z, float partialTicks) {
        Object symbol;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        GOLMasterTile master = (GOLMasterTile)tileEntityIn;
        BoardGameMasterTile.prepareMatrix(master);
        GameOfLight game = (GameOfLight)master.getGame();
        BoardLootGame.BoardStage stage = (BoardLootGame.BoardStage)game.getStage();
        int ticks = stage instanceof GameOfLight.StageUnderExpanding ? ((GameOfLight.StageUnderExpanding)stage).getTicks() : 0;
        this.drawBoard(game, ticks, partialTicks);
        if (stage instanceof GameOfLight.StageShowSequence && (symbol = ((GameOfLight.StageShowSequence)stage).getSymbolForRender()) != null) {
            this.drawSymbol((Symbol)((Object)symbol));
        }
        for (DisplayedSymbol symbol2 : game.getDisplayedSymbols()) {
            this.drawSymbol(symbol2.getSymbol());
        }
        QMarkAppearance.State questionMark = game.getMarkState();
        if (questionMark != QMarkAppearance.State.NONE) {
            this.drawMark(questionMark);
        }
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glPopMatrix();
    }

    private void drawSymbol(Symbol symbol) {
        this.func_147499_a(BOARD_ACTIVE);
        Pos2i pos = symbol.getPos();
        DrawHelper.drawTexturedRectByParts(pos.getX(), pos.getY(), 1.0f, 1.0f, -0.006f, pos.getX(), pos.getY(), 1.0f, 1.0f, 3.0f);
    }

    private void drawMark(QMarkAppearance.State state) {
        this.func_147499_a(MARKS);
        boolean textureX = false;
        boolean textureY = false;
        switch (state) {
            case ACCEPTED: {
                textureX = true;
                break;
            }
            case DENIED: {
                textureX = false;
                textureY = true;
            }
        }
        DrawHelper.drawTexturedRectByParts(1.0f, 1.0f, 1.0f, 1.0f, -0.006f, (float)textureX, (float)textureY, 1.0f, 1.0f, 2.0f);
    }

    private void drawBoard(GameOfLight game, int ticks, float partialTicks) {
        this.func_147499_a(BOARD);
        float length = 3.0f;
        float textureStart = 0.0f;
        float textureLength = 48.0f;
        if (game.getStage() instanceof GameOfLight.StageUnderExpanding) {
            float progress = Ease.inOutQuart((float)MathUtils.coerceInRange(ticks, 0, 20) / 20.0f);
            length = MathUtils.lerp(progress, 1.0f, 3.0f);
            textureStart = 16.0f - 16.0f * progress;
            textureLength = 32.0f + 16.0f * progress - textureStart;
        }
        GL11.glTranslatef((float)1.5f, (float)1.5f, (float)0.0f);
        DrawHelper.drawTexturedRectByParts(-length / 2.0f, -length / 2.0f, length, length, -0.005f, textureStart, textureStart, textureLength, textureLength, 48.0f);
        GL11.glTranslatef((float)-1.5f, (float)-1.5f, (float)0.0f);
    }
}

