/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.search;

import com.jamesswafford.chess4j.board.Board;
import com.jamesswafford.chess4j.board.Move;
import com.jamesswafford.chess4j.search.MVVLVA;
import com.jamesswafford.chess4j.search.MoveOrderStage;
import com.jamesswafford.chess4j.utils.MoveUtils;
import java.util.Arrays;
import java.util.List;

public class MoveOrderer {
    private Board board;
    private MoveOrderStage lastMoveOrderStage = MoveOrderStage.INITIAL;
    private Move[] moves;
    private Integer[] scores;
    private Move pvMove;
    private Move hashMove;
    private Move killer1;
    private Move killer2;

    public MoveOrderer(Board board, List<Move> moves, Move pvMove, Move hashMove, Move killer1, Move killer2) {
        this.board = board;
        this.moves = moves.toArray(new Move[moves.size()]);
        this.scores = new Integer[moves.size()];
        this.pvMove = pvMove;
        this.hashMove = hashMove;
        this.killer1 = killer1;
        this.killer2 = killer2;
    }

    public Move selectNextMove(int startIndex) {
        int bestInd;
        int ind;
        assert (startIndex < this.moves.length);
        assert (this.lastMoveOrderStage != null);
        if (this.lastMoveOrderStage == MoveOrderStage.INITIAL && this.pvMove != null) {
            assert (MoveUtils.indexOf(this.moves, this.pvMove, 0) >= 0);
            MoveUtils.putMoveAtTop(this.moves, this.pvMove);
            this.lastMoveOrderStage = MoveOrderStage.PV;
            return this.pvMove;
        }
        if (this.lastMoveOrderStage.ordinal() <= MoveOrderStage.PV.ordinal() && this.hashMove != null && (ind = MoveUtils.indexOf(this.moves, this.hashMove, startIndex)) != -1) {
            assert (Arrays.asList(this.moves).subList(startIndex, this.moves.length).contains(this.hashMove));
            MoveUtils.swap(this.moves, startIndex, ind);
            this.lastMoveOrderStage = MoveOrderStage.HASH_MOVE;
            return this.hashMove;
        }
        if (this.lastMoveOrderStage.ordinal() <= MoveOrderStage.SCORE_MOVES.ordinal()) {
            this.scoreMoves(startIndex);
        }
        if (this.lastMoveOrderStage.ordinal() <= MoveOrderStage.WINNING_CAPTURES.ordinal() && (bestInd = this.getIndexOfBestCapture(startIndex)) != -1 && this.scores[bestInd] >= 0) {
            MoveUtils.swap(this.moves, startIndex, bestInd);
            this.swapScores(startIndex, bestInd);
            this.lastMoveOrderStage = MoveOrderStage.WINNING_CAPTURES;
            return this.moves[startIndex];
        }
        if (this.lastMoveOrderStage.ordinal() <= MoveOrderStage.KILLER1.ordinal() && this.killer1 != null && (ind = MoveUtils.indexOf(this.moves, this.killer1, startIndex)) != -1) {
            MoveUtils.swap(this.moves, startIndex, ind);
            this.swapScores(startIndex, ind);
            this.lastMoveOrderStage = MoveOrderStage.KILLER1;
            return this.moves[startIndex];
        }
        if (this.lastMoveOrderStage.ordinal() <= MoveOrderStage.KILLER2.ordinal() && this.killer2 != null && (ind = MoveUtils.indexOf(this.moves, this.killer2, startIndex)) != -1) {
            MoveUtils.swap(this.moves, startIndex, ind);
            this.swapScores(startIndex, ind);
            this.lastMoveOrderStage = MoveOrderStage.KILLER2;
            return this.moves[startIndex];
        }
        if (this.lastMoveOrderStage.ordinal() <= MoveOrderStage.NONCAPTURES.ordinal() && (ind = this.getIndexOfFirstNonCapture(startIndex)) != -1) {
            MoveUtils.swap(this.moves, startIndex, ind);
            this.swapScores(startIndex, ind);
            this.lastMoveOrderStage = MoveOrderStage.NONCAPTURES;
            return this.moves[startIndex];
        }
        this.lastMoveOrderStage = MoveOrderStage.LOSING_CAPTURES;
        int loserInd = this.getIndexOfBestCapture(startIndex);
        if (loserInd != -1) {
            assert (this.scores[loserInd] < 0);
            MoveUtils.swap(this.moves, startIndex, loserInd);
            this.swapScores(startIndex, loserInd);
        }
        return this.moves[startIndex];
    }

    private void scoreMoves(int startIndex) {
        for (int i = startIndex; i < this.moves.length; ++i) {
            this.scores[i] = MVVLVA.score(this.board, this.moves[i]);
        }
    }

    private int getIndexOfBestCapture(int startIndex) {
        int index = -1;
        int bestScore = -9999;
        for (int i = startIndex; i < this.moves.length; ++i) {
            int myScore;
            Move m = this.moves[i];
            if (m.captured() == null && m.promotion() == null || (myScore = this.scores[i].intValue()) <= bestScore) continue;
            index = i;
            bestScore = myScore;
        }
        return index;
    }

    private int getIndexOfFirstNonCapture(int startIndex) {
        int index = -1;
        for (int i = startIndex; i < this.moves.length; ++i) {
            Move m = this.moves[i];
            if (m.captured() != null) continue;
            index = i;
            break;
        }
        return index;
    }

    public void swapScores(int ind1, int ind2) {
        Integer tmp = this.scores[ind1];
        this.scores[ind1] = this.scores[ind2];
        this.scores[ind2] = tmp;
    }

    public MoveOrderStage getLastMoveOrderStage() {
        return this.lastMoveOrderStage;
    }

    public void setLastMoveOrderStage(MoveOrderStage lastMoveOrderStage) {
        this.lastMoveOrderStage = lastMoveOrderStage;
    }
}

