/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.early.minecraft;

import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.mitchej123.hodgepodge.config.SpeedupsConfig;
import com.mitchej123.hodgepodge.mixins.interfaces.SpawnListEntryExt;
import com.mitchej123.hodgepodge.util.ChunkPosUtil;
import cpw.mods.fml.common.eventhandler.Event;
import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import it.unimi.dsi.fastutil.longs.Long2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongLists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={SpawnerAnimals.class}, priority=900)
public class MixinSpawnerAnimals_optimizeSpawning {
    @Shadow
    private final HashMap<ChunkCoordIntPair, Boolean> field_77193_b = null;
    private static final EnumCreatureType[] CREATURE_TYPE_VALUES = EnumCreatureType.values();
    private final Long2BooleanMap hodgepodge$eligibleChunks = new Long2BooleanOpenHashMap();
    private final LongList hodgepodge$shuffledChunks = new LongArrayList();
    private final BlockPos hodgepodge$reusableBlockPos = new BlockPos(0, 0, 0);

    private BlockPos hodgepodge$getRandomPosInChunk(World world, int chunkX, int chunkZ) {
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        int randX = chunkX * 16 + world.field_73012_v.nextInt(16);
        int randZ = chunkZ * 16 + world.field_73012_v.nextInt(16);
        int randY = world.field_73012_v.nextInt(chunk == null ? world.func_72940_L() : chunk.func_76625_h() + 16 - 1);
        return this.hodgepodge$reusableBlockPos.set(randX, randY, randZ);
    }

    @Overwrite
    public int func_77192_a(WorldServer world, boolean spawnHostileMobs, boolean spawnPeacefulMobs, boolean spawnOnSetTickRate) {
        if (!spawnHostileMobs && !spawnPeacefulMobs) {
            return 0;
        }
        this.hodgepodge$eligibleChunks.clear();
        int spawnRange = SpeedupsConfig.limitMobSpawningToViewDistance ? Math.min(8, MinecraftServer.func_71276_C().func_71203_ab().func_72395_o()) : 8;
        for (int playerIndex = 0; playerIndex < world.field_73010_i.size(); ++playerIndex) {
            EntityPlayer player = (EntityPlayer)world.field_73010_i.get(playerIndex);
            int playerChunkX = MathHelper.func_76128_c((double)(player.field_70165_t / 16.0));
            int playerChunkZ = MathHelper.func_76128_c((double)(player.field_70161_v / 16.0));
            for (int offsetX = -spawnRange; offsetX <= spawnRange; ++offsetX) {
                for (int offsetZ = -spawnRange; offsetZ <= spawnRange; ++offsetZ) {
                    boolean isEdge = Math.abs(offsetX) == spawnRange || Math.abs(offsetZ) == spawnRange;
                    long packedPos = ChunkPosUtil.toLong(offsetX + playerChunkX, offsetZ + playerChunkZ);
                    if (!isEdge) {
                        this.hodgepodge$eligibleChunks.put(packedPos, false);
                        continue;
                    }
                    if (this.hodgepodge$eligibleChunks.containsKey(packedPos)) continue;
                    this.hodgepodge$eligibleChunks.put(packedPos, true);
                }
            }
        }
        int spawnRangeOffset = 6;
        ChunkCoordinates spawnPoint = world.func_72861_E();
        int creatureTypeCount = CREATURE_TYPE_VALUES.length;
        int totalSpawnedEntities = 0;
        double playerDistanceCheck = 24.0;
        for (int creatureTypeIndex = 0; creatureTypeIndex < creatureTypeCount; ++creatureTypeIndex) {
            EnumCreatureType creatureType = CREATURE_TYPE_VALUES[creatureTypeIndex];
            if (creatureType.func_75599_d() && !spawnPeacefulMobs || !creatureType.func_75599_d() && !spawnHostileMobs || creatureType.func_82705_e() && !spawnOnSetTickRate || world.countEntities(creatureType, true) > creatureType.func_75601_b() * this.hodgepodge$eligibleChunks.size() / 256) continue;
            this.hodgepodge$shuffledChunks.clear();
            this.hodgepodge$shuffledChunks.addAll((LongCollection)this.hodgepodge$eligibleChunks.keySet());
            LongLists.shuffle((LongList)this.hodgepodge$shuffledChunks, (Random)world.field_73012_v);
            LongListIterator iterator = this.hodgepodge$shuffledChunks.iterator();
            while (iterator.hasNext()) {
                long chunkPos = iterator.nextLong();
                if (this.hodgepodge$eligibleChunks.get(chunkPos)) continue;
                int chunkX = ChunkPosUtil.getPackedX(chunkPos);
                int chunkZ = ChunkPosUtil.getPackedZ(chunkPos);
                BlockPos spawnPosition = this.hodgepodge$getRandomPosInChunk((World)world, chunkX, chunkZ);
                int spawnX = spawnPosition.x;
                int spawnY = spawnPosition.y;
                int spawnZ = spawnPosition.z;
                if (world.func_147439_a(spawnX, spawnY, spawnZ).func_149721_r() || world.func_147439_a(spawnX, spawnY, spawnZ).func_149688_o() != creatureType.func_75600_c()) continue;
                int packSize = 0;
                block7: for (int spawnAttempt = 0; spawnAttempt < 3; ++spawnAttempt) {
                    int attemptX = spawnX;
                    int attemptY = spawnY;
                    int attemptZ = spawnZ;
                    BiomeGenBase.SpawnListEntry spawnListEntry = null;
                    IEntityLivingData entityLivingData = null;
                    for (int attempt = 0; attempt < 4; ++attempt) {
                        EntityLiving entityLiving;
                        float distanceZ;
                        float distanceY;
                        float distanceX;
                        float distanceSquared;
                        float spawnPosZ;
                        float spawnPosY;
                        float spawnPosX;
                        if (!MixinSpawnerAnimals_optimizeSpawning.func_77190_a(creatureType, (World)world, attemptX += world.field_73012_v.nextInt(6) - world.field_73012_v.nextInt(6), attemptY += world.field_73012_v.nextInt(1) - world.field_73012_v.nextInt(1), attemptZ += world.field_73012_v.nextInt(6) - world.field_73012_v.nextInt(6)) || world.func_72977_a((double)(spawnPosX = (float)attemptX + 0.5f), (double)(spawnPosY = (float)attemptY), (double)(spawnPosZ = (float)attemptZ + 0.5f), 24.0) != null || !((distanceSquared = (distanceX = spawnPosX - (float)spawnPoint.field_71574_a) * distanceX + (distanceY = spawnPosY - (float)spawnPoint.field_71572_b) * distanceY + (distanceZ = spawnPosZ - (float)spawnPoint.field_71573_c) * distanceZ) >= 576.0f)) continue;
                        if (spawnListEntry == null && (spawnListEntry = world.func_73057_a(creatureType, attemptX, attemptY, attemptZ)) == null) continue block7;
                        try {
                            entityLiving = ((SpawnListEntryExt)spawnListEntry).constructEntity((World)world);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            return totalSpawnedEntities;
                        }
                        entityLiving.func_70012_b((double)spawnPosX, (double)spawnPosY, (double)spawnPosZ, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entityLiving, (World)world, (float)spawnPosX, (float)spawnPosY, (float)spawnPosZ);
                        if (canSpawn == Event.Result.ALLOW || canSpawn == Event.Result.DEFAULT && entityLiving.func_70601_bi()) {
                            ++packSize;
                            world.func_72838_d((Entity)entityLiving);
                            if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entityLiving, (World)world, (float)spawnPosX, (float)spawnPosY, (float)spawnPosZ)) {
                                entityLivingData = entityLiving.func_110161_a(entityLivingData);
                            }
                            if (spawnAttempt >= ForgeEventFactory.getMaxSpawnPackSize((EntityLiving)entityLiving)) continue block7;
                        }
                        totalSpawnedEntities += packSize;
                    }
                }
            }
        }
        return totalSpawnedEntities;
    }

    @Overwrite
    public static boolean func_77190_a(EnumCreatureType creatureType, World world, int x, int y, int z) {
        if (creatureType.func_75600_c() == Material.field_151586_h) {
            return world.func_147439_a(x, y, z).func_149688_o().func_76224_d() && world.func_147439_a(x, y - 1, z).func_149688_o().func_76224_d() && !world.func_147439_a(x, y + 1, z).func_149721_r();
        }
        if (!World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z)) {
            return false;
        }
        Block blockBelow = world.func_147439_a(x, y - 1, z);
        if (blockBelow != Blocks.field_150357_h && blockBelow.canCreatureSpawn(creatureType, (IBlockAccess)world, x, y - 1, z)) {
            Block block = world.func_147439_a(x, y, z);
            return !block.func_149721_r() && !block.func_149688_o().func_76224_d() && !world.func_147439_a(x, y + 1, z).func_149721_r();
        }
        return false;
    }

    @Overwrite
    public static void func_77191_a(World world, BiomeGenBase biome, int startX, int startZ, int areaWidth, int areaHeight, Random random) {
        List spawnableList = biome.func_76747_a(EnumCreatureType.creature);
        if (spawnableList.isEmpty()) {
            return;
        }
        while (random.nextFloat() < biome.func_76741_f()) {
            BiomeGenBase.SpawnListEntry spawnListEntry = (BiomeGenBase.SpawnListEntry)WeightedRandom.func_76271_a((Random)world.field_73012_v, (Collection)spawnableList);
            IEntityLivingData entityLivingData = null;
            int groupCount = spawnListEntry.field_76301_c + random.nextInt(1 + spawnListEntry.field_76299_d - spawnListEntry.field_76301_c);
            int posX = startX + random.nextInt(areaWidth);
            int posZ = startZ + random.nextInt(areaHeight);
            int initialPosX = posX;
            int initialPosZ = posZ;
            for (int i = 0; i < groupCount; ++i) {
                boolean spawned = false;
                for (int j2 = 0; !spawned && j2 < 4; ++j2) {
                    int posY = world.func_72825_h(posX, posZ);
                    if (MixinSpawnerAnimals_optimizeSpawning.func_77190_a(EnumCreatureType.creature, world, posX, posY, posZ)) {
                        EntityLiving entityLiving;
                        float spawnPosX = (float)posX + 0.5f;
                        float spawnPosY = posY;
                        float spawnPosZ = (float)posZ + 0.5f;
                        try {
                            entityLiving = ((SpawnListEntryExt)spawnListEntry).constructEntity(world);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            continue;
                        }
                        entityLiving.func_70012_b((double)spawnPosX, (double)spawnPosY, (double)spawnPosZ, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityLiving);
                        entityLivingData = entityLiving.func_110161_a(entityLivingData);
                        spawned = true;
                    }
                    posX += random.nextInt(5) - random.nextInt(5);
                    posZ += random.nextInt(5) - random.nextInt(5);
                    while (posX < startX || posX >= startX + areaWidth || posZ < startZ || posZ >= startZ + areaHeight) {
                        posX = initialPosX + random.nextInt(5) - random.nextInt(5);
                        posZ = initialPosZ + random.nextInt(5) - random.nextInt(5);
                    }
                }
            }
        }
    }
}

