/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.mixin;

import com.gtnewhorizon.gtnhlib.GTNHLib;
import com.gtnewhorizon.gtnhlib.mixin.ITargetedMod;
import com.gtnewhorizon.gtnhlib.mixin.Phase;
import com.gtnewhorizon.gtnhlib.mixin.Side;
import com.gtnewhorizon.gtnhlib.mixin.TargetedMod;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public interface IMixins {
    public List<String> getMixinClasses();

    public Supplier<Boolean> getApplyIf();

    public Phase getPhase();

    public Side getSide();

    public List<ITargetedMod> getTargetedMods();

    public List<ITargetedMod> getExcludedMods();

    public static <E extends Enum<E>> List<E> getAllValues(Class<E> enumClass) {
        if (enumClass.isEnum() && IMixins.class.isAssignableFrom(enumClass)) {
            return Arrays.asList((Enum[])enumClass.getEnumConstants());
        }
        throw new IllegalStateException("Tried to use IMixins enum with a class that doesn't inherit IMixins and/or isn't an enum.");
    }

    public static <E extends Enum<E>> List<String> getEarlyMixins(Class<E> enumClass, Set<String> loadedCoreMods) {
        ArrayList<String> mixins = new ArrayList<String>();
        ArrayList<String> notLoading = new ArrayList<String>();
        for (Enum mixin : IMixins.getAllValues(enumClass)) {
            if (((IMixins)((Object)mixin)).getPhase() != Phase.EARLY) continue;
            if (((IMixins)((Object)mixin)).shouldLoad(loadedCoreMods, Collections.emptySet())) {
                mixins.addAll(((IMixins)((Object)mixin)).getMixinClasses());
                continue;
            }
            notLoading.addAll(((IMixins)((Object)mixin)).getMixinClasses());
        }
        GTNHLib.LOG.info("Not loading the following EARLY mixins: {}", new Object[]{notLoading});
        return mixins;
    }

    public static <E extends Enum<E>> List<String> getLateMixins(Class<E> enumClass, Set<String> loadedMods) {
        ArrayList<String> mixins = new ArrayList<String>();
        ArrayList<String> notLoading = new ArrayList<String>();
        for (Enum mixin : IMixins.getAllValues(enumClass)) {
            if (((IMixins)((Object)mixin)).getPhase() != Phase.LATE) continue;
            if (((IMixins)((Object)mixin)).shouldLoad(Collections.emptySet(), loadedMods)) {
                mixins.addAll(((IMixins)((Object)mixin)).getMixinClasses());
                continue;
            }
            notLoading.addAll(((IMixins)((Object)mixin)).getMixinClasses());
        }
        GTNHLib.LOG.info("Not loading the following LATE mixins: {}", new Object[]{((Object)notLoading).toString()});
        return mixins;
    }

    default public boolean shouldLoadSide() {
        return this.getSide() == Side.BOTH || this.getSide() == Side.SERVER && FMLLaunchHandler.side().isServer() || this.getSide() == Side.CLIENT && FMLLaunchHandler.side().isClient();
    }

    default public boolean allModsLoaded(List<ITargetedMod> targetedMods, Set<String> loadedCoreMods, Set<String> loadedMods) {
        if (targetedMods.isEmpty()) {
            return false;
        }
        for (ITargetedMod target : targetedMods) {
            if (target == TargetedMod.VANILLA) continue;
            if (!loadedCoreMods.isEmpty() && target.getCoreModClass() != null && !loadedCoreMods.contains(target.getCoreModClass())) {
                return false;
            }
            if (loadedMods.isEmpty() || target.getModId() == null || loadedMods.contains(target.getModId())) continue;
            return false;
        }
        return true;
    }

    default public boolean noModsLoaded(List<ITargetedMod> targetedMods, Set<String> loadedCoreMods, Set<String> loadedMods) {
        if (targetedMods.isEmpty()) {
            return true;
        }
        for (ITargetedMod target : targetedMods) {
            if (target == TargetedMod.VANILLA) continue;
            if (!loadedCoreMods.isEmpty() && target.getCoreModClass() != null && loadedCoreMods.contains(target.getCoreModClass())) {
                return false;
            }
            if (loadedMods.isEmpty() || target.getModId() == null || !loadedMods.contains(target.getModId())) continue;
            return false;
        }
        return true;
    }

    default public boolean shouldLoad(Set<String> loadedCoreMods, Set<String> loadedMods) {
        return this.shouldLoadSide() && this.getApplyIf().get() != false && this.allModsLoaded(this.getTargetedMods(), loadedCoreMods, loadedMods) && this.noModsLoaded(this.getExcludedMods(), loadedCoreMods, loadedMods);
    }
}

