/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.model.json;

import com.gtnewhorizon.gtnhlib.client.renderer.quad.Axis;
import java.util.List;
import lombok.Generated;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class ModelElement {
    private final Vector3f from;
    private final Vector3f to;
    @Nullable
    private final Rotation rotation;
    private final boolean shade;
    private final List<Face> faces;

    ModelElement(Vector3f from, Vector3f vector3f, @Nullable Rotation rotation, boolean shade, List<Face> faces) {
        this.from = from;
        this.to = vector3f;
        this.rotation = rotation;
        this.shade = shade;
        this.faces = faces;
    }

    @Generated
    public Vector3f getFrom() {
        return this.from;
    }

    @Generated
    public Vector3f getTo() {
        return this.to;
    }

    @Nullable
    @Generated
    public Rotation getRotation() {
        return this.rotation;
    }

    @Generated
    public List<Face> getFaces() {
        return this.faces;
    }

    static class Rotation {
        static final Rotation NOOP = new Rotation(new Vector3f(0.0f, 0.0f, 0.0f), Axis.X, 0.0f, false);
        private final Vector3f origin;
        private final Axis axis;
        private final float angle;
        private final boolean rescale;

        Rotation(Vector3f origin, Axis axis, float angle, boolean rescale) {
            this.origin = origin;
            this.axis = axis;
            this.angle = (float)Math.toRadians(angle);
            this.rescale = rescale;
        }

        Matrix4f getAffineMatrix() {
            Matrix4f ret = new Matrix4f().translation(-this.origin.x, -this.origin.y, -this.origin.z);
            switch (this.axis) {
                case X: {
                    ret.rotateLocalX(this.angle);
                    break;
                }
                case Y: {
                    ret.rotateLocalY(this.angle);
                    break;
                }
                case Z: {
                    ret.rotateLocalZ(this.angle);
                }
            }
            return ret.translateLocal(this.origin.x, this.origin.y, this.origin.z);
        }
    }

    static class Face {
        private final ForgeDirection name;
        private final Vector4f uv;
        private final String texture;
        private final ForgeDirection cullFace;
        private final int rotation;
        private final int tintIndex;

        Face(ForgeDirection name, Vector4f uv, String texture, ForgeDirection cullFace, int rotation, int tintIndex) {
            this.name = name;
            this.uv = uv;
            this.texture = texture;
            this.cullFace = cullFace;
            this.rotation = rotation;
            this.tintIndex = tintIndex;
        }

        @Generated
        public ForgeDirection getName() {
            return this.name;
        }

        @Generated
        public Vector4f getUv() {
            return this.uv;
        }

        @Generated
        public String getTexture() {
            return this.texture;
        }

        @Generated
        public ForgeDirection getCullFace() {
            return this.cullFace;
        }

        @Generated
        public int getRotation() {
            return this.rotation;
        }

        @Generated
        public int getTintIndex() {
            return this.tintIndex;
        }
    }
}

