/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.storage;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.zip.CRC32;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.MapType;
import org.dynmap.PlayerFaces;
import org.dynmap.WebAuthManager;
import org.dynmap.storage.MapStorageTile;
import org.dynmap.storage.MapStorageTileEnumCB;
import org.dynmap.utils.BufferInputStream;
import org.dynmap.utils.BufferOutputStream;

public abstract class MapStorage {
    private static Object lock = new Object();
    private static HashMap<String, Integer> filelocks = new HashMap();
    private static final Integer WRITELOCK = new Integer(-1);
    protected File baseStandaloneDir;
    protected long serverID = 0L;
    private static final int RETRY_LIMIT = 4;

    protected MapStorage() {
    }

    protected static final int modulo(int x, int y) {
        return (x % y + y) % y;
    }

    public boolean init(DynmapCore core) {
        this.baseStandaloneDir = new File(core.configuration.getString("webpath", "web"), "standalone");
        if (!this.baseStandaloneDir.isAbsolute()) {
            this.baseStandaloneDir = new File(core.getDataFolder(), this.baseStandaloneDir.toString());
        }
        return true;
    }

    public void setServerID(long serverID) {
        this.serverID = serverID;
    }

    public abstract MapStorageTile getTile(DynmapWorld var1, MapType var2, int var3, int var4, int var5, MapType.ImageVariant var6);

    public abstract MapStorageTile getTile(DynmapWorld var1, String var2);

    public abstract void enumMapTiles(DynmapWorld var1, MapType var2, MapStorageTileEnumCB var3);

    public abstract void purgeMapTiles(DynmapWorld var1, MapType var2);

    public abstract boolean setPlayerFaceImage(String var1, PlayerFaces.FaceType var2, BufferOutputStream var3);

    public abstract BufferInputStream getPlayerFaceImage(String var1, PlayerFaces.FaceType var2);

    public abstract boolean hasPlayerFaceImage(String var1, PlayerFaces.FaceType var2);

    public abstract boolean setMarkerImage(String var1, BufferOutputStream var2);

    public abstract BufferInputStream getMarkerImage(String var1);

    public abstract boolean setMarkerFile(String var1, String var2);

    public abstract String getMarkerFile(String var1);

    public static long calculateImageHashCode(int[] buf, int off, int len) {
        CRC32 crc32 = new CRC32();
        int perCall = 256;
        int accum = 0;
        byte[] crcworkbuf = new byte[1024];
        for (int i = 0; i < len; ++i) {
            int v = buf[i + off];
            crcworkbuf[accum++] = (byte)v;
            crcworkbuf[accum++] = (byte)(v >> 8);
            crcworkbuf[accum++] = (byte)(v >> 16);
            crcworkbuf[accum++] = (byte)(v >> 24);
            if (accum != crcworkbuf.length) continue;
            crc32.update(crcworkbuf, 0, accum);
            accum = 0;
        }
        if (accum > 0) {
            crc32.update(crcworkbuf, 0, accum);
            accum = 0;
        }
        return crc32.getValue();
    }

    public abstract String getMarkersURI(boolean var1);

    public abstract String getTilesURI(boolean var1);

    public boolean wrapStandaloneJSON(boolean login_enabled) {
        return login_enabled;
    }

    public String getSendMessageURI() {
        return "standalone/sendmessage.php";
    }

    public String getConfigurationJSONURI(boolean login_enabled) {
        return login_enabled ? "standalone/configuration.php" : "standalone/dynmap_config.json?_={timestamp}";
    }

    public String getUpdateJSONURI(boolean login_enabled) {
        return login_enabled ? "standalone/update.php?world={world}&ts={timestamp}" : "standalone/dynmap_{world}.json?_={timestamp}";
    }

    public void addPaths(StringBuilder sb, DynmapCore core) {
        File wpath = core.getFile(core.getWebPath());
        String p = wpath.getAbsolutePath();
        if (!p.endsWith("/")) {
            p = p + "/";
        }
        sb.append("$webpath = '");
        sb.append(WebAuthManager.esc(p));
        sb.append("';\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setStandaloneFile(String fileid, BufferOutputStream content) {
        RandomAccessFile fos = null;
        boolean good = false;
        boolean done = false;
        File f = new File(this.baseStandaloneDir, fileid);
        File fnew = new File(this.baseStandaloneDir, fileid + ".new");
        File fold = new File(this.baseStandaloneDir, fileid + ".old");
        int retrycnt = 0;
        this.getWriteLock(fileid);
        while (!done) {
            try {
                if (fnew.exists()) {
                    fnew.delete();
                }
                if (content != null) {
                    fos = new RandomAccessFile(fnew, "rw");
                    fos.write(content.buf, 0, content.len);
                }
                good = true;
                done = true;
            }
            catch (IOException ioe) {
                if (retrycnt < 4) {
                    try {
                        Thread.sleep(20 * (1 << retrycnt));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++retrycnt;
                    continue;
                }
                Log.severe("Exception while writing JSON-file - " + fnew.getPath(), ioe);
                done = true;
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                    fos = null;
                }
                if (!good) continue;
                f.renameTo(fold);
                if (content != null) {
                    fnew.renameTo(f);
                }
                fold.delete();
            }
        }
        this.releaseWriteLock(fileid);
        return good;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferInputStream getStandaloneFile(String fileid) {
        RandomAccessFile fos = null;
        BufferInputStream bis = null;
        boolean done = false;
        File f = new File(this.baseStandaloneDir, fileid);
        if (this.getReadLock(fileid, 5000L)) {
            int retrycnt = 0;
            if (!f.exists()) {
                done = true;
            }
            while (!done) {
                byte[] b = new byte[(int)f.length()];
                try {
                    fos = new RandomAccessFile(f, "r");
                    fos.read(b, 0, b.length);
                    done = true;
                    bis = new BufferInputStream(b);
                }
                catch (IOException ioe) {
                    if (retrycnt < 4) {
                        try {
                            Thread.sleep(20 * (1 << retrycnt));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ++retrycnt;
                        continue;
                    }
                    Log.severe("Exception while reading standalone - " + f.getPath(), ioe);
                    done = true;
                }
                finally {
                    if (fos == null) continue;
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                    fos = null;
                }
            }
            this.releaseReadLock(fileid);
        }
        return bis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseWriteLock(String baseFilename) {
        Object object = lock;
        synchronized (object) {
            Integer lockcnt = filelocks.get(baseFilename);
            if (lockcnt == null) {
                Log.severe("releaseWriteLock(" + baseFilename + ") on unlocked file");
            } else if (lockcnt.equals(WRITELOCK)) {
                filelocks.remove(baseFilename);
                lock.notifyAll();
            } else {
                Log.severe("releaseWriteLock(" + baseFilename + ") on read-locked file");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getWriteLock(String baseFilename) {
        Object object = lock;
        synchronized (object) {
            boolean got_lock = false;
            while (!got_lock) {
                Integer lockcnt = filelocks.get(baseFilename);
                if (lockcnt != null) {
                    try {
                        lock.wait();
                        continue;
                    }
                    catch (InterruptedException ix) {
                        Log.severe("getWriteLock(" + baseFilename + ") interrupted");
                        return false;
                    }
                }
                filelocks.put(baseFilename, WRITELOCK);
                got_lock = true;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getReadLock(String baseFilename, long timeout) {
        Object object = lock;
        synchronized (object) {
            boolean got_lock = false;
            long starttime = 0L;
            if (timeout > 0L) {
                starttime = System.currentTimeMillis();
            }
            while (!got_lock) {
                Integer lockcnt = filelocks.get(baseFilename);
                if (lockcnt == null) {
                    filelocks.put(baseFilename, 1);
                    got_lock = true;
                    continue;
                }
                if (!lockcnt.equals(WRITELOCK)) {
                    filelocks.put(baseFilename, lockcnt + 1);
                    got_lock = true;
                    continue;
                }
                try {
                    if (timeout < 0L) {
                        lock.wait();
                        continue;
                    }
                    long now = System.currentTimeMillis();
                    long elapsed = now - starttime;
                    if (elapsed > timeout) {
                        return false;
                    }
                    lock.wait(timeout - elapsed);
                }
                catch (InterruptedException ix) {
                    Log.severe("getReadLock(" + baseFilename + ") interrupted");
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseReadLock(String baseFilename) {
        Object object = lock;
        synchronized (object) {
            Integer lockcnt = filelocks.get(baseFilename);
            if (lockcnt == null) {
                Log.severe("releaseReadLock(" + baseFilename + ") on unlocked file");
            } else if (lockcnt.equals(WRITELOCK)) {
                Log.severe("releaseReadLock(" + baseFilename + ") on write-locked file");
            } else if (lockcnt > 1) {
                filelocks.put(baseFilename, lockcnt - 1);
            } else {
                filelocks.remove(baseFilename);
                lock.notifyAll();
            }
        }
    }

    public boolean wrapStandalonePHP() {
        return true;
    }

    public String getStandaloneLoginURI() {
        return "standalone/login.php";
    }

    public String getStandaloneRegisterURI() {
        return "standalone/register.php";
    }

    public void setLoginEnabled(DynmapCore core) {
    }
}

