/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.dynmap.DynmapCore;
import org.dynmap.Event;
import org.dynmap.JSONUtils;
import org.dynmap.Log;
import org.dynmap.shadow.javax.servlet.ServletException;
import org.dynmap.shadow.javax.servlet.http.HttpServlet;
import org.dynmap.shadow.javax.servlet.http.HttpServletRequest;
import org.dynmap.shadow.javax.servlet.http.HttpServletResponse;
import org.dynmap.shadow.javax.servlet.http.HttpSession;
import org.dynmap.shadow.org.json.simple.JSONObject;
import org.dynmap.shadow.org.json.simple.parser.JSONParser;
import org.dynmap.shadow.org.json.simple.parser.ParseException;

public class SendMessageServlet
extends HttpServlet {
    protected static final Logger log = Logger.getLogger("Minecraft");
    private static final JSONParser parser = new JSONParser();
    public Event<Message> onMessageReceived = new Event();
    private Charset cs_utf8 = Charset.forName("UTF-8");
    public int maximumMessageInterval = 1000;
    public boolean hideip = false;
    public boolean trustclientname = false;
    public String spamMessage = "\"You may only chat once every %interval% seconds.\"";
    private HashMap<String, WebUser> disallowedUsers = new HashMap();
    private LinkedList<WebUser> disallowedUserQueue = new LinkedList();
    private Object disallowedUsersLock = new Object();
    private HashMap<String, String> useralias = new HashMap();
    private int aliasindex = 1;
    public boolean use_player_login_ip = false;
    public boolean require_player_login_ip = false;
    public boolean check_user_ban = false;
    public boolean require_login = false;
    public boolean chat_perms = false;
    public int lengthlimit = 256;
    public DynmapCore core;
    public HashSet<String> proxyaddress = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean chat_requires_login;
        String error = "none";
        HttpSession sess = request.getSession(true);
        String userID = (String)sess.getAttribute("userid");
        if (userID == null) {
            userID = "_guest_";
        }
        boolean bl = chat_requires_login = this.core.getLoginRequired() || this.require_login;
        if (chat_requires_login && userID.equals("_guest_")) {
            error = "login-required";
        } else if (chat_requires_login && !userID.equals("_guest_") && this.chat_perms && !this.core.checkPermission(userID, "webchat")) {
            Log.info("Rejected web chat by " + userID + ": not permitted");
            error = "not-permitted";
        } else {
            boolean ok = true;
            InputStreamReader reader = new InputStreamReader((InputStream)request.getInputStream(), this.cs_utf8);
            JSONObject o = null;
            try {
                o = (JSONObject)parser.parse(reader);
            }
            catch (ParseException e) {
                error = "bad-format";
                ok = false;
            }
            final Message message = new Message();
            if (userID.equals("_guest_")) {
                message.name = "";
                if (this.trustclientname) {
                    message.name = String.valueOf(o.get("name"));
                }
                boolean isip = true;
                if (message.name == null || message.name.equals("")) {
                    String rmtaddr = request.getRemoteAddr();
                    if (this.proxyaddress.contains(rmtaddr)) {
                        if (request.getHeader("X-Forwarded-For") != null) {
                            String[] proxyAddrs = request.getHeader("X-Forwarded-For").split(", ");
                            for (int i = proxyAddrs.length - 1; i >= 0; --i) {
                                if (this.proxyaddress.contains(proxyAddrs[i])) continue;
                                message.name = proxyAddrs[0];
                                for (int j = 1; j <= i; ++j) {
                                    message.name = message.name + ", " + proxyAddrs[j];
                                }
                                break;
                            }
                        } else {
                            message.name = String.valueOf(o.get("name"));
                        }
                    } else {
                        message.name = request.getRemoteAddr();
                    }
                }
                if (this.use_player_login_ip) {
                    List<String> ids = this.core.getIDsForIP(message.name);
                    if (ids != null) {
                        String id = ids.get(0);
                        if (this.check_user_ban && this.core.getServer().isPlayerBanned(id)) {
                            Log.info("Ignore message from '" + message.name + "' - banned player (" + id + ")");
                            error = "not-allowed";
                            ok = false;
                        }
                        if (this.chat_perms && !this.core.getServer().checkPlayerPermission(id, "webchat")) {
                            Log.info("Rejected web chat from '" + message.name + "': not permitted (" + id + ")");
                            error = "not-allowed";
                            ok = false;
                        }
                        message.name = id;
                        isip = false;
                    } else if (this.require_player_login_ip) {
                        Log.info("Ignore message from '" + message.name + "' - no matching player login recorded");
                        error = "not-allowed";
                        ok = false;
                    }
                }
                if (this.hideip && isip) {
                    Object object = this.disallowedUsersLock;
                    synchronized (object) {
                        String n = this.useralias.get(message.name);
                        if (n == null) {
                            n = String.format("web-%03d", this.aliasindex);
                            ++this.aliasindex;
                            this.useralias.put(message.name, n);
                        }
                        message.name = n;
                    }
                }
            } else {
                message.name = userID;
            }
            message.message = String.valueOf(o.get("message"));
            if (this.lengthlimit > 0 && message.message.length() > this.lengthlimit) {
                message.message = message.message.substring(0, this.lengthlimit);
            }
            final long now = System.currentTimeMillis();
            Object object = this.disallowedUsersLock;
            synchronized (object) {
                WebUser user;
                while (!this.disallowedUserQueue.isEmpty()) {
                    WebUser wu = this.disallowedUserQueue.getFirst();
                    if (now < wu.nextMessageTime) break;
                    this.disallowedUserQueue.remove();
                    this.disallowedUsers.remove(wu.name);
                }
                if ((user = this.disallowedUsers.get(message.name)) == null) {
                    user = new WebUser(){
                        {
                            this.name = message.name;
                            this.nextMessageTime = now + (long)SendMessageServlet.this.maximumMessageInterval;
                        }
                    };
                    this.disallowedUsers.put(user.name, user);
                    this.disallowedUserQueue.add(user);
                } else {
                    error = "not-allowed";
                    ok = false;
                }
            }
            if (ok) {
                this.onMessageReceived.trigger(message);
            }
        }
        JSONObject json = new JSONObject();
        JSONUtils.s(json, "error", error);
        byte[] bytes = json.toJSONString().getBytes(this.cs_utf8);
        String dateStr = new Date().toString();
        response.addHeader("Date", dateStr);
        response.addHeader("Content-Type", "text/plain; charset=utf-8");
        response.addHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        response.addHeader("Last-Modified", dateStr);
        response.addHeader("Content-Length", Integer.toString(bytes.length));
        response.getOutputStream().write(bytes);
    }

    public static class WebUser {
        public long nextMessageTime;
        public String name;
    }

    public static class Message {
        public String name;
        public String message;
    }
}

