/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.renderer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dynmap.renderer.CustomRendererData;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public abstract class CustomRenderer {
    private static final int[] default_patches = new int[]{0, 0, 0, 0, 0, 0};

    protected CustomRenderer() {
    }

    public static RenderPatch[] getBoxSingleTexture(RenderPatchFactory rpf, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax, int tex, boolean rotateTopAndBottom) {
        int[] patchTextureIds = new int[]{tex, tex, tex, tex, tex, tex};
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        if (rotateTopAndBottom) {
            CustomRenderer.addBoxRotatedTopAndBottom(rpf, list, xmin, xmax, ymin, ymax, zmin, zmax, patchTextureIds);
        } else {
            CustomRenderer.addBox(rpf, list, xmin, xmax, ymin, ymax, zmin, zmax, patchTextureIds);
        }
        return list.toArray(new RenderPatch[patchTextureIds.length]);
    }

    public static RenderPatch[] getBoxSingleTextureInt(RenderPatchFactory rpf, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax, int tex, boolean rotateTopAndBottom) {
        return CustomRenderer.getBoxSingleTexture(rpf, (double)xmin / 16.0, (double)xmax / 16.0, (double)ymin / 16.0, (double)ymax / 16.0, (double)zmin / 16.0, (double)zmax / 16.0, tex, rotateTopAndBottom);
    }

    public static RenderPatch[] getBoxMultiTexture(RenderPatchFactory rpf, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax, int startTex) {
        int[] patchTextureIds = new int[]{startTex, startTex + 1, startTex + 2, startTex + 3, startTex + 4, startTex + 5};
        return CustomRenderer.getBoxMultiTexture(rpf, xmin, xmax, ymin, ymax, zmin, zmax, patchTextureIds);
    }

    public static RenderPatch[] getBoxMultiTexture(RenderPatchFactory rpf, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax, int[] patchTextureIds) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        CustomRenderer.addBox(rpf, list, xmin, xmax, ymin, ymax, zmin, zmax, patchTextureIds);
        return list.toArray(new RenderPatch[patchTextureIds.length]);
    }

    public static RenderPatch[] getBoxMultiTextureInt(RenderPatchFactory rpf, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax, int startTex) {
        return CustomRenderer.getBoxMultiTexture(rpf, (double)xmin / 16.0, (double)xmax / 16.0, (double)ymin / 16.0, (double)ymax / 16.0, (double)zmin / 16.0, (double)zmax / 16.0, startTex);
    }

    public static RenderPatch[] getBoxFull(RenderPatchFactory rpf, int[] patchIndices) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, patchIndices);
        return list.toArray(new RenderPatch[patchIndices.length]);
    }

    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        return true;
    }

    public void cleanupRenderer() {
    }

    public String[] getTileEntityFieldsNeeded() {
        return null;
    }

    protected int getMaximumTextureCount() {
        return 1;
    }

    public int getMaximumTextureCount(RenderPatchFactory rpf) {
        return this.getMaximumTextureCount();
    }

    public static RenderPatch[] getRotatedSet(RenderPatchFactory rpf, RenderPatch[] input, int rotX, int rotY, int rotZ) {
        return CustomRenderer.getRotatedSet(rpf, input, rotX, rotY, rotZ, false);
    }

    public static RenderPatch[] getRotatedSet(RenderPatchFactory rpf, RenderPatch[] input, int rotX, int rotY, int rotZ, boolean autoTexCoords) {
        int i;
        RenderPatch[] ret = new RenderPatch[input.length];
        for (i = 0; i < input.length; ++i) {
            ret[i] = autoTexCoords ? rpf.getRotatedPatchAutoTexCoords(input[i], 0, rotY, 0, input[i].getTextureIndex()) : rpf.getRotatedPatch(input[i], 0, rotY, 0, input[i].getTextureIndex());
        }
        if (rotX != 0) {
            for (i = 0; i < input.length; ++i) {
                ret[i] = autoTexCoords ? rpf.getRotatedPatchAutoTexCoords(ret[i], rotX, 0, 0, ret[i].getTextureIndex()) : rpf.getRotatedPatch(ret[i], rotX, 0, 0, ret[i].getTextureIndex());
            }
        }
        if (rotZ != 0) {
            for (i = 0; i < input.length; ++i) {
                ret[i] = autoTexCoords ? rpf.getRotatedPatchAutoTexCoords(ret[i], 0, 0, rotZ, ret[i].getTextureIndex()) : rpf.getRotatedPatch(ret[i], 0, 0, rotZ, ret[i].getTextureIndex());
            }
        }
        return ret;
    }

    public abstract RenderPatch[] getRenderPatchList(MapDataContext var1);

    public static RenderPatch[] combineMultiple(RenderPatch[] ... list) {
        int count = 0;
        for (RenderPatch[] rp : list) {
            count += rp.length;
        }
        RenderPatch[] ret = new RenderPatch[count];
        int j = 0;
        for (RenderPatch[] rp : list) {
            for (int i = 0; i < rp.length; ++i) {
                ret[j++] = rp[i];
            }
        }
        return ret;
    }

    public static RenderPatch[] combineMultiple(RenderPatch ... list) {
        RenderPatch[] ret = new RenderPatch[list.length];
        int j = 0;
        for (RenderPatch rp : list) {
            ret[j++] = rp;
        }
        return ret;
    }

    public CustomRendererData getRenderData(MapDataContext mapDataCtx) {
        return new CustomRendererData(this.getRenderPatchList(mapDataCtx), null, null);
    }

    private static void addIfNonNull(List<RenderPatch> list, RenderPatch p) {
        if (p != null) {
            list.add(p);
        }
    }

    public static void addBox(RenderPatchFactory rpf, List<RenderPatch> list, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax, int[] patchids) {
        if (patchids == null) {
            patchids = default_patches;
        }
        if (patchids[0] >= 0) {
            CustomRenderer.addIfNonNull(list, rpf.getPatch(0.0, ymin, 0.0, 1.0, ymin, 0.0, 0.0, ymin, 1.0, xmin, xmax, zmin, zmax, RenderPatchFactory.SideVisible.TOP, patchids[0]));
        }
        if (patchids[1] >= 0) {
            CustomRenderer.addIfNonNull(list, rpf.getPatch(0.0, ymax, 1.0, 1.0, ymax, 1.0, 0.0, ymax, 0.0, xmin, xmax, 1.0 - zmax, 1.0 - zmin, RenderPatchFactory.SideVisible.TOP, patchids[1]));
        }
        if (patchids[2] >= 0) {
            CustomRenderer.addIfNonNull(list, rpf.getPatch(xmin, 0.0, 0.0, xmin, 0.0, 1.0, xmin, 1.0, 0.0, zmin, zmax, ymin, ymax, RenderPatchFactory.SideVisible.TOP, patchids[2]));
        }
        if (patchids[3] >= 0) {
            CustomRenderer.addIfNonNull(list, rpf.getPatch(xmax, 0.0, 1.0, xmax, 0.0, 0.0, xmax, 1.0, 1.0, 1.0 - zmax, 1.0 - zmin, ymin, ymax, RenderPatchFactory.SideVisible.TOP, patchids[3]));
        }
        if (patchids[4] >= 0) {
            CustomRenderer.addIfNonNull(list, rpf.getPatch(1.0, 0.0, zmin, 0.0, 0.0, zmin, 1.0, 1.0, zmin, 1.0 - xmax, 1.0 - xmin, ymin, ymax, RenderPatchFactory.SideVisible.TOP, patchids[4]));
        }
        if (patchids[5] >= 0) {
            CustomRenderer.addIfNonNull(list, rpf.getPatch(0.0, 0.0, zmax, 1.0, 0.0, zmax, 0.0, 1.0, zmax, xmin, xmax, ymin, ymax, RenderPatchFactory.SideVisible.TOP, patchids[5]));
        }
    }

    public static void addBoxRotatedTopAndBottom(RenderPatchFactory rpf, List<RenderPatch> list, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax, int[] patchids) {
        if (patchids == null) {
            patchids = default_patches;
        }
        if (patchids[0] >= 0) {
            CustomRenderer.addIfNonNull(list, rpf.getPatch(0.0, ymin, 1.0, 1.0, ymin, 1.0, 0.0, ymin, 0.0, xmin, xmax, zmin, zmax, RenderPatchFactory.SideVisible.TOP, patchids[0]));
        }
        if (patchids[1] >= 0) {
            CustomRenderer.addIfNonNull(list, rpf.getPatch(0.0, ymax, 0.0, 0.0, ymax, 1.0, 1.0, ymax, 0.0, 1.0 - zmax, 1.0 - zmin, xmin, xmax, RenderPatchFactory.SideVisible.TOP, patchids[1]));
        }
        if (patchids[2] >= 0) {
            CustomRenderer.addIfNonNull(list, rpf.getPatch(xmin, 0.0, 0.0, xmin, 0.0, 1.0, xmin, 1.0, 0.0, zmin, zmax, ymin, ymax, RenderPatchFactory.SideVisible.TOP, patchids[2]));
        }
        if (patchids[3] >= 0) {
            CustomRenderer.addIfNonNull(list, rpf.getPatch(xmax, 0.0, 1.0, xmax, 0.0, 0.0, xmax, 1.0, 1.0, 1.0 - zmax, 1.0 - zmin, ymin, ymax, RenderPatchFactory.SideVisible.TOP, patchids[3]));
        }
        if (patchids[4] >= 0) {
            CustomRenderer.addIfNonNull(list, rpf.getPatch(1.0, 0.0, zmin, 0.0, 0.0, zmin, 1.0, 1.0, zmin, 1.0 - xmax, 1.0 - xmin, ymin, ymax, RenderPatchFactory.SideVisible.TOP, patchids[4]));
        }
        if (patchids[5] >= 0) {
            CustomRenderer.addIfNonNull(list, rpf.getPatch(0.0, 0.0, zmax, 1.0, 0.0, zmax, 0.0, 1.0, zmax, xmin, xmax, ymin, ymax, RenderPatchFactory.SideVisible.TOP, patchids[5]));
        }
    }

    public static void addBoxInt(RenderPatchFactory rpf, List<RenderPatch> list, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax, int[] patchids) {
        CustomRenderer.addBox(rpf, list, (double)xmin / 16.0, (double)xmax / 16.0, (double)ymin / 16.0, (double)ymax / 16.0, (double)zmin / 16.0, (double)zmax / 16.0, patchids);
    }

    public static RenderPatch getSidePatch(RenderPatchFactory rpf, int side, double setback, double umin, double umax, double vmin, double vmax, int rot, int textureidx) {
        RenderPatch rp = null;
        switch (side) {
            case 0: {
                rp = rpf.getPatch(0.0, setback, 0.0, 1.0, setback, 0.0, 0.0, setback, 1.0, umin, umax, vmin, vmax, RenderPatchFactory.SideVisible.TOP, textureidx);
                if (rot == 0) break;
                rp = rpf.getRotatedPatch(rp, 0, rot, 0, textureidx);
                break;
            }
            case 1: {
                rp = rpf.getPatch(0.0, 1.0 - setback, 1.0, 1.0, 1.0 - setback, 1.0, 0.0, 1.0 - setback, 0.0, umin, umax, 1.0 - vmax, 1.0 - vmin, RenderPatchFactory.SideVisible.TOP, textureidx);
                if (rot == 0) break;
                rp = rpf.getRotatedPatch(rp, 0, 360 - rot, 0, textureidx);
                break;
            }
            case 2: {
                rp = rpf.getPatch(1.0, 0.0, setback, 0.0, 0.0, setback, 1.0, 1.0, setback, 1.0 - umax, 1.0 - umin, vmin, vmax, RenderPatchFactory.SideVisible.TOP, textureidx);
                if (rot == 0) break;
                rp = rpf.getRotatedPatch(rp, 0, 0, rot, textureidx);
                break;
            }
            case 3: {
                rp = rpf.getPatch(0.0, 0.0, 1.0 - setback, 1.0, 0.0, 1.0 - setback, 0.0, 1.0, 1.0 - setback, umin, umax, vmin, vmax, RenderPatchFactory.SideVisible.TOP, textureidx);
                if (rot == 0) break;
                rp = rpf.getRotatedPatch(rp, 0, 0, 360 - rot, textureidx);
                break;
            }
            case 4: {
                rp = rpf.getPatch(setback, 0.0, 0.0, setback, 0.0, 1.0, setback, 1.0, 0.0, umin, umax, vmin, vmax, RenderPatchFactory.SideVisible.TOP, textureidx);
                if (rot == 0) break;
                rp = rpf.getRotatedPatch(rp, rot, 0, 0, textureidx);
                break;
            }
            case 5: {
                rp = rpf.getPatch(1.0 - setback, 0.0, 1.0, 1.0 - setback, 0.0, 0.0, 1.0 - setback, 1.0, 1.0, 1.0 - umax, 1.0 - umin, vmin, vmax, RenderPatchFactory.SideVisible.TOP, textureidx);
                if (rot == 0) break;
                rp = rpf.getRotatedPatch(rp, 360 - rot, 0, 0, textureidx);
            }
        }
        return rp;
    }

    public static RenderPatch getSidePatch(RenderPatchFactory rpf, int side, int rot, int textureidx) {
        return CustomRenderer.getSidePatch(rpf, side, 0.0, 0.0, 1.0, 0.0, 1.0, rot, textureidx);
    }

    public static RenderPatch[] getFullBlock(RenderPatchFactory rpf, int fixedTexture) {
        int[] patchTextureIds = new int[]{0, 1, 4, 5, 2, 3};
        if (fixedTexture != -1) {
            for (int i = 0; i < patchTextureIds.length; ++i) {
                patchTextureIds[i] = fixedTexture;
            }
        }
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, patchTextureIds);
        return list.toArray(new RenderPatch[patchTextureIds.length]);
    }

    public static RenderPatch[] getFullBlock(RenderPatchFactory rpf, int[] patchTextureIds) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, patchTextureIds);
        return list.toArray(new RenderPatch[patchTextureIds.length]);
    }
}

