/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.modsupport.impl;

import java.util.ArrayList;
import java.util.Arrays;
import org.dynmap.modsupport.BlockSide;
import org.dynmap.modsupport.BlockTextureRecord;
import org.dynmap.modsupport.TextureFile;
import org.dynmap.modsupport.TextureModifier;
import org.dynmap.modsupport.TransparencyMode;

public class BlockTextureRecordImpl
implements BlockTextureRecord {
    private int[] ids = new int[0];
    private String[] names = new String[0];
    private int metaMask = -1;
    private TransparencyMode transmode = TransparencyMode.OPAQUE;
    private ArrayList<TexturePatch> txtPatches = new ArrayList();
    private TexturePatch blockColor = null;
    private static final int[] patchBySideOrdinal = new int[]{2, 16, 4, 32, 1, 8, 2, 16, 4, 32, 1, 8, 2, 16, 4, 32, 1, 8, 45, 63};
    public static final int COLORMOD_GRASSTONED = 1;
    public static final int COLORMOD_FOLIAGETONED = 2;
    public static final int COLORMOD_WATERTONED = 3;
    public static final int COLORMOD_ROT90 = 4;
    public static final int COLORMOD_ROT180 = 5;
    public static final int COLORMOD_ROT270 = 6;
    public static final int COLORMOD_FLIPHORIZ = 7;
    public static final int COLORMOD_SHIFTDOWNHALF = 8;
    public static final int COLORMOD_SHIFTDOWNHALFANDFLIPHORIZ = 9;
    public static final int COLORMOD_INCLINEDTORCH = 10;
    public static final int COLORMOD_GRASSSIDE = 11;
    public static final int COLORMOD_CLEARINSIDE = 12;
    public static final int COLORMOD_PINETONED = 13;
    public static final int COLORMOD_BIRCHTONED = 14;
    public static final int COLORMOD_LILYTONED = 15;
    public static final int COLORMOD_MULTTONED = 17;
    public static final int COLORMOD_GRASSTONED270 = 18;
    public static final int COLORMOD_FOLIAGETONED270 = 19;
    public static final int COLORMOD_WATERTONED270 = 20;
    public static final int COLORMOD_MULTTONED_CLEARINSIDE = 21;
    public static final int COLORMOD_FOLIAGEMULTTONED = 22;
    private static final int[] modValueByModifierOrd = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 18, 19, 20, 21, 22};

    public BlockTextureRecordImpl(int blkid) {
        this.addBlockID(blkid);
        for (int i = 0; i < 6; ++i) {
            this.txtPatches.add(null);
        }
    }

    public BlockTextureRecordImpl(String blkname) {
        this.addBlockName(blkname);
        for (int i = 0; i < 6; ++i) {
            this.txtPatches.add(null);
        }
    }

    @Override
    public void addBlockID(int blockID) {
        if (blockID > 0 && blockID < 4096) {
            for (int i = 0; i < this.ids.length; ++i) {
                if (this.ids[i] != blockID) continue;
                return;
            }
            this.ids = Arrays.copyOf(this.ids, this.ids.length + 1);
            this.ids[this.ids.length - 1] = blockID;
        }
    }

    @Override
    public void addBlockName(String blockname) {
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equals(blockname)) continue;
            return;
        }
        this.names = Arrays.copyOf(this.names, this.names.length + 1);
        this.names[this.names.length - 1] = blockname;
    }

    @Override
    public int[] getBlockIDs() {
        return this.ids;
    }

    @Override
    public String[] getBlockNames() {
        return this.names;
    }

    @Override
    public void setMetaValue(int data) {
        if (data < 0) {
            this.metaMask = -1;
        } else if (data < 16) {
            if (this.metaMask == -1) {
                this.metaMask = 0;
            }
            this.metaMask |= 1 << data;
        }
    }

    @Override
    public int getMetaValueMask() {
        return this.metaMask;
    }

    @Override
    public void setTransparencyMode(TransparencyMode mode) {
        this.transmode = mode;
    }

    @Override
    public TransparencyMode getTransparencyMode() {
        return this.transmode;
    }

    @Override
    public void setSideTexture(String txtFileID, BlockSide side) {
        this.setSideTexture(txtFileID, 0, TextureModifier.NONE, side);
    }

    @Override
    public void setSideTexture(TextureFile txtFile, BlockSide side) {
        this.setSideTexture(txtFile.getTextureID(), 0, TextureModifier.NONE, side);
    }

    @Override
    public void setSideTexture(String txtFileID, int txtIndex, BlockSide side) {
        this.setSideTexture(txtFileID, txtIndex, TextureModifier.NONE, side);
    }

    @Override
    public void setSideTexture(TextureFile txtFile, int txtIndex, BlockSide side) {
        this.setSideTexture(txtFile.getTextureID(), txtIndex, TextureModifier.NONE, side);
    }

    @Override
    public void setSideTexture(String txtFileID, TextureModifier modifier, BlockSide side) {
        this.setSideTexture(txtFileID, 0, modifier, side);
    }

    @Override
    public void setSideTexture(TextureFile txtFile, TextureModifier modifier, BlockSide side) {
        this.setSideTexture(txtFile.getTextureID(), 0, modifier, side);
    }

    @Override
    public void setSideTexture(String txtFileID, int txtIndex, TextureModifier modifier, BlockSide side) {
        int patchflags = patchBySideOrdinal[side.ordinal()];
        for (int i = 0; i < 6; ++i) {
            if ((patchflags & 1 << i) == 0) continue;
            this.setPatchTexture(txtFileID, txtIndex, modifier, i);
        }
    }

    @Override
    public void setSideTexture(TextureFile txtFile, int txtIndex, TextureModifier modifier, BlockSide side) {
        this.setSideTexture(txtFile.getTextureID(), txtIndex, modifier, side);
    }

    @Override
    public void setPatchTexture(String txtFileID, int patchIndex) {
        this.setPatchTexture(txtFileID, 0, TextureModifier.NONE, patchIndex);
    }

    @Override
    public void setPatchTexture(TextureFile txtFile, int patchIndex) {
        this.setPatchTexture(txtFile.getTextureID(), 0, TextureModifier.NONE, patchIndex);
    }

    @Override
    public void setPatchTexture(String txtFileID, int txtIndex, int patchIndex) {
        this.setPatchTexture(txtFileID, txtIndex, TextureModifier.NONE, patchIndex);
    }

    @Override
    public void setPatchTexture(TextureFile txtFile, int txtIndex, int patchIndex) {
        this.setPatchTexture(txtFile.getTextureID(), txtIndex, TextureModifier.NONE, patchIndex);
    }

    @Override
    public void setPatchTexture(String txtFileID, TextureModifier modifier, int patchIndex) {
        this.setPatchTexture(txtFileID, 0, modifier, patchIndex);
    }

    @Override
    public void setPatchTexture(TextureFile txtFile, TextureModifier modifier, int patchIndex) {
        this.setPatchTexture(txtFile.getTextureID(), 0, modifier, patchIndex);
    }

    @Override
    public void setPatchTexture(String txtFileID, int txtIndex, TextureModifier modifier, int patchIndex) {
        while (this.txtPatches.size() <= patchIndex) {
            this.txtPatches.add(null);
        }
        TexturePatch tp = new TexturePatch();
        tp.txtFileID = txtFileID;
        tp.txtIndex = txtIndex;
        tp.txtMod = modifier;
        this.txtPatches.set(patchIndex, tp);
    }

    @Override
    public void setPatchTexture(TextureFile txtFile, int txtIndex, TextureModifier modifier, int patchIndex) {
        this.setPatchTexture(txtFile.getTextureID(), txtIndex, modifier, patchIndex);
    }

    private TexturePatch getPatchBySide(BlockSide side) {
        int patchflags = patchBySideOrdinal[side.ordinal()];
        for (int i = 0; i < 6; ++i) {
            if ((patchflags & 1 << i) == 0) continue;
            return this.txtPatches.get(i);
        }
        return null;
    }

    @Override
    public String getSideTextureID(BlockSide side) {
        TexturePatch tp = this.getPatchBySide(side);
        if (tp != null) {
            return tp.txtFileID;
        }
        return null;
    }

    @Override
    public TextureModifier getSideTextureModifier(BlockSide side) {
        TexturePatch tp = this.getPatchBySide(side);
        if (tp != null) {
            return tp.txtMod;
        }
        return TextureModifier.NONE;
    }

    @Override
    public int getSideTextureIndex(BlockSide side) {
        TexturePatch tp = this.getPatchBySide(side);
        if (tp != null) {
            return tp.txtIndex;
        }
        return 0;
    }

    @Override
    public String getPatchTextureID(int patchIndex) {
        TexturePatch tp = this.txtPatches.get(patchIndex);
        if (tp != null) {
            return tp.txtFileID;
        }
        return null;
    }

    @Override
    public TextureModifier getPatchTextureModifier(int patchIndex) {
        TexturePatch tp = this.txtPatches.get(patchIndex);
        if (tp != null) {
            return tp.txtMod;
        }
        return TextureModifier.NONE;
    }

    @Override
    public int getPatchTextureIndex(int patchIndex) {
        TexturePatch tp = this.txtPatches.get(patchIndex);
        if (tp != null) {
            return tp.txtIndex;
        }
        return 0;
    }

    @Override
    public void setBlockColorMapTexture(String txtFileID) {
        TexturePatch tp = new TexturePatch();
        tp.txtFileID = txtFileID;
        tp.txtIndex = 0;
        tp.txtMod = TextureModifier.NONE;
        this.blockColor = tp;
    }

    @Override
    public void setBlockColorMapTexture(TextureFile txtFile) {
        this.setBlockColorMapTexture(txtFile.getTextureID());
    }

    public String getLine() {
        int i;
        if (this.ids.length == 0 && this.names.length == 0) {
            return null;
        }
        String s = "block:";
        int idcnt = 0;
        for (i = 0; i < this.ids.length; ++i) {
            s = i == 0 ? s + "id=" + this.ids[i] : s + ",id=" + this.ids[i];
            ++idcnt;
        }
        for (i = 0; i < this.names.length; ++i) {
            if (idcnt > 0) {
                s = s + ",";
            }
            s = s + "id=%" + this.names[i];
            ++idcnt;
        }
        if (this.metaMask == -1) {
            s = s + ",data=*";
        } else {
            for (i = 0; i < 16; ++i) {
                if ((this.metaMask & 1 << i) == 0) continue;
                s = s + ",data=" + i;
            }
        }
        for (i = 0; i < this.txtPatches.size(); ++i) {
            TexturePatch tp = this.txtPatches.get(i);
            if (tp == null) continue;
            int idx = modValueByModifierOrd[tp.txtMod.ordinal()] * 1000 + tp.txtIndex;
            s = s + ",patch" + i + "=" + idx + ":" + tp.txtFileID;
        }
        if (this.blockColor != null) {
            s = s + ",blockcolor=" + this.blockColor.txtFileID;
        }
        switch (this.transmode) {
            case TRANSPARENT: {
                s = s + ",transparency=TRANSPARENT";
                break;
            }
            case SEMITRANSPARENT: {
                s = s + ",transparency=SEMITRANSPARENT";
                break;
            }
        }
        s = s + ",stdrot=true";
        return s;
    }

    private static class TexturePatch {
        private String txtFileID;
        private int txtIndex;
        private TextureModifier txtMod;

        private TexturePatch() {
        }
    }
}

