/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.modsupport.impl;

import java.util.Arrays;
import org.dynmap.modsupport.BlockModel;
import org.dynmap.modsupport.impl.ModModelDefinitionImpl;

public abstract class BlockModelImpl
implements BlockModel {
    private int[] ids = new int[0];
    private String[] names = new String[0];
    private int metaMask = -1;
    protected final ModModelDefinitionImpl mdf;

    public BlockModelImpl(int blkid, ModModelDefinitionImpl mdf) {
        this.addBlockID(blkid);
        this.mdf = mdf;
    }

    public BlockModelImpl(String blkname, ModModelDefinitionImpl mdf) {
        this.addBlockName(blkname);
        this.mdf = mdf;
    }

    @Override
    public void addBlockID(int blockID) {
        if (blockID > 0 && blockID < 4096) {
            for (int i = 0; i < this.ids.length; ++i) {
                if (this.ids[i] != blockID) continue;
                return;
            }
            this.ids = Arrays.copyOf(this.ids, this.ids.length + 1);
            this.ids[this.ids.length - 1] = blockID;
        }
    }

    @Override
    public void addBlockName(String blockname) {
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equals(blockname)) continue;
            return;
        }
        this.names = Arrays.copyOf(this.names, this.names.length + 1);
        this.names[this.names.length - 1] = blockname;
    }

    @Override
    public int[] getBlockIDs() {
        return this.ids;
    }

    @Override
    public String[] getBlockNames() {
        return this.names;
    }

    @Override
    public void setMetaValue(int data) {
        if (data < 0) {
            this.metaMask = -1;
        } else if (data < 16) {
            if (this.metaMask == -1) {
                this.metaMask = 0;
            }
            this.metaMask |= 1 << data;
        }
    }

    @Override
    public int getMetaValueMask() {
        return this.metaMask;
    }

    public abstract String getLine();

    protected String getIDsAndMeta() {
        int i;
        if (this.ids.length == 0 && this.names.length == 0) {
            return null;
        }
        String s = "";
        for (i = 0; i < this.ids.length; ++i) {
            s = i == 0 ? s + "id=" + this.ids[i] : s + ",id=" + this.ids[i];
        }
        for (i = 0; i < this.names.length; ++i) {
            if (s.length() > 0) {
                s = s + ",";
            }
            s = s + "id=%" + this.names[i];
        }
        if (this.metaMask == -1) {
            s = s + ",data=*";
        } else {
            for (i = 0; i < 16; ++i) {
                if ((this.metaMask & 1 << i) == 0) continue;
                s = s + ",data=" + i;
            }
        }
        return s;
    }
}

