/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.markers.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapWorld;
import org.dynmap.markers.MarkerSet;
import org.dynmap.markers.PolyLineMarker;
import org.dynmap.markers.impl.MarkerAPIImpl;
import org.dynmap.markers.impl.MarkerSetImpl;

class PolyLineMarkerImpl
implements PolyLineMarker {
    private String markerid;
    private String label;
    private boolean markup;
    private String desc;
    private MarkerSetImpl markerset;
    private String world;
    private String normalized_world;
    private boolean ispersistent;
    private ArrayList<Coord> corners;
    private int lineweight = 3;
    private double lineopacity = 0.8;
    private int linecolor = 0xFF0000;
    private int minzoom;
    private int maxzoom;

    PolyLineMarkerImpl(String id, String lbl, boolean markup, String world, double[] x, double[] y, double[] z, boolean persistent, MarkerSetImpl set) {
        this.markerid = id;
        this.label = lbl != null ? lbl : id;
        this.markup = markup;
        this.corners = new ArrayList();
        for (int i = 0; i < x.length; ++i) {
            this.corners.add(new Coord(x[i], y[i], z[i]));
        }
        this.world = world;
        this.normalized_world = DynmapWorld.normalizeWorldName(world);
        this.desc = null;
        this.minzoom = -1;
        this.maxzoom = -1;
        this.ispersistent = persistent;
        this.markerset = set;
    }

    PolyLineMarkerImpl(String id, MarkerSetImpl set) {
        this.markerid = id;
        this.markerset = set;
        this.label = id;
        this.markup = false;
        this.desc = null;
        this.corners = new ArrayList();
        this.minzoom = -1;
        this.maxzoom = -1;
        this.normalized_world = "world";
        this.world = "world";
    }

    boolean loadPersistentData(ConfigurationNode node) {
        this.label = node.getString("label", this.markerid);
        this.markup = node.getBoolean("markup", false);
        List xx = node.getList("x");
        List yy = node.getList("y");
        List zz = node.getList("z");
        this.corners.clear();
        if (xx != null && yy != null && zz != null) {
            int sz = Math.min(xx.size(), Math.min(yy.size(), zz.size()));
            for (int i = 0; i < sz; ++i) {
                this.corners.add(new Coord((Double)xx.get(i), (Double)yy.get(i), (Double)zz.get(i)));
            }
        }
        this.world = node.getString("world", "world");
        this.normalized_world = DynmapWorld.normalizeWorldName(this.world);
        this.desc = node.getString("desc", null);
        this.lineweight = node.getInteger("strokeWeight", -1);
        if (this.lineweight == -1) {
            this.lineweight = node.getInteger("stokeWeight", 3);
        }
        this.lineopacity = node.getDouble("strokeOpacity", 0.8);
        this.linecolor = node.getInteger("strokeColor", 0xFF0000);
        this.minzoom = node.getInteger("minzoom", -1);
        this.maxzoom = node.getInteger("maxzoom", -1);
        this.ispersistent = true;
        return true;
    }

    void cleanup() {
        this.corners.clear();
        this.markerset = null;
    }

    @Override
    public String getMarkerID() {
        return this.markerid;
    }

    @Override
    public MarkerSet getMarkerSet() {
        return this.markerset;
    }

    @Override
    public void deleteMarker() {
        if (this.markerset == null) {
            return;
        }
        this.markerset.removePolyLineMarker(this);
        this.cleanup();
    }

    @Override
    public boolean isPersistentMarker() {
        return this.ispersistent;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String lbl) {
        this.setLabel(lbl, false);
    }

    @Override
    public void setLabel(String lbl, boolean markup) {
        if (this.markerset == null) {
            return;
        }
        this.label = lbl;
        this.markup = markup;
        MarkerAPIImpl.polyLineMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }

    Map<String, Object> getPersistentData() {
        if (!this.ispersistent) {
            return null;
        }
        HashMap<String, Object> node = new HashMap<String, Object>();
        node.put("label", this.label);
        node.put("markup", this.markup);
        ArrayList<Double> xx = new ArrayList<Double>();
        ArrayList<Double> yy = new ArrayList<Double>();
        ArrayList<Double> zz = new ArrayList<Double>();
        for (int i = 0; i < this.corners.size(); ++i) {
            Coord c = this.corners.get(i);
            xx.add(c.x);
            yy.add(c.y);
            zz.add(c.z);
        }
        node.put("x", xx);
        node.put("y", yy);
        node.put("z", zz);
        node.put("world", this.world);
        if (this.desc != null) {
            node.put("desc", this.desc);
        }
        node.put("strokeWeight", this.lineweight);
        node.put("strokeOpacity", this.lineopacity);
        node.put("strokeColor", this.linecolor);
        if (this.minzoom >= 0) {
            node.put("minzoom", this.minzoom);
        }
        if (this.maxzoom >= 0) {
            node.put("maxzoom", this.maxzoom);
        }
        return node;
    }

    @Override
    public String getWorld() {
        return this.world;
    }

    @Override
    public String getNormalizedWorld() {
        return this.normalized_world;
    }

    @Override
    public boolean isLabelMarkup() {
        return this.markup;
    }

    @Override
    public void setDescription(String desc) {
        if (this.markerset == null) {
            return;
        }
        if (this.desc == null || !this.desc.equals(desc)) {
            this.desc = desc;
            MarkerAPIImpl.polyLineMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
        }
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public int getCornerCount() {
        return this.corners.size();
    }

    @Override
    public double getCornerX(int n) {
        Coord c = this.corners.get(n);
        if (c != null) {
            return c.x;
        }
        return 0.0;
    }

    @Override
    public double getCornerY(int n) {
        Coord c = this.corners.get(n);
        if (c != null) {
            return c.y;
        }
        return 0.0;
    }

    @Override
    public double getCornerZ(int n) {
        Coord c = this.corners.get(n);
        if (c != null) {
            return c.z;
        }
        return 0.0;
    }

    @Override
    public void setCornerLocation(int n, double x, double y, double z) {
        if (this.markerset == null) {
            return;
        }
        if (n >= this.corners.size()) {
            this.corners.add(new Coord(x, y, z));
        } else {
            Coord c = this.corners.get(n);
            if (c.x == x && c.y == y && c.z == z) {
                return;
            }
            c.x = x;
            c.y = y;
            c.z = z;
        }
        MarkerAPIImpl.polyLineMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }

    @Override
    public void deleteCorner(int n) {
        if (this.markerset == null) {
            return;
        }
        if (n < this.corners.size()) {
            this.corners.remove(n);
            MarkerAPIImpl.polyLineMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
        }
    }

    @Override
    public void setCornerLocations(double[] x, double[] y, double[] z) {
        if (this.markerset == null) {
            return;
        }
        int sz = Math.min(x.length, Math.min(y.length, z.length));
        if (sz == this.corners.size()) {
            boolean match = true;
            for (int i = 0; i < sz; ++i) {
                Coord c = this.corners.get(i);
                if (c.x == x[i] && c.y == y[i] && c.z == z[i]) continue;
                match = false;
                break;
            }
            if (match) {
                return;
            }
        }
        this.corners.clear();
        for (int i = 0; i < sz; ++i) {
            this.corners.add(new Coord(x[i], y[i], z[i]));
        }
        MarkerAPIImpl.polyLineMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }

    @Override
    public void setLineStyle(int weight, double opacity, int color) {
        if (this.markerset == null) {
            return;
        }
        if (weight != this.lineweight || opacity != this.lineopacity || color != this.linecolor) {
            this.lineweight = weight;
            this.lineopacity = opacity;
            this.linecolor = color;
            MarkerAPIImpl.polyLineMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
        }
    }

    @Override
    public int getLineWeight() {
        return this.lineweight;
    }

    @Override
    public double getLineOpacity() {
        return this.lineopacity;
    }

    @Override
    public int getLineColor() {
        return this.linecolor;
    }

    @Override
    public void setMarkerSet(MarkerSet newset) {
        if (this.markerset != null) {
            this.markerset.removePolyLineMarker(this);
        }
        this.markerset = (MarkerSetImpl)newset;
        this.markerset.insertPolyLineMarker(this);
    }

    @Override
    public int getMinZoom() {
        return this.minzoom;
    }

    @Override
    public void setMinZoom(int zoom) {
        if (zoom < 0) {
            zoom = -1;
        }
        if (this.minzoom == zoom) {
            return;
        }
        this.minzoom = zoom;
        MarkerAPIImpl.polyLineMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }

    @Override
    public int getMaxZoom() {
        return this.maxzoom;
    }

    @Override
    public void setMaxZoom(int zoom) {
        if (zoom < 0) {
            zoom = -1;
        }
        if (this.maxzoom == zoom) {
            return;
        }
        this.maxzoom = zoom;
        MarkerAPIImpl.polyLineMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }

    private static class Coord {
        double x;
        double y;
        double z;

        Coord(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

