/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class ThaumcraftTableRenderer
extends CustomRenderer {
    RenderPatch[] otherTable;
    RenderPatch[] table;
    RenderPatch[] craftingTable;

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkid, blockdatamask, custparm)) {
            return false;
        }
        this.otherTable = ThaumcraftTableRenderer.getFullBlock(rpf, 3);
        this.table = this.makeTable(rpf);
        this.craftingTable = this.makeCraftingTable(rpf);
        return true;
    }

    RenderPatch[] makeTable(RenderPatchFactory rpf) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        int[] patchTextureIds = new int[]{0, 0, 0, 0, 0, 0};
        CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.5, 1.0, 0.0, 1.0, patchTextureIds);
        CustomRenderer.addBox(rpf, list, 0.25, 0.75, 0.25, 0.5, 0.25, 0.75, patchTextureIds);
        CustomRenderer.addBox(rpf, list, 0.2, 0.8, 0.0, 0.25, 0.0, 1.0, patchTextureIds);
        return list.toArray(new RenderPatch[list.size()]);
    }

    RenderPatch[] makeCraftingTable(RenderPatchFactory rpf) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        int[] patchTextureIds = new int[]{0, 1, 2, 2, 2, 2};
        CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.5, 1.0, 0.0, 1.0, patchTextureIds);
        patchTextureIds = new int[]{0, 0, 0, 0, 0, 0};
        CustomRenderer.addBox(rpf, list, 0.0, 0.2, 0.2, 0.5, 0.0, 0.2, patchTextureIds);
        CustomRenderer.addBox(rpf, list, 0.8, 1.0, 0.2, 0.5, 0.0, 0.2, patchTextureIds);
        CustomRenderer.addBox(rpf, list, 0.0, 0.2, 0.2, 0.5, 0.8, 1.0, patchTextureIds);
        CustomRenderer.addBox(rpf, list, 0.8, 1.0, 0.2, 0.5, 0.8, 1.0, patchTextureIds);
        patchTextureIds = new int[]{0, 0, 0, 0, 0, 0};
        CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 0.2, 0.0, 1.0, patchTextureIds);
        return list.toArray(new RenderPatch[list.size()]);
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        int data = mapDataCtx.getBlockData();
        switch (data) {
            case 0: 
            case 2: 
            case 5: 
            case 7: {
                return this.table;
            }
            case 15: {
                return this.craftingTable;
            }
        }
        return this.table;
    }
}

