/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class StairBlockRenderer
extends CustomRenderer {
    private static final int TEXTURE_SIDES = 0;
    private static final int TEXTURE_TOP = 1;
    private static final int TEXTURE_BOTTOM = 2;
    private static BitSet stair_ids = new BitSet();
    private RenderPatch[][] stepmeshes = new RenderPatch[8][];
    private RenderPatch[][] step_3_4_meshes = new RenderPatch[8][];
    private RenderPatch[][] step_1_4_meshes = new RenderPatch[8][];
    private int textsetcnt = 0;
    private String textindex = null;
    private String[] tilefields = null;
    private String[] texturemap;
    private static final int[] patchlist = new int[]{2, 1, 0, 0, 0, 0};
    private static final int[] off_x = new int[]{1, -1, 0, 0, 1, -1, 0, 0};
    private static final int[] off_z = new int[]{0, 0, 1, -1, 0, 0, 1, -1};
    private static final int[] match1 = new int[]{2, 3, 0, 1, 6, 7, 4, 5};
    private static final int[] corner1 = new int[]{3, 1, 3, 1, 7, 5, 7, 5};
    private static final int[] icorner1 = new int[]{1, 2, 1, 2, 5, 6, 5, 6};
    private static final int[] match2 = new int[]{3, 2, 1, 0, 7, 6, 5, 4};
    private static final int[] corner2 = new int[]{0, 2, 2, 0, 4, 6, 6, 4};
    private static final int[] icorner2 = new int[]{0, 3, 3, 0, 4, 7, 7, 4};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkid, blockdatamask, custparm)) {
            return false;
        }
        stair_ids.set(blkid);
        for (int i = 0; i < 8; ++i) {
            this.stepmeshes[i] = this.buildStepMeshes(rpf, i);
            this.step_1_4_meshes[i] = this.buildCornerStepMeshes(rpf, i);
            this.step_3_4_meshes[i] = this.buildIntCornerStepMeshes(rpf, i);
        }
        this.textindex = custparm.get("textureindex");
        if (this.textindex != null) {
            String cnt = custparm.get("texturecnt");
            this.textsetcnt = cnt != null ? Integer.parseInt(cnt) : 16;
            this.tilefields = new String[]{this.textindex};
            this.texturemap = new String[this.textsetcnt];
            for (int i = 0; i < this.textsetcnt; ++i) {
                this.texturemap[i] = custparm.get("textmap" + i);
                if (this.texturemap[i] != null) continue;
                this.texturemap[i] = Integer.toString(i);
            }
        }
        return true;
    }

    @Override
    public int getMaximumTextureCount() {
        if (this.textsetcnt == 0) {
            return 3;
        }
        return this.textsetcnt;
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return this.tilefields;
    }

    private void addBox(RenderPatchFactory rpf, List<RenderPatch> list, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        StairBlockRenderer.addBox(rpf, list, xmin, xmax, ymin, ymax, zmin, zmax, patchlist);
    }

    private RenderPatch[] buildStepMeshes(RenderPatchFactory rpf, int dat) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        if ((dat & 4) != 0) {
            this.addBox(rpf, list, 0.0, 1.0, 0.5, 1.0, 0.0, 1.0);
        } else {
            this.addBox(rpf, list, 0.0, 1.0, 0.0, 0.5, 0.0, 1.0);
        }
        switch (dat & 3) {
            case 0: {
                this.addBox(rpf, list, 0.5, 1.0, 0.0, 1.0, 0.0, 1.0);
                break;
            }
            case 1: {
                this.addBox(rpf, list, 0.0, 0.5, 0.0, 1.0, 0.0, 1.0);
                break;
            }
            case 2: {
                this.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.5, 1.0);
                break;
            }
            case 3: {
                this.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.0, 0.5);
            }
        }
        return list.toArray(new RenderPatch[list.size()]);
    }

    private RenderPatch[] buildCornerStepMeshes(RenderPatchFactory rpf, int dat) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        if ((dat & 4) != 0) {
            this.addBox(rpf, list, 0.0, 1.0, 0.5, 1.0, 0.0, 1.0);
        } else {
            this.addBox(rpf, list, 0.0, 1.0, 0.0, 0.5, 0.0, 1.0);
        }
        switch (dat & 3) {
            case 0: {
                this.addBox(rpf, list, 0.5, 1.0, 0.0, 1.0, 0.0, 0.5);
                break;
            }
            case 1: {
                this.addBox(rpf, list, 0.0, 0.5, 0.0, 1.0, 0.0, 0.5);
                break;
            }
            case 2: {
                this.addBox(rpf, list, 0.0, 0.5, 0.0, 1.0, 0.5, 1.0);
                break;
            }
            case 3: {
                this.addBox(rpf, list, 0.5, 1.0, 0.0, 1.0, 0.5, 1.0);
            }
        }
        return list.toArray(new RenderPatch[list.size()]);
    }

    private RenderPatch[] buildIntCornerStepMeshes(RenderPatchFactory rpf, int dat) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        if ((dat & 4) != 0) {
            this.addBox(rpf, list, 0.0, 1.0, 0.5, 1.0, 0.0, 1.0);
        } else {
            this.addBox(rpf, list, 0.0, 1.0, 0.0, 0.5, 0.0, 1.0);
        }
        switch (dat & 3) {
            case 0: {
                this.addBox(rpf, list, 0.5, 1.0, 0.0, 1.0, 0.0, 1.0);
                this.addBox(rpf, list, 0.0, 0.5, 0.0, 1.0, 0.0, 0.5);
                break;
            }
            case 1: {
                this.addBox(rpf, list, 0.5, 1.0, 0.0, 1.0, 0.0, 1.0);
                this.addBox(rpf, list, 0.0, 0.5, 0.0, 1.0, 0.5, 1.0);
                break;
            }
            case 2: {
                this.addBox(rpf, list, 0.0, 0.5, 0.0, 1.0, 0.0, 1.0);
                this.addBox(rpf, list, 0.5, 1.0, 0.0, 1.0, 0.0, 0.5);
                break;
            }
            case 3: {
                this.addBox(rpf, list, 0.0, 0.5, 0.0, 1.0, 0.0, 1.0);
                this.addBox(rpf, list, 0.5, 1.0, 0.0, 1.0, 0.5, 1.0);
            }
        }
        return list.toArray(new RenderPatch[list.size()]);
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        RenderPatch[] rp = this.getBaseRenderPatchList(ctx);
        if (this.textindex != null) {
            int i;
            int idx = 0;
            Object o = ctx.getBlockTileEntityField(this.textindex);
            if (o instanceof Number) {
                idx = ((Number)o).intValue();
            } else if (o instanceof String) {
                String os = (String)o;
                for (i = 0; i < this.texturemap.length; ++i) {
                    if (!os.equals(this.texturemap[i])) continue;
                    idx = i;
                    break;
                }
            }
            if (idx < 0 || idx >= this.textsetcnt) {
                idx = 0;
            }
            RenderPatch[] rp2 = new RenderPatch[rp.length];
            for (i = 0; i < rp.length; ++i) {
                rp2[i] = ctx.getPatchFactory().getRotatedPatch(rp[i], 0, 0, 0, idx);
            }
            return rp2;
        }
        return rp;
    }

    private RenderPatch[] getBaseRenderPatchList(MapDataContext ctx) {
        int sideid;
        int cornerdat;
        int data = ctx.getBlockData() & 7;
        int cornerid = ctx.getBlockTypeIDAt(off_x[data], 0, off_z[data]);
        if (stair_ids.get(cornerid)) {
            cornerdat = ctx.getBlockDataAt(off_x[data], 0, off_z[data]);
            if (cornerdat == match1[data]) {
                sideid = ctx.getBlockTypeIDAt(-off_x[cornerdat], 0, -off_z[cornerdat]);
                if (!stair_ids.get(sideid) || ctx.getBlockDataAt(-off_x[cornerdat], 0, -off_z[cornerdat]) != data) {
                    return this.step_1_4_meshes[corner1[data]];
                }
            } else if (!(cornerdat != match2[data] || stair_ids.get(sideid = ctx.getBlockTypeIDAt(-off_x[cornerdat], 0, -off_z[cornerdat])) && ctx.getBlockDataAt(-off_x[cornerdat], 0, -off_z[cornerdat]) == data)) {
                return this.step_1_4_meshes[corner2[data]];
            }
        }
        if (stair_ids.get(cornerid = ctx.getBlockTypeIDAt(-off_x[data], 0, -off_z[data]))) {
            cornerdat = ctx.getBlockDataAt(-off_x[data], 0, -off_z[data]);
            if (cornerdat == match1[data]) {
                sideid = ctx.getBlockTypeIDAt(off_x[cornerdat], 0, off_z[cornerdat]);
                if (!stair_ids.get(sideid) || ctx.getBlockDataAt(off_x[cornerdat], 0, off_z[cornerdat]) != data) {
                    return this.step_3_4_meshes[icorner1[data]];
                }
            } else if (!(cornerdat != match2[data] || stair_ids.get(sideid = ctx.getBlockTypeIDAt(off_x[cornerdat], 0, off_z[cornerdat])) && ctx.getBlockDataAt(off_x[cornerdat], 0, off_z[cornerdat]) == data)) {
                return this.step_3_4_meshes[icorner2[data]];
            }
        }
        return this.stepmeshes[data];
    }
}

