/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.Map;
import org.dynmap.Log;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class SimpleMultiBoxRenderer
extends CustomRenderer {
    RenderPatch[] model;
    private static final int[] patchlist = new int[]{0, 1, 4, 5, 2, 3};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        String data;
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        for (int i = 0; i < 1000 && (data = custparm.get("box" + i)) != null; ++i) {
            int j;
            String[] parts = data.split(":");
            if (parts.length != 5) {
                Log.severe("Error initializing SimpleMultiBoxBlockRenderer for block " + blkid);
                break;
            }
            boolean intMode = false;
            if (parts[0].equals("i")) {
                intMode = true;
            }
            double xmin = 0.0;
            double xmax = 1.0;
            double ymin = 0.0;
            double ymax = 1.0;
            double zmin = 0.0;
            double zmax = 1.0;
            String[] xparts = parts[1].split("-");
            String[] yparts = parts[2].split("-");
            String[] zparts = parts[3].split("-");
            if (intMode) {
                xmin = (double)Integer.valueOf(xparts[0]).intValue() / 16.0;
                xmax = (double)Integer.valueOf(xparts[1]).intValue() / 16.0;
                ymin = (double)Integer.valueOf(yparts[0]).intValue() / 16.0;
                ymax = (double)Integer.valueOf(yparts[1]).intValue() / 16.0;
                zmin = (double)Integer.valueOf(zparts[0]).intValue() / 16.0;
                zmax = (double)Integer.valueOf(zparts[1]).intValue() / 16.0;
            } else {
                xmin = Double.valueOf(xparts[0]);
                xmax = Double.valueOf(xparts[1]);
                ymin = Double.valueOf(yparts[0]);
                ymax = Double.valueOf(yparts[1]);
                zmin = Double.valueOf(zparts[0]);
                zmax = Double.valueOf(zparts[1]);
            }
            int[] patchIds = new int[6];
            if (parts[4].startsWith("b")) {
                int off = Integer.parseInt(parts[4].substring(1));
                for (j = 0; j < 6; ++j) {
                    patchIds[j] = patchlist[j] + off;
                }
            } else {
                int fixed = Integer.parseInt(parts[4]);
                for (j = 0; j < 6; ++j) {
                    patchIds[j] = fixed;
                }
            }
            SimpleMultiBoxRenderer.addBox(rpf, list, xmin, xmax, ymin, ymax, zmin, zmax, patchIds);
        }
        this.model = list.toArray(new RenderPatch[list.size()]);
        return super.initializeRenderer(rpf, blkid, blockdatamask, custparm);
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        return this.model;
    }
}

