/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class RedstoneWireRenderer
extends CustomRenderer {
    private static final int TEXTURE_REDSTONE_STRAIGHT = 0;
    private static final int TEXTURE_REDSTONE_CROSS = 1;
    private int blkid;
    private RenderPatch[] bottom_patches = new RenderPatch[16];
    private RenderPatch[] side_patches = new RenderPatch[4];
    private RenderPatch[][] meshes = new RenderPatch[256][];
    private static final int[] x_off = new int[]{-1, 1, 0, 0};
    private static final int[] z_off = new int[]{0, 0, -1, 1};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkid, blockdatamask, custparm)) {
            return false;
        }
        this.blkid = blkid;
        this.side_patches[0] = rpf.getPatch(0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0);
        this.side_patches[1] = rpf.getRotatedPatch(this.side_patches[0], 0, 180, 0, 0);
        this.side_patches[2] = rpf.getRotatedPatch(this.side_patches[0], 0, 90, 0, 0);
        this.side_patches[3] = rpf.getRotatedPatch(this.side_patches[0], 0, 270, 0, 0);
        block4: for (int i = 0; i < 16; ++i) {
            switch (i) {
                case 1: 
                case 2: 
                case 3: {
                    this.bottom_patches[i] = rpf.getPatch(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTTOM, 0);
                    continue block4;
                }
                case 4: 
                case 8: 
                case 12: {
                    this.bottom_patches[i] = rpf.getPatch(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0);
                    continue block4;
                }
                default: {
                    this.bottom_patches[i] = rpf.getPatch(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, (i & 4) != 0 ? 0.0 : 0.3125, (i & 8) != 0 ? 1.0 : 0.6875, (i & 1) != 0 ? 0.0 : 0.3125, (i & 2) != 0 ? 1.0 : 0.6875, RenderPatchFactory.SideVisible.TOP, 1);
                }
            }
        }
        return true;
    }

    @Override
    public int getMaximumTextureCount() {
        return 2;
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        int idx = 0;
        for (int i = 0; i < x_off.length; ++i) {
            if (mapDataCtx.getBlockTypeIDAt(x_off[i], 1, z_off[i]) == this.blkid) {
                idx |= 1 << i | 16 << i;
                continue;
            }
            if (mapDataCtx.getBlockTypeIDAt(x_off[i], 0, z_off[i]) == this.blkid) {
                idx |= 1 << i;
                continue;
            }
            if (mapDataCtx.getBlockTypeIDAt(x_off[i], -1, z_off[i]) != this.blkid) continue;
            idx |= 1 << i;
        }
        RenderPatch[] mesh = this.meshes[idx];
        if (mesh == null) {
            mesh = this.buildMesh(idx);
            this.meshes[idx] = mesh;
        }
        return mesh;
    }

    private RenderPatch[] buildMesh(int idx) {
        ArrayList<RenderPatch> lst = new ArrayList<RenderPatch>();
        lst.add(this.bottom_patches[idx & 0xF]);
        for (int i = 0; i < 4; ++i) {
            if ((idx & 16 << i) == 0) continue;
            lst.add(this.side_patches[i]);
        }
        return lst.toArray(new RenderPatch[lst.size()]);
    }
}

