/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class RailCraftSlabBlockRenderer
extends CustomRenderer {
    RenderPatch[][] topOnly;
    RenderPatch[][] bottomOnly;
    RenderPatch[][] fullBlocks;
    static String[] nbtFieldsNeeded = new String[]{"top", "bottom"};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        this.topOnly = new RenderPatch[RailCraftBlocks.values().length][];
        this.bottomOnly = new RenderPatch[RailCraftBlocks.values().length][];
        this.fullBlocks = new RenderPatch[RailCraftBlocks.values().length][];
        for (RailCraftBlocks b : RailCraftBlocks.values()) {
            int ord;
            int tex = ord = b.ordinal();
            if (b.equals((Object)RailCraftBlocks.NOTHING)) {
                tex = 0;
            }
            this.topOnly[ord] = CustomRenderer.getBoxSingleTexture(rpf, 0.0, 1.0, 0.5, 1.0, 0.0, 1.0, tex, false);
            this.bottomOnly[ord] = CustomRenderer.getBoxSingleTexture(rpf, 0.0, 1.0, 0.0, 0.5, 0.0, 1.0, tex, false);
            this.fullBlocks[ord] = CustomRenderer.getBoxSingleTexture(rpf, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, tex, false);
        }
        return super.initializeRenderer(rpf, blkid, blockdatamask, custparm);
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        Object objTop = mapDataCtx.getBlockTileEntityField("top");
        Object objBottom = mapDataCtx.getBlockTileEntityField("bottom");
        RailCraftBlocks top = RailCraftBlocks.NOTHING;
        RailCraftBlocks bottom = RailCraftBlocks.NOTHING;
        if (objTop != null) {
            top = RailCraftBlocks.valueOf((String)objTop);
        }
        if (objBottom != null) {
            bottom = RailCraftBlocks.valueOf((String)objBottom);
        }
        if (top.equals((Object)bottom)) {
            return this.fullBlocks[top.ordinal()];
        }
        if (top.equals((Object)RailCraftBlocks.NOTHING)) {
            return this.bottomOnly[bottom.ordinal()];
        }
        if (bottom.equals((Object)RailCraftBlocks.NOTHING)) {
            return this.topOnly[top.ordinal()];
        }
        return RailCraftSlabBlockRenderer.combineMultiple(new RenderPatch[][]{this.topOnly[top.ordinal()], this.bottomOnly[bottom.ordinal()]});
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return nbtFieldsNeeded;
    }

    public static enum RailCraftBlocks {
        SNOW,
        ICE,
        PACKED_ICE,
        IRON,
        STEEL,
        COPPER,
        TIN,
        LEAD,
        GOLD,
        DIAMOND,
        OBSIDIAN,
        CONCRETE,
        CREOSOTE,
        ABYSSAL_BRICK,
        ABYSSAL_FITTED,
        ABYSSAL_BLOCK,
        ABYSSAL_COBBLE,
        INFERNAL_BRICK,
        INFERNAL_FITTED,
        INFERNAL_BLOCK,
        INFERNAL_COBBLE,
        BLOODSTAINED_BRICK,
        BLOODSTAINED_FITTED,
        BLOODSTAINED_BLOCK,
        BLOODSTAINED_COBBLE,
        SANDY_BRICK,
        SANDY_FITTED,
        SANDY_BLOCK,
        SANDY_COBBLE,
        BLEACHEDBONE_BRICK,
        BLEACHEDBONE_FITTED,
        BLEACHEDBONE_BLOCK,
        BLEACHEDBONE_COBBLE,
        QUARRIED_BRICK,
        QUARRIED_FITTED,
        QUARRIED_BLOCK,
        QUARRIED_COBBLE,
        FROSTBOUND_BRICK,
        FROSTBOUND_FITTED,
        FROSTBOUND_BLOCK,
        FROSTBOUND_COBBLE,
        NETHER_FITTED,
        NETHER_BLOCK,
        NETHER_COBBLE,
        NOTHING;

    }
}

