/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.Map;
import org.dynmap.modsupport.GWM_Util;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class JabbaBarrelRenderer
extends CustomRenderer {
    RenderPatch[][] patchesPerOrientation;
    int maxStructural = 7;
    static String[] nbtFieldsNeeded = new String[]{"orientation", "structural"};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        this.patchesPerOrientation = new RenderPatch[6 * (this.maxStructural + 1)][];
        for (int i = 0; i <= this.maxStructural; ++i) {
            int topBottomLabel = 4 * i + 0;
            int sideLabel = 4 * i + 1;
            int topBottom = 4 * i + 2;
            int side = 4 * i + 3;
            this.patchesPerOrientation[i * 6 + 0] = JabbaBarrelRenderer.getFullBlock(rpf, new int[]{topBottomLabel, topBottom, side, side, side, side});
            this.patchesPerOrientation[i * 6 + 1] = JabbaBarrelRenderer.getFullBlock(rpf, new int[]{topBottom, topBottomLabel, side, side, side, side});
            this.patchesPerOrientation[i * 6 + 2] = JabbaBarrelRenderer.getFullBlock(rpf, new int[]{topBottom, topBottom, side, side, sideLabel, side});
            this.patchesPerOrientation[i * 6 + 3] = JabbaBarrelRenderer.getFullBlock(rpf, new int[]{topBottom, topBottom, side, side, side, sideLabel});
            this.patchesPerOrientation[i * 6 + 4] = JabbaBarrelRenderer.getFullBlock(rpf, new int[]{topBottom, topBottom, sideLabel, side, side, side});
            this.patchesPerOrientation[i * 6 + 5] = JabbaBarrelRenderer.getFullBlock(rpf, new int[]{topBottom, topBottom, side, sideLabel, side, side});
        }
        return super.initializeRenderer(rpf, blkid, blockdatamask, custparm);
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        int structural;
        int orientation = GWM_Util.objectToInt(mapDataCtx.getBlockTileEntityField("orientation"), 0);
        if (orientation < 0 || orientation > 5) {
            orientation = 0;
        }
        if ((structural = GWM_Util.objectToInt(mapDataCtx.getBlockTileEntityField("structural"), 0)) < 0 || structural > 7) {
            structural = 0;
        }
        return this.patchesPerOrientation[structural * 6 + orientation];
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return nbtFieldsNeeded;
    }
}

