/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.Map;
import org.dynmap.hdmap.renderer.FenceWallBlockRenderer;
import org.dynmap.modsupport.GWM_Util;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class ForestryFenceBlockRenderer
extends FenceWallBlockRenderer {
    String nbtKey = "WT";
    int max = 29;
    String[] nbtFieldsNeeded;

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        boolean status = super.initializeRenderer(rpf, blkid, blockdatamask, custparm);
        if (custparm.get("key") != null) {
            this.nbtKey = custparm.get("key");
        }
        if (custparm.get("max") != null) {
            this.max = Integer.parseInt(custparm.get("max"));
        }
        return status;
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        RenderPatch[] model = super.getRenderPatchList(ctx);
        RenderPatch[] ret = new RenderPatch[model.length];
        int woodType = GWM_Util.objectToInt(ctx.getBlockTileEntityField(this.nbtKey), 0);
        if (woodType < 0 || woodType >= this.max) {
            woodType = 0;
        }
        for (int i = 0; i < model.length; ++i) {
            ret[i] = ctx.getPatchFactory().getRotatedPatch(model[i], 0, 0, 0, woodType);
        }
        return ret;
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        if (this.nbtFieldsNeeded == null) {
            this.nbtFieldsNeeded = new String[]{this.nbtKey};
        }
        return this.nbtFieldsNeeded;
    }
}

