/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.CustomRendererData;
import org.dynmap.renderer.CustomTextureMapper;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class ChiselCTMBlockRenderer
extends CustomRenderer {
    private RenderPatch[] fullBlock;
    private static final int[] patchlist = new int[]{0, 1, 4, 5, 2, 3};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, patchlist);
        this.fullBlock = list.toArray(new RenderPatch[patchlist.length]);
        return true;
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        return this.fullBlock;
    }

    @Override
    public CustomRendererData getRenderData(MapDataContext mapDataCtx) {
        return new CustomRendererData(this.getRenderPatchList(mapDataCtx), null, new TextureSelector(mapDataCtx));
    }

    class TextureSelector
    implements CustomTextureMapper {
        private final MapDataContext mapDataCtx;
        int block;
        int data;
        int baseTex;
        int[][] cachedTextures = new int[6][];

        public TextureSelector(MapDataContext mapDataCtx) {
            this.mapDataCtx = mapDataCtx;
            this.block = mapDataCtx.getBlockTypeID();
            this.data = mapDataCtx.getBlockData();
            TexturePack.HDTextureMap map = TexturePack.HDTextureMap.getMap(this.block, this.data, 0);
            this.baseTex = map.getIndexForFace(0);
        }

        int getVersion(ForgeDirection down, ForgeDirection up, ForgeDirection left, ForgeDirection right) {
            int version = 0;
            if (this.mapDataCtx.getBlockTypeIDAt(down.offsetX, down.offsetY, down.offsetZ) != this.block || this.mapDataCtx.getBlockDataAt(down.offsetX, down.offsetY, down.offsetZ) != this.data) {
                version |= 1;
            }
            if (this.mapDataCtx.getBlockTypeIDAt(up.offsetX, up.offsetY, up.offsetZ) != this.block || this.mapDataCtx.getBlockDataAt(up.offsetX, up.offsetY, up.offsetZ) != this.data) {
                version |= 2;
            }
            if (this.mapDataCtx.getBlockTypeIDAt(left.offsetX, left.offsetY, left.offsetZ) != this.block || this.mapDataCtx.getBlockDataAt(left.offsetX, left.offsetY, left.offsetZ) != this.data) {
                version |= 4;
            }
            if (this.mapDataCtx.getBlockTypeIDAt(right.offsetX, right.offsetY, right.offsetZ) != this.block || this.mapDataCtx.getBlockDataAt(right.offsetX, right.offsetY, right.offsetZ) != this.data) {
                version |= 8;
            }
            return version;
        }

        @Override
        public int[] getTextureLayersForPatchId(int patchId) {
            if (this.cachedTextures[patchId] == null) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)patchId);
                int version = 0;
                switch (dir) {
                    case DOWN: {
                        version = this.getVersion(ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST);
                        break;
                    }
                    case UP: {
                        version = this.getVersion(ForgeDirection.SOUTH, ForgeDirection.NORTH, ForgeDirection.WEST, ForgeDirection.EAST);
                        break;
                    }
                    case NORTH: {
                        version = this.getVersion(ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.EAST, ForgeDirection.WEST);
                        break;
                    }
                    case SOUTH: {
                        version = this.getVersion(ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.WEST, ForgeDirection.EAST);
                        break;
                    }
                    case WEST: {
                        version = this.getVersion(ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH);
                        break;
                    }
                    case EAST: {
                        version = this.getVersion(ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.NORTH);
                        break;
                    }
                }
                this.cachedTextures[patchId] = new int[]{this.baseTex + version};
            }
            return this.cachedTextures[patchId];
        }
    }
}

