/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.HashMap;
import java.util.Map;
import org.dynmap.hdmap.renderer.CarpentersBlocksRenderer;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.CustomRendererData;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class CarpentersFlowerPotRenderer
extends CarpentersBlocksRenderer {
    HashMap<String, RenderPatch[]> potsByDesign = new HashMap();
    RenderPatch[] base;
    static String[] nbtFieldsNeeded = new String[]{"cbDesign", "cbAttrList"};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        super.initializeRenderer(rpf, blkid, blockdatamask, custparm);
        String[] list = new String[]{"", "black", "blue", "brown", "cyan", "gray", "green", "light_blue", "light_gray", "lime", "magenta", "orange", "original", "pink", "purple", "rainbow", "red", "white", "yellow"};
        for (int i = 0; i < list.length; ++i) {
            RenderPatch[] pot = this.getFlowerPot(rpf, i);
            if (i == 0) {
                this.base = pot;
                continue;
            }
            this.potsByDesign.put(list[i], pot);
        }
        return true;
    }

    private RenderPatch[] getFlowerPot(RenderPatchFactory rpf, int basePatch) {
        double soilMin = 0.375;
        double soilMax = 0.6875;
        double soilY = 0.1875;
        double flowerMin = 0.21187943262411346;
        double flowerMax = 1.0 - flowerMin;
        return CarpentersFlowerPotRenderer.combineMultiple(new RenderPatch[][]{CustomRenderer.getBoxSingleTextureInt(rpf, 5, 11, 0, 1, 5, 11, basePatch, false), CustomRenderer.getBoxSingleTextureInt(rpf, 5, 6, 1, 6, 5, 11, basePatch, false), CustomRenderer.getBoxSingleTextureInt(rpf, 10, 11, 1, 6, 5, 11, basePatch, false), CustomRenderer.getBoxSingleTextureInt(rpf, 5, 11, 1, 6, 5, 6, basePatch, false), CustomRenderer.getBoxSingleTextureInt(rpf, 5, 11, 1, 6, 10, 11, basePatch, false), CarpentersFlowerPotRenderer.combineMultiple(rpf.getPatch(flowerMin, soilY, flowerMin, flowerMax, soilY, flowerMax, flowerMin, 1.0, flowerMin, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, 22), rpf.getPatch(flowerMin, soilY, flowerMax, flowerMax, soilY, flowerMin, flowerMin, 1.0, flowerMax, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, 22), rpf.getPatch(soilMin, soilY, soilMin, soilMax, soilY, soilMin, soilMin, soilY, soilMax, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 23))});
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        Object design = mapDataCtx.getBlockTileEntityField("cbDesign");
        RenderPatch[] ret = null;
        if (design instanceof String) {
            ret = this.potsByDesign.get((String)design);
        }
        if (ret == null) {
            return this.base;
        }
        return ret;
    }

    @Override
    public CustomRendererData getRenderData(MapDataContext mapDataCtx) {
        return new CustomRendererData(this.getRenderPatchList(mapDataCtx), null, new CarpentersBlocksRenderer.TextureSelector(mapDataCtx, 24));
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return nbtFieldsNeeded;
    }
}

