/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.MapManager;
import org.dynmap.MapType;
import org.dynmap.hdmap.HDBlockModels;
import org.dynmap.hdmap.HDLighting;
import org.dynmap.hdmap.HDMap;
import org.dynmap.hdmap.HDMapTile;
import org.dynmap.hdmap.HDPerspective;
import org.dynmap.hdmap.HDShader;
import org.dynmap.hdmap.HDShaderState;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;

public class HDMapManager {
    public HashMap<String, HDShader> shaders = new HashMap();
    public HashMap<String, HDPerspective> perspectives = new HashMap();
    public HashMap<String, HDLighting> lightings = new HashMap();
    public HashSet<HDMap> maps = new HashSet();
    public HashMap<String, ArrayList<HDMap>> maps_by_world_perspective = new HashMap();
    public static boolean waterlightingfix;
    public static boolean biomeshadingfix;
    private static final int BIOMEDATAFLAG = 0;
    private static final int HIGHESTZFLAG = 1;
    private static final int RAWBIOMEFLAG = 2;
    private static final int BLOCKTYPEFLAG = 3;
    private HashMap<String, boolean[]> cached_data_flags_by_world_perspective = new HashMap();

    public void loadHDShaders(DynmapCore core) {
        Log.verboseinfo("Loading shaders...");
        TexturePack.handleBlockAlias();
        File f = new File(core.getDataFolder(), "shaders.txt");
        if (!core.updateUsingDefaultResource("/shaders.txt", f, "shaders")) {
            return;
        }
        ConfigurationNode shadercfg = new ConfigurationNode(f);
        shadercfg.load();
        for (HDShader shader : shadercfg.createInstances("shaders", new Class[]{DynmapCore.class}, new Object[]{core})) {
            if (shader.getName() == null) continue;
            this.shaders.put(shader.getName(), shader);
        }
        f = new File(core.getDataFolder(), "custom-shaders.txt");
        core.createDefaultFileFromResource("/custom-shaders.txt", f);
        if (f.exists()) {
            ConfigurationNode customshadercfg = new ConfigurationNode(f);
            customshadercfg.load();
            for (HDShader shader : customshadercfg.createInstances("shaders", new Class[]{DynmapCore.class}, new Object[]{core})) {
                if (shader.getName() == null) continue;
                this.shaders.put(shader.getName(), shader);
            }
        }
        Log.info("Loaded " + this.shaders.size() + " shaders.");
    }

    public void loadHDPerspectives(DynmapCore core) {
        Log.verboseinfo("Loading perspectives...");
        HDBlockModels.handleBlockAlias();
        File f = new File(core.getDataFolder(), "perspectives.txt");
        if (!core.updateUsingDefaultResource("/perspectives.txt", f, "perspectives")) {
            return;
        }
        ConfigurationNode perspectivecfg = new ConfigurationNode(f);
        perspectivecfg.load();
        for (HDPerspective perspective : perspectivecfg.createInstances("perspectives", new Class[]{DynmapCore.class}, new Object[]{core})) {
            if (perspective.getName() == null) continue;
            this.perspectives.put(perspective.getName(), perspective);
        }
        f = new File(core.getDataFolder(), "custom-perspectives.txt");
        core.createDefaultFileFromResource("/custom-perspectives.txt", f);
        if (f.exists()) {
            perspectivecfg = new ConfigurationNode(f);
            perspectivecfg.load();
            for (HDPerspective perspective : perspectivecfg.createInstances("perspectives", new Class[]{DynmapCore.class}, new Object[]{core})) {
                if (perspective.getName() == null) continue;
                this.perspectives.put(perspective.getName(), perspective);
            }
        }
        Log.info("Loaded " + this.perspectives.size() + " perspectives.");
    }

    public void loadHDLightings(DynmapCore core) {
        Log.verboseinfo("Loading lightings...");
        File f = new File(core.getDataFolder(), "lightings.txt");
        if (!core.updateUsingDefaultResource("/lightings.txt", f, "lightings")) {
            return;
        }
        ConfigurationNode lightingcfg = new ConfigurationNode(f);
        lightingcfg.load();
        for (HDLighting lighting : lightingcfg.createInstances("lightings", new Class[]{DynmapCore.class}, new Object[]{core})) {
            if (lighting.getName() == null) continue;
            this.lightings.put(lighting.getName(), lighting);
        }
        f = new File(core.getDataFolder(), "custom-lightings.txt");
        core.createDefaultFileFromResource("/custom-lightings.txt", f);
        if (f.exists()) {
            lightingcfg = new ConfigurationNode(f);
            lightingcfg.load();
            for (HDLighting lighting : lightingcfg.createInstances("lightings", new Class[]{DynmapCore.class}, new Object[]{core})) {
                if (lighting.getName() == null) continue;
                this.lightings.put(lighting.getName(), lighting);
            }
        }
        Log.info("Loaded " + this.lightings.size() + " lightings.");
    }

    public HDShaderState[] getShaderStateForTile(HDMapTile tile, MapChunkCache cache, MapIterator mapiter, String mapname, int scale) {
        DynmapWorld w = MapManager.mapman.worldsLookup.get(tile.getDynmapWorld().getName());
        if (w == null) {
            return new HDShaderState[0];
        }
        ArrayList<HDShaderState> shaders = new ArrayList<HDShaderState>();
        for (MapType map : w.maps) {
            HDMap hdmap;
            if (!(map instanceof HDMap) || (hdmap = (HDMap)map).getPerspective() != tile.perspective || hdmap.getBoostZoom() != tile.boostzoom || mapname != null && !hdmap.getName().equals(mapname)) continue;
            shaders.add(hdmap.getShader().getStateInstance(hdmap, cache, mapiter, scale));
        }
        return shaders.toArray(new HDShaderState[shaders.size()]);
    }

    public boolean isBiomeDataNeeded(HDMapTile t) {
        return this.getCachedFlags(t)[0];
    }

    public boolean isHightestBlockYDataNeeded(HDMapTile t) {
        return this.getCachedFlags(t)[1];
    }

    public boolean isRawBiomeDataNeeded(HDMapTile t) {
        return this.getCachedFlags(t)[2];
    }

    public boolean isBlockTypeDataNeeded(HDMapTile t) {
        return this.getCachedFlags(t)[3];
    }

    private boolean[] getCachedFlags(HDMapTile t) {
        String w = t.getDynmapWorld().getName();
        String k = w + "/" + t.perspective.getName();
        boolean[] flags = this.cached_data_flags_by_world_perspective.get(k);
        if (flags != null) {
            return flags;
        }
        flags = new boolean[4];
        this.cached_data_flags_by_world_perspective.put(k, flags);
        DynmapWorld dw = MapManager.mapman.worldsLookup.get(w);
        if (dw == null) {
            return flags;
        }
        for (MapType map : dw.maps) {
            HDMap hdmap;
            if (!(map instanceof HDMap) || (hdmap = (HDMap)map).getPerspective() != t.perspective) continue;
            HDShader sh = hdmap.getShader();
            HDLighting lt = hdmap.getLighting();
            flags[0] = flags[0] | (sh.isBiomeDataNeeded() | lt.isBiomeDataNeeded());
            flags[1] = flags[1] | (sh.isHightestBlockYDataNeeded() | lt.isHightestBlockYDataNeeded());
            flags[2] = flags[2] | (sh.isRawBiomeDataNeeded() | lt.isRawBiomeDataNeeded());
            flags[3] = flags[3] | (sh.isBlockTypeDataNeeded() | lt.isBlockTypeDataNeeded());
        }
        return flags;
    }
}

