/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.Log;
import org.dynmap.MapManager;
import org.dynmap.debug.Debug;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.CustomRendererData;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.ForgeConfigFile;
import org.dynmap.utils.MapIterator;
import org.dynmap.utils.PatchDefinition;
import org.dynmap.utils.PatchDefinitionFactory;

public class HDBlockModels {
    private static final int BLOCKTABLELEN = 4096;
    private static int[] linkalg = new int[4096];
    private static int[][] linkmap = new int[4096][];
    private static int max_patches;
    private static HashMap<Integer, HDBlockModel> models_by_id_data;
    private static PatchDefinitionFactory pdf;
    private static BitSet customModelsRequestingTileData;
    private static BitSet changeIgnoredBlocks;
    private static HashSet<String> loadedmods;
    private static final int FENCE_ALGORITHM = 1;
    private static final int CHEST_ALGORITHM = 2;
    private static final int REDSTONE_ALGORITHM = 3;
    private static final int GLASS_IRONFENCE_ALG = 4;
    private static final int WIRE_ALGORITHM = 5;
    private static final int DOOR_ALGORITHM = 6;
    private static final int REDSTONE_BLKTYPEID = 55;
    private static final int FENCEGATE_BLKTYPEID = 107;
    private static HashMap<Integer, HDScaledBlockModels> scaled_models_by_scale;
    public static final int[] boxPatchList;
    private static long[] vscale;

    public static final int getMaxPatchCount() {
        return max_patches;
    }

    public static final PatchDefinitionFactory getPatchDefinitionFactory() {
        return pdf;
    }

    public static boolean resetIfNotBlockSet(int blkid, int blkdata, String blockset) {
        HDBlockModel bm = models_by_id_data.get(blkid << 4 | blkdata);
        if (bm != null && !bm.getBlockSet().equals(blockset)) {
            Debug.debug("Reset block model for " + blkid + ":" + blkdata + " from " + bm.getBlockSet() + " due to new def from " + blockset);
            models_by_id_data.remove(blkid << 4 | blkdata);
            return true;
        }
        return false;
    }

    public static int getNeededTextureCount(int blkid, int blkdata) {
        HDBlockModel bm = models_by_id_data.get(blkid << 4 | blkdata);
        if (bm != null) {
            return bm.getTextureCount();
        }
        return 6;
    }

    public static final boolean isChangeIgnoredBlock(int blkid, int blkdata) {
        return changeIgnoredBlocks.get(blkid << 4 | blkdata);
    }

    public static void handleBlockAlias() {
        for (int i = 0; i < 4096; ++i) {
            int id = MapManager.mapman.getBlockIDAlias(i);
            if (id == i) continue;
            HDBlockModels.remapModel(i, id);
        }
    }

    private static void remapModel(int id, int newid) {
        if (id > 0 && id < 4096 && newid >= 0 && newid < 4096) {
            HDBlockModels.linkalg[id] = linkalg[newid];
            HDBlockModels.linkmap[id] = linkmap[newid];
            for (int meta = 0; meta < 16; ++meta) {
                int srcid = newid * 16 + meta;
                int destid = id * 16 + meta;
                HDBlockModel m = models_by_id_data.get(srcid);
                if (m != null) {
                    models_by_id_data.put(destid, m);
                } else {
                    models_by_id_data.remove(destid);
                }
                customModelsRequestingTileData.set(destid, customModelsRequestingTileData.get(srcid));
                changeIgnoredBlocks.set(destid, changeIgnoredBlocks.get(srcid));
            }
        }
    }

    public static final int getLinkAlgID(int blkid) {
        return linkalg[blkid];
    }

    public static final int[] getLinkIDs(int blkid) {
        return linkmap[blkid];
    }

    public static final String[] getTileEntityFieldsNeeded(int blkid, int blkdat) {
        HDBlockModel mod;
        int idx = blkid << 4 | blkdat;
        if (customModelsRequestingTileData.get(idx) && (mod = models_by_id_data.get(idx)) instanceof CustomBlockModel) {
            return ((CustomBlockModel)mod).render.getTileEntityFieldsNeeded();
        }
        return null;
    }

    public static HDScaledBlockModels getModelsForScale(int scale) {
        HDScaledBlockModels model = scaled_models_by_scale.get(scale);
        if (model == null) {
            model = new HDScaledBlockModels();
            short[][][] blockmodels = new short[4096][][];
            PatchDefinition[][][] patches = new PatchDefinition[4096][][];
            CustomBlockModel[][] custom = new CustomBlockModel[4096][];
            for (Integer id_data : models_by_id_data.keySet()) {
                int blkid = id_data >> 4;
                int blkmeta = id_data & 0xF;
                HDBlockModel m = models_by_id_data.get(id_data);
                if (m instanceof HDBlockVolumetricModel) {
                    HDBlockVolumetricModel vm;
                    short[] smod;
                    Object row = blockmodels[blkid];
                    if (row == null) {
                        blockmodels[blkid] = row = (Object)new short[16][];
                    }
                    if ((smod = (vm = (HDBlockVolumetricModel)m).getScaledMap(scale)) == null) continue;
                    boolean keep = false;
                    for (int i = 0; !keep && i < smod.length; ++i) {
                        if (smod[i] != 0) continue;
                        keep = true;
                    }
                    if (!keep) continue;
                    row[blkmeta] = smod;
                    continue;
                }
                if (m instanceof HDBlockPatchModel) {
                    HDBlockPatchModel pm = (HDBlockPatchModel)m;
                    PatchDefinition[] patch = pm.getPatches();
                    PatchDefinition[][] row = patches[blkid];
                    if (row == null) {
                        row = new PatchDefinition[16][];
                        patches[blkid] = row;
                    }
                    if (patch == null) continue;
                    row[blkmeta] = patch;
                    continue;
                }
                if (!(m instanceof CustomBlockModel)) continue;
                CustomBlockModel cbm = (CustomBlockModel)m;
                CustomBlockModel[] row = custom[blkid];
                if (row == null) {
                    row = new CustomBlockModel[16];
                    custom[blkid] = row;
                }
                row[blkmeta] = cbm;
            }
            HDScaledBlockModels.access$302(model, blockmodels);
            HDScaledBlockModels.access$402(model, patches);
            HDScaledBlockModels.access$502(model, custom);
            scaled_models_by_scale.put(scale, model);
        }
        return model;
    }

    private static void addFiles(ArrayList<String> files, File dir, String path) {
        File[] listfiles = dir.listFiles();
        if (listfiles == null) {
            return;
        }
        for (File f : listfiles) {
            String fn = f.getName();
            if (fn.equals(".") || fn.equals("..")) continue;
            if (f.isFile()) {
                if (!fn.endsWith("-models.txt")) continue;
                files.add(path + fn);
                continue;
            }
            if (!f.isDirectory()) continue;
            HDBlockModels.addFiles(files, f, path + f.getName() + "/");
        }
    }

    public static String getModIDFromFileName(String fn) {
        int off = fn.lastIndexOf(47);
        if (off > 0) {
            fn = fn.substring(off + 1);
        }
        if ((off = fn.lastIndexOf(45)) > 0) {
            fn = fn.substring(0, off);
        }
        return fn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadModels(DynmapCore core, ConfigurationNode config) {
        ZipFile zf;
        File datadir = core.getDataFolder();
        max_patches = 6;
        models_by_id_data.clear();
        scaled_models_by_scale.clear();
        changeIgnoredBlocks.clear();
        loadedmods.clear();
        int i = 0;
        boolean done = false;
        InputStream in = null;
        while (!done) {
            in = TexturePack.class.getResourceAsStream("/models_" + i + ".txt");
            if (in != null) {
                HDBlockModels.loadModelFile(in, "models_" + i + ".txt", config, core, "core");
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                in = null;
            } else {
                done = true;
            }
            ++i;
        }
        for (String modid : core.getServer().getModList()) {
            File f = core.getServer().getModContainerFile(modid);
            if (!f.isFile()) continue;
            zf = null;
            in = null;
            try {
                zf = new ZipFile(f);
                String fn = "assets/" + modid.toLowerCase() + "/dynmap-models.txt";
                ZipEntry ze = zf.getEntry(fn);
                if (ze == null) continue;
                in = zf.getInputStream(ze);
                HDBlockModels.loadModelFile(in, fn, config, core, modid);
                loadedmods.add(modid);
            }
            catch (ZipException fn) {
            }
            catch (IOException fn) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException fn) {}
                    in = null;
                }
                if (zf == null) continue;
                try {
                    zf.close();
                }
                catch (IOException fn) {}
                zf = null;
            }
        }
        ArrayList<String> files = new ArrayList<String>();
        File customdir = new File(datadir, "renderdata");
        HDBlockModels.addFiles(files, customdir, "");
        for (String fn : files) {
            File custom = new File(customdir, fn);
            if (!custom.canRead()) continue;
            try {
                in = new FileInputStream(custom);
                HDBlockModels.loadModelFile(in, custom.getPath(), config, core, HDBlockModels.getModIDFromFileName(fn));
            }
            catch (IOException iox) {
                Log.severe("Error loading " + custom.getPath());
            }
            finally {
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException iox) {}
                in = null;
            }
        }
        zf = null;
        try {
            zf = new ZipFile(core.getPluginJarFile());
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                String n = ze.getName();
                if (!n.startsWith("renderdata/") || !n.endsWith("-models.txt") || (in = zf.getInputStream(ze)) == null) continue;
                HDBlockModels.loadModelFile(in, n, config, core, HDBlockModels.getModIDFromFileName(n));
                try {
                    in.close();
                }
                catch (IOException x) {
                    in = null;
                }
            }
            return;
        }
        catch (IOException iox) {
            Log.severe("Error processing nodel files");
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                in = null;
            }
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (IOException iOException) {}
                zf = null;
            }
        }
    }

    private static Integer getIntValue(Map<String, Integer> vars, String val) throws NumberFormatException {
        char c = val.charAt(0);
        if (Character.isLetter(c) || c == '%' || c == '&') {
            Integer v;
            int off = val.indexOf(43);
            int offset = 0;
            if (off > 0) {
                offset = Integer.valueOf(val.substring(off + 1));
                val = val.substring(0, off);
            }
            if ((v = vars.get(val)) == null) {
                if (c == '%' || c == '&') {
                    vars.put(val, 0);
                    v = 0;
                } else {
                    throw new NumberFormatException("invalid ID - " + val);
                }
            }
            if (offset != 0 && v > 0) {
                v = v + offset;
            }
            return v;
        }
        return Integer.valueOf(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadModelFile(InputStream in, String fname, ConfigurationNode config, DynmapCore core, String blockset) {
        BufferedReader rdr = null;
        int cnt = 0;
        boolean need_mod_cfg = false;
        boolean mod_cfg_loaded = false;
        String modname = null;
        String modversion = null;
        String mcver = core.getDynmapPluginPlatformVersion();
        try {
            String line;
            ArrayList<HDBlockVolumetricModel> modlist = new ArrayList<HDBlockVolumetricModel>();
            ArrayList<HDBlockPatchModel> pmodlist = new ArrayList<HDBlockPatchModel>();
            HashMap<String, Integer> varvals = new HashMap<String, Integer>();
            HashMap<String, PatchDefinition> patchdefs = new HashMap<String, PatchDefinition>();
            pdf.setPatchNameMape(patchdefs);
            int layerbits = 0;
            int rownum = 0;
            int scale = 0;
            rdr = new LineNumberReader(new InputStreamReader(in));
            while ((line = ((LineNumberReader)rdr).readLine()) != null) {
                Object pd;
                String[] args;
                boolean skip = false;
                if (line.length() > 0 && line.charAt(0) == '[') {
                    int end = line.indexOf(93);
                    if (end < 0) {
                        Log.severe("Format error - line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname + ": bad version limit");
                        return;
                    }
                    String vertst = line.substring(1, end);
                    String tver = mcver;
                    if (vertst.startsWith("mod:")) {
                        tver = modversion;
                        vertst = vertst.substring(4);
                    }
                    if (!HDBlockModels.checkVersionRange(tver, vertst)) {
                        skip = true;
                    }
                    line = line.substring(end + 1);
                }
                if (skip) continue;
                if (line.startsWith("block:")) {
                    ArrayList<Integer> blkids = new ArrayList<Integer>();
                    int databits = 0;
                    scale = 0;
                    line = line.substring(6);
                    args = line.split(",");
                    for (String a : args) {
                        String[] av = a.split("=");
                        if (av.length < 2) continue;
                        if (av[0].equals("id")) {
                            blkids.add(HDBlockModels.getIntValue(varvals, av[1]));
                            continue;
                        }
                        if (av[0].equals("data")) {
                            if (av[1].equals("*")) {
                                databits = 65535;
                                continue;
                            }
                            databits |= 1 << HDBlockModels.getIntValue(varvals, av[1]);
                            continue;
                        }
                        if (!av[0].equals("scale")) continue;
                        scale = Integer.parseInt(av[1]);
                    }
                    if (blkids.size() > 0 && databits != 0 && scale > 0) {
                        modlist.clear();
                        for (Integer id : blkids) {
                            if (id <= 0) continue;
                            modlist.add(new HDBlockVolumetricModel(id, databits, scale, new long[0], blockset));
                            ++cnt;
                        }
                    } else {
                        Log.severe("Block model missing required parameters = line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                    }
                    layerbits = 0;
                    continue;
                }
                if (line.startsWith("layer:")) {
                    line = line.substring(6);
                    String[] args2 = line.split(",");
                    layerbits = 0;
                    rownum = 0;
                    for (String a : args2) {
                        layerbits |= 1 << Integer.parseInt(a);
                    }
                    continue;
                }
                if (line.startsWith("rotate:")) {
                    line = line.substring(7);
                    String[] args3 = line.split(",");
                    int id = -1;
                    int data = -1;
                    int rot = -1;
                    for (String a : args3) {
                        int newid;
                        String[] av = a.split("=");
                        if (av.length < 2) continue;
                        if (av[0].equals("id") && (newid = HDBlockModels.getIntValue(varvals, av[1]).intValue()) > 0) {
                            id = newid;
                        }
                        if (av[0].equals("data")) {
                            data = HDBlockModels.getIntValue(varvals, av[1]);
                        }
                        if (!av[0].equals("rot")) continue;
                        rot = Integer.parseInt(av[1]);
                    }
                    HDBlockModel mod = models_by_id_data.get((id << 4) + data);
                    if (modlist.isEmpty()) continue;
                    if (mod != null && rot % 90 == 0 && mod instanceof HDBlockVolumetricModel) {
                        HDBlockVolumetricModel vmod = (HDBlockVolumetricModel)mod;
                        for (int x = 0; x < scale; ++x) {
                            for (int y = 0; y < scale; ++y) {
                                block69: for (int z = 0; z < scale; ++z) {
                                    if (!vmod.isSubblockSet(x, y, z)) continue;
                                    switch (rot) {
                                        case 0: {
                                            for (HDBlockVolumetricModel bm : modlist) {
                                                bm.setSubblock(x, y, z, true);
                                            }
                                            continue block69;
                                        }
                                        case 90: {
                                            for (HDBlockVolumetricModel bm : modlist) {
                                                bm.setSubblock(scale - z - 1, y, x, true);
                                            }
                                            continue block69;
                                        }
                                        case 180: {
                                            for (HDBlockVolumetricModel bm : modlist) {
                                                bm.setSubblock(scale - x - 1, y, scale - z - 1, true);
                                            }
                                            continue block69;
                                        }
                                        case 270: {
                                            for (HDBlockVolumetricModel bm : modlist) {
                                                bm.setSubblock(z, y, scale - x - 1, true);
                                            }
                                            continue block69;
                                        }
                                    }
                                }
                            }
                        }
                        continue;
                    }
                    Log.severe("Invalid rotate error - line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                    return;
                }
                if (line.startsWith("patchrotate:")) {
                    line = line.substring(12);
                    String[] args4 = line.split(",");
                    int id = -1;
                    int data = -1;
                    int rotx = 0;
                    int roty = 0;
                    int rotz = 0;
                    for (String a : args4) {
                        int newid;
                        String[] av = a.split("=");
                        if (av.length < 2) continue;
                        if (av[0].equals("id") && (newid = HDBlockModels.getIntValue(varvals, av[1]).intValue()) > 0) {
                            id = newid;
                        }
                        if (av[0].equals("data")) {
                            data = HDBlockModels.getIntValue(varvals, av[1]);
                        }
                        if (av[0].equals("rot")) {
                            roty = Integer.parseInt(av[1]);
                        }
                        if (av[0].equals("roty")) {
                            roty = Integer.parseInt(av[1]);
                        }
                        if (av[0].equals("rotx")) {
                            rotx = Integer.parseInt(av[1]);
                        }
                        if (!av[0].equals("rotz")) continue;
                        rotz = Integer.parseInt(av[1]);
                    }
                    HDBlockModel mod = models_by_id_data.get((id << 4) + data);
                    if (pmodlist.isEmpty()) continue;
                    if (mod != null && mod instanceof HDBlockPatchModel) {
                        HDBlockPatchModel pmod = (HDBlockPatchModel)mod;
                        PatchDefinition[] patches = pmod.getPatches();
                        PatchDefinition[] newpatches = new PatchDefinition[patches.length];
                        for (int i = 0; i < patches.length; ++i) {
                            newpatches[i] = (PatchDefinition)pdf.getRotatedPatch(patches[i], rotx, roty, rotz, patches[i].textureindex);
                        }
                        if (patches.length > max_patches) {
                            max_patches = patches.length;
                        }
                        for (HDBlockPatchModel patchmod : pmodlist) {
                            HDBlockPatchModel.access$602(patchmod, newpatches);
                        }
                        continue;
                    }
                    Log.severe("Invalid rotate error - line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                    return;
                }
                if (line.startsWith("linkmap:")) {
                    ArrayList<Integer> blkids = new ArrayList<Integer>();
                    line = line.substring(8);
                    String[] args5 = line.split(",");
                    ArrayList<Integer> map = new ArrayList<Integer>();
                    int linktype = 0;
                    for (String a : args5) {
                        String[] av = a.split("=");
                        if (av.length < 2) continue;
                        if (av[0].equals("id")) {
                            blkids.add(HDBlockModels.getIntValue(varvals, av[1]));
                            continue;
                        }
                        if (av[0].equals("linkalg")) {
                            linktype = Integer.parseInt(av[1]);
                            continue;
                        }
                        if (!av[0].equals("linkid")) continue;
                        map.add(HDBlockModels.getIntValue(varvals, av[1]));
                    }
                    if (linktype <= 0) continue;
                    int[] mapids = new int[map.size()];
                    for (int i = 0; i < mapids.length; ++i) {
                        mapids[i] = (Integer)map.get(i);
                    }
                    for (Integer bid : blkids) {
                        HDBlockModels.linkalg[bid.intValue()] = linktype;
                        HDBlockModels.linkmap[bid.intValue()] = mapids;
                    }
                    continue;
                }
                if (line.startsWith("ignore-updates:")) {
                    ArrayList<Integer> blkids = new ArrayList<Integer>();
                    int blkdat = 0;
                    line = line.substring(line.indexOf(58) + 1);
                    args = line.split(",");
                    for (String a : args) {
                        String[] av = a.split("=");
                        if (av.length < 2) continue;
                        if (av[0].equals("id")) {
                            blkids.add(HDBlockModels.getIntValue(varvals, av[1]));
                            continue;
                        }
                        if (!av[0].equals("data")) continue;
                        if (av[1].equals("*")) {
                            blkdat = 65535;
                            continue;
                        }
                        blkdat |= 1 << HDBlockModels.getIntValue(varvals, av[1]);
                    }
                    if (blkdat == 0) {
                        blkdat = 65535;
                    }
                    for (Integer id : blkids) {
                        if (id <= 0) continue;
                        for (int i = 0; i < 16; ++i) {
                            changeIgnoredBlocks.set(id * 16 + i);
                        }
                    }
                    continue;
                }
                if (line.startsWith("#") || line.startsWith(";")) continue;
                if (line.startsWith("enabled:")) {
                    if ((line = line.substring(8).trim()).startsWith("true")) continue;
                    if (line.startsWith("false")) {
                        return;
                    }
                    if (!config.getBoolean(line, false)) {
                        return;
                    }
                    Log.info(line + " models enabled");
                    continue;
                }
                if (line.startsWith("var:")) {
                    line = line.substring(4).trim();
                    String[] args6 = line.split(",");
                    for (int i = 0; i < args6.length; ++i) {
                        String[] v = args6[i].split("=");
                        if (v.length < 2) {
                            Log.severe("Format error - line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                            return;
                        }
                        try {
                            int val = Integer.valueOf(v[1]);
                            int parmval = config.getInteger(v[0], val);
                            varvals.put(v[0], parmval);
                            continue;
                        }
                        catch (NumberFormatException nfx) {
                            Log.severe("Format error - line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                            if (rdr != null) {
                                try {
                                    rdr.close();
                                    rdr = null;
                                }
                                catch (IOException parmval) {
                                    // empty catch block
                                }
                            }
                            pdf.setPatchNameMape(null);
                            return;
                        }
                    }
                    continue;
                }
                if (line.startsWith("cfgfile:")) {
                    File cfgfile = new File(line.substring(8).trim());
                    ForgeConfigFile cfg = new ForgeConfigFile(cfgfile);
                    if (!mod_cfg_loaded) {
                        need_mod_cfg = true;
                    }
                    if (!cfg.load()) continue;
                    cfg.addBlockIDs(varvals);
                    need_mod_cfg = false;
                    mod_cfg_loaded = true;
                    continue;
                }
                if (line.startsWith("patch:")) {
                    PatchDefinition pd2;
                    String patchid = null;
                    line = line.substring(6);
                    String[] args7 = line.split(",");
                    double p_x0 = 0.0;
                    double p_y0 = 0.0;
                    double p_z0 = 0.0;
                    double p_xu = 0.0;
                    double p_yu = 1.0;
                    double p_zu = 0.0;
                    double p_xv = 1.0;
                    double p_yv = 0.0;
                    double p_zv = 0.0;
                    double p_umin = 0.0;
                    double p_umax = 1.0;
                    double p_vmin = 0.0;
                    double p_vmax = 1.0;
                    double p_uplusvmax = 100.0;
                    RenderPatchFactory.SideVisible p_sidevis = RenderPatchFactory.SideVisible.BOTH;
                    for (String a : args7) {
                        String[] av = a.split("=");
                        if (av.length < 2) continue;
                        if (av[0].equals("id")) {
                            patchid = av[1];
                            continue;
                        }
                        if (av[0].equals("Ox")) {
                            p_x0 = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Oy")) {
                            p_y0 = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Oz")) {
                            p_z0 = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Ux")) {
                            p_xu = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Uy")) {
                            p_yu = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Uz")) {
                            p_zu = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Vx")) {
                            p_xv = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Vy")) {
                            p_yv = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Vz")) {
                            p_zv = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Umin")) {
                            p_umin = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Umax")) {
                            p_umax = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Vmin")) {
                            p_vmin = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("Vmax")) {
                            p_vmax = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("UplusVmax")) {
                            p_uplusvmax = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (!av[0].equals("visibility")) continue;
                        p_sidevis = av[1].equals("top") ? RenderPatchFactory.SideVisible.TOP : (av[1].equals("bottom") ? RenderPatchFactory.SideVisible.BOTTOM : (av[1].equals("flip") ? RenderPatchFactory.SideVisible.FLIP : RenderPatchFactory.SideVisible.BOTH));
                    }
                    if (patchid == null || (pd2 = pdf.getPatch(p_x0, p_y0, p_z0, p_xu, p_yu, p_zu, p_xv, p_yv, p_zv, p_umin, p_umax, p_vmin, p_vmax, p_uplusvmax, p_sidevis, 0)) == null) continue;
                    patchdefs.put(patchid, pd2);
                    continue;
                }
                if (line.startsWith("patchblock:")) {
                    ArrayList<Integer> blkids = new ArrayList<Integer>();
                    int databits = 0;
                    line = line.substring(11);
                    args = line.split(",");
                    ArrayList<Object> patches = new ArrayList<Object>();
                    for (String a : args) {
                        int patchnum0;
                        int patchnum1;
                        String[] av = a.split("=");
                        if (av.length < 2) continue;
                        if (av[0].equals("id")) {
                            blkids.add(HDBlockModels.getIntValue(varvals, av[1]));
                            continue;
                        }
                        if (av[0].equals("data")) {
                            if (av[1].equals("*")) {
                                databits = 65535;
                                continue;
                            }
                            databits |= 1 << HDBlockModels.getIntValue(varvals, av[1]);
                            continue;
                        }
                        if (!av[0].startsWith("patch")) continue;
                        String ids = av[0].substring(5);
                        String[] ids2 = ids.split("-");
                        if (ids2.length == 1) {
                            patchnum0 = patchnum1 = Integer.parseInt(ids2[0]);
                        } else {
                            patchnum0 = Integer.parseInt(ids2[0]);
                            patchnum1 = Integer.parseInt(ids2[1]);
                        }
                        if (patchnum0 < 0) {
                            Log.severe("Invalid patch index " + patchnum0 + " - line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                            return;
                        }
                        if (patchnum1 < patchnum0) {
                            Log.severe("Invalid patch index " + patchnum1 + " - line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                            return;
                        }
                        String patchid = av[1];
                        for (int i = patchnum0; i <= patchnum1; ++i) {
                            pd = pdf.getPatchByName(patchid, i);
                            if (pd == null) {
                                Log.severe("Invalid patch ID " + patchid + " - line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                                return;
                            }
                            patches.add(i, pd);
                        }
                    }
                    pmodlist.clear();
                    if (blkids.size() > 0 && databits != 0) {
                        PatchDefinition[] patcharray = patches.toArray(new PatchDefinition[patches.size()]);
                        if (patcharray.length > max_patches) {
                            max_patches = patcharray.length;
                        }
                        for (Integer id : blkids) {
                            if (id <= 0) continue;
                            pmodlist.add(new HDBlockPatchModel(id, databits, patcharray, blockset));
                            ++cnt;
                        }
                        continue;
                    }
                    Log.severe("Patch block model missing required parameters = line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                    continue;
                }
                if (line.startsWith("boxblock:")) {
                    ArrayList<Integer> blkids = new ArrayList<Integer>();
                    int databits = 0;
                    line = line.substring(9);
                    args = line.split(",");
                    double xmin = 0.0;
                    double xmax = 1.0;
                    double ymin = 0.0;
                    double ymax = 1.0;
                    double zmin = 0.0;
                    double zmax = 1.0;
                    for (String a : args) {
                        String[] av = a.split("=");
                        if (av.length < 2) continue;
                        if (av[0].equals("id")) {
                            blkids.add(HDBlockModels.getIntValue(varvals, av[1]));
                            continue;
                        }
                        if (av[0].equals("data")) {
                            if (av[1].equals("*")) {
                                databits = 65535;
                                continue;
                            }
                            databits |= 1 << HDBlockModels.getIntValue(varvals, av[1]);
                            continue;
                        }
                        if (av[0].equals("xmin")) {
                            xmin = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("xmax")) {
                            xmax = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("ymin")) {
                            ymin = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("ymax")) {
                            ymax = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (av[0].equals("zmin")) {
                            zmin = Double.parseDouble(av[1]);
                            continue;
                        }
                        if (!av[0].equals("zmax")) continue;
                        zmax = Double.parseDouble(av[1]);
                    }
                    pmodlist.clear();
                    if (blkids.size() > 0 && databits != 0) {
                        pd = new ArrayList();
                        CustomRenderer.addBox(pdf, (List<RenderPatch>)pd, xmin, xmax, ymin, ymax, zmin, zmax, boxPatchList);
                        PatchDefinition[] patcharray = new PatchDefinition[((ArrayList)pd).size()];
                        for (int i = 0; i < patcharray.length; ++i) {
                            patcharray[i] = (PatchDefinition)((ArrayList)pd).get(i);
                        }
                        if (patcharray.length > max_patches) {
                            max_patches = patcharray.length;
                        }
                        for (Integer id : blkids) {
                            if (id <= 0) continue;
                            pmodlist.add(new HDBlockPatchModel(id, databits, patcharray, blockset));
                            ++cnt;
                        }
                        continue;
                    }
                    Log.severe("Box block model missing required parameters = line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                    continue;
                }
                if (line.startsWith("customblock:")) {
                    ArrayList<Integer> blkids = new ArrayList<Integer>();
                    HashMap<String, String> custargs = new HashMap<String, String>();
                    int databits = 0;
                    line = line.substring(12);
                    String[] args8 = line.split(",");
                    String cls = null;
                    for (String a : args8) {
                        String[] av = a.split("=");
                        if (av.length < 2) continue;
                        if (av[0].equals("id")) {
                            blkids.add(HDBlockModels.getIntValue(varvals, av[1]));
                            continue;
                        }
                        if (av[0].equals("data")) {
                            if (av[1].equals("*")) {
                                databits = 65535;
                                continue;
                            }
                            databits |= 1 << HDBlockModels.getIntValue(varvals, av[1]);
                            continue;
                        }
                        if (av[0].equals("class")) {
                            cls = av[1];
                            continue;
                        }
                        Integer vv = varvals.get(av[1]);
                        if (vv == null) {
                            custargs.put(av[0], av[1]);
                            continue;
                        }
                        custargs.put(av[0], vv.toString());
                    }
                    if (blkids.size() > 0 && databits != 0 && cls != null) {
                        for (Integer id : blkids) {
                            if (id <= 0) continue;
                            CustomBlockModel cbm = new CustomBlockModel(id, databits, cls, custargs, blockset);
                            if (cbm.render == null) {
                                Log.severe("Custom block model failed to initialize = line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                            } else {
                                int texturecnt = cbm.getTextureCount();
                                if (texturecnt > max_patches) {
                                    max_patches = texturecnt;
                                }
                            }
                            ++cnt;
                        }
                        continue;
                    }
                    Log.severe("Custom block model missing required parameters = line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname);
                    continue;
                }
                if (line.startsWith("modname:")) {
                    String[] names = line.substring(8).split(",");
                    boolean found = false;
                    for (String n : names) {
                        String[] ntok = n.split("[\\[\\]]");
                        String rng = null;
                        if (ntok.length > 1) {
                            n = ntok[0].trim();
                            rng = ntok[1].trim();
                        }
                        if (loadedmods.contains(n = n.trim())) {
                            return;
                        }
                        String modver = core.getServer().getModVersion(n);
                        if (modver == null || rng != null && !HDBlockModels.checkVersionRange(modver, rng)) continue;
                        found = true;
                        Log.info(n + "[" + modver + "] models enabled");
                        modname = n;
                        modversion = modver;
                        loadedmods.add(n);
                        core.addModBlockItemIDs(modname, varvals);
                    }
                }
                if (line.startsWith("version:")) {
                    if (HDBlockModels.checkVersionRange(mcver, line = line.substring(line.indexOf(58) + 1))) continue;
                    return;
                }
                if (layerbits == 0) continue;
                for (int i = 0; i < scale && i < line.length(); ++i) {
                    if (line.charAt(i) != '*') continue;
                    for (int y = 0; y < scale; ++y) {
                        if ((layerbits & 1 << y) == 0) continue;
                        for (HDBlockVolumetricModel mod : modlist) {
                            mod.setSubblock(rownum, y, scale - i - 1, true);
                        }
                    }
                }
                if (++rownum < scale) continue;
                rownum = 0;
                layerbits = 0;
            }
            if (need_mod_cfg) {
                Log.severe("Error loading configuration file for " + modname);
            }
            Log.verboseinfo("Loaded " + cnt + " block models from " + fname);
        }
        catch (IOException iox) {
            Log.severe("Error reading models.txt - " + iox.toString());
        }
        catch (NumberFormatException nfx) {
            Log.severe("Format error - line " + ((LineNumberReader)rdr).getLineNumber() + " of " + fname + ": " + nfx.getMessage());
        }
        finally {
            if (rdr != null) {
                try {
                    rdr.close();
                    rdr = null;
                }
                catch (IOException iox) {}
            }
            pdf.setPatchNameMape(null);
        }
    }

    private static String normalizeVersion(String v) {
        StringBuilder v2 = new StringBuilder();
        boolean skip = false;
        for (int i = 0; i < v.length(); ++i) {
            char c = v.charAt(i);
            if (c == '.' || c >= '0' && c <= '9') {
                v2.append(c);
                skip = false;
                continue;
            }
            if (skip) continue;
            skip = true;
            v2.append('.');
        }
        return v2.toString();
    }

    private static long parseVersion(String v, boolean up) {
        v = HDBlockModels.normalizeVersion(v);
        String[] vv = v.split("\\.");
        long ver = 0L;
        for (int i = 0; i < vscale.length; ++i) {
            if (i < vv.length) {
                try {
                    ver += vscale[i] * (long)Integer.parseInt(vv[i]);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!up) continue;
            ver += vscale[i] * 99L;
        }
        return ver;
    }

    public static boolean checkVersionRange(String ver, String range) {
        String high;
        String low;
        if (ver.equals(range)) {
            return true;
        }
        String[] rng = range.split("-", -1);
        long v = HDBlockModels.parseVersion(ver, false);
        if (v == 0L) {
            return false;
        }
        if (rng.length == 1) {
            low = rng[0];
            high = rng[0];
        } else {
            low = rng[0];
            high = rng[1];
        }
        if (low.length() > 0 && HDBlockModels.parseVersion(low, false) > v) {
            return false;
        }
        return high.length() <= 0 || HDBlockModels.parseVersion(high, true) >= v;
    }

    public static int getBlockRenderData(int blocktypeid, MapIterator map) {
        int blockrenderdata = -1;
        switch (HDBlockModels.getLinkAlgID(blocktypeid)) {
            case 1: {
                blockrenderdata = HDBlockModels.generateFenceBlockData(blocktypeid, map);
                break;
            }
            case 2: {
                blockrenderdata = HDBlockModels.generateChestBlockData(blocktypeid, map);
                break;
            }
            case 3: {
                blockrenderdata = HDBlockModels.generateRedstoneWireBlockData(map);
                break;
            }
            case 4: {
                blockrenderdata = HDBlockModels.generateIronFenceGlassBlockData(blocktypeid, map);
                break;
            }
            case 5: {
                blockrenderdata = HDBlockModels.generateWireBlockData(HDBlockModels.getLinkIDs(blocktypeid), map);
                break;
            }
            case 6: {
                blockrenderdata = HDBlockModels.generateDoorBlockData(blocktypeid, map);
            }
        }
        return blockrenderdata;
    }

    private static int generateFenceBlockData(int blkid, MapIterator mapiter) {
        int blockdata = 0;
        int id = mapiter.getBlockTypeIDAt(BlockStep.X_MINUS);
        if (id == blkid || id == 107 || id > 0 && TexturePack.HDTextureMap.getTransparency(id) == TexturePack.BlockTransparency.OPAQUE) {
            blockdata |= 1;
        }
        if ((id = mapiter.getBlockTypeIDAt(BlockStep.Z_MINUS)) == blkid || id == 107 || id > 0 && TexturePack.HDTextureMap.getTransparency(id) == TexturePack.BlockTransparency.OPAQUE) {
            blockdata |= 2;
        }
        if ((id = mapiter.getBlockTypeIDAt(BlockStep.X_PLUS)) == blkid || id == 107 || id > 0 && TexturePack.HDTextureMap.getTransparency(id) == TexturePack.BlockTransparency.OPAQUE) {
            blockdata |= 4;
        }
        if ((id = mapiter.getBlockTypeIDAt(BlockStep.Z_PLUS)) == blkid || id == 107 || id > 0 && TexturePack.HDTextureMap.getTransparency(id) == TexturePack.BlockTransparency.OPAQUE) {
            blockdata |= 8;
        }
        return blockdata;
    }

    private static int generateChestBlockData(int blktype, MapIterator mapiter) {
        int blkdata = mapiter.getBlockData();
        ChestData cd = ChestData.SINGLE_WEST;
        switch (blkdata) {
            case 2: {
                if (mapiter.getBlockTypeIDAt(BlockStep.X_MINUS) == blktype) {
                    cd = ChestData.LEFT_EAST;
                    break;
                }
                if (mapiter.getBlockTypeIDAt(BlockStep.X_PLUS) == blktype) {
                    cd = ChestData.RIGHT_EAST;
                    break;
                }
                cd = ChestData.SINGLE_EAST;
                break;
            }
            case 4: {
                if (mapiter.getBlockTypeIDAt(BlockStep.Z_MINUS) == blktype) {
                    cd = ChestData.RIGHT_NORTH;
                    break;
                }
                if (mapiter.getBlockTypeIDAt(BlockStep.Z_PLUS) == blktype) {
                    cd = ChestData.LEFT_NORTH;
                    break;
                }
                cd = ChestData.SINGLE_NORTH;
                break;
            }
            case 5: {
                if (mapiter.getBlockTypeIDAt(BlockStep.Z_MINUS) == blktype) {
                    cd = ChestData.LEFT_SOUTH;
                    break;
                }
                if (mapiter.getBlockTypeIDAt(BlockStep.Z_PLUS) == blktype) {
                    cd = ChestData.RIGHT_SOUTH;
                    break;
                }
                cd = ChestData.SINGLE_SOUTH;
                break;
            }
            default: {
                cd = mapiter.getBlockTypeIDAt(BlockStep.X_MINUS) == blktype ? ChestData.RIGHT_WEST : (mapiter.getBlockTypeIDAt(BlockStep.X_PLUS) == blktype ? ChestData.LEFT_WEST : ChestData.SINGLE_WEST);
            }
        }
        return cd.ordinal();
    }

    private static int generateRedstoneWireBlockData(MapIterator mapiter) {
        int[] ids = new int[]{mapiter.getBlockTypeIDAt(BlockStep.Z_PLUS), mapiter.getBlockTypeIDAt(BlockStep.X_PLUS), mapiter.getBlockTypeIDAt(BlockStep.Z_MINUS), mapiter.getBlockTypeIDAt(BlockStep.X_MINUS)};
        int flags = 0;
        for (int i = 0; i < 4; ++i) {
            if (ids[i] != 55) continue;
            flags |= 1 << i;
        }
        switch (flags) {
            case 0: {
                return 11;
            }
            case 15: {
                return 0;
            }
            case 2: 
            case 8: 
            case 10: {
                return 1;
            }
            case 1: 
            case 4: 
            case 5: {
                return 2;
            }
            case 12: {
                return 3;
            }
            case 9: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 3: {
                return 6;
            }
            case 14: {
                return 7;
            }
            case 11: {
                return 8;
            }
            case 13: {
                return 9;
            }
            case 7: {
                return 10;
            }
        }
        return 0;
    }

    private static int generateIronFenceGlassBlockData(int typeid, MapIterator mapiter) {
        int blockdata = 0;
        int id = mapiter.getBlockTypeIDAt(BlockStep.X_MINUS);
        if (id == typeid || id > 0 && TexturePack.HDTextureMap.getTransparency(id) == TexturePack.BlockTransparency.OPAQUE) {
            blockdata |= 1;
        }
        if ((id = mapiter.getBlockTypeIDAt(BlockStep.Z_MINUS)) == typeid || id > 0 && TexturePack.HDTextureMap.getTransparency(id) == TexturePack.BlockTransparency.OPAQUE) {
            blockdata |= 2;
        }
        if ((id = mapiter.getBlockTypeIDAt(BlockStep.X_PLUS)) == typeid || id > 0 && TexturePack.HDTextureMap.getTransparency(id) == TexturePack.BlockTransparency.OPAQUE) {
            blockdata |= 4;
        }
        if ((id = mapiter.getBlockTypeIDAt(BlockStep.Z_PLUS)) == typeid || id > 0 && TexturePack.HDTextureMap.getTransparency(id) == TexturePack.BlockTransparency.OPAQUE) {
            blockdata |= 8;
        }
        return blockdata;
    }

    private static int generateDoorBlockData(int typeid, MapIterator mapiter) {
        int blockdata = 0;
        int topdata = mapiter.getBlockData();
        int bottomdata = 0;
        if ((topdata & 8) != 0) {
            blockdata |= 8;
            mapiter.stepPosition(BlockStep.Y_MINUS);
            bottomdata = mapiter.getBlockData();
            mapiter.unstepPosition(BlockStep.Y_MINUS);
        } else {
            bottomdata = topdata;
            mapiter.stepPosition(BlockStep.Y_PLUS);
            topdata = mapiter.getBlockData();
            mapiter.unstepPosition(BlockStep.Y_PLUS);
        }
        boolean onright = false;
        if ((topdata & 1) == 1) {
            blockdata |= 4;
            onright = true;
        }
        blockdata |= bottomdata & 3;
        if ((bottomdata & 4) > 0) {
            blockdata = onright ? blockdata & 8 | 0 | blockdata - 1 & 3 : blockdata & 8 | 4 | blockdata + 1 & 3;
        }
        return blockdata;
    }

    private static boolean containsID(int id, int[] linkids) {
        for (int i = 0; i < linkids.length; ++i) {
            if (id != linkids[i]) continue;
            return true;
        }
        return false;
    }

    private static int generateWireBlockData(int[] linkids, MapIterator mapiter) {
        int blockdata = 0;
        int id = mapiter.getBlockTypeIDAt(BlockStep.X_MINUS);
        if (HDBlockModels.containsID(id, linkids)) {
            blockdata |= 1;
        }
        if (HDBlockModels.containsID(id = mapiter.getBlockTypeIDAt(BlockStep.Z_MINUS), linkids)) {
            blockdata |= 2;
        }
        if (HDBlockModels.containsID(id = mapiter.getBlockTypeIDAt(BlockStep.X_PLUS), linkids)) {
            blockdata |= 4;
        }
        if (HDBlockModels.containsID(id = mapiter.getBlockTypeIDAt(BlockStep.Z_PLUS), linkids)) {
            blockdata |= 8;
        }
        return blockdata;
    }

    static {
        models_by_id_data = new HashMap();
        pdf = new PatchDefinitionFactory();
        customModelsRequestingTileData = new BitSet();
        changeIgnoredBlocks = new BitSet();
        loadedmods = new HashSet();
        scaled_models_by_scale = new HashMap();
        boxPatchList = new int[]{1, 4, 0, 3, 2, 5};
        vscale = new long[]{10000000000L, 100000000L, 1000000L, 10000L, 100L, 1L};
    }

    public static class HDBlockPatchModel
    extends HDBlockModel {
        private PatchDefinition[] patches;
        private final int max_texture;

        public HDBlockPatchModel(int blockid, int databits, PatchDefinition[] patches, String blockset) {
            super(blockid, databits, blockset);
            this.patches = patches;
            int max = 0;
            for (int i = 0; i < patches.length; ++i) {
                if (patches[i] == null || patches[i].textureindex <= max) continue;
                max = patches[i].textureindex;
            }
            this.max_texture = max + 1;
        }

        public final PatchDefinition[] getPatches() {
            return this.patches;
        }

        @Override
        public int getTextureCount() {
            return this.max_texture;
        }

        static /* synthetic */ PatchDefinition[] access$602(HDBlockPatchModel x0, PatchDefinition[] x1) {
            x0.patches = x1;
            return x1;
        }
    }

    public static class HDBlockVolumetricModel
    extends HDBlockModel {
        private long[] blockflags;
        private int nativeres;
        private HashMap<Integer, short[]> scaledblocks;

        public HDBlockVolumetricModel(int blockid, int databits, int nativeres, long[] blockflags, String blockset) {
            super(blockid, databits, blockset);
            this.nativeres = nativeres;
            this.blockflags = new long[nativeres * nativeres];
            System.arraycopy(blockflags, 0, this.blockflags, 0, blockflags.length);
        }

        public final boolean isSubblockSet(int x, int y, int z) {
            return (this.blockflags[this.nativeres * y + z] & (long)(1 << x)) != 0L;
        }

        public final void setSubblock(int x, int y, int z, boolean isset) {
            if (isset) {
                int n = this.nativeres * y + z;
                this.blockflags[n] = this.blockflags[n] | (long)(1 << x);
            } else {
                int n = this.nativeres * y + z;
                this.blockflags[n] = this.blockflags[n] & (long)(~(1 << x));
            }
        }

        public short[] getScaledMap(int res) {
            short[] map;
            if (this.scaledblocks == null) {
                this.scaledblocks = new HashMap();
            }
            if ((map = this.scaledblocks.get(res)) == null) {
                map = new short[res * res * res];
                if (res == this.nativeres) {
                    for (int i = 0; i < this.blockflags.length; ++i) {
                        for (int j = 0; j < this.nativeres; ++j) {
                            if ((this.blockflags[i] & (long)(1 << j)) == 0L) continue;
                            map[res * i + j] = 255;
                        }
                    }
                } else if (res > this.nativeres) {
                    int[] weights = new int[res];
                    int[] offsets = new int[res];
                    int v = 0;
                    int idx = 0;
                    while (v < res * this.nativeres) {
                        offsets[idx] = v / res;
                        if ((v + this.nativeres - 1) / res == offsets[idx]) {
                            weights[idx] = this.nativeres;
                        } else {
                            weights[idx] = offsets[idx] + res - v;
                            weights[idx] = offsets[idx] * res + res - v;
                        }
                        v += this.nativeres;
                        ++idx;
                    }
                    int off = 0;
                    for (int y = 0; y < res; ++y) {
                        int ind_y = offsets[y];
                        int wgt_y = weights[y];
                        for (int z = 0; z < res; ++z) {
                            int ind_z = offsets[z];
                            int wgt_z = weights[z];
                            int x = 0;
                            while (x < res) {
                                int ind_x = offsets[x];
                                int wgt_x = weights[x];
                                int raw_w = 0;
                                for (int xx = 0; xx < 2; ++xx) {
                                    int wx;
                                    int n = wx = xx == 0 ? wgt_x : this.nativeres - wgt_x;
                                    if (wx == 0) continue;
                                    for (int yy = 0; yy < 2; ++yy) {
                                        int wy;
                                        int n2 = wy = yy == 0 ? wgt_y : this.nativeres - wgt_y;
                                        if (wy == 0) continue;
                                        for (int zz = 0; zz < 2; ++zz) {
                                            int wz;
                                            int n3 = wz = zz == 0 ? wgt_z : this.nativeres - wgt_z;
                                            if (wz == 0 || !this.isSubblockSet(ind_x + xx, ind_y + yy, ind_z + zz)) continue;
                                            raw_w += wx * wy * wz;
                                        }
                                    }
                                }
                                map[off] = (short)(255 * raw_w / (this.nativeres * this.nativeres * this.nativeres));
                                if (map[off] > 255) {
                                    map[off] = 255;
                                }
                                if (map[off] < 0) {
                                    map[off] = 0;
                                }
                                ++x;
                                ++off;
                            }
                        }
                    }
                } else {
                    int[] weights = new int[this.nativeres];
                    int[] offsets = new int[this.nativeres];
                    int v = 0;
                    int idx = 0;
                    while (v < res * this.nativeres) {
                        offsets[idx] = v / this.nativeres;
                        weights[idx] = (v + res - 1) / this.nativeres == offsets[idx] ? res : offsets[idx] * this.nativeres + this.nativeres - v;
                        v += res;
                        ++idx;
                    }
                    long[] accum = new long[map.length];
                    for (int y = 0; y < this.nativeres; ++y) {
                        int ind_y = offsets[y];
                        int wgt_y = weights[y];
                        for (int z = 0; z < this.nativeres; ++z) {
                            int ind_z = offsets[z];
                            int wgt_z = weights[z];
                            for (int x = 0; x < this.nativeres; ++x) {
                                if (!this.isSubblockSet(x, y, z)) continue;
                                int ind_x = offsets[x];
                                int wgt_x = weights[x];
                                for (int xx = 0; xx < 2; ++xx) {
                                    int wx;
                                    int n = wx = xx == 0 ? wgt_x : res - wgt_x;
                                    if (wx == 0) continue;
                                    for (int yy = 0; yy < 2; ++yy) {
                                        int wy;
                                        int n4 = wy = yy == 0 ? wgt_y : res - wgt_y;
                                        if (wy == 0) continue;
                                        for (int zz = 0; zz < 2; ++zz) {
                                            int wz;
                                            int n5 = wz = zz == 0 ? wgt_z : res - wgt_z;
                                            if (wz == 0) continue;
                                            int n6 = (ind_y + yy) * res * res + (ind_z + zz) * res + (ind_x + xx);
                                            accum[n6] = accum[n6] + (long)(wx * wy * wz);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    for (int i = 0; i < map.length; ++i) {
                        map[i] = (short)(accum[i] * 255L / (long)this.nativeres / (long)this.nativeres / (long)this.nativeres);
                        if (map[i] > 255) {
                            map[i] = 255;
                        }
                        if (map[i] >= 0) continue;
                        map[i] = 0;
                    }
                }
                this.scaledblocks.put(res, map);
            }
            return map;
        }

        @Override
        public int getTextureCount() {
            return 6;
        }
    }

    public static class CustomBlockModel
    extends HDBlockModel {
        public CustomRenderer render;
        private static final RenderPatch[] empty_list = new RenderPatch[0];

        public CustomBlockModel(int blockid, int databits, String classname, Map<String, String> classparm, String blockset) {
            super(blockid, databits, blockset);
            try {
                Class<?> cls = Class.forName(classname);
                this.render = (CustomRenderer)cls.newInstance();
                if (!this.render.initializeRenderer(pdf, blockid, databits, classparm)) {
                    Log.severe("Error loading custom renderer - " + classname);
                    this.render = null;
                } else if (this.render.getTileEntityFieldsNeeded() != null) {
                    for (int i = 0; i < 16; ++i) {
                        if ((databits & 1 << i) == 0) continue;
                        customModelsRequestingTileData.set(blockid << 4 | i);
                    }
                }
            }
            catch (Exception x) {
                Log.severe("Error loading custom renderer - " + classname, x);
                this.render = null;
            }
        }

        @Override
        public int getTextureCount() {
            return this.render.getMaximumTextureCount(pdf);
        }

        public CustomRendererData getMeshForBlock(MapDataContext ctx) {
            if (this.render != null) {
                return this.render.getRenderData(ctx);
            }
            return new CustomRendererData(empty_list, null, null);
        }

        @Override
        public void removed(int blkid, int blkdat) {
            super.removed(blkid, blkdat);
            customModelsRequestingTileData.clear(blkid << 4 | blkdat);
        }
    }

    public static abstract class HDBlockModel {
        private String blockset;

        protected HDBlockModel(int blockid, int databits, String blockset) {
            this.blockset = blockset;
            if (blockid > 0) {
                for (int i = 0; i < 16; ++i) {
                    HDBlockModel prev;
                    if ((databits & 1 << i) == 0 || (prev = models_by_id_data.put((blockid << 4) + i, this)) == null || prev == this) continue;
                    prev.removed(blockid, i);
                }
            }
        }

        public String getBlockSet() {
            return this.blockset;
        }

        public abstract int getTextureCount();

        public void removed(int blkid, int blkdat) {
        }
    }

    public static class HDScaledBlockModels {
        private short[][][] modelvectors;
        private PatchDefinition[][][] patches;
        private CustomBlockModel[][] custom;

        public final short[] getScaledModel(int blocktype, int blockdata, int blockrenderdata) {
            short[][] m;
            try {
                if (this.modelvectors[blocktype] == null) {
                    return null;
                }
                m = this.modelvectors[blocktype];
            }
            catch (ArrayIndexOutOfBoundsException aioobx) {
                short[][][] newmodels = new short[blocktype + 1][][];
                System.arraycopy(this.modelvectors, 0, newmodels, 0, this.modelvectors.length);
                this.modelvectors = newmodels;
                return null;
            }
            return m[blockrenderdata >= 0 ? blockrenderdata : blockdata];
        }

        public PatchDefinition[] getPatchModel(int blocktype, int blockdata, int blockrenderdata) {
            try {
                if (this.patches[blocktype] == null) {
                    return null;
                }
                return this.patches[blocktype][blockrenderdata >= 0 ? blockrenderdata : blockdata];
            }
            catch (ArrayIndexOutOfBoundsException aioobx) {
                PatchDefinition[][][] newpatches = new PatchDefinition[blocktype + 1][][];
                System.arraycopy(this.patches, 0, newpatches, 0, this.patches.length);
                this.patches = newpatches;
                return null;
            }
        }

        public CustomBlockModel getCustomBlockModel(int blocktype, int blockdata) {
            try {
                if (this.custom[blocktype] == null) {
                    return null;
                }
                return this.custom[blocktype][blockdata];
            }
            catch (ArrayIndexOutOfBoundsException aioobx) {
                CustomBlockModel[][] newcustom = new CustomBlockModel[blocktype + 1][];
                System.arraycopy(this.custom, 0, newcustom, 0, this.custom.length);
                this.custom = newcustom;
                return null;
            }
        }

        static /* synthetic */ short[][][] access$302(HDScaledBlockModels x0, short[][][] x1) {
            x0.modelvectors = x1;
            return x1;
        }

        static /* synthetic */ PatchDefinition[][][] access$402(HDScaledBlockModels x0, PatchDefinition[][][] x1) {
            x0.patches = x1;
            return x1;
        }

        static /* synthetic */ CustomBlockModel[][] access$502(HDScaledBlockModels x0, CustomBlockModel[][] x1) {
            x0.custom = x1;
            return x1;
        }
    }

    private static enum ChestData {
        SINGLE_WEST,
        SINGLE_SOUTH,
        SINGLE_EAST,
        SINGLE_NORTH,
        LEFT_WEST,
        LEFT_SOUTH,
        LEFT_EAST,
        LEFT_NORTH,
        RIGHT_WEST,
        RIGHT_SOUTH,
        RIGHT_EAST,
        RIGHT_NORTH;

    }
}

