/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.dynmap.ChatEvent;
import org.dynmap.Client;
import org.dynmap.Color;
import org.dynmap.Component;
import org.dynmap.ComponentManager;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapLocation;
import org.dynmap.DynmapMapCommands;
import org.dynmap.DynmapWorld;
import org.dynmap.Events;
import org.dynmap.MapManager;
import org.dynmap.MapType;
import org.dynmap.PlayerFaces;
import org.dynmap.PlayerList;
import org.dynmap.WebAuthManager;
import org.dynmap.common.DynmapCommandSender;
import org.dynmap.common.DynmapListenerManager;
import org.dynmap.common.DynmapPlayer;
import org.dynmap.common.DynmapServerInterface;
import org.dynmap.debug.Debug;
import org.dynmap.debug.Debugger;
import org.dynmap.exporter.DynmapExpCommands;
import org.dynmap.hdmap.HDBlockModels;
import org.dynmap.hdmap.HDMapManager;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.impl.MarkerAPIImpl;
import org.dynmap.modsupport.GWM_Util;
import org.dynmap.modsupport.ModSupportImpl;
import org.dynmap.servlet.ClientConfigurationServlet;
import org.dynmap.servlet.ConfigJSServlet;
import org.dynmap.servlet.FileResourceHandler;
import org.dynmap.servlet.JettyNullLogger;
import org.dynmap.servlet.LoginServlet;
import org.dynmap.servlet.MapStorageResourceHandler;
import org.dynmap.shadow.javax.servlet.Filter;
import org.dynmap.shadow.javax.servlet.http.HttpServlet;
import org.dynmap.shadow.org.eclipse.jetty.server.Connector;
import org.dynmap.shadow.org.eclipse.jetty.server.Handler;
import org.dynmap.shadow.org.eclipse.jetty.server.Server;
import org.dynmap.shadow.org.eclipse.jetty.server.handler.HandlerList;
import org.dynmap.shadow.org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.dynmap.shadow.org.eclipse.jetty.server.session.HashSessionIdManager;
import org.dynmap.shadow.org.eclipse.jetty.server.session.SessionHandler;
import org.dynmap.shadow.org.eclipse.jetty.servlet.ServletHolder;
import org.dynmap.shadow.org.eclipse.jetty.util.log.Log;
import org.dynmap.shadow.org.eclipse.jetty.util.resource.FileResource;
import org.dynmap.shadow.org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.dynmap.storage.MapStorage;
import org.dynmap.storage.filetree.FileTreeMapStorage;
import org.dynmap.storage.mariadb.MariaDBMapStorage;
import org.dynmap.storage.mysql.MySQLMapStorage;
import org.dynmap.storage.sqllte.SQLiteMapStorage;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.ImageIOManager;
import org.dynmap.web.BanIPFilter;
import org.dynmap.web.CustomHeaderFilter;
import org.dynmap.web.FilterHandler;
import org.dynmap.web.HandlerRouter;

public class DynmapCore
implements DynmapCommonAPI {
    public static final String TAG_TO_REPLACE_ON_EXTRACT = "${GWM_VERSION}";
    private File jarfile;
    private DynmapServerInterface server;
    private String version;
    private String platform = null;
    private String platformVersion = null;
    private Server webServer = null;
    private String webhostname = null;
    private int webport = 0;
    private HandlerRouter router = null;
    public MapManager mapManager = null;
    public PlayerList playerList;
    public ConfigurationNode configuration;
    public ConfigurationNode world_config;
    public ComponentManager componentManager = new ComponentManager();
    public DynmapListenerManager listenerManager = new DynmapListenerManager(this);
    public PlayerFaces playerfacemgr;
    public Events events = new Events();
    public String deftemplatesuffix = "";
    private DynmapMapCommands dmapcmds = new DynmapMapCommands();
    private DynmapExpCommands dynmapexpcmds = new DynmapExpCommands();
    boolean bettergrass = false;
    boolean smoothlighting = false;
    private boolean ctmsupport = false;
    private boolean customcolorssupport = false;
    private String def_image_format = "png";
    private HashSet<String> enabledTriggers = new HashSet();
    public boolean disable_chat_to_web = false;
    private WebAuthManager authmgr;
    public boolean player_info_protected;
    private boolean transparentLeaves = true;
    private List<String> sortPermissionNodes;
    private int perTickLimit = 50;
    private boolean dumpMissing = false;
    public CompassMode compassmode = CompassMode.PRE19;
    private int config_hashcode;
    private int fullrenderplayerlimit;
    private int updateplayerlimit;
    private boolean didfullpause;
    private boolean didupdatepause;
    private Map<String, LinkedList<String>> ids_by_ip = new HashMap<String, LinkedList<String>>();
    private boolean persist_ids_by_ip = false;
    private int snapshotcachesize;
    private boolean snapshotsoftref;
    private int[] blockmaterialmap = new int[0];
    private String[] biomenames = new String[0];
    private Map<String, Integer> blockmap = null;
    private Map<String, Integer> itemmap = null;
    private boolean loginRequired;
    public boolean is_reload = false;
    public static boolean ignore_chunk_loads = false;
    private MarkerAPIImpl markerapi;
    private File dataDirectory;
    private File tilesDirectory;
    private File exportDirectory;
    private String plugin_ver;
    private MapStorage defaultStorage;
    private String[] deftriggers = new String[0];
    private static final String[] stdtemplates = new String[]{"normal.txt", "nether.txt", "normal-lowres.txt", "nether-lowres.txt", "normal-hires.txt", "nether-hires.txt", "normal-vlowres.txt", "nether-vlowres.txt", "the_end.txt", "the_end-vlowres.txt", "the_end-lowres.txt", "the_end-hires.txt", "normal-low_boost_hi.txt", "normal-hi_boost_vhi.txt", "normal-hi_boost_xhi.txt", "nether-low_boost_hi.txt", "nether-hi_boost_vhi.txt", "nether-hi_boost_xhi.txt", "the_end-low_boost_hi.txt", "the_end-hi_boost_vhi.txt", "the_end-hi_boost_xhi.txt"};
    private static final String CUSTOM_PREFIX = "custom-";
    private static final Set<String> commands = new HashSet<String>(Arrays.asList("render", "hide", "show", "version", "fullrender", "cancelrender", "radiusrender", "updaterender", "reload", "stats", "triggerstats", "resetstats", "sendtoweb", "pause", "purgequeue", "purgemap", "purgeworld", "quiet", "ids-for-ip", "ips-for-id", "add-id-for-ip", "del-id-for-ip", "webregister", "help"));
    private static final CommandInfo[] commandinfo = new CommandInfo[]{new CommandInfo("dynmap", "", "Control execution of dynmap."), new CommandInfo("dynmap", "hide", "Hides the current player from the map."), new CommandInfo("dynmap", "hide", "<player>", "Hides <player> on the map."), new CommandInfo("dynmap", "show", "Shows the current player on the map."), new CommandInfo("dynmap", "show", "<player>", "Shows <player> on the map."), new CommandInfo("dynmap", "render", "Renders the tile at your location."), new CommandInfo("dynmap", "fullrender", "Render all maps for entire world from your location."), new CommandInfo("dynmap", "fullrender", "<world>", "Render all maps for world <world>."), new CommandInfo("dynmap", "fullrender", "<world>:<map>", "Render map <map> of world'<world>."), new CommandInfo("dynmap", "radiusrender", "<radius>", "Render at least <radius> block radius from your location on all maps."), new CommandInfo("dynmap", "radiusrender", "<radius> <mapname>", "Render at least <radius> block radius from your location on map <mapname>."), new CommandInfo("dynmap", "radiusrender", "<world> <x> <z> <radius>", "Render at least <radius> block radius from location <x>,<z> on world <world>."), new CommandInfo("dynmap", "radiusrender", "<world> <x> <z> <radius> <map>", "Render at least <radius> block radius from location <x>,<z> on world <world> on map <map>."), new CommandInfo("dynmap", "updaterender", "Render updates starting at your location on all maps."), new CommandInfo("dynmap", "updaterender", "<map>", "Render updates starting at your location on map <map>."), new CommandInfo("dynmap", "updaterender", "<world> <x> <z> <map>", "Render updates starting at location <x>,<z> on world <world> for map <map>."), new CommandInfo("dynmap", "cancelrender", "Cancels any active renders on current world."), new CommandInfo("dynmap", "cancelrender", "<world>", "Cancels any active renders of world <world>."), new CommandInfo("dynmap", "stats", "Show render statistics."), new CommandInfo("dynmap", "triggerstats", "Show render update trigger statistics."), new CommandInfo("dynmap", "resetstats", "Reset render statistics."), new CommandInfo("dynmap", "sendtoweb", "<msg>", "Send message <msg> to web users."), new CommandInfo("dynmap", "purgequeue", "Empty all pending tile updates from update queue."), new CommandInfo("dynmap", "purgequeue", "<world>", "Empty all pending tile updates from update queue for world <world>."), new CommandInfo("dynmap", "purgemap", "<world> <map>", "Delete all existing tiles for map <map> on world <world>."), new CommandInfo("dynmap", "purgeworld", "<world>", "Delete all existing directories for world <world>."), new CommandInfo("dynmap", "pause", "Show render pause state."), new CommandInfo("dynmap", "pause", "<all|none|full|update>", "Set render pause state."), new CommandInfo("dynmap", "quiet", "Stop output from active jobs."), new CommandInfo("dynmap", "ids-for-ip", "<ipaddress>", "Show player IDs that have logged in from address <ipaddress>."), new CommandInfo("dynmap", "ips-for-id", "<player>", "Show IP addresses that have been used for player <player>."), new CommandInfo("dynmap", "add-id-for-ip", "<player> <ipaddress>", "Associate player <player> with IP address <ipaddress>."), new CommandInfo("dynmap", "del-id-for-ip", "<player> <ipaddress>", "Disassociate player <player> from IP address <ipaddress>."), new CommandInfo("dynmap", "webregister", "Start registration process for creating web login account"), new CommandInfo("dynmap", "webregister", "<player>", "Start registration process for creating web login account for player <player>"), new CommandInfo("dynmap", "version", "Return version information"), new CommandInfo("dmarker", "", "Manipulate map markers."), new CommandInfo("dmarker", "add", "<label>", "Add new marker with label <label> at current location (use double-quotes if spaces needed)."), new CommandInfo("dmarker", "add", "id:<id> <label>", "Add new marker with ID <id> at current location (use double-quotes if spaces needed)."), new CommandInfo("dmarker", "movehere", "<label>", "Move marker with label <label> to current location."), new CommandInfo("dmarker", "movehere", "id:<id>", "Move marker with ID <id> to current location."), new CommandInfo("dmarker", "update", "<label> icon:<icon> newlabel:<newlabel>", "Update marker with ID <id> with new label <newlabel> and new icon <icon>."), new CommandInfo("dmarker", "delete", "<label>", "Delete marker with label of <label>."), new CommandInfo("dmarker", "delete ", "id:<id>", "Delete marker with ID of <id>."), new CommandInfo("dmarker", "list", "List details of all markers."), new CommandInfo("dmarker", "icons", "List details of all icons."), new CommandInfo("dmarker", "addset", "<label>", "Add marker set with label <label>."), new CommandInfo("dmarker", "addset", "id:<id> <label>", "Add marker set with ID <id> and label <label>."), new CommandInfo("dmarker", "updateset", "id:<id> newlabel:<newlabel>", "Update marker set with ID <id> with new label <newlabel>."), new CommandInfo("dmarker", "updateset", "<label> newlabel:<newlabel>", "Update marker set with label <label> to new label <newlabel>."), new CommandInfo("dmarker", "deleteset", "<label>", "Delete marker set with label <label>."), new CommandInfo("dmarker", "deleteset", "id:<id>", "Delete marker set with ID of <id>."), new CommandInfo("dmarker", "listsets", "List all marker sets."), new CommandInfo("dmarker", "addicon", "id:<id> <label> file:<filename>", "Install new icon with ID <id> using image file <filename>"), new CommandInfo("dmarker", "updateicon", "id:<id> newlabel:<newlabel> file:<filename>", "Update existing icon with ID of <id> with new label or file."), new CommandInfo("dmarker", "updateicon", "<label> newlabel:<newlabel> file:<filename>", "Update existing icon with label of <label> with new label or file."), new CommandInfo("dmarker", "deleteicon", "id:<id>", "Remove icon with ID of <id>."), new CommandInfo("dmarker", "deleteicon", "<label>", "Remove icon with label of <label>."), new CommandInfo("dmarker", "addcorner", "Add corner to corner list using current location."), new CommandInfo("dmarker", "addcorner", "<x> <y> <z> <world>", "Add corner with coordinate <x>, <y>, <z> on world <world> to corner list."), new CommandInfo("dmarker", "clearcorners", "Clear corner list."), new CommandInfo("dmarker", "addarea", "<label>", "Add new area marker with label of <label> using current corner list."), new CommandInfo("dmarker", "addarea", "id:<id> <label>", "Add new area marker with ID of <id> using current corner list."), new CommandInfo("dmarker", "deletearea", "<label>", "Delete area marker with label of <label>."), new CommandInfo("dmarker", "deletearea", "id:<id> <label>", "Delete area marker with ID of <id>."), new CommandInfo("dmarker", "listareas", "List details of all area markers."), new CommandInfo("dmarker", "updatearea", "<label> <arg>:<value> ...", "Update attributes of area marker with label of <label>."), new CommandInfo("dmarker", "updatearea", "id:<id> <arg>:<value> ...", "Update attributes of area marker with ID of <id>."), new CommandInfo("dmarker", "addline", "<label>", "Add new poly-line marker with label of <label> using current corner list."), new CommandInfo("dmarker", "addline", "id:<id> <label>", "Add new poly-line marker with ID of <id> using current corner list."), new CommandInfo("dmarker", "deleteline", "<label>", "Delete poly-line marker with label of <label>."), new CommandInfo("dmarker", "deleteline", "id:<id>", "Delete poly-line marker with ID of <id>."), new CommandInfo("dmarker", "listlines", "List details of all poly-line markers."), new CommandInfo("dmarker", "updateline", "<label> <arg>:<value> ...", "Update attributes of poly-line marker with label of <label>."), new CommandInfo("dmarker", "updateline", "id:<id> <arg>:<value> ...", "Update attributes of poly-line marker with ID of <id>."), new CommandInfo("dmarker", "addcircle", "<label> radius:<rad>", "Add new circle centered at current location with radius of <radius> and label of <label>."), new CommandInfo("dmarker", "addcircle", "id:<id> <label> radius:<rad>", "Add new circle centered at current location with radius of <radius> and ID of <id>."), new CommandInfo("dmarker", "addcircle", "<label> radius:<rad> x:<x> y:<y> z:<z> world:<world>", "Add new circle centered at <x>,<y>,<z> on world <world> with radius of <rad> and label of <label>."), new CommandInfo("dmarker", "deletecircle", "<label>", "Delete circle with label of <label>."), new CommandInfo("dmarker", "deletecircle", "id:<id>", "Delete circle with ID of <id>."), new CommandInfo("dmarker", "listcircles", "List details of all circles."), new CommandInfo("dmarker", "updatecircle", "<label> <arg>:<value> ...", "Update attributes of circle with label of <label>."), new CommandInfo("dmarker", "updatecircle", "id:<id> <arg>:<value> ...", "Update attributes of circle with ID of <id>."), new CommandInfo("dmap", "", "List and modify dynmap configuration."), new CommandInfo("dmap", "worldlist", "List all worlds configured (enabled or disabled)."), new CommandInfo("dmap", "worldset", "<world> enabled:<true|false>", "Enable or disable world named <world>."), new CommandInfo("dmap", "worldset", "<world> center:<x/y/z|here|default>", "Set map center for world <world> to ccoordinates <x>,<y>,<z>."), new CommandInfo("dmap", "worldset", "<world> extrazoomout:<N>", "Set extra zoom out levels for world <world>."), new CommandInfo("dmap", "maplist", "<world>", "List all maps for world <world>"), new CommandInfo("dmap", "mapdelete", "<world>:<map>", "Delete map <map> from world <world>."), new CommandInfo("dmap", "mapadd", "<world>:<map> <attrib>:<value> <attrib>:<value>", "Create map for world <world> with name <map> using provided attributes."), new CommandInfo("dmap", "mapset", "<world>:<map> <attrib>:<value> <attrib>:<value>", "Update map <map> of world <world> with new attribute values."), new CommandInfo("dmap", "worldreset", "<world>", "Reset world <world> to default template for world type"), new CommandInfo("dmap", "worldreset", "<world> <templatename>", "Reset world <world> to temaplte <templatename>."), new CommandInfo("dmap", "disableworlds", "<world0> <world1> ...", "Disable all worlds in list."), new CommandInfo("dmap", "setorder", "<world0> <world1> ...", "Set the top worlds to the ones listed. Worlds not listed will be pushed down."), new CommandInfo("dmap", "enableonly", "<world0> <world1> ...", "Enable all worlds in list, disable the rest, and set the order of the enabled worlds to order of args."), new CommandInfo("dmap", "exploremode", "<world0> <world1> ...", "Disable all currently enabled worlds not in args, and mark them as enable on visit. If list is empty, overworld will remain enabled."), new CommandInfo("dynmapexp", "", "Set and execute exports in OBJ format."), new CommandInfo("dynmapexp", "set", "<attrib> <value> ...", "Set bounds attributes for OBJ export."), new CommandInfo("dynmapexp", "reset", "Reset all bounds for OBJ export."), new CommandInfo("dynmapexp", "pos0", "Set first corner of bounds to player's position."), new CommandInfo("dynmapexp", "pos1", "Set second corner of bounds to player's position."), new CommandInfo("dynmapexp", "radius", "<radius>", "Set bounds to radius <radius> around player's position."), new CommandInfo("dynmapexp", "export", "<name>", "Export map data to <name>.zip in export path."), new CommandInfo("dynmapexp", "purge", "<name>", "Purge exported map data <name>.zip from export path.")};

    public void cleanup() {
        this.server = null;
        this.markerapi = null;
    }

    public void setPluginJarFile(File f) {
        this.jarfile = f;
    }

    public File getPluginJarFile() {
        return this.jarfile;
    }

    public void setPluginVersion(String pluginver, String platform) {
        this.plugin_ver = pluginver;
        this.platform = platform;
    }

    public void setPluginVersion(String pluginver) {
        this.setPluginVersion(pluginver, "Forge");
    }

    public void setDataFolder(File dir) {
        this.dataDirectory = dir;
    }

    public final File getDataFolder() {
        return this.dataDirectory;
    }

    public final File getTilesFolder() {
        return this.tilesDirectory;
    }

    public final File getExportFolder() {
        return this.exportDirectory;
    }

    public void setMinecraftVersion(String mcver) {
        this.platformVersion = mcver;
    }

    public void setServer(DynmapServerInterface srv) {
        this.server = srv;
    }

    public final DynmapServerInterface getServer() {
        return this.server;
    }

    public final void setBlockMaterialMap(int[] materials) {
        this.blockmaterialmap = materials;
    }

    public final int[] getBlockMaterialMap() {
        return this.blockmaterialmap;
    }

    public final Map<String, Integer> getBlockIDMap() {
        return this.blockmap;
    }

    public final void setBlockNames(String[] names) {
    }

    public final void setBiomeNames(String[] names) {
        this.biomenames = names;
    }

    public final String getBiomeName(int biomeid) {
        String n = null;
        if (biomeid >= 0 && biomeid < this.biomenames.length) {
            n = this.biomenames[biomeid];
        }
        if (n == null) {
            n = "biome" + biomeid;
        }
        return n;
    }

    public final String[] getBiomeNames() {
        return this.biomenames;
    }

    public final MapManager getMapManager() {
        return this.mapManager;
    }

    public final void setTriggerDefault(String[] triggers) {
        this.deftriggers = triggers;
    }

    public final void setLeafTransparency(boolean trans) {
        this.transparentLeaves = trans;
    }

    public final boolean getLeafTransparency() {
        return this.transparentLeaves;
    }

    private void mergeConfigurationBranch(ConfigurationNode cfgnode, String branch, boolean replace_existing, boolean islist) {
        Object srcbranch = cfgnode.getObject(branch);
        if (srcbranch == null) {
            return;
        }
        Object destbranch = this.configuration.getObject(branch);
        if (destbranch == null) {
            this.configuration.put(branch, srcbranch);
            return;
        }
        if (islist) {
            List<ConfigurationNode> dest = this.configuration.getNodes(branch);
            List<ConfigurationNode> src = cfgnode.getNodes(branch);
            for (ConfigurationNode node : src) {
                String name = node.getString("name", null);
                if (name == null) continue;
                boolean matched = false;
                for (ConfigurationNode dnode : dest) {
                    String dname = dnode.getString("name", null);
                    if (dname == null || !dname.equals(name)) continue;
                    if (replace_existing) {
                        dnode.clear();
                        dnode.putAll(node);
                    }
                    matched = true;
                    break;
                }
                if (matched) continue;
                dest.add(node);
            }
            this.configuration.put(branch, (Object)dest);
        } else {
            ConfigurationNode src = cfgnode.getNode(branch);
            ConfigurationNode dest = this.configuration.getNode(branch);
            for (String key : src.keySet()) {
                if (dest.containsKey(key)) {
                    if (!replace_existing) continue;
                    dest.put(key, src.getObject(key));
                    continue;
                }
                dest.put(key, src.getObject(key));
            }
        }
    }

    private void loadTemplates() {
        ConfigurationNode cn;
        File tf;
        String[] templates;
        File templatedir = new File(this.dataDirectory, "templates");
        templatedir.mkdirs();
        for (String stdtemplate : stdtemplates) {
            File f = new File(templatedir, stdtemplate);
            this.updateVersionUsingDefaultResource("/templates/" + stdtemplate, f);
        }
        for (String tname : templates = templatedir.list()) {
            if (!tname.endsWith(".txt") || tname.startsWith(CUSTOM_PREFIX)) continue;
            tf = new File(templatedir, tname);
            cn = new ConfigurationNode(tf);
            cn.load();
            this.mergeConfigurationBranch(cn, "templates", false, false);
        }
        for (String tname : templates) {
            if (!tname.endsWith(".txt") || !tname.startsWith(CUSTOM_PREFIX)) continue;
            tf = new File(templatedir, tname);
            cn = new ConfigurationNode(tf);
            cn.load();
            this.mergeConfigurationBranch(cn, "templates", true, false);
        }
    }

    public boolean enableCore() {
        boolean rslt = this.initConfiguration(null);
        if (rslt) {
            rslt = this.enableCore(null);
        }
        return rslt;
    }

    public boolean initConfiguration(EnableCoreCallbacks cb) {
        String storetype;
        this.events = new Events();
        this.player_info_protected = false;
        this.loadVersion();
        File f = new File(this.dataDirectory, "configuration.txt");
        if (!this.createDefaultFileFromResource("/configuration.txt", f)) {
            return false;
        }
        this.configuration = new ConfigurationNode(f);
        this.configuration.load();
        this.tilesDirectory = this.getFile(this.configuration.getString("tilespath", "web/tiles"));
        if (!this.tilesDirectory.isDirectory() && !this.tilesDirectory.mkdirs()) {
            org.dynmap.Log.warning("Could not create directory for tiles ('" + this.tilesDirectory + "').");
        }
        this.exportDirectory = this.getFile(this.configuration.getString("exportpath", "export"));
        if (!this.exportDirectory.isDirectory() && !this.exportDirectory.mkdirs()) {
            org.dynmap.Log.warning("Could not create directory for exports ('" + this.exportDirectory + "').");
        }
        if ((storetype = this.configuration.getString("storage/type", "filetree")).equals("filetree")) {
            this.defaultStorage = new FileTreeMapStorage();
        } else if (storetype.equals("sqlite")) {
            this.defaultStorage = new SQLiteMapStorage();
        } else if (storetype.equals("mysql")) {
            this.defaultStorage = new MySQLMapStorage();
        } else if (storetype.equals("mariadb")) {
            this.defaultStorage = new MariaDBMapStorage();
        } else {
            org.dynmap.Log.severe("Invalid storage type for map data: " + storetype);
            return false;
        }
        if (!this.defaultStorage.init(this)) {
            org.dynmap.Log.severe("Map storage initialization failure");
            return false;
        }
        if (!this.markerAPIInitialized()) {
            MarkerAPIImpl api = MarkerAPIImpl.initializeMarkerAPI(this);
            this.registerMarkerAPI(api);
        }
        if (cb != null) {
            cb.configurationLoaded();
        }
        return true;
    }

    public boolean enableCore(EnableCoreCallbacks cb) {
        this.updateExtractedFiles();
        if (this.configuration.getBoolean("login-enabled", false)) {
            this.authmgr = new WebAuthManager(this);
            this.defaultStorage.setLoginEnabled(this);
        }
        HDMapManager.waterlightingfix = this.configuration.getBoolean("correct-water-lighting", false);
        HDMapManager.biomeshadingfix = this.configuration.getBoolean("correct-biome-shading", false);
        this.transparentLeaves = this.configuration.getBoolean("transparent-leaves", true);
        this.def_image_format = this.configuration.getString("image-format", "png");
        MapType.ImageFormat fmt = MapType.ImageFormat.fromID(this.def_image_format);
        if (fmt == null) {
            org.dynmap.Log.severe("Invalid image-format: " + this.def_image_format);
            this.def_image_format = "png";
        }
        DynmapWorld.doInitialScan(this.configuration.getBoolean("initial-zoomout-validate", true));
        this.smoothlighting = this.configuration.getBoolean("smooth-lighting", false);
        this.ctmsupport = this.configuration.getBoolean("ctm-support", true);
        this.customcolorssupport = this.configuration.getBoolean("custom-colors-support", true);
        org.dynmap.Log.verbose = this.configuration.getBoolean("verbose", true);
        this.deftemplatesuffix = this.configuration.getString("deftemplatesuffix", "");
        this.snapshotcachesize = this.configuration.getInteger("snapshotcachesize", 500);
        this.snapshotsoftref = this.configuration.getBoolean("soft-ref-cache", true);
        String cmode = this.configuration.getString("compass-mode", "newrose");
        this.compassmode = cmode.equals("newnorth") ? CompassMode.NEWNORTH : (cmode.equals("newrose") ? CompassMode.NEWROSE : CompassMode.PRE19);
        this.bettergrass = this.configuration.getBoolean("better-grass", false);
        this.fullrenderplayerlimit = this.configuration.getInteger("fullrenderplayerlimit", 0);
        this.updateplayerlimit = this.configuration.getInteger("updateplayerlimit", 0);
        this.sortPermissionNodes = this.configuration.getStrings("player-sort-permission-nodes", null);
        this.perTickLimit = this.configuration.getInteger("per-tick-time-limit", 50);
        if (this.perTickLimit < 5) {
            this.perTickLimit = 5;
        }
        this.dumpMissing = this.configuration.getBoolean("dump-missing-blocks", false);
        ImageIOManager.preUpdateCommand = this.configuration.getString("custom-commands/image-updates/preupdatecommand", "");
        ImageIOManager.postUpdateCommand = this.configuration.getString("custom-commands/image-updates/postupdatecommand", "");
        this.blockmap = this.server.getBlockUniqueIDMap();
        this.itemmap = this.server.getItemUniqueIDMap();
        ModSupportImpl.complete(this.dataDirectory);
        org.dynmap.Log.verboseinfo("Loading models...");
        HDBlockModels.loadModels(this, this.configuration);
        org.dynmap.Log.verboseinfo("Loading texture mappings...");
        TexturePack.loadTextureMapping(this, this.configuration);
        GWM_Util.loadBlockGroups(this);
        File f = new File(this.dataDirectory, "worlds.txt");
        if (!this.createDefaultFileFromResource("/worlds.txt", f)) {
            return false;
        }
        this.world_config = new ConfigurationNode(f);
        this.world_config.load();
        org.dynmap.Log.verboseinfo("Loading templates...");
        this.loadTemplates();
        this.persist_ids_by_ip = this.configuration.getBoolean("persist-ids-by-ip", true);
        if (this.persist_ids_by_ip) {
            org.dynmap.Log.verboseinfo("Loading userid-by-IP data...");
            this.loadIDsByIP();
        }
        this.loadDebuggers();
        this.playerList = new PlayerList(this.getServer(), this.getFile("hiddenplayers.txt"), this.configuration);
        this.playerList.load();
        this.mapManager = new MapManager(this, this.configuration);
        this.mapManager.startRendering();
        this.playerfacemgr = new PlayerFaces(this);
        this.updateConfigHashcode();
        this.loginRequired = this.configuration.getBoolean("login-required", false);
        this.loadWebserver();
        this.enabledTriggers.clear();
        List<String> triggers = this.configuration.getStrings("render-triggers", new ArrayList<String>());
        if (triggers != null && triggers.size() > 0) {
            for (Object e : triggers) {
                this.enabledTriggers.add((String)e);
            }
        } else {
            for (String def : this.deftriggers) {
                this.enabledTriggers.add(def);
            }
        }
        for (Component component : this.configuration.createInstances("components", new Class[]{DynmapCore.class}, new Object[]{this})) {
            this.componentManager.add(component);
        }
        org.dynmap.Log.verboseinfo("Loaded " + this.componentManager.components.size() + " components.");
        if (!this.configuration.getBoolean("disable-webserver", false)) {
            this.startWebserver();
        }
        this.listenerManager.addListener(DynmapListenerManager.EventType.PLAYER_JOIN, new DynmapListenerManager.PlayerEventListener(){

            @Override
            public void playerEvent(DynmapPlayer p) {
                DynmapCore.this.playerJoined(p);
            }
        });
        this.listenerManager.addListener(DynmapListenerManager.EventType.PLAYER_QUIT, new DynmapListenerManager.PlayerEventListener(){

            @Override
            public void playerEvent(DynmapPlayer p) {
                DynmapCore.this.playerQuit(p);
            }
        });
        org.dynmap.Log.info("version " + this.plugin_ver + " is enabled - core version " + this.version);
        this.events.trigger("initialized", null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpColorMap(String id, String name) {
        int[] sides = new int[]{BlockStep.Y_MINUS.ordinal(), BlockStep.X_PLUS.ordinal(), BlockStep.Z_PLUS.ordinal(), BlockStep.Y_PLUS.ordinal(), BlockStep.X_MINUS.ordinal(), BlockStep.Z_MINUS.ordinal()};
        FileWriter fw = null;
        try {
            fw = new FileWriter(id);
            TexturePack tp = TexturePack.getTexturePack(this, name);
            if (tp == null) {
                return;
            }
            if ((tp = tp.resampleTexturePack(1)) == null) {
                return;
            }
            Color c = new Color();
            for (int blkid = 1; blkid < 256; ++blkid) {
                int meta0color = 0;
                for (int blkmeta = 0; blkmeta < 16; ++blkmeta) {
                    TexturePack.HDTextureMap map = TexturePack.HDTextureMap.getMap(blkid, blkmeta, blkmeta);
                    boolean done = false;
                    for (int i = 0; !done && i < sides.length; ++i) {
                        int[] rgb;
                        int idx = map.getIndexForFace(sides[i]);
                        if (idx < 0 || (rgb = tp.getTileARGB(idx % 1000000)) == null || rgb[0] == 0) continue;
                        c.setARGB(rgb[0]);
                        switch (idx /= 1000000) {
                            case 1: 
                            case 18: {
                                System.out.println("Used grass for " + blkid + ":" + blkmeta);
                                c.blendColor(tp.getTrivialGrassMultiplier() | 0xFF000000);
                                break;
                            }
                            case 2: 
                            case 19: 
                            case 22: {
                                System.out.println("Used foliage for " + blkid + ":" + blkmeta);
                                c.blendColor(tp.getTrivialFoliageMultiplier() | 0xFF000000);
                                break;
                            }
                            case 13: {
                                c.blendColor(-10380959);
                                break;
                            }
                            case 14: {
                                c.blendColor(-8345771);
                                break;
                            }
                            case 15: {
                                c.blendColor(-14647248);
                                break;
                            }
                            case 3: 
                            case 20: {
                                System.out.println("Used water for " + blkid + ":" + blkmeta);
                                c.blendColor(tp.getTrivialWaterMultiplier() | 0xFF000000);
                                break;
                            }
                            case 12: {
                                if (blkid != 8 && blkid != 9) break;
                                System.out.println("Used water for " + blkid + ":" + blkmeta);
                                c.blendColor(tp.getTrivialWaterMultiplier() | 0xFF000000);
                            }
                        }
                        int custmult = tp.getCustomBlockMultiplier(blkid, blkmeta);
                        if (custmult != 0xFFFFFF) {
                            System.out.println(String.format("Custom color: %06x for %d:%d", custmult, blkid, blkmeta));
                            if ((custmult & 0xFF000000) == 0) {
                                custmult |= 0xFF000000;
                            }
                            c.blendColor(custmult);
                        }
                        String ln = "";
                        if (blkmeta == 0) {
                            meta0color = c.getARGB();
                            ln = blkid + " ";
                        } else {
                            ln = blkid + ":" + blkmeta + " ";
                        }
                        if (blkmeta == 0 || meta0color != c.getARGB()) {
                            ln = ln + c.getRed() + " " + c.getGreen() + " " + c.getBlue() + " " + c.getAlpha();
                            ln = ln + " " + c.getRed() * 4 / 5 + " " + c.getGreen() * 4 / 5 + " " + c.getBlue() * 4 / 5 + " " + c.getAlpha();
                            ln = ln + " " + c.getRed() / 2 + " " + c.getGreen() / 2 + " " + c.getBlue() / 2 + " " + c.getAlpha();
                            ln = ln + " " + c.getRed() * 2 / 5 + " " + c.getGreen() * 2 / 5 + " " + c.getBlue() * 2 / 5 + " " + c.getAlpha() + "\n";
                            fw.write(ln);
                        }
                        done = true;
                    }
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void playerJoined(DynmapPlayer p) {
        InetSocketAddress addr;
        this.playerList.updateOnlinePlayers(null);
        if (this.fullrenderplayerlimit > 0 || this.updateplayerlimit > 0) {
            int pcnt = this.getServer().getOnlinePlayers().length;
            if (this.fullrenderplayerlimit > 0 && pcnt == this.fullrenderplayerlimit) {
                if (!this.getPauseFullRadiusRenders()) {
                    this.setPauseFullRadiusRenders(true);
                    org.dynmap.Log.info("Pause full/radius renders - player limit reached");
                    this.didfullpause = true;
                } else {
                    this.didfullpause = false;
                }
            }
            if (this.updateplayerlimit > 0 && pcnt == this.updateplayerlimit) {
                if (!this.getPauseUpdateRenders()) {
                    this.setPauseUpdateRenders(true);
                    org.dynmap.Log.info("Pause tile update renders - player limit reached");
                    this.didupdatepause = true;
                } else {
                    this.didupdatepause = false;
                }
            }
        }
        if ((addr = p.getAddress()) != null) {
            String pid;
            String ip = addr.getAddress().getHostAddress();
            LinkedList<String> ids = this.ids_by_ip.get(ip);
            if (ids == null) {
                ids = new LinkedList();
                this.ids_by_ip.put(ip, ids);
            }
            if (ids.indexOf(pid = p.getName()) != 0) {
                ids.remove(pid);
                ids.addFirst(pid);
            }
        }
        if (this.sortPermissionNodes != null && this.sortPermissionNodes.size() > 0) {
            int ord;
            for (ord = 0; ord < this.sortPermissionNodes.size() && !p.hasPermissionNode(this.sortPermissionNodes.get(ord)); ++ord) {
            }
            p.setSortWeight(ord);
        } else {
            p.setSortWeight(0);
        }
        if (this.mapManager != null) {
            this.mapManager.connectTasksToPlayer(p);
        }
    }

    private void playerQuit(DynmapPlayer p) {
        this.playerList.updateOnlinePlayers(p.getName());
        if (this.fullrenderplayerlimit > 0 || this.updateplayerlimit > 0) {
            int pcnt = this.getServer().getOnlinePlayers().length - 1;
            if (this.fullrenderplayerlimit > 0 && pcnt == this.fullrenderplayerlimit - 1) {
                if (this.didfullpause && this.getPauseFullRadiusRenders()) {
                    this.setPauseFullRadiusRenders(false);
                    org.dynmap.Log.info("Resume full/radius renders - below player limit");
                }
                this.didfullpause = false;
            }
            if (this.updateplayerlimit > 0 && pcnt == this.updateplayerlimit - 1) {
                if (this.didupdatepause && this.getPauseUpdateRenders()) {
                    this.setPauseUpdateRenders(false);
                    org.dynmap.Log.info("Resume tile update renders - below player limit");
                }
                this.didupdatepause = false;
            }
        }
    }

    public void updateConfigHashcode() {
        this.config_hashcode = (int)System.currentTimeMillis();
    }

    public int getConfigHashcode() {
        return this.config_hashcode;
    }

    private FileResource createFileResource(String path) {
        try {
            File f = new File(path);
            URI uri = f.toURI();
            URL url = uri.toURL();
            return new FileResource(url);
        }
        catch (Exception e) {
            org.dynmap.Log.info("Could not create file resource");
            return null;
        }
    }

    public void loadWebserver() {
        Log.setLog(new JettyNullLogger());
        String ip = this.server.getServerIP();
        if (ip == null || ip.trim().length() == 0) {
            ip = "0.0.0.0";
        }
        this.webhostname = this.configuration.getString("webserver-bindaddress", ip);
        this.webport = this.configuration.getInteger("webserver-port", 8123);
        this.webServer = new Server();
        this.webServer.setSessionIdManager(new HashSessionIdManager());
        int maxconnections = this.configuration.getInteger("max-sessions", 30);
        if (maxconnections < 2) {
            maxconnections = 2;
        }
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(maxconnections);
        ExecutorThreadPool pool = new ExecutorThreadPool(2, maxconnections, 60L, TimeUnit.SECONDS, queue);
        this.webServer.setThreadPool(pool);
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setMaxIdleTime(5000);
        connector.setAcceptors(1);
        connector.setAcceptQueueSize(50);
        connector.setLowResourcesMaxIdleTime(1000);
        connector.setLowResourcesConnections(maxconnections / 2);
        if (!this.webhostname.equals("0.0.0.0")) {
            connector.setHost(this.webhostname);
        }
        connector.setPort(this.webport);
        this.webServer.setConnectors(new Connector[]{connector});
        this.webServer.setStopAtShutdown(true);
        final boolean allow_symlinks = this.configuration.getBoolean("allow-symlinks", false);
        this.router = new HandlerRouter(){
            {
                this.addHandler("/", new FileResourceHandler(){
                    {
                        this.setAliases(allow_symlinks);
                        this.setWelcomeFiles(new String[]{"index.html"});
                        this.setDirectoriesListed(true);
                        this.setBaseResource(DynmapCore.this.createFileResource(DynmapCore.this.getFile(DynmapCore.this.getWebPath()).getAbsolutePath()));
                    }
                });
                this.addHandler("/tiles/*", new MapStorageResourceHandler(){
                    {
                        this.setCore(DynmapCore.this);
                    }
                });
            }
        };
        if (allow_symlinks) {
            org.dynmap.Log.verboseinfo("Web server is permitting symbolic links");
        } else {
            org.dynmap.Log.verboseinfo("Web server is not permitting symbolic links");
        }
        LinkedList<Filter> filters = new LinkedList<Filter>();
        boolean checkbannedips = this.configuration.getBoolean("check-banned-ips", true);
        if (checkbannedips) {
            filters.add(new BanIPFilter(this));
        }
        filters.add(new CustomHeaderFilter(this.configuration.getNode("http-response-headers")));
        FilterHandler fh = new FilterHandler(this.router, filters);
        HandlerList hlist = new HandlerList();
        hlist.setHandlers(new Handler[]{new SessionHandler(), fh});
        this.webServer.setHandler(hlist);
        this.addServlet("/up/configuration", new ClientConfigurationServlet(this));
        this.addServlet("/standalone/config.js", new ConfigJSServlet(this));
        if (this.authmgr != null) {
            LoginServlet login = new LoginServlet(this);
            this.addServlet("/up/login", login);
            this.addServlet("/up/register", login);
        }
    }

    public boolean isLoginSupportEnabled() {
        return this.authmgr != null;
    }

    public boolean isLoginRequired() {
        return this.loginRequired;
    }

    public boolean isCTMSupportEnabled() {
        return this.ctmsupport;
    }

    public boolean isCustomColorsSupportEnabled() {
        return this.customcolorssupport;
    }

    public Set<String> getIPBans() {
        return this.getServer().getIPBans();
    }

    public void addServlet(String path, HttpServlet servlet) {
        new ServletHolder(servlet);
        this.router.addServlet(path, servlet);
    }

    public void startWebserver() {
        try {
            if (this.webServer != null) {
                this.webServer.start();
                org.dynmap.Log.info("Web server started on address " + this.webhostname + ":" + this.webport);
            }
        }
        catch (Exception e) {
            org.dynmap.Log.severe("Failed to start WebServer on address " + this.webhostname + ":" + this.webport + " : " + e.getMessage());
        }
    }

    public void disableCore() {
        if (this.persist_ids_by_ip) {
            this.saveIDsByIP();
        }
        if (this.webServer != null) {
            try {
                this.webServer.stop();
                for (int i = 0; i < 100; ++i) {
                    if (!this.webServer.isStopping()) continue;
                    Thread.sleep(100L);
                }
                if (this.webServer.isStopping()) {
                    org.dynmap.Log.warning("Graceful shutdown timed out - continuing to terminate");
                }
            }
            catch (Exception e) {
                org.dynmap.Log.severe("Failed to stop WebServer!", e);
            }
            this.webServer = null;
        }
        if (this.componentManager != null) {
            int componentCount = this.componentManager.components.size();
            for (Component component : this.componentManager.components) {
                component.dispose();
            }
            this.componentManager.clear();
            org.dynmap.Log.info("Unloaded " + componentCount + " components.");
        }
        if (this.mapManager != null) {
            this.mapManager.stopRendering();
            this.mapManager = null;
        }
        this.playerfacemgr = null;
        this.listenerManager.cleanup();
        this.authmgr = null;
        Debug.clearDebuggers();
    }

    private static File combinePaths(File parent, String path) {
        return DynmapCore.combinePaths(parent, new File(path));
    }

    private static File combinePaths(File parent, File path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new File(parent, path.getPath());
    }

    public File getFile(String path) {
        return DynmapCore.combinePaths(this.getDataFolder(), path);
    }

    protected void loadDebuggers() {
        List<ConfigurationNode> debuggersConfiguration = this.configuration.getNodes("debuggers");
        Debug.clearDebuggers();
        for (ConfigurationNode debuggerConfiguration : debuggersConfiguration) {
            try {
                Class<?> debuggerClass = Class.forName(debuggerConfiguration.getString("class"));
                Constructor<?> constructor = debuggerClass.getConstructor(DynmapCore.class, ConfigurationNode.class);
                Debugger debugger = (Debugger)constructor.newInstance(this, debuggerConfiguration);
                Debug.addDebugger(debugger);
            }
            catch (Exception e) {
                org.dynmap.Log.severe("Error loading debugger: " + e);
                e.printStackTrace();
            }
        }
    }

    public static String[] parseArgs(String[] args, DynmapCommandSender snd) {
        ArrayList<String> rslt = new ArrayList<String>();
        String cmdline = "";
        for (int i = 0; i < args.length; ++i) {
            cmdline = cmdline + args[i] + " ";
        }
        boolean inquote = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cmdline.length(); ++i) {
            char c = cmdline.charAt(i);
            if (inquote) {
                if (c == '\"') {
                    inquote = false;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == '\"') {
                inquote = true;
                continue;
            }
            if (c == ' ') {
                rslt.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (inquote) {
            snd.sendMessage("Error: unclosed doublequote");
            return null;
        }
        return rslt.toArray(new String[rslt.size()]);
    }

    public void printCommandHelp(DynmapCommandSender sender, String cmd, String subcmd) {
        boolean matched = false;
        if (subcmd != null && !subcmd.equals("")) {
            for (CommandInfo ci : commandinfo) {
                if (!ci.matches(cmd, subcmd)) continue;
                sender.sendMessage(String.format("/%s %s %s - %s", ci.cmd, ci.subcmd, ci.args, ci.helptext));
                matched = true;
            }
            if (!matched) {
                sender.sendMessage("Invalid subcommand: " + subcmd);
            } else {
                return;
            }
        }
        for (CommandInfo ci : commandinfo) {
            if (!ci.matches(cmd, "")) continue;
            sender.sendMessage(String.format("/%s - %s", ci.cmd, ci.helptext));
        }
        String subcmdlist = " Valid subcommands:";
        TreeSet<String> ts = new TreeSet<String>();
        for (CommandInfo ci : commandinfo) {
            if (!ci.matches(cmd)) continue;
            ts.add(ci.subcmd);
        }
        for (String sc : ts) {
            subcmdlist = subcmdlist + " " + sc;
        }
        sender.sendMessage(subcmdlist);
    }

    public boolean processCommand(DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        if (this.mapManager == null) {
            sender.sendMessage("Dynmap failed to initialize properly: commands not available");
            return true;
        }
        if (cmd.equalsIgnoreCase("dmarker")) {
            if (!MarkerAPIImpl.onCommand(this, sender, cmd, commandLabel, args)) {
                this.printCommandHelp(sender, cmd, args.length > 0 ? args[0] : "");
            }
            return true;
        }
        if (cmd.equalsIgnoreCase("dmap")) {
            if (!this.dmapcmds.processCommand(sender, cmd, commandLabel, args, this)) {
                this.printCommandHelp(sender, cmd, args.length > 0 ? args[0] : "");
            }
            return true;
        }
        if (cmd.equalsIgnoreCase("dynmapexp")) {
            if (!this.dynmapexpcmds.processCommand(sender, cmd, commandLabel, args, this)) {
                this.printCommandHelp(sender, cmd, args.length > 0 ? args[0] : "");
            }
            return true;
        }
        if (!cmd.equalsIgnoreCase("dynmap")) {
            return false;
        }
        DynmapPlayer player = null;
        if (sender instanceof DynmapPlayer) {
            player = (DynmapPlayer)sender;
        }
        if ((args = DynmapCore.parseArgs(args, sender)) == null) {
            this.printCommandHelp(sender, cmd, "");
            return true;
        }
        if (args.length > 0) {
            String c = args[0];
            if (!commands.contains(c)) {
                this.printCommandHelp(sender, cmd, "");
                return true;
            }
            if (c.equals("render") && this.checkPlayerPermission(sender, "render")) {
                if (player != null) {
                    DynmapLocation loc = player.getLocation();
                    if (loc != null) {
                        this.mapManager.touch(loc.world, (int)loc.x, (int)loc.y, (int)loc.z, "render");
                        sender.sendMessage("Tile render queued.");
                    }
                } else {
                    sender.sendMessage("Command can only be issued by player.");
                }
            } else if (c.equals("radiusrender") && this.checkPlayerPermission(sender, "radiusrender")) {
                int radius = 0;
                String mapname = null;
                DynmapLocation loc = null;
                if (args.length == 2 || args.length == 3) {
                    try {
                        radius = Integer.parseInt(args[1]);
                    }
                    catch (NumberFormatException nfe) {
                        sender.sendMessage("Invalid radius: " + args[1]);
                        return true;
                    }
                    if (radius < 0) {
                        radius = 0;
                    }
                    if (args.length > 2) {
                        mapname = args[2];
                    }
                    if (player != null) {
                        loc = player.getLocation();
                    } else {
                        sender.sendMessage("Command require <world> <x> <z> <radius> if issued from console.");
                    }
                } else if (args.length > 3) {
                    DynmapWorld w = this.mapManager.worldsLookup.get(args[1]);
                    if (w == null) {
                        sender.sendMessage("World '" + args[1] + "' not defined/loaded");
                    }
                    int x = 0;
                    int z = 0;
                    try {
                        x = Integer.parseInt(args[2]);
                    }
                    catch (NumberFormatException nfe) {
                        sender.sendMessage("Invalid x coord: " + args[2]);
                        return true;
                    }
                    try {
                        z = Integer.parseInt(args[3]);
                    }
                    catch (NumberFormatException nfe) {
                        sender.sendMessage("Invalid z coord: " + args[3]);
                        return true;
                    }
                    if (args.length > 4) {
                        try {
                            radius = Integer.parseInt(args[4]);
                        }
                        catch (NumberFormatException nfe) {
                            sender.sendMessage("Invalid radius: " + args[4]);
                            return true;
                        }
                    }
                    if (args.length > 5) {
                        mapname = args[5];
                    }
                    if (w != null) {
                        loc = new DynmapLocation(w.getName(), x, 64.0, z);
                    }
                }
                if (loc != null) {
                    this.mapManager.renderWorldRadius(loc, sender, mapname, radius);
                }
            } else if (c.equals("updaterender") && this.checkPlayerPermission(sender, "updaterender")) {
                String mapname = null;
                DynmapLocation loc = null;
                if (args.length <= 3) {
                    if (args.length > 1) {
                        mapname = args[1];
                    }
                    if (player != null) {
                        loc = player.getLocation();
                    } else {
                        sender.sendMessage("Command require <world> <x> <z> <mapname> if issued from console.");
                    }
                } else {
                    DynmapWorld w = this.mapManager.worldsLookup.get(args[1]);
                    if (w == null) {
                        sender.sendMessage("World '" + args[1] + "' not defined/loaded");
                    }
                    int x = 0;
                    int z = 0;
                    try {
                        x = Integer.parseInt(args[2]);
                    }
                    catch (NumberFormatException nfe) {
                        sender.sendMessage("Invalid x coord: " + args[2]);
                        return true;
                    }
                    try {
                        z = Integer.parseInt(args[3]);
                    }
                    catch (NumberFormatException nfe) {
                        sender.sendMessage("Invalid z coord: " + args[3]);
                        return true;
                    }
                    if (args.length > 4) {
                        mapname = args[4];
                    }
                    if (w != null) {
                        loc = new DynmapLocation(w.getName(), x, 64.0, z);
                    }
                }
                if (loc != null) {
                    this.mapManager.renderFullWorld(loc, sender, mapname, true);
                }
            } else if (c.equals("hide")) {
                if (args.length == 1) {
                    if (player != null && this.checkPlayerPermission(sender, "hide.self")) {
                        this.playerList.setVisible(player.getName(), false);
                        sender.sendMessage("You are now hidden on Dynmap.");
                    }
                } else if (this.checkPlayerPermission(sender, "hide.others")) {
                    for (int i = 1; i < args.length; ++i) {
                        this.playerList.setVisible(args[i], false);
                        sender.sendMessage(args[i] + " is now hidden on Dynmap.");
                    }
                }
            } else if (c.equals("show")) {
                if (args.length == 1) {
                    if (player != null && this.checkPlayerPermission(sender, "show.self")) {
                        this.playerList.setVisible(player.getName(), true);
                        sender.sendMessage("You are now visible on Dynmap.");
                    }
                } else if (this.checkPlayerPermission(sender, "show.others")) {
                    for (int i = 1; i < args.length; ++i) {
                        this.playerList.setVisible(args[i], true);
                        sender.sendMessage(args[i] + " is now visible on Dynmap.");
                    }
                }
            } else if (c.equals("fullrender") && this.checkPlayerPermission(sender, "fullrender")) {
                String map = null;
                if (args.length > 1) {
                    for (int i = 1; i < args.length; ++i) {
                        DynmapWorld w;
                        int dot = args[i].indexOf(":");
                        String wname = args[i];
                        if (dot >= 0) {
                            wname = args[i].substring(0, dot);
                            map = args[i].substring(dot + 1);
                        }
                        if ((w = this.mapManager.getWorld(wname)) != null) {
                            DynmapLocation loc = w.center != null ? w.center : w.getSpawnLocation();
                            this.mapManager.renderFullWorld(loc, sender, map, false);
                            continue;
                        }
                        sender.sendMessage("World '" + wname + "' not defined/loaded");
                    }
                } else if (player != null) {
                    DynmapLocation loc = player.getLocation();
                    if (args.length > 1) {
                        map = args[1];
                    }
                    if (loc != null) {
                        this.mapManager.renderFullWorld(loc, sender, map, false);
                    }
                } else {
                    sender.sendMessage("World name is required");
                }
            } else if (c.equals("cancelrender") && this.checkPlayerPermission(sender, "cancelrender")) {
                if (args.length > 1) {
                    for (int i = 1; i < args.length; ++i) {
                        DynmapWorld w = this.mapManager.getWorld(args[i]);
                        if (w != null) {
                            this.mapManager.cancelRender(w.getName(), sender);
                            continue;
                        }
                        sender.sendMessage("World '" + args[i] + "' not defined/loaded");
                    }
                } else if (player != null) {
                    DynmapLocation loc = player.getLocation();
                    if (loc != null) {
                        this.mapManager.cancelRender(loc.world, sender);
                    }
                } else {
                    sender.sendMessage("World name is required");
                }
            } else if (c.equals("purgequeue") && this.checkPlayerPermission(sender, "purgequeue")) {
                if (args.length > 1) {
                    for (int i = 1; i < args.length; ++i) {
                        this.mapManager.purgeQueue(sender, args[i]);
                    }
                } else {
                    this.mapManager.purgeQueue(sender, null);
                }
            } else if (c.equals("purgemap") && this.checkPlayerPermission(sender, "purgemap")) {
                if (args.length > 2) {
                    this.mapManager.purgeMap(sender, args[1], args[2]);
                } else {
                    sender.sendMessage("World name and map name values are required");
                }
            } else if (c.equals("purgeworld") && this.checkPlayerPermission(sender, "purgeworld")) {
                if (args.length > 1) {
                    this.mapManager.purgeWorld(sender, args[1]);
                } else {
                    sender.sendMessage("World name is required");
                }
            } else if (c.equals("reload") && this.checkPlayerPermission(sender, "reload")) {
                sender.sendMessage("Reloading Dynmap...");
                this.getServer().reload();
                sender.sendMessage("Dynmap reloaded");
            } else if (c.equals("stats") && this.checkPlayerPermission(sender, "stats")) {
                if (args.length == 1) {
                    this.mapManager.printStats(sender, null);
                } else {
                    this.mapManager.printStats(sender, args[1]);
                }
            } else if (c.equals("triggerstats") && this.checkPlayerPermission(sender, "stats")) {
                this.mapManager.printTriggerStats(sender);
            } else if (c.equals("pause") && this.checkPlayerPermission(sender, "pause")) {
                if (args.length != 1) {
                    if (args[1].equals("full")) {
                        this.setPauseFullRadiusRenders(true);
                        this.setPauseUpdateRenders(false);
                    } else if (args[1].equals("update")) {
                        this.setPauseFullRadiusRenders(false);
                        this.setPauseUpdateRenders(true);
                    } else if (args[1].equals("all")) {
                        this.setPauseFullRadiusRenders(true);
                        this.setPauseUpdateRenders(true);
                    } else {
                        this.setPauseFullRadiusRenders(false);
                        this.setPauseUpdateRenders(false);
                    }
                }
                if (this.getPauseFullRadiusRenders()) {
                    sender.sendMessage("Full/Radius renders are PAUSED");
                } else if (this.mapManager.getTPSFullRenderPause()) {
                    sender.sendMessage("Full/Radius renders are TPS PAUSED");
                } else {
                    sender.sendMessage("Full/Radius renders are ACTIVE");
                }
                if (this.getPauseUpdateRenders()) {
                    sender.sendMessage("Update renders are PAUSED");
                } else if (this.mapManager.getTPSUpdateRenderPause()) {
                    sender.sendMessage("Update renders are TPS PAUSED");
                } else {
                    sender.sendMessage("Update renders are ACTIVE");
                }
                if (this.mapManager.getTPSZoomOutPause()) {
                    sender.sendMessage("Zoom out processing is TPS PAUSED");
                } else {
                    sender.sendMessage("Zoom out processing is ACTIVE");
                }
            } else if (c.equals("resetstats") && this.checkPlayerPermission(sender, "resetstats")) {
                if (args.length == 1) {
                    this.mapManager.resetStats(sender, null);
                } else {
                    this.mapManager.resetStats(sender, args[1]);
                }
            } else if (c.equals("sendtoweb") && this.checkPlayerPermission(sender, "sendtoweb")) {
                String msg = "";
                for (int i = 1; i < args.length; ++i) {
                    msg = msg + args[i] + " ";
                }
                this.sendBroadcastToWeb("dynmap", msg);
            } else if (c.equals("ids-for-ip") && this.checkPlayerPermission(sender, "ids-for-ip")) {
                if (args.length > 1) {
                    List<String> ids = this.getIDsForIP(args[1]);
                    sender.sendMessage("IDs logged in from address " + args[1] + " (most recent to least):");
                    if (ids != null) {
                        for (String id : ids) {
                            sender.sendMessage("  " + id);
                        }
                    }
                } else {
                    sender.sendMessage("IP address required as parameter");
                }
            } else if (c.equals("ips-for-id") && this.checkPlayerPermission(sender, "ips-for-id")) {
                if (args.length > 1) {
                    sender.sendMessage("IP addresses logged for player " + args[1] + ":");
                    for (String ip : this.ids_by_ip.keySet()) {
                        LinkedList<String> ids = this.ids_by_ip.get(ip);
                        if (ids == null || !ids.contains(args[1])) continue;
                        sender.sendMessage("  " + ip);
                    }
                } else {
                    sender.sendMessage("Player ID required as parameter");
                }
            } else if (c.equals("add-id-for-ip") && this.checkPlayerPermission(sender, "add-id-for-ip") || c.equals("del-id-for-ip") && this.checkPlayerPermission(sender, "del-id-for-ip")) {
                if (args.length > 2) {
                    String ipaddr = "";
                    try {
                        InetAddress ip = InetAddress.getByName(args[2]);
                        ipaddr = ip.getHostAddress();
                    }
                    catch (UnknownHostException uhx) {
                        sender.sendMessage("Invalid address : " + args[2]);
                        return true;
                    }
                    LinkedList<String> ids = this.ids_by_ip.get(ipaddr);
                    if (ids == null) {
                        ids = new LinkedList();
                        this.ids_by_ip.put(ipaddr, ids);
                    }
                    ids.remove(args[1]);
                    if (c.equals("add-id-for-ip")) {
                        ids.addFirst(args[1]);
                        sender.sendMessage("Added player ID '" + args[1] + "' to address '" + ipaddr + "'");
                    } else {
                        sender.sendMessage("Removed player ID '" + args[1] + "' from address '" + ipaddr + "'");
                    }
                    this.saveIDsByIP();
                } else {
                    sender.sendMessage("Needs player ID and IP address");
                }
            } else if (c.equals("webregister") && this.checkPlayerPermission(sender, "webregister")) {
                if (this.authmgr != null) {
                    return this.authmgr.processWebRegisterCommand(this, sender, player, args);
                }
                sender.sendMessage("Login support is not enabled");
            } else if (c.equals("quiet") && this.checkPlayerPermission(sender, "quiet")) {
                this.mapManager.setJobsQuiet(sender);
            } else if (c.equals("help")) {
                this.printCommandHelp(sender, cmd, args.length > 1 ? args[1] : "");
            } else if (c.equals("version")) {
                sender.sendMessage("Dynmap version: core=" + this.getDynmapCoreVersion() + ", plugin=" + this.getDynmapPluginVersion());
            }
            return true;
        }
        this.printCommandHelp(sender, cmd, args.length > 0 ? args[0] : "");
        return true;
    }

    public boolean checkPlayerPermission(DynmapCommandSender sender, String permission) {
        if (!(sender instanceof DynmapPlayer) || sender.isOp()) {
            return true;
        }
        if (!sender.hasPrivilege(permission.toLowerCase())) {
            sender.sendMessage("You don't have permission to use this command!");
            return false;
        }
        return true;
    }

    public boolean checkPermission(String player, String permission) {
        return this.getServer().checkPlayerPermission(player, permission);
    }

    public ConfigurationNode getWorldConfiguration(DynmapWorld world) {
        boolean bl;
        Object templateName;
        String wname = world.getName();
        ConfigurationNode finalConfiguration = new ConfigurationNode();
        finalConfiguration.put("name", (Object)wname);
        finalConfiguration.put("title", (Object)world.getTitle());
        ConfigurationNode worldConfiguration = this.getWorldConfigurationNode(wname);
        ConfigurationNode templateConfiguration = null;
        if (worldConfiguration != null && (templateName = worldConfiguration.getString("template")) != null) {
            templateConfiguration = this.getTemplateConfigurationNode((String)templateName);
        }
        if (templateConfiguration == null) {
            templateConfiguration = this.getDefaultTemplateConfigurationNode(world);
        }
        finalConfiguration.extend(templateConfiguration);
        finalConfiguration.extend(worldConfiguration);
        org.dynmap.Log.verboseinfo("Configuration of world " + world.getName());
        for (Map.Entry entry : finalConfiguration.entrySet()) {
            org.dynmap.Log.verboseinfo((String)entry.getKey() + ": " + entry.getValue());
        }
        List<Map<String, Object>> worlds = this.world_config.getMapList("worlds");
        if (worlds == null) {
            worlds = new ArrayList<Map<String, Object>>();
            this.world_config.put("worlds", (Object)worlds);
        }
        boolean bl2 = false;
        for (int idx = 0; idx < worlds.size(); ++idx) {
            Map<String, Object> m = worlds.get(idx);
            if (!wname.equals(m.get("name"))) continue;
            worlds.set(idx, finalConfiguration);
            bl = true;
            break;
        }
        if (!bl) {
            worlds.add(finalConfiguration);
        }
        return finalConfiguration;
    }

    ConfigurationNode getDefaultTemplateConfigurationNode(DynmapWorld world) {
        String environmentName = world.getEnvironment();
        if (this.deftemplatesuffix.length() > 0) {
            environmentName = environmentName + "-" + this.deftemplatesuffix;
        }
        org.dynmap.Log.verboseinfo("Using environment as template: " + environmentName);
        return this.getTemplateConfigurationNode(environmentName);
    }

    private ConfigurationNode getWorldConfigurationNode(String worldName) {
        worldName = DynmapWorld.normalizeWorldName(worldName);
        for (ConfigurationNode worldNode : this.world_config.getNodes("worlds")) {
            if (!worldName.equals(worldNode.getString("name"))) continue;
            return worldNode;
        }
        return new ConfigurationNode();
    }

    ConfigurationNode getTemplateConfigurationNode(String templateName) {
        ConfigurationNode templatesNode = this.configuration.getNode("templates");
        if (templatesNode != null) {
            return templatesNode.getNode(templateName);
        }
        return null;
    }

    public String getWebPath() {
        return this.configuration.getString("webpath", "web");
    }

    public static void setIgnoreChunkLoads(boolean ignore) {
        ignore_chunk_loads = ignore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createDefaultFileFromResource(String resourcename, File deffile) {
        if (deffile.canRead()) {
            return true;
        }
        Debug.debug(deffile.getPath() + " not found - creating default");
        InputStream in = this.getClass().getResourceAsStream(resourcename);
        if (in == null) {
            org.dynmap.Log.severe("Unable to find default resource - " + resourcename);
            return false;
        }
        FileOutputStream fos = null;
        try {
            int len;
            fos = new FileOutputStream(deffile);
            byte[] buf = new byte[512];
            while ((len = in.read(buf)) > 0) {
                fos.write(buf, 0, len);
            }
        }
        catch (IOException iox) {
            org.dynmap.Log.severe("ERROR creatomg default for " + deffile.getPath());
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public boolean updateVersionUsingDefaultResource(String resourcename, File deffile) {
        InputStream in = this.getClass().getResourceAsStream(resourcename);
        if (in == null) {
            org.dynmap.Log.severe("Unable to find resource - " + resourcename);
            return false;
        }
        if (!deffile.canRead()) {
            return this.createDefaultFileFromResource(resourcename, deffile);
        }
        ConfigurationNode def_fc = new ConfigurationNode(in);
        ConfigurationNode fc = new ConfigurationNode(deffile);
        fc.load();
        if (fc.getString("version", "").equals(def_fc.getString("version", ""))) {
            return true;
        }
        deffile.delete();
        return this.createDefaultFileFromResource(resourcename, deffile);
    }

    public boolean updateUsingDefaultResource(String resourcename, File deffile, String basenode) {
        InputStream in = this.getClass().getResourceAsStream(resourcename);
        if (in == null) {
            org.dynmap.Log.severe("Unable to find resource - " + resourcename);
            return false;
        }
        if (!deffile.canRead()) {
            return this.createDefaultFileFromResource(resourcename, deffile);
        }
        ConfigurationNode def_fc = new ConfigurationNode(in);
        ConfigurationNode fc = new ConfigurationNode(deffile);
        fc.load();
        List<Map<String, Object>> existing = fc.getMapList(basenode);
        HashSet<String> existing_names = new HashSet<String>();
        if (existing != null) {
            for (Map<String, Object> m : existing) {
                Object name = m.get("name");
                if (!(name instanceof String)) continue;
                existing_names.add((String)name);
            }
        }
        boolean did_update = false;
        List<Map<String, Object>> defmaps = def_fc.getMapList(basenode);
        if (defmaps != null) {
            for (Map<String, Object> m : defmaps) {
                Object name = m.get("name");
                if (!(name instanceof String) || existing_names.contains((String)name)) continue;
                existing.add(m);
                did_update = true;
            }
        }
        if (did_update) {
            fc.put(basenode, (Object)existing);
            fc.save(deffile);
            org.dynmap.Log.info("Updated file " + deffile.getPath());
        }
        return true;
    }

    @Override
    public MarkerAPI getMarkerAPI() {
        if (this.markerapi == null) {
            org.dynmap.Log.warning("Marker API has been requested, but is not enabled.  Uncomment or add 'markers' component to configuration.txt.");
        }
        return this.markerapi;
    }

    @Override
    public boolean markerAPIInitialized() {
        return this.markerapi != null;
    }

    @Override
    public boolean sendBroadcastToWeb(String sender, String msg) {
        if (this.mapManager != null) {
            this.mapManager.pushUpdate(new Client.ChatMessage("plugin", sender, "", msg, ""));
            return true;
        }
        return false;
    }

    public void registerMarkerAPI(MarkerAPIImpl api) {
        this.markerapi = api;
    }

    @Override
    public void setPauseFullRadiusRenders(boolean dopause) {
        this.mapManager.setPauseFullRadiusRenders(dopause);
    }

    @Override
    public boolean getPauseFullRadiusRenders() {
        return this.mapManager.getPauseFullRadiusRenders();
    }

    @Override
    public void setPauseUpdateRenders(boolean dopause) {
        this.mapManager.setPauseUpdateRenders(dopause);
    }

    @Override
    public boolean getPauseUpdateRenders() {
        return this.mapManager.getPauseUpdateRenders();
    }

    public List<String> getIDsForIP(InetAddress addr) {
        return this.getIDsForIP(addr.getHostAddress());
    }

    public List<String> getIDsForIP(String ip) {
        LinkedList<String> ids = this.ids_by_ip.get(ip);
        if (ids != null) {
            return new ArrayList<String>(ids);
        }
        return null;
    }

    private void loadIDsByIP() {
        File f = new File(this.getDataFolder(), "ids-by-ip.txt");
        if (!f.exists()) {
            return;
        }
        ConfigurationNode fc = new ConfigurationNode(new File(this.getDataFolder(), "ids-by-ip.txt"));
        try {
            fc.load();
            this.ids_by_ip.clear();
            for (String k : fc.keySet()) {
                List ids = fc.getList(k);
                if (ids == null) continue;
                k = k.replace("_", ".");
                this.ids_by_ip.put(k, new LinkedList(ids));
            }
        }
        catch (Exception iox) {
            org.dynmap.Log.severe("Error loading " + f.getPath() + " - " + iox.getMessage());
        }
    }

    private void saveIDsByIP() {
        File f = new File(this.getDataFolder(), "ids-by-ip.txt");
        ConfigurationNode fc = new ConfigurationNode();
        for (String k : this.ids_by_ip.keySet()) {
            List v = this.ids_by_ip.get(k);
            if (v == null) continue;
            k = k.replace(".", "_");
            fc.put(k, (Object)v);
        }
        try {
            fc.save(f);
        }
        catch (Exception x) {
            org.dynmap.Log.severe("Error saving " + f.getPath() + " - " + x.getMessage());
        }
    }

    @Override
    public void setPlayerVisiblity(String player, boolean is_visible) {
        this.playerList.setVisible(player, is_visible);
    }

    @Override
    public boolean getPlayerVisbility(String player) {
        return this.playerList.isVisiblePlayer(player);
    }

    @Override
    public void assertPlayerInvisibility(String player, boolean is_invisible, String plugin_id) {
        this.playerList.assertInvisiblilty(player, is_invisible, plugin_id);
    }

    @Override
    public void assertPlayerVisibility(String player, boolean is_visible, String plugin_id) {
        this.playerList.assertVisiblilty(player, is_visible, plugin_id);
    }

    @Override
    public void postPlayerMessageToWeb(String playerid, String playerdisplay, String message) {
        if (playerdisplay == null) {
            playerdisplay = playerid;
        }
        if (this.mapManager != null) {
            this.mapManager.pushUpdate(new Client.ChatMessage("player", "", playerdisplay, message, playerid));
        }
    }

    @Override
    public void postPlayerJoinQuitToWeb(String playerid, String playerdisplay, boolean isjoin) {
        if (playerdisplay == null) {
            playerdisplay = playerid;
        }
        if (this.mapManager != null && this.playerList != null && this.playerList.isVisiblePlayer(playerid)) {
            if (isjoin) {
                this.mapManager.pushUpdate(new Client.PlayerJoinMessage(playerdisplay, playerid));
            } else {
                this.mapManager.pushUpdate(new Client.PlayerQuitMessage(playerdisplay, playerid));
            }
        }
    }

    @Override
    public String getDynmapCoreVersion() {
        return this.version;
    }

    public String getDynmapPluginVersion() {
        return this.plugin_ver;
    }

    @Override
    public int triggerRenderOfBlock(String wid, int x, int y, int z) {
        if (this.mapManager != null) {
            this.mapManager.touch(wid, x, y, z, "api");
        }
        return 0;
    }

    @Override
    public int triggerRenderOfVolume(String wid, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
        if (this.mapManager != null) {
            if (minx == maxx && miny == maxy && minz == maxz) {
                this.mapManager.touch(wid, minx, miny, minz, "api");
            } else {
                this.mapManager.touchVolume(wid, minx, miny, minz, maxx, maxy, maxz, "api");
            }
        }
        return 0;
    }

    public boolean isTrigger(String s) {
        return this.enabledTriggers.contains(s);
    }

    public DynmapWorld getWorld(String wid) {
        if (this.mapManager != null) {
            return this.mapManager.getWorld(wid);
        }
        return null;
    }

    public boolean processWorldLoad(DynmapWorld w) {
        boolean activated = true;
        if (this.mapManager.getWorld(w.getName()) == null) {
            this.updateConfigHashcode();
            activated = this.mapManager.activateWorld(w);
        } else {
            this.mapManager.loadWorld(w);
        }
        return activated;
    }

    public boolean processWorldUnload(DynmapWorld w) {
        boolean done = false;
        if (this.mapManager.getWorld(w.getName()) != null) {
            this.mapManager.unloadWorld(w);
            done = true;
        }
        return done;
    }

    public boolean setWorldEnable(String wname, boolean isenab) {
        wname = DynmapWorld.normalizeWorldName(wname);
        List<Map<String, Object>> worlds = this.world_config.getMapList("worlds");
        for (Map<String, Object> m : worlds) {
            String wn = (String)m.get("name");
            if (wn == null || !wn.equals(wname)) continue;
            m.put("enabled", isenab);
            return true;
        }
        if (!isenab) {
            LinkedHashMap<String, Object> newworld = new LinkedHashMap<String, Object>();
            newworld.put("name", wname);
            newworld.put("enabled", isenab);
        }
        return true;
    }

    public boolean setWorldEnableOnVisit(String wname, boolean isenab) {
        wname = DynmapWorld.normalizeWorldName(wname);
        List<Map<String, Object>> worlds = this.world_config.getMapList("worlds");
        for (Map<String, Object> m : worlds) {
            String wn = (String)m.get("name");
            if (wn == null || !wn.equals(wname)) continue;
            m.put("enableonvisit", isenab);
            return true;
        }
        if (!isenab) {
            LinkedHashMap<String, Object> newworld = new LinkedHashMap<String, Object>();
            newworld.put("name", wname);
            newworld.put("enableonvisit", isenab);
        }
        return true;
    }

    public void visitWorld(String wname) {
        wname = DynmapWorld.normalizeWorldName(wname);
        List<Map<String, Object>> worlds = this.world_config.getMapList("worlds");
        for (Map<String, Object> m : worlds) {
            Object enableonvisit;
            String wn = (String)m.get("name");
            if (wn == null || !wn.equals(wname)) continue;
            if (m.get("enabled").equals(false) && (enableonvisit = m.get("enableonvisit")) != null && enableonvisit.equals(true)) {
                boolean wasPausedFull = this.getPauseFullRadiusRenders();
                boolean wasPausedUpdate = this.getPauseUpdateRenders();
                this.setPauseFullRadiusRenders(true);
                this.setPauseUpdateRenders(true);
                this.setWorldEnable(wname, true);
                this.setWorldOrder(wname, 10000);
                this.refreshWorld(wname);
                if (!wasPausedFull) {
                    this.setPauseFullRadiusRenders(false);
                }
                if (!wasPausedUpdate) {
                    this.setPauseUpdateRenders(false);
                }
            }
            return;
        }
    }

    public boolean setWorldZoomOut(String wname, int xzoomout) {
        wname = DynmapWorld.normalizeWorldName(wname);
        List<Map<String, Object>> worlds = this.world_config.getMapList("worlds");
        for (Map<String, Object> m : worlds) {
            String wn = (String)m.get("name");
            if (wn == null || !wn.equals(wname)) continue;
            m.put("extrazoomout", xzoomout);
            return true;
        }
        return false;
    }

    public boolean setWorldTileUpdateDelay(String wname, int tud) {
        wname = DynmapWorld.normalizeWorldName(wname);
        List<Map<String, Object>> worlds = this.world_config.getMapList("worlds");
        for (Map<String, Object> m : worlds) {
            String wn = (String)m.get("name");
            if (wn == null || !wn.equals(wname)) continue;
            if (tud > 0) {
                m.put("tileupdatedelay", tud);
            } else {
                m.remove("tileupdatedelay");
            }
            return true;
        }
        return false;
    }

    public boolean setWorldCenter(String wname, DynmapLocation loc) {
        wname = DynmapWorld.normalizeWorldName(wname);
        List<Map<String, Object>> worlds = this.world_config.getMapList("worlds");
        for (Map<String, Object> m : worlds) {
            String wn = (String)m.get("name");
            if (wn == null || !wn.equals(wname)) continue;
            if (loc != null) {
                LinkedHashMap<String, Double> c = new LinkedHashMap<String, Double>();
                c.put("x", loc.x);
                c.put("y", loc.y);
                c.put("z", loc.z);
                m.put("center", c);
            } else {
                m.remove("center");
            }
            return true;
        }
        return false;
    }

    public boolean setWorldOrder(String wname, int order) {
        wname = DynmapWorld.normalizeWorldName(wname);
        List<Map<String, Object>> worlds = this.world_config.getMapList("worlds");
        ArrayList<Map<String, Object>> newworlds = new ArrayList<Map<String, Object>>(worlds);
        Map<String, Object> w = null;
        for (Map<String, Object> m : worlds) {
            String wn = (String)m.get("name");
            if (wn == null || !wn.equals(wname)) continue;
            w = m;
            newworlds.remove(m);
            break;
        }
        if (w != null) {
            if (order >= newworlds.size()) {
                newworlds.add(w);
            } else {
                newworlds.add(order, w);
            }
            this.world_config.put("worlds", (Object)newworlds);
            return true;
        }
        return false;
    }

    public boolean updateWorldConfig(DynmapWorld w) {
        ConfigurationNode cn = w.saveConfiguration();
        return this.replaceWorldConfig(w.getName(), cn);
    }

    public boolean replaceWorldConfig(String wname, ConfigurationNode cn) {
        wname = DynmapWorld.normalizeWorldName(wname);
        List<Map<String, Object>> worlds = this.world_config.getMapList("worlds");
        if (worlds == null) {
            worlds = new ArrayList<Map<String, Object>>();
            this.world_config.put("worlds", (Object)worlds);
        }
        for (int i = 0; i < worlds.size(); ++i) {
            Map<String, Object> m = worlds.get(i);
            String wn = (String)m.get("name");
            if (wn == null || !wn.equals(wname)) continue;
            worlds.set(i, cn.entries);
            return true;
        }
        return false;
    }

    public boolean saveWorldConfig() {
        boolean rslt = this.world_config.save();
        this.updateConfigHashcode();
        return rslt;
    }

    public boolean refreshWorld(String wname) {
        wname = DynmapWorld.normalizeWorldName(wname);
        this.saveWorldConfig();
        if (this.mapManager != null) {
            this.mapManager.deactivateWorld(wname);
            DynmapWorld w = this.getServer().getWorldByName(wname);
            if (w != null) {
                this.mapManager.activateWorld(w);
            }
        }
        return true;
    }

    private void loadVersion() {
        this.version = "0.3.38";
    }

    public int getSnapShotCacheSize() {
        return this.snapshotcachesize;
    }

    public boolean useSoftRefInSnapShotCache() {
        return this.snapshotsoftref;
    }

    public String getDefImageFormat() {
        return this.def_image_format;
    }

    public void webChat(final String name, final String message) {
        if (this.mapManager == null) {
            return;
        }
        Runnable c = new Runnable(){

            @Override
            public void run() {
                ChatEvent event = new ChatEvent("web", name, message);
                DynmapCore.this.events.trigger("webchat", event);
            }
        };
        this.getServer().scheduleServerTask(c, 1L);
    }

    @Override
    public boolean setDisableChatToWebProcessing(boolean disable) {
        boolean prev = this.disable_chat_to_web;
        this.disable_chat_to_web = disable;
        return prev;
    }

    public boolean getLoginRequired() {
        return this.loginRequired;
    }

    public boolean registerLogin(String uid, String pwd, String passcode) {
        if (this.authmgr != null) {
            return this.authmgr.registerLogin(uid, pwd, passcode);
        }
        return false;
    }

    public boolean checkLogin(String uid, String pwd) {
        if (this.authmgr != null) {
            return this.authmgr.checkLogin(uid, pwd);
        }
        return false;
    }

    String getLoginPHP(boolean wrap) {
        if (this.authmgr != null) {
            return this.authmgr.getLoginPHP(wrap);
        }
        return null;
    }

    String getAccessPHP(boolean wrap) {
        if (this.authmgr != null) {
            return this.authmgr.getAccessPHP(wrap);
        }
        return WebAuthManager.getDisabledAccessPHP(this, wrap);
    }

    boolean pendingRegisters() {
        if (this.authmgr != null) {
            return this.authmgr.pendingRegisters();
        }
        return false;
    }

    boolean processCompletedRegister(String uid, String pc, String hash) {
        if (this.authmgr != null) {
            return this.authmgr.processCompletedRegister(uid, pc, hash);
        }
        return false;
    }

    @Override
    public boolean testIfPlayerVisibleToPlayer(String player, String player_to_see) {
        if ((player = player.toLowerCase()).equals(player_to_see = player_to_see.toLowerCase())) {
            return true;
        }
        if (!this.getPlayerVisbility(player_to_see)) {
            return false;
        }
        if (this.checkPermission(player, "playermarkers.seeall")) {
            return true;
        }
        if (this.markerapi != null) {
            return this.markerapi.testIfPlayerVisible(player, player_to_see);
        }
        return false;
    }

    public Set<String> getPlayersVisibleToPlayer(String player) {
        if (this.markerapi != null) {
            return this.markerapi.getPlayersVisibleToPlayer(player);
        }
        return Collections.singleton(player.toLowerCase());
    }

    @Override
    public boolean testIfPlayerInfoProtected() {
        return this.player_info_protected;
    }

    public int getMaxPlayers() {
        return this.server.getMaxPlayers();
    }

    public int getCurrentPlayers() {
        return this.server.getCurrentPlayers();
    }

    public String getDynmapPluginPlatform() {
        return this.platform;
    }

    public String getDynmapPluginPlatformVersion() {
        return this.platformVersion;
    }

    private static boolean deleteDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.getName().equals(".") || f.getName().equals("..")) continue;
                if (f.isDirectory()) {
                    DynmapCore.deleteDirectory(f);
                    continue;
                }
                if (!f.isFile()) continue;
                f.delete();
            }
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExtractedFiles() {
        if (this.jarfile == null) {
            return;
        }
        File df = this.getDataFolder();
        if (!df.exists()) {
            df.mkdirs();
        }
        File ver = new File(df, "version.txt");
        String prevver = "1.6";
        if (ver.exists()) {
            FileReader ir = null;
            try {
                int c;
                ir = new FileReader(ver);
                prevver = "";
                while ((c = ((Reader)ir).read()) >= 0) {
                    prevver = prevver + (char)c;
                }
            }
            catch (IOException c) {
            }
            finally {
                if (ir != null) {
                    try {
                        ((Reader)ir).close();
                    }
                    catch (IOException c) {}
                }
            }
        } else {
            DynmapCore.deleteDirectory(new File(df, "texturepacks/standard"));
        }
        if (prevver.equals(this.getDynmapCoreVersion()) && !prevver.contains("dirty")) {
            return;
        }
        InputStream in = this.getClass().getResourceAsStream("/deleted.txt");
        if (in != null) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                while ((line = br.readLine()) != null) {
                    if (line.length() == 0 || line.startsWith("#")) continue;
                    File newfile = new File(df, line);
                    newfile.delete();
                }
            }
            catch (IOException iox) {
                org.dynmap.Log.warning("Exception while processing deleted files - " + iox.getMessage());
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iox) {}
            }
        }
        ZipFile zf = null;
        FileOutputStream fos = null;
        InputStream ins = null;
        byte[] buf = new byte[2048];
        String n = null;
        try {
            zf = new ZipFile(this.jarfile);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                n = ze.getName();
                if (!n.startsWith("extracted/")) continue;
                n = n.substring("extracted/".length());
                File f = new File(df, n);
                if (ze.isDirectory()) {
                    f.mkdirs();
                    continue;
                }
                f.getParentFile().mkdirs();
                fos = new FileOutputStream(f);
                ins = zf.getInputStream(ze);
                if (n.endsWith(".html") || n.endsWith(".js") || n.endsWith(".php") || n.endsWith(".txt")) {
                    String data = IOUtils.toString((InputStream)ins);
                    data = data.replace(TAG_TO_REPLACE_ON_EXTRACT, "0.3.38");
                    IOUtils.write((String)data, (OutputStream)fos);
                } else {
                    int len;
                    while ((len = ins.read(buf)) >= 0) {
                        fos.write(buf, 0, len);
                    }
                }
                ins.close();
                ins = null;
                fos.close();
                fos = null;
            }
        }
        catch (IOException iox) {
            org.dynmap.Log.severe("Error extracting file - " + n);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException iox) {}
                ins = null;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iox) {}
                fos = null;
            }
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (IOException iox) {}
                zf = null;
            }
        }
        FileWriter out = null;
        try {
            out = new FileWriter(ver);
            out.write(this.getDynmapCoreVersion());
        }
        catch (IOException iOException) {
        }
        finally {
            if (out != null) {
                try {
                    ((Writer)out).close();
                }
                catch (IOException iOException) {}
            }
        }
        org.dynmap.Log.info("Extracted files upgraded");
    }

    public void serverTick(double tps) {
        if (this.mapManager != null) {
            this.mapManager.updateTPS(tps);
        }
    }

    public int getMaxTickUseMS() {
        return this.perTickLimit;
    }

    public boolean dumpMissingBlocks() {
        return this.dumpMissing;
    }

    public void serverStarted() {
        this.events.trigger("server-started", null);
    }

    public String getNormalizedModID(String mod) {
        int idx = mod.indexOf(124);
        if (idx > 0) {
            mod = mod.substring(0, idx);
        }
        return mod;
    }

    public void addModBlockItemIDs(String mod, Map<String, Integer> modvals) {
        int id;
        String[] ks;
        mod = this.getNormalizedModID(mod);
        for (String k : this.blockmap.keySet()) {
            ks = k.split(":", 2);
            if (ks.length != 2) continue;
            id = this.blockmap.get(k);
            ks[0] = this.getNormalizedModID(ks[0]);
            if (!mod.equals(ks[0])) continue;
            modvals.put("%" + ks[1], id);
        }
        for (String k : this.itemmap.keySet()) {
            ks = k.split(":", 2);
            if (ks.length != 2) continue;
            id = this.itemmap.get(k);
            ks[0] = this.getNormalizedModID(ks[0]);
            if (!mod.equals(ks[0])) continue;
            modvals.put("&" + ks[1], id);
        }
    }

    @Override
    public void processSignChange(int blkid, String world, int x, int y, int z, String[] lines, String playerid) {
        DynmapPlayer dp = this.server.getPlayer(playerid);
        this.listenerManager.processSignChangeEvent(DynmapListenerManager.EventType.SIGN_CHANGE, blkid, world, x, y, z, lines, dp);
    }

    public MapStorage getDefaultMapStorage() {
        return this.defaultStorage;
    }

    private static class CommandInfo {
        final String cmd;
        final String subcmd;
        final String args;
        final String helptext;

        public CommandInfo(String cmd, String subcmd, String helptxt) {
            this.cmd = cmd;
            this.subcmd = subcmd;
            this.helptext = helptxt;
            this.args = "";
        }

        public CommandInfo(String cmd, String subcmd, String args, String helptxt) {
            this.cmd = cmd;
            this.subcmd = subcmd;
            this.args = args;
            this.helptext = helptxt;
        }

        public boolean matches(String c, String sc) {
            return this.cmd.equals(c) && this.subcmd.equals(sc);
        }

        public boolean matches(String c) {
            return this.cmd.equals(c);
        }
    }

    public static enum CompassMode {
        PRE19,
        NEWROSE,
        NEWNORTH;

    }

    public static abstract class EnableCoreCallbacks {
        public abstract void configurationLoaded();
    }
}

