/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import ganymedes01.etfuturum.EtFuturumLootTables;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.ModEnchantments;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.api.BeePlantRegistry;
import ganymedes01.etfuturum.api.BrewingFuelRegistry;
import ganymedes01.etfuturum.api.CompostingRegistry;
import ganymedes01.etfuturum.api.DeepslateOreRegistry;
import ganymedes01.etfuturum.api.HoeRegistry;
import ganymedes01.etfuturum.api.MultiBlockSoundRegistry;
import ganymedes01.etfuturum.api.PistonBehaviorRegistry;
import ganymedes01.etfuturum.api.RawOreRegistry;
import ganymedes01.etfuturum.api.StrippedLogRegistry;
import ganymedes01.etfuturum.api.mappings.BasicMultiBlockSound;
import ganymedes01.etfuturum.blocks.BlockSculk;
import ganymedes01.etfuturum.blocks.BlockSculkCatalyst;
import ganymedes01.etfuturum.client.BuiltInResourcePack;
import ganymedes01.etfuturum.client.DynamicSoundsResourcePack;
import ganymedes01.etfuturum.client.GrayscaleWaterResourcePack;
import ganymedes01.etfuturum.client.sound.ModSounds;
import ganymedes01.etfuturum.command.CommandFill;
import ganymedes01.etfuturum.compat.CompatBaublesExpanded;
import ganymedes01.etfuturum.compat.CompatMisc;
import ganymedes01.etfuturum.compat.CompatRPLEEventHandler;
import ganymedes01.etfuturum.compat.CompatTinkersConstruct;
import ganymedes01.etfuturum.compat.CompatWaila;
import ganymedes01.etfuturum.compat.ExternalContent;
import ganymedes01.etfuturum.compat.ModsList;
import ganymedes01.etfuturum.configuration.ConfigBase;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigExperiments;
import ganymedes01.etfuturum.configuration.configs.ConfigFunctions;
import ganymedes01.etfuturum.configuration.configs.ConfigModCompat;
import ganymedes01.etfuturum.configuration.configs.ConfigSounds;
import ganymedes01.etfuturum.core.handlers.WorldEventHandler;
import ganymedes01.etfuturum.core.proxy.CommonProxy;
import ganymedes01.etfuturum.core.utils.IInitAction;
import ganymedes01.etfuturum.core.utils.Logger;
import ganymedes01.etfuturum.entities.ModEntityList;
import ganymedes01.etfuturum.items.ItemWoodSign;
import ganymedes01.etfuturum.lib.Reference;
import ganymedes01.etfuturum.network.ArmourStandInteractHandler;
import ganymedes01.etfuturum.network.ArmourStandInteractMessage;
import ganymedes01.etfuturum.network.AttackYawHandler;
import ganymedes01.etfuturum.network.AttackYawMessage;
import ganymedes01.etfuturum.network.BlackHeartParticlesHandler;
import ganymedes01.etfuturum.network.BlackHeartParticlesMessage;
import ganymedes01.etfuturum.network.BoatMoveHandler;
import ganymedes01.etfuturum.network.BoatMoveMessage;
import ganymedes01.etfuturum.network.ChestBoatOpenInventoryHandler;
import ganymedes01.etfuturum.network.ChestBoatOpenInventoryMessage;
import ganymedes01.etfuturum.network.StartElytraFlyingHandler;
import ganymedes01.etfuturum.network.StartElytraFlyingMessage;
import ganymedes01.etfuturum.network.WoodSignOpenHandler;
import ganymedes01.etfuturum.network.WoodSignOpenMessage;
import ganymedes01.etfuturum.potion.ModPotions;
import ganymedes01.etfuturum.recipes.ModRecipes;
import ganymedes01.etfuturum.recipes.SmithingTableRecipes;
import ganymedes01.etfuturum.spectator.SpectatorMode;
import ganymedes01.etfuturum.world.EtFuturumLateWorldGenerator;
import ganymedes01.etfuturum.world.EtFuturumWorldGenerator;
import ganymedes01.etfuturum.world.end.dimension.DimensionProviderEFREnd;
import ganymedes01.etfuturum.world.nether.biome.utils.NetherBiomeManager;
import ganymedes01.etfuturum.world.nether.dimension.DimensionProviderEFRNether;
import ganymedes01.etfuturum.world.structure.OceanMonument;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import makamys.mclib.core.MCLib;
import makamys.mclib.core.MCLibModules;
import makamys.mclib.ext.assetdirector.ADConfig;
import makamys.mclib.ext.assetdirector.AssetDirectorAPI;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockHay;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

@Mod(modid="etfuturum", name="Et Futurum Requiem", version="2.6.2.16-GTNH-pre", dependencies="required-after:Forge@[10.13.4.1614,);after:Thaumcraft@[4.2.3.5,);after:TwilightForest;after:HardcoreEnderExpansion;after:bluepower;after:MineTweaker3;after:TConstruct;")
public class EtFuturum {
    @Mod.Instance(value="etfuturum")
    public static EtFuturum instance;
    @SidedProxy(clientSide="ganymedes01.etfuturum.core.proxy.ClientProxy", serverSide="ganymedes01.etfuturum.core.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static SimpleNetworkWrapper networkWrapper;
    public static CreativeTabs creativeTabItems;
    public static CreativeTabs creativeTabBlocks;
    static final String NETHER_FORTRESS = "netherFortress";
    private Field fortressWeightedField;

    @Mod.EventHandler
    public void onConstruction(FMLConstructionEvent event) {
        if (Reference.SNAPSHOT_BUILD && !Reference.DEV_ENVIRONMENT) {
            Logger.info("etfuturum is in snapshot mode. Disabling update checker... Other features may also be different.");
        }
        MCLib.init();
        ADConfig config = new ADConfig();
        EtFuturum.getSounds(config);
        AssetDirectorAPI.register(config);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        try {
            Field chestInfo = ChestGenHooks.class.getDeclaredField("chestInfo");
            chestInfo.setAccessible(true);
            if (!((HashMap)chestInfo.get(null)).containsKey(NETHER_FORTRESS)) {
                this.fortressWeightedField = Class.forName("net.minecraft.world.gen.structure.StructureNetherBridgePieces$Piece").getDeclaredField("field_111019_a");
                this.fortressWeightedField.setAccessible(true);
                ((HashMap)chestInfo.get(null)).put(NETHER_FORTRESS, new ChestGenHooks(NETHER_FORTRESS, (WeightedRandomChestContent[])this.fortressWeightedField.get(null), 2, 5));
            }
        }
        catch (Exception e) {
            System.out.println("Failed to get Nether fortress loot table:");
            e.printStackTrace();
        }
        for (ModBlocks modBlocks : ModBlocks.values()) {
            if (!modBlocks.isEnabled() || !(modBlocks.get() instanceof IInitAction)) continue;
            ((IInitAction)modBlocks.get()).preInitAction();
        }
        for (Enum enum_ : ModItems.values()) {
            if (!((ModItems)enum_).isEnabled() || !(((ModItems)enum_).get() instanceof IInitAction)) continue;
            ((IInitAction)((ModItems)enum_).get()).preInitAction();
        }
        ModBlocks.init();
        ModItems.init();
        ModEnchantments.init();
        ModPotions.init();
        SpectatorMode.init();
        if (event.getSide() == Side.CLIENT) {
            if (ConfigFunctions.enableNewTextures || ConfigFunctions.enableLangReplacements) {
                BuiltInResourcePack.register("vanilla_overrides");
            }
            GrayscaleWaterResourcePack.inject();
            DynamicSoundsResourcePack.inject();
        }
        if (ConfigExperiments.netherDimensionProvider) {
            NetherBiomeManager.init();
        }
        GameRegistry.registerWorldGenerator((IWorldGenerator)EtFuturumWorldGenerator.INSTANCE, (int)0);
        GameRegistry.registerWorldGenerator((IWorldGenerator)EtFuturumLateWorldGenerator.INSTANCE, (int)Integer.MAX_VALUE);
        OceanMonument.makeMap();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("etfuturum");
        networkWrapper.registerMessage(ArmourStandInteractHandler.class, ArmourStandInteractMessage.class, 0, Side.SERVER);
        networkWrapper.registerMessage(BlackHeartParticlesHandler.class, BlackHeartParticlesMessage.class, 1, Side.CLIENT);
        networkWrapper.registerMessage(WoodSignOpenHandler.class, WoodSignOpenMessage.class, 3, Side.CLIENT);
        networkWrapper.registerMessage(BoatMoveHandler.class, BoatMoveMessage.class, 4, Side.SERVER);
        networkWrapper.registerMessage(ChestBoatOpenInventoryHandler.class, ChestBoatOpenInventoryMessage.class, 5, Side.SERVER);
        networkWrapper.registerMessage(StartElytraFlyingHandler.class, StartElytraFlyingMessage.class, 6, Side.SERVER);
        networkWrapper.registerMessage(AttackYawHandler.class, AttackYawMessage.class, 7, Side.CLIENT);
        if (!Reference.SNAPSHOT_BUILD && !Reference.DEV_ENVIRONMENT) {
            MCLibModules.updateCheckAPI.submitModTask("etfuturum", "2.6.2.16-GTNH-pre", Reference.VERSION_URL);
        }
        CompatMisc.runModHooksPreInit();
        if (ModsList.RPLE.isLoaded()) {
            CompatRPLEEventHandler.registerRPLECompat();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        for (ModBlocks modBlocks : ModBlocks.values()) {
            if (!modBlocks.isEnabled() || !(modBlocks.get() instanceof IInitAction)) continue;
            ((IInitAction)modBlocks.get()).initAction();
        }
        for (Enum enum_ : ModItems.values()) {
            if (!((ModItems)enum_).isEnabled() || !(((ModItems)enum_).get() instanceof IInitAction)) continue;
            ((IInitAction)((ModItems)enum_).get()).initAction();
        }
        if (ModsList.WAILA.isLoaded()) {
            CompatWaila.register();
        }
        proxy.registerEvents();
        proxy.registerEntities();
        proxy.registerRenderers();
        CompatMisc.runModHooksInit();
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (!message.key.equals("register-brewing-fuel")) continue;
            NBTTagCompound nbt = message.getNBTValue();
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Fuel"));
            int brews = nbt.func_74762_e("Brews");
            BrewingFuelRegistry.registerFuel(stack, brews);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (ConfigFunctions.enableUpdatedFoodValues) {
            ((ItemFood)Items.field_151172_bF).field_77853_b = 3;
            ((ItemFood)Items.field_151168_bH).field_77853_b = 5;
        }
        if (ConfigFunctions.enableUpdatedHarvestLevels) {
            Blocks.field_150403_cj.setHarvestLevel("pickaxe", 0);
            Blocks.field_150468_ap.setHarvestLevel("axe", 0);
            Blocks.field_150440_ba.setHarvestLevel("axe", 0);
        }
        if (ConfigFunctions.enableFloatingTrapDoors) {
            BlockTrapDoor.disableValidation = true;
        }
        CompatMisc.runModHooksPostInit();
        Items.field_151072_bj.func_77664_n();
        Blocks.field_150447_bR.func_149647_a(CreativeTabs.field_78028_d);
        if (ConfigBlocksItems.enableOtherside) {
            ChestGenHooks.addItem((String)"strongholdCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(ModItems.OTHERSIDE_RECORD.get(), 0, 1, 1, 1));
            ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(ModItems.OTHERSIDE_RECORD.get(), 0, 1, 1, 1));
        }
        if (ConfigBlocksItems.enablePigstep) {
            ChestGenHooks.addItem((String)NETHER_FORTRESS, (WeightedRandomChestContent)new WeightedRandomChestContent(ModItems.PIGSTEP_RECORD.get(), 0, 1, 1, 5));
            if (this.fortressWeightedField != null) {
                try {
                    Field contents = ChestGenHooks.class.getDeclaredField("contents");
                    contents.setAccessible(true);
                    ArrayList fortressContentList = (ArrayList)contents.get(ChestGenHooks.getInfo((String)NETHER_FORTRESS));
                    if (!fortressContentList.isEmpty()) {
                        void var5_9;
                        WeightedRandomChestContent[] fortressChest = new WeightedRandomChestContent[fortressContentList.size()];
                        boolean bl = false;
                        while (var5_9 < fortressContentList.size()) {
                            fortressChest[var5_9] = (WeightedRandomChestContent)fortressContentList.get((int)var5_9);
                            ++var5_9;
                        }
                        this.fortressWeightedField.set(null, fortressChest);
                    }
                }
                catch (Exception e) {
                    System.out.println("Failed to fill Nether fortress loot table:");
                    e.printStackTrace();
                }
            }
        }
        for (ModBlocks modBlocks : ModBlocks.values()) {
            if (!modBlocks.isEnabled() || !(modBlocks.get() instanceof IInitAction)) continue;
            ((IInitAction)modBlocks.get()).postInitAction();
        }
        for (Enum enum_ : ModItems.values()) {
            if (!((ModItems)enum_).isEnabled() || !(((ModItems)enum_).get() instanceof IInitAction)) continue;
            ((IInitAction)((ModItems)enum_).get()).postInitAction();
        }
        if (ConfigModCompat.elytraBaublesExpandedCompat > 0 && ModsList.BAUBLES_EXPANDED.isLoaded()) {
            CompatBaublesExpanded.postInit();
        }
        EtFuturumLootTables.init();
        ModRecipes.init();
        DeepslateOreRegistry.init();
        StrippedLogRegistry.init();
        RawOreRegistry.init();
        SmithingTableRecipes.init();
        CompostingRegistry.init();
        BeePlantRegistry.init();
        PistonBehaviorRegistry.init();
        if (ModsList.TINKERS_CONSTRUCT.isLoaded()) {
            CompatTinkersConstruct.postInit();
        }
    }

    @Mod.EventHandler
    public void onLoadComplete(FMLLoadCompleteEvent e) {
        Block block;
        for (ModBlocks modBlocks : ModBlocks.values()) {
            if (!modBlocks.isEnabled() || !(modBlocks.get() instanceof IInitAction)) continue;
            ((IInitAction)modBlocks.get()).onLoadAction();
        }
        for (Enum enum_ : ModItems.values()) {
            if (!((ModItems)enum_).isEnabled() || !(((ModItems)enum_).get() instanceof IInitAction)) continue;
            ((IInitAction)((ModItems)enum_).get()).onLoadAction();
        }
        ConfigBase.postInit();
        EtFuturumWorldGenerator.INSTANCE.postInit();
        WorldEventHandler.INSTANCE.postInit();
        if (ConfigSounds.newBlockSounds) {
            Blocks.field_150421_aI.func_149672_a(Block.field_149766_f);
            Blocks.field_150323_B.func_149672_a(Block.field_149766_f);
            Blocks.field_150443_bT.func_149672_a(Block.field_149777_j);
            Blocks.field_150445_bS.func_149672_a(Block.field_149777_j);
            Blocks.field_150479_bC.func_149672_a(Block.field_149766_f);
            Blocks.field_150442_at.func_149672_a(Block.field_149769_e);
            Blocks.field_150416_aS.func_149672_a(Block.field_149769_e);
            Blocks.field_150413_aR.func_149672_a(Block.field_149769_e);
            Blocks.field_150455_bV.func_149672_a(Block.field_149769_e);
            Blocks.field_150441_bU.func_149672_a(Block.field_149769_e);
            Blocks.field_150360_v.func_149672_a(ModSounds.soundSponge);
        }
        if (ConfigSounds.paintingItemFramePlacing && (block = GameRegistry.findBlock((String)"torchLevers", (String)"paintingDoor")) != null) {
            block.field_149762_H = ModSounds.soundPainting;
        }
        if (ConfigBlocksItems.enableDyedBeds) {
            Blocks.field_150324_C.field_149764_J = Material.field_151575_d;
            Blocks.field_150324_C.func_149672_a(Block.field_149766_f);
        }
        for (Block block3 : Block.field_149771_c) {
            if (ConfigFunctions.enableHoeMining) {
                if (block3 instanceof BlockLeaves || block3 instanceof BlockHay || block3 instanceof BlockSponge || block3 instanceof BlockNetherWart || block3 instanceof BlockSculk || block3 instanceof BlockSculkCatalyst) {
                    HoeRegistry.addToHoeArray(block3);
                }
                HoeRegistry.addToHoeArray(ModBlocks.SHROOMLIGHT.get());
                HoeRegistry.addToHoeArray(ModBlocks.SPONGE.get());
            }
            if (!ConfigSounds.newBlockSounds) continue;
            String blockID = Block.field_149771_c.func_148750_c((Object)block3).split(":")[1].toLowerCase();
            Block.SoundType soundType = this.getCustomStepSound(block3, blockID);
            if (soundType != null) {
                block3.func_149672_a(soundType);
            }
            this.setupMultiBlockSoundRegistry();
        }
        CompatMisc.runModHooksLoadComplete();
        if (ConfigExperiments.netherDimensionProvider && !ModsList.NETHERLICIOUS.isLoaded()) {
            DimensionProviderEFRNether.init();
        }
        if (ConfigExperiments.endDimensionProvider) {
            DimensionProviderEFREnd.init();
        }
    }

    private void setupMultiBlockSoundRegistry() {
        MultiBlockSoundRegistry.addBasic((Block)Blocks.field_150333_U, ModSounds.soundNetherBricks, 6, 14);
        MultiBlockSoundRegistry.addBasic((Block)Blocks.field_150334_T, ModSounds.soundNetherBricks, 6, 14);
        MultiBlockSoundRegistry.addBasic(ExternalContent.Blocks.TCON_MULTIBRICK.get(), ModSounds.soundNetherrack, 2);
        MultiBlockSoundRegistry.addBasic(ExternalContent.Blocks.TCON_MULTIBRICK.get(), ModSounds.soundBoneBlock, 9);
        MultiBlockSoundRegistry.addBasic(ExternalContent.Blocks.TCON_MULTIBRICK_FANCY.get(), ModSounds.soundNetherrack, 2);
        MultiBlockSoundRegistry.addBasic(ExternalContent.Blocks.TCON_MULTIBRICK_FANCY.get(), ModSounds.soundBoneBlock, 9);
        MultiBlockSoundRegistry.addBasic(ModBlocks.DEEPSLATE_BRICK_WALL.get(), ModSounds.soundDeepslateTiles, 1);
        MultiBlockSoundRegistry.addBasic(ModBlocks.DEEPSLATE_BRICKS.get(), ModSounds.soundDeepslateTiles, 2, 3);
        MultiBlockSoundRegistry.addBasic(ModBlocks.DEEPSLATE_BRICK_SLAB.get(), ModSounds.soundDeepslateTiles, 1, 9);
        MultiBlockSoundRegistry.addBasic(ModBlocks.TUFF.get(), ModSounds.soundPolishedTuff, 1);
        MultiBlockSoundRegistry.addBasic(ModBlocks.TUFF.get(), ModSounds.soundTuffBricks, 2, 4);
        MultiBlockSoundRegistry.addBasic(ModBlocks.TUFF_WALL.get(), ModSounds.soundPolishedTuff, 1);
        MultiBlockSoundRegistry.addBasic(ModBlocks.TUFF_WALL.get(), ModSounds.soundTuffBricks, 2);
        MultiBlockSoundRegistry.addBasic(ModBlocks.TUFF_SLAB.get(), ModSounds.soundPolishedTuff, 1, 9);
        MultiBlockSoundRegistry.addBasic(ModBlocks.TUFF_SLAB.get(), ModSounds.soundTuffBricks, 2, 10);
        MultiBlockSoundRegistry.addBasic(ModBlocks.DOUBLE_TUFF_SLAB.get(), ModSounds.soundPolishedTuff, 1, 9);
        MultiBlockSoundRegistry.addBasic(ModBlocks.DOUBLE_TUFF_SLAB.get(), ModSounds.soundTuffBricks, 2, 10);
        MultiBlockSoundRegistry.addBasic(ModBlocks.AMETHYST_CLUSTER_1.get(), ModSounds.soundAmethystBudSmall, 0, 1, 2, 3, 4, 5, 6);
        MultiBlockSoundRegistry.addBasic(ModBlocks.AMETHYST_CLUSTER_2.get(), ModSounds.soundAmethystBudLrg, 0, 1, 2, 3, 4, 5, 6);
        MultiBlockSoundRegistry.addBasic(ModBlocks.SPONGE.get(), ModSounds.soundWetSponge, 1);
        MultiBlockSoundRegistry.addBasic(Blocks.field_150360_v, ModSounds.soundWetSponge, 1);
        MultiBlockSoundRegistry.addBasic(ModBlocks.SAPLING.get(), ModSounds.soundCherrySapling, 1, 9);
        MultiBlockSoundRegistry.addBasic(ModBlocks.LEAVES.get(), ModSounds.soundCherryLeaves, 1, 5, 9, 13);
        MultiBlockSoundRegistry.addBasic(ModBlocks.WOOD_PLANKS.get(), ModSounds.soundNetherWood, 0, 1);
        MultiBlockSoundRegistry.addBasic(ModBlocks.WOOD_PLANKS.get(), ModSounds.soundCherryWood, 3);
        MultiBlockSoundRegistry.addBasic(ModBlocks.WOOD_PLANKS.get(), ModSounds.soundBambooWood, 4);
        MultiBlockSoundRegistry.addBasic(ModBlocks.WOOD_FENCE.get(), ModSounds.soundNetherWood, 0, 1);
        MultiBlockSoundRegistry.addBasic(ModBlocks.WOOD_FENCE.get(), ModSounds.soundCherryWood, 3);
        MultiBlockSoundRegistry.addBasic(ModBlocks.WOOD_FENCE.get(), ModSounds.soundBambooWood, 4);
        MultiBlockSoundRegistry.addBasic(ModBlocks.WOOD_SLAB.get(), ModSounds.soundNetherWood, 0, 1, 8, 9);
        MultiBlockSoundRegistry.addBasic(ModBlocks.WOOD_SLAB.get(), ModSounds.soundCherryWood, 3, 11);
        MultiBlockSoundRegistry.addBasic(ModBlocks.WOOD_SLAB.get(), ModSounds.soundBambooWood, 4, 12);
        MultiBlockSoundRegistry.addBasic(ModBlocks.DOUBLE_WOOD_SLAB.get(), ModSounds.soundNetherWood, 0, 1, 8, 9);
        MultiBlockSoundRegistry.addBasic(ModBlocks.DOUBLE_WOOD_SLAB.get(), ModSounds.soundCherryWood, 3, 11);
        MultiBlockSoundRegistry.addBasic(ModBlocks.DOUBLE_WOOD_SLAB.get(), ModSounds.soundBambooWood, 4, 12);
        MultiBlockSoundRegistry.addBasic(ModBlocks.PACKED_MUD.get(), ModSounds.soundMudBricks, 1);
        if (ModsList.IRON_CHEST.isLoaded() && ModsList.IRON_CHEST.isVersionNewerOrEqual("6.0.78")) {
            MultiBlockSoundRegistry.addBasic(ExternalContent.Blocks.IRON_CHEST.get(), ModSounds.soundNetherite, 8);
        }
        if (ExternalContent.Blocks.TCON_METAL.get() != null) {
            BasicMultiBlockSound mbs = new BasicMultiBlockSound(){

                @Override
                public float getPitch(World world, int x, int y, int z, float pitch, MultiBlockSoundRegistry.BlockSoundType type) {
                    if (type != MultiBlockSoundRegistry.BlockSoundType.WALK) {
                        return pitch * 0.67f;
                    }
                    return 1.0f;
                }
            };
            mbs.setTypes(ModSounds.soundCopper, 3);
            mbs.setTypes(ModSounds.soundCopper, 5);
            MultiBlockSoundRegistry.multiBlockSounds.put(ExternalContent.Blocks.TCON_METAL.get(), mbs);
        }
    }

    @Mod.EventHandler
    public void onMissingMapping(FMLMissingMappingsEvent e) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : e.getAll()) {
            if (!mapping.name.startsWith("etfuturum") || Block.func_149729_e((int)mapping.id) == null || mapping.type != GameRegistry.Type.ITEM) continue;
            mapping.ignore();
            ReflectionHelper.setPrivateValue(FMLMissingMappingsEvent.MissingMapping.class, (Object)mapping, (Object)FMLMissingMappingsEvent.Action.BLOCKONLY, (String[])new String[]{"action"});
        }
    }

    public Block.SoundType getCustomStepSound(Block block, String namespace) {
        if (block.field_149762_H == Block.field_149780_i || block.field_149762_H == Block.field_149769_e) {
            if (namespace.contains("nether") && namespace.contains("brick")) {
                return ModSounds.soundNetherBricks;
            }
            if (namespace.contains("netherrack") || namespace.contains("hellfish")) {
                return ModSounds.soundNetherrack;
            }
            if (block == Blocks.field_150449_bY || namespace.contains("nether") && (block instanceof BlockOre || namespace.contains("ore"))) {
                return ModSounds.soundNetherOre;
            }
            if (namespace.contains("deepslate")) {
                return namespace.contains("brick") ? ModSounds.soundDeepslateBricks : ModSounds.soundDeepslate;
            }
            if (block instanceof BlockNetherWart || namespace.contains("nether") && namespace.contains("wart")) {
                return ModSounds.soundCropWarts;
            }
            if (namespace.contains("bone") || namespace.contains("ivory")) {
                return ModSounds.soundBoneBlock;
            }
        }
        if (block.field_149762_H == Block.field_149779_h) {
            if (block instanceof BlockVine) {
                return ModSounds.soundVines;
            }
            if (block instanceof BlockLilyPad) {
                return ModSounds.soundWetGrass;
            }
        }
        if (block instanceof BlockCrops || block instanceof BlockStem) {
            return ModSounds.soundCrops;
        }
        if (block.field_149762_H == Block.field_149776_m && namespace.contains("soul") && namespace.contains("sand")) {
            return ModSounds.soundSoulSand;
        }
        if (block.field_149762_H == Block.field_149777_j && (namespace.contains("copper") || namespace.contains("tin"))) {
            return ModSounds.soundCopper;
        }
        if (block.func_149688_o() == Material.field_151573_f && block instanceof BlockHopper) {
            return Block.field_149777_j;
        }
        return null;
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        if (ConfigFunctions.enableFillCommand) {
            event.registerServerCommand((ICommand)new CommandFill());
        }
    }

    public static boolean stringListContainsPhrase(Set<String> set, String string) {
        for (String stringInSet : set) {
            if (!string.contains(stringInSet)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getOreStrings(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        for (int oreID : OreDictionary.getOreIDs((ItemStack)stack)) {
            list.add(OreDictionary.getOreName((int)oreID));
        }
        return list;
    }

    public static boolean hasDictTag(Block block, String ... tags) {
        return EtFuturum.hasDictTag(new ItemStack(block), tags);
    }

    public static boolean hasDictTag(Item item, String ... tags) {
        return EtFuturum.hasDictTag(new ItemStack(item), tags);
    }

    public static boolean hasDictTag(ItemStack stack, String ... tags) {
        for (String oreName : EtFuturum.getOreStrings(stack)) {
            if (!ArrayUtils.contains((Object[])tags, (Object)oreName)) continue;
            return true;
        }
        return false;
    }

    public static boolean dictTagsStartWith(Block block, String stringToFind) {
        return EtFuturum.dictTagsContain(new ItemStack(block), stringToFind);
    }

    public static boolean dictTagsStartWith(Item item, String stringToFind) {
        return EtFuturum.dictTagsContain(new ItemStack(item), stringToFind);
    }

    public static boolean dictTagsStartWith(ItemStack stack, String stringToFind) {
        for (String oreName : EtFuturum.getOreStrings(stack)) {
            if (!oreName.startsWith(stringToFind)) continue;
            return true;
        }
        return false;
    }

    public static boolean dictTagsContain(Block block, String stringToFind) {
        return EtFuturum.dictTagsContain(new ItemStack(block), stringToFind);
    }

    public static boolean dictTagsContain(Item item, String stringToFind) {
        return EtFuturum.dictTagsContain(new ItemStack(item), stringToFind);
    }

    public static boolean dictTagsContain(ItemStack stack, String stringToFind) {
        for (String oreName : EtFuturum.getOreStrings(stack)) {
            if (!oreName.contains(stringToFind)) continue;
            return true;
        }
        return false;
    }

    public static PotionEffect getSuspiciousStewEffect(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (item == Item.func_150898_a((Block)Blocks.field_150328_O)) {
            switch (stack.func_77960_j()) {
                default: {
                    return new PotionEffect(Potion.field_76439_r.field_76415_H, 100, 0);
                }
                case 1: {
                    return new PotionEffect(Potion.field_76443_y.field_76415_H, 7, 0);
                }
                case 2: {
                    return new PotionEffect(Potion.field_76426_n.field_76415_H, 80, 0);
                }
                case 3: {
                    return new PotionEffect(Potion.field_76440_q.field_76415_H, 160, 0);
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return new PotionEffect(Potion.field_76437_t.field_76415_H, 180, 0);
                }
                case 8: 
            }
            return new PotionEffect(Potion.field_76428_l.field_76415_H, 160, 0);
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150327_N)) {
            return new PotionEffect(Potion.field_76443_y.field_76415_H, 7, 0);
        }
        if (item == Item.func_150898_a((Block)ModBlocks.CORNFLOWER.get())) {
            return new PotionEffect(Potion.field_76430_j.field_76415_H, 120, 0);
        }
        if (item == Item.func_150898_a((Block)ModBlocks.LILY_OF_THE_VALLEY.get())) {
            return new PotionEffect(Potion.field_76436_u.field_76415_H, 240, 0);
        }
        if (item == Item.func_150898_a((Block)ModBlocks.WITHER_ROSE.get())) {
            return new PotionEffect(Potion.field_82731_v.field_76415_H, 160, 0);
        }
        return null;
    }

    private static void getSounds(ADConfig config) {
        String ver = "minecraft_1.21".split("_")[1];
        config.addObject(ver, "minecraft/sounds/ambient/cave/cave14.ogg");
        config.addObject(ver, "minecraft/sounds/ambient/cave/cave15.ogg");
        config.addObject(ver, "minecraft/sounds/ambient/cave/cave16.ogg");
        config.addObject(ver, "minecraft/sounds/ambient/cave/cave17.ogg");
        config.addObject(ver, "minecraft/sounds/ambient/cave/cave18.ogg");
        config.addObject(ver, "minecraft/sounds/ambient/cave/cave19.ogg");
        config.addSoundEvent(ver, "weather.rain", "weather");
        config.addSoundEvent(ver, "weather.rain.above", "weather");
        config.addSoundEvent(ver, "music.nether.nether_wastes", "music");
        config.addSoundEvent(ver, "ambient.nether_wastes.additions", "ambient");
        config.addSoundEvent(ver, "ambient.nether_wastes.loop", "ambient");
        config.addSoundEvent(ver, "ambient.nether_wastes.mood", "ambient");
        config.addSoundEvent(ver, "music.nether.crimson_forest", "music");
        config.addSoundEvent(ver, "ambient.crimson_forest.additions", "ambient");
        config.addSoundEvent(ver, "ambient.crimson_forest.loop", "ambient");
        config.addSoundEvent(ver, "ambient.crimson_forest.mood", "ambient");
        config.addSoundEvent(ver, "music.nether.warped_forest", "music");
        config.addSoundEvent(ver, "ambient.warped_forest.additions", "ambient");
        config.addSoundEvent(ver, "ambient.warped_forest.loop", "ambient");
        config.addSoundEvent(ver, "ambient.warped_forest.mood", "ambient");
        config.addSoundEvent(ver, "music.nether.soul_sand_valley", "music");
        config.addSoundEvent(ver, "ambient.soul_sand_valley.additions", "ambient");
        config.addSoundEvent(ver, "ambient.soul_sand_valley.loop", "ambient");
        config.addSoundEvent(ver, "ambient.soul_sand_valley.mood", "ambient");
        config.addSoundEvent(ver, "music.nether.basalt_deltas", "music");
        config.addSoundEvent(ver, "ambient.basalt_deltas.additions", "ambient");
        config.addSoundEvent(ver, "ambient.basalt_deltas.loop", "ambient");
        config.addSoundEvent(ver, "ambient.basalt_deltas.mood", "ambient");
        config.addSoundEvent(ver, "music_disc.pigstep", "record");
        config.addSoundEvent(ver, "music_disc.otherside", "record");
        config.addSoundEvent(ver, "item.elytra.flying", "player");
        config.addSoundEvent(ver, "enchant.thorns.hit", "player");
        config.addSoundEvent(ver, "entity.boat.paddle_land", "player");
        config.addSoundEvent(ver, "entity.boat.paddle_water", "player");
        config.addSoundEvent(ver, "entity.rabbit.ambient", "neutral");
        config.addSoundEvent(ver, "entity.rabbit.jump", "neutral");
        config.addSoundEvent(ver, "entity.rabbit.attack", "neutral");
        config.addSoundEvent(ver, "entity.rabbit.hurt", "neutral");
        config.addSoundEvent(ver, "entity.rabbit.death", "neutral");
        config.addSoundEvent(ver, "entity.zombie_villager.ambient", "hostile");
        config.addSoundEvent(ver, "entity.zombie_villager.step", "hostile");
        config.addSoundEvent(ver, "entity.zombie_villager.hurt", "hostile");
        config.addSoundEvent(ver, "entity.zombie_villager.death", "hostile");
        config.addSoundEvent(ver, "entity.husk.ambient", "hostile");
        config.addSoundEvent(ver, "entity.husk.step", "hostile");
        config.addSoundEvent(ver, "entity.husk.hurt", "hostile");
        config.addSoundEvent(ver, "entity.husk.death", "hostile");
        config.addSoundEvent(ver, "entity.zombie.converted_to_drowned", "hostile");
        config.addSoundEvent(ver, "entity.husk.converted_to_zombie", "hostile");
        config.addSoundEvent(ver, "entity.stray.ambient", "hostile");
        config.addSoundEvent(ver, "entity.stray.step", "hostile");
        config.addSoundEvent(ver, "entity.stray.hurt", "hostile");
        config.addSoundEvent(ver, "entity.stray.death", "hostile");
        config.addSoundEvent(ver, "entity.skeleton.converted_to_stray", "hostile");
        config.addSoundEvent(ver, "entity.shulker_bullet.hurt", "hostile");
        config.addSoundEvent(ver, "entity.shulker_bullet.hit", "hostile");
        config.addSoundEvent(ver, "entity.shulker.ambient", "hostile");
        config.addSoundEvent(ver, "entity.shulker.open", "hostile");
        config.addSoundEvent(ver, "entity.shulker.close", "hostile");
        config.addSoundEvent(ver, "entity.shulker.shoot", "hostile");
        config.addSoundEvent(ver, "entity.shulker.hurt", "hostile");
        config.addSoundEvent(ver, "entity.shulker.hurt_closed", "hostile");
        config.addSoundEvent(ver, "entity.shulker.death", "hostile");
        config.addSoundEvent(ver, "entity.shulker.teleport", "hostile");
        config.addSoundEvent(ver, "entity.snow_golem.ambient", "neutral");
        config.addSoundEvent(ver, "entity.snow_golem.hurt", "neutral");
        config.addSoundEvent(ver, "entity.snow_golem.death", "neutral");
        config.addSoundEvent(ver, "entity.wither_skeleton.ambient", "hostile");
        config.addSoundEvent(ver, "entity.wither_skeleton.hurt", "hostile");
        config.addSoundEvent(ver, "entity.wither_skeleton.death", "hostile");
        config.addSoundEvent(ver, "entity.wither_skeleton.step", "hostile");
        config.addSoundEvent(ver, "entity.squid.ambient", "neutral");
        config.addSoundEvent(ver, "entity.squid.hurt", "neutral");
        config.addSoundEvent(ver, "entity.squid.death", "neutral");
        config.addSoundEvent(ver, "entity.squid.squirt", "neutral");
        config.addSoundEvent(ver, "entity.witch.ambient", "hostile");
        config.addSoundEvent(ver, "entity.witch.hurt", "hostile");
        config.addSoundEvent(ver, "entity.witch.death", "hostile");
        config.addSoundEvent(ver, "entity.witch.drink", "hostile");
        config.addSoundEvent(ver, "entity.item_frame.add_item", "player");
        config.addSoundEvent(ver, "entity.item_frame.break", "player");
        config.addSoundEvent(ver, "entity.item_frame.place", "player");
        config.addSoundEvent(ver, "entity.item_frame.remove_item", "player");
        config.addSoundEvent(ver, "entity.item_frame.rotate_item", "player");
        config.addSoundEvent(ver, "entity.painting.break", "player");
        config.addSoundEvent(ver, "entity.painting.place", "player");
        config.addSoundEvent(ver, "entity.leash_knot.break", "player");
        config.addSoundEvent(ver, "entity.leash_knot.place", "player");
        config.addSoundEvent(ver, "entity.ender_eye.death", "neutral");
        config.addSoundEvent(ver, "entity.ender_eye.launch", "neutral");
        config.addSoundEvent(ver, "entity.fishing_bobber.retrieve", "neutral");
        config.addSoundEvent(ver, "entity.fishing_bobber.throw", "neutral");
        config.addSoundEvent(ver, "entity.horse.eat", "neutral");
        config.addSoundEvent(ver, "entity.cow.milk", "neutral");
        config.addSoundEvent(ver, "entity.mooshroom.milk", "neutral");
        config.addSoundEvent(ver, "entity.mooshroom.convert", "neutral");
        config.addSoundEvent(ver, "entity.bee.loop", "neutral");
        config.addSoundEvent(ver, "entity.bee.loop_aggressive", "neutral");
        config.addSoundEvent(ver, "entity.bee.hurt", "neutral");
        config.addSoundEvent(ver, "entity.bee.death", "neutral");
        config.addSoundEvent(ver, "entity.bee.pollinate", "neutral");
        config.addSoundEvent(ver, "entity.bee.sting", "neutral");
        config.addSoundEvent(ver, "entity.fox.eat", "neutral");
        config.addSoundEvent(ver, "entity.fox.aggro", "neutral");
        config.addSoundEvent(ver, "entity.fox.spit", "neutral");
        config.addSoundEvent(ver, "entity.fox.screech", "neutral");
        config.addSoundEvent(ver, "entity.fox.sleep", "neutral");
        config.addSoundEvent(ver, "entity.fox.ambient", "neutral");
        config.addSoundEvent(ver, "entity.fox.hurt", "neutral");
        config.addSoundEvent(ver, "entity.fox.death", "neutral");
        config.addSoundEvent(ver, "entity.fox.bite", "neutral");
        config.addSoundEvent(ver, "entity.fox.sniff", "neutral");
        config.addSoundEvent(ver, "entity.player.hurt_on_fire", "player");
        config.addSoundEvent(ver, "entity.player.hurt_drown", "player");
        config.addSoundEvent(ver, "entity.player.hurt_sweet_berry_bush", "player");
        config.addSoundEvent(ver, "entity.player.attack.crit", "player");
        config.addSoundEvent(ver, "entity.player.attack.knockback", "player");
        config.addSoundEvent(ver, "entity.player.attack.nodamage", "player");
        config.addSoundEvent(ver, "entity.player.attack.strong", "player");
        config.addSoundEvent(ver, "entity.player.attack.sweep", "player");
        config.addSoundEvent(ver, "entity.player.attack.weak", "player");
        config.addSoundEvent(ver, "entity.player.splash.high_speed", "player");
        config.addSoundEvent(ver, "item.axe.scrape", "player");
        config.addSoundEvent(ver, "item.axe.wax_off", "player");
        config.addSoundEvent(ver, "item.axe.strip", "player");
        config.addSoundEvent(ver, "item.hoe.till", "player");
        config.addSoundEvent(ver, "item.honeycomb.wax_on", "player");
        config.addSoundEvent(ver, "item.totem.use", "player");
        config.addSoundEvent(ver, "item.shovel.flatten", "player");
        config.addSoundEvent(ver, "item.chorus_fruit.teleport", "player");
        config.addSoundEvent(ver, "item.book.page_turn", "player");
        config.addSoundEvent(ver, "item.bucket.fill", "player");
        config.addSoundEvent(ver, "item.bucket.fill_lava", "player");
        config.addSoundEvent(ver, "item.bucket.empty", "player");
        config.addSoundEvent(ver, "item.bucket.empty_lava", "player");
        config.addSoundEvent(ver, "item.bottle.fill", "player");
        config.addSoundEvent(ver, "item.bottle.empty", "player");
        config.addSoundEvent(ver, "item.bone_meal.use", "player");
        config.addSoundEvent(ver, "item.honey_bottle.drink", "player");
        config.addSoundEvent(ver, "item.armor.equip_leather", "player");
        config.addSoundEvent(ver, "item.armor.equip_gold", "player");
        config.addSoundEvent(ver, "item.armor.equip_chain", "player");
        config.addSoundEvent(ver, "item.armor.equip_iron", "player");
        config.addSoundEvent(ver, "item.armor.equip_diamond", "player");
        config.addSoundEvent(ver, "item.armor.equip_netherite", "player");
        config.addSoundEvent(ver, "item.armor.equip_turtle", "player");
        config.addSoundEvent(ver, "item.armor.equip_generic", "player");
        config.addSoundEvent(ver, "item.armor.equip_elytra", "player");
        config.addSoundEvent(ver, "block.note_block.banjo", "record");
        config.addSoundEvent(ver, "block.note_block.bell", "record");
        config.addSoundEvent(ver, "block.note_block.bit", "record");
        config.addSoundEvent(ver, "block.note_block.chime", "record");
        config.addSoundEvent(ver, "block.note_block.cow_bell", "record");
        config.addSoundEvent(ver, "block.note_block.didgeridoo", "record");
        config.addSoundEvent(ver, "block.note_block.flute", "record");
        config.addSoundEvent(ver, "block.note_block.guitar", "record");
        config.addSoundEvent(ver, "block.note_block.harp", "record");
        config.addSoundEvent(ver, "block.note_block.iron_xylophone", "record");
        config.addSoundEvent(ver, "block.note_block.xylophone", "record");
        config.addSoundEvent(ver, "block.barrel.open", "block");
        config.addSoundEvent(ver, "block.barrel.close", "block");
        config.addSoundEvent(ver, "block.chorus_flower.grow", "block");
        config.addSoundEvent(ver, "block.chorus_flower.death", "block");
        config.addSoundEvent(ver, "block.end_portal.spawn", "ambient");
        config.addSoundEvent(ver, "block.end_portal_frame.fill", "block");
        config.addSoundEvent(ver, "block.shulker_box.open", "block");
        config.addSoundEvent(ver, "block.shulker_box.close", "block");
        config.addSoundEvent(ver, "block.sweet_berry_bush.pick_berries", "player");
        config.addSoundEvent(ver, "block.brewing_stand.brew", "block");
        config.addSoundEvent(ver, "block.furnace.fire_crackle", "block");
        config.addSoundEvent(ver, "block.blastfurnace.fire_crackle", "block");
        config.addSoundEvent(ver, "block.smoker.smoke", "block");
        config.addSoundEvent(ver, "block.chest.close", "block");
        config.addSoundEvent(ver, "block.ender_chest.open", "block");
        config.addSoundEvent(ver, "block.ender_chest.close", "block");
        config.addSoundEvent(ver, "block.composter.empty", "block");
        config.addSoundEvent(ver, "block.composter.fill", "block");
        config.addSoundEvent(ver, "block.composter.fill_success", "block");
        config.addSoundEvent(ver, "block.composter.ready", "block");
        config.addSoundEvent(ver, "block.amethyst_block.hit", "block");
        config.addSoundEvent(ver, "block.amethyst_block.chime", "block");
        config.addSoundEvent(ver, "block.smithing_table.use", "player");
        config.addSoundEvent(ver, "block.enchantment_table.use", "player");
        config.addSoundEvent(ver, "block.beacon.activate", "block");
        config.addSoundEvent(ver, "block.beacon.ambient", "block");
        config.addSoundEvent(ver, "block.beacon.deactivate", "block");
        config.addSoundEvent(ver, "block.beacon.power_select", "block");
        config.addSoundEvent(ver, "block.honey_block.slide", "neutral");
        config.addSoundEvent(ver, "block.beehive.drip", "block");
        config.addSoundEvent(ver, "block.beehive.enter", "neutral");
        config.addSoundEvent(ver, "block.beehive.exit", "neutral");
        config.addSoundEvent(ver, "block.beehive.work", "neutral");
        config.addSoundEvent(ver, "block.beehive.shear", "player");
        config.addSoundEvent(ver, "block.sponge.absorb", "block");
        config.addSoundEvent(ver, "block.copper_bulb.turn_on", "block");
        config.addSoundEvent(ver, "block.copper_bulb.turn_off", "block");
        config.addSoundEvent(ver, "block.bubble_column.bubble_pop", "block");
        config.addSoundEvent(ver, "block.bubble_column.upwards_ambient", "block");
        config.addSoundEvent(ver, "block.bubble_column.upwards_inside", "neutral");
        config.addSoundEvent(ver, "block.bubble_column.whirlpool_ambient", "block");
        config.addSoundEvent(ver, "block.bubble_column.whirlpool_inside", "neutral");
        config.addSoundEvent(ver, "block.fence_gate.open", "block");
        config.addSoundEvent(ver, "block.fence_gate.close", "block");
        config.addSoundEvent(ver, "block.nether_wood_fence_gate.open", "block");
        config.addSoundEvent(ver, "block.nether_wood_fence_gate.close", "block");
        config.addSoundEvent(ver, "block.cherry_wood_fence_gate.open", "block");
        config.addSoundEvent(ver, "block.cherry_wood_fence_gate.close", "block");
        config.addSoundEvent(ver, "block.bamboo_wood_fence_gate.open", "block");
        config.addSoundEvent(ver, "block.bamboo_wood_fence_gate.close", "block");
        config.addSoundEvent(ver, "block.wooden_door.open", "block");
        config.addSoundEvent(ver, "block.wooden_door.close", "block");
        config.addSoundEvent(ver, "block.nether_wood_door.open", "block");
        config.addSoundEvent(ver, "block.nether_wood_door.close", "block");
        config.addSoundEvent(ver, "block.cherry_wood_door.open", "block");
        config.addSoundEvent(ver, "block.cherry_wood_door.close", "block");
        config.addSoundEvent(ver, "block.bamboo_wood_door.open", "block");
        config.addSoundEvent(ver, "block.bamboo_wood_door.close", "block");
        config.addSoundEvent(ver, "block.iron_door.open", "block");
        config.addSoundEvent(ver, "block.iron_door.close", "block");
        config.addSoundEvent(ver, "block.copper_door.open", "block");
        config.addSoundEvent(ver, "block.copper_door.close", "block");
        config.addSoundEvent(ver, "block.wooden_trapdoor.open", "block");
        config.addSoundEvent(ver, "block.wooden_trapdoor.close", "block");
        config.addSoundEvent(ver, "block.nether_wood_trapdoor.open", "block");
        config.addSoundEvent(ver, "block.nether_wood_trapdoor.close", "block");
        config.addSoundEvent(ver, "block.cherry_wood_trapdoor.open", "block");
        config.addSoundEvent(ver, "block.cherry_wood_trapdoor.close", "block");
        config.addSoundEvent(ver, "block.bamboo_wood_trapdoor.open", "block");
        config.addSoundEvent(ver, "block.bamboo_wood_trapdoor.close", "block");
        config.addSoundEvent(ver, "block.iron_trapdoor.open", "block");
        config.addSoundEvent(ver, "block.iron_trapdoor.close", "block");
        config.addSoundEvent(ver, "block.copper_trapdoor.open", "block");
        config.addSoundEvent(ver, "block.copper_trapdoor.close", "block");
        config.addSoundEvent(ver, "block.wooden_button.click_off", "block");
        config.addSoundEvent(ver, "block.wooden_button.click_on", "block");
        config.addSoundEvent(ver, "block.nether_wood_button.click_off", "block");
        config.addSoundEvent(ver, "block.nether_wood_button.click_on", "block");
        config.addSoundEvent(ver, "block.cherry_wood_button.click_off", "block");
        config.addSoundEvent(ver, "block.cherry_wood_button.click_on", "block");
        config.addSoundEvent(ver, "block.bamboo_wood_button.click_off", "block");
        config.addSoundEvent(ver, "block.bamboo_wood_button.click_on", "block");
        config.addSoundEvent(ver, "block.wooden_pressure_plate.click_off", "block");
        config.addSoundEvent(ver, "block.wooden_pressure_plate.click_on", "block");
        config.addSoundEvent(ver, "block.nether_wood_pressure_plate.click_off", "block");
        config.addSoundEvent(ver, "block.nether_wood_pressure_plate.click_on", "block");
        config.addSoundEvent(ver, "block.cherry_wood_pressure_plate.click_off", "block");
        config.addSoundEvent(ver, "block.cherry_wood_pressure_plate.click_on", "block");
        config.addSoundEvent(ver, "block.metal_pressure_plate.click_off", "block");
        config.addSoundEvent(ver, "block.metal_pressure_plate.click_on", "block");
        for (ModSounds.CustomSound sound : ModSounds.getSounds()) {
            if (sound.func_150498_e().startsWith("minecraft_1.21")) {
                config.addSoundEvent(ver, sound.func_150498_e().substring("minecraft_1.21".length() + 1), "neutral");
            }
            if (sound.func_150496_b().startsWith("minecraft_1.21")) {
                config.addSoundEvent(ver, sound.func_150496_b().substring("minecraft_1.21".length() + 1), "block");
            }
            if (!sound.func_150495_a().startsWith("minecraft_1.21")) continue;
            config.addSoundEvent(ver, sound.func_150495_a().substring("minecraft_1.21".length() + 1), "block");
        }
    }

    static {
        creativeTabItems = new CreativeTabs("etfuturum.items"){

            public Item func_78016_d() {
                return ModItems.RAW_ORE.isEnabled() ? ModItems.RAW_ORE.get() : (ModItems.NETHERITE_SCRAP.isEnabled() ? ModItems.NETHERITE_SCRAP.get() : (ModItems.PRISMARINE_SHARD.isEnabled() ? ModItems.PRISMARINE_SHARD.get() : Items.field_151064_bs));
            }

            public void func_78018_a(List<ItemStack> p_78018_1_) {
                for (byte i = 1; i <= 3; i = (byte)(i + 1)) {
                    ItemStack firework = new ItemStack(Items.field_151152_bP);
                    NBTTagCompound nbt = new NBTTagCompound();
                    NBTTagCompound nbt2 = new NBTTagCompound();
                    nbt2.func_74774_a("Flight", i);
                    nbt.func_74782_a("Fireworks", (NBTBase)nbt2);
                    firework.func_77982_d(nbt);
                    p_78018_1_.add(firework);
                }
                for (int i : ModEntityList.eggIDs) {
                    p_78018_1_.add(new ItemStack(Items.field_151063_bx, 1, i));
                }
                super.func_78018_a(p_78018_1_);
            }
        };
        creativeTabBlocks = new CreativeTabs("etfuturum.blocks"){

            public Item func_78016_d() {
                return ModBlocks.COPPER_BLOCK.isEnabled() ? ModBlocks.COPPER_BLOCK.getItem() : (ModBlocks.CHERRY_LOG.isEnabled() ? ModBlocks.CHERRY_LOG.getItem() : (ModBlocks.SMOKER.isEnabled() ? ModBlocks.SMOKER.getItem() : (ModBlocks.CHORUS_FLOWER.isEnabled() ? ModBlocks.CHORUS_FLOWER.getItem() : Item.func_150898_a((Block)Blocks.field_150477_bB))));
            }

            public void func_78018_a(List<ItemStack> list) {
                list.add(new ItemStack(Blocks.field_150474_ac));
                super.func_78018_a(list);
                Iterator<ItemStack> iterator = list.iterator();
                while (iterator.hasNext()) {
                    ItemStack stack = iterator.next();
                    ModItems[] modItemsArray = ModItems.OLD_SIGN_ITEMS;
                    int n = modItemsArray.length;
                    for (int i = 0; i < n; ++i) {
                        ModItems sign = modItemsArray[i];
                        if (stack.func_77973_b() != sign.get()) continue;
                        iterator.remove();
                    }
                }
                block2: for (ModItems sign : ModItems.OLD_SIGN_ITEMS) {
                    for (ItemStack stack : list) {
                        if (Item.func_150891_b((Item)stack.func_77973_b()) <= Block.func_149682_b((Block)((ItemWoodSign)sign.get()).getSignBlock())) continue;
                        list.add(list.indexOf(stack), sign.newItemStack());
                        continue block2;
                    }
                }
            }
        };
    }
}

