/*
 * Decompiled with CFR 0.152.
 */
package hohserg.elegant.networking.impl;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public interface ISerializerBase<Packet> {
    public void serialize(Packet var1, ByteBuf var2);

    public Packet unserialize(ByteBuf var1);

    default public void serialize_Boolean_Generic(boolean value, ByteBuf acc) {
        acc.writeBoolean(value);
    }

    default public void serialize_Byte_Generic(byte value, ByteBuf acc) {
        acc.writeByte((int)value);
    }

    default public void serialize_Short_Generic(short value, ByteBuf acc) {
        acc.writeShort((int)value);
    }

    default public void serialize_Int_Generic(int value, ByteBuf acc) {
        acc.writeInt(value);
    }

    default public void serialize_Long_Generic(long value, ByteBuf acc) {
        acc.writeLong(value);
    }

    default public void serialize_Char_Generic(char value, ByteBuf acc) {
        acc.writeChar((int)value);
    }

    default public void serialize_Float_Generic(float value, ByteBuf acc) {
        acc.writeFloat(value);
    }

    default public void serialize_Double_Generic(double value, ByteBuf acc) {
        acc.writeDouble(value);
    }

    default public void serialize_String_Generic(String value, ByteBuf acc) {
        byte[] utf8Bytes = value.getBytes(StandardCharsets.UTF_8);
        acc.writeInt(utf8Bytes.length);
        acc.writeBytes(utf8Bytes);
    }

    default public void serialize_UUID_Generic(UUID value, ByteBuf acc) {
        this.serialize_String_Generic(value.toString(), acc);
    }

    default public boolean unserialize_Boolean_Generic(ByteBuf buf) {
        return buf.readBoolean();
    }

    default public byte unserialize_Byte_Generic(ByteBuf buf) {
        return buf.readByte();
    }

    default public short unserialize_Short_Generic(ByteBuf buf) {
        return buf.readShort();
    }

    default public int unserialize_Int_Generic(ByteBuf buf) {
        return buf.readInt();
    }

    default public long unserialize_Long_Generic(ByteBuf buf) {
        return buf.readLong();
    }

    default public char unserialize_Char_Generic(ByteBuf buf) {
        return buf.readChar();
    }

    default public float unserialize_Float_Generic(ByteBuf buf) {
        return buf.readFloat();
    }

    default public double unserialize_Double_Generic(ByteBuf buf) {
        return buf.readDouble();
    }

    default public String unserialize_String_Generic(ByteBuf buf) {
        int len = buf.readInt();
        String str = buf.toString(buf.readerIndex(), len, StandardCharsets.UTF_8);
        buf.readerIndex(buf.readerIndex() + len);
        return str;
    }

    default public UUID unserialize_UUID_Generic(ByteBuf buf) {
        return UUID.fromString(this.unserialize_String_Generic(buf));
    }
}

