/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks;

import cpw.mods.fml.relauncher.ModListHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import makamys.coretweaks.Config;
import makamys.coretweaks.CoreTweaks;
import makamys.coretweaks.util.Util;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public class Persistence {
    private static final File PERSISTENCE_TXT = Util.childFile(CoreTweaks.MY_DIR, "persistence.txt");
    private static Properties props;
    public static String lastMods;
    public static String lastVersion;
    public static Log erroredClassesLog;
    public static Log debugLog;

    public static void loadIfNotLoadedAlready() {
        if (props != null) {
            return;
        }
        props = new Properties();
        try {
            props.load(new BufferedInputStream(new FileInputStream(PERSISTENCE_TXT)));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            CoreTweaks.LOGGER.warn("Failed to load persistence file");
            e.printStackTrace();
        }
        lastMods = props.getProperty("lastMods", "");
        lastVersion = props.getProperty("lastVersion", "");
    }

    public static void save() {
        if (props == null) {
            throw new IllegalStateException("Tried to save persistence without loading first");
        }
        try {
            props.setProperty("lastMods", lastMods);
            props.setProperty("lastVersion", lastVersion);
            props.store(new BufferedOutputStream(new FileOutputStream(PERSISTENCE_TXT)), "This file is used by CoreTweaks to store data. You probably shouldn't edit it.");
        }
        catch (IOException e) {
            CoreTweaks.LOGGER.warn("Failed to save persistence file");
            e.printStackTrace();
        }
    }

    public static boolean modsChanged() {
        boolean changed = false;
        List<ModInfo> modFiles = Persistence.findMods();
        ArrayList<ModInfo> previousModFiles = new ArrayList<ModInfo>();
        List<String> lines = Arrays.asList(lastMods.split("\n"));
        File lastFile = null;
        long lastModDate = -1L;
        for (String line : lines) {
            if (lastFile == null) {
                lastFile = new File(line);
                continue;
            }
            if (lastModDate == -1L) {
                lastModDate = Long.parseLong(line);
                continue;
            }
            previousModFiles.add(new ModInfo(lastFile, lastModDate, line));
            lastFile = null;
            lastModDate = -1L;
        }
        changed = previousModFiles.size() != modFiles.size() || !Persistence.filesMatch(previousModFiles.stream().sorted().iterator(), modFiles.stream().sorted().iterator());
        modFiles.parallelStream().forEach(mf -> mf.getValidHash());
        lastMods = String.join((CharSequence)"\n", modFiles.stream().map(p -> p.file.getPath() + "\n" + p.modificationDate + "\n" + p.hash).collect(Collectors.toList()));
        Persistence.save();
        return changed;
    }

    private static boolean filesMatch(Iterator<ModInfo> aIt, Iterator<ModInfo> bIt) {
        HashSet modFilesToIgnore = new HashSet(Arrays.stream(Config.modFilesToIgnore.split(",")).collect(Collectors.toList()));
        while (aIt.hasNext()) {
            ModInfo a = aIt.next();
            ModInfo b = bIt.next();
            if (a.file.equals(b.file) && (modFilesToIgnore.contains(a.file.getName()) || a.modificationDate == b.modificationDate || a.getValidHash().equals(b.getValidHash()))) continue;
            return false;
        }
        return true;
    }

    private static byte[] calculateHash(File f) {
        byte[] byArray;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
        try {
            byArray = DigestUtils.md5((InputStream)is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return new byte[0];
            }
        }
        ((InputStream)is).close();
        return byArray;
    }

    private static List<ModInfo> findMods() {
        File modsDir = new File(Launch.minecraftHome, "mods");
        File versionedModsDir = new File(modsDir, "1.7.10");
        ArrayList<File> modFiles = new ArrayList<File>();
        for (File dir : Arrays.asList(modsDir, versionedModsDir)) {
            if (!dir.isDirectory()) continue;
            modFiles.addAll(Arrays.asList(modsDir.listFiles(x -> x.getName().endsWith(".jar") || x.getName().endsWith(".litemod"))));
        }
        modFiles.addAll(ModListHelper.additionalMods.values());
        return modFiles.parallelStream().map(f -> new ModInfo((File)f, f.lastModified())).collect(Collectors.toList());
    }

    static {
        erroredClassesLog = new Log("out/errored-classes.txt");
        debugLog = new Log("out/debug.txt");
    }

    static class ModInfo
    implements Comparable<ModInfo> {
        File file;
        long modificationDate;
        String hash;

        public ModInfo(File file, long modDate, String hash) {
            this.file = file;
            this.modificationDate = modDate;
            this.hash = hash;
        }

        public ModInfo(File file, long modDate) {
            this(file, modDate, "");
        }

        public String getValidHash() {
            if (this.hash.isEmpty()) {
                this.hash = Hex.encodeHexString((byte[])Persistence.calculateHash(this.file));
            }
            return this.hash;
        }

        @Override
        public int compareTo(ModInfo o) {
            return this.file.compareTo(o.file);
        }
    }

    public static class Log {
        private File file;
        private OutputStream out;
        boolean failed = false;

        public Log(String path) {
            this.file = Util.childFile(CoreTweaks.OUT_DIR, path);
        }

        public void write(String msg) {
            if (this.failed) {
                return;
            }
            if (this.out == null) {
                try {
                    this.file.createNewFile();
                    this.out = new BufferedOutputStream(new FileOutputStream(this.file));
                }
                catch (IOException e) {
                    CoreTweaks.LOGGER.warn("Failed to open log file: " + this.file);
                    e.getStackTrace();
                    this.failed = true;
                }
            }
            if (this.out != null) {
                try {
                    this.out.write((msg + "\n").getBytes(Charset.forName("UTF-8")));
                }
                catch (IOException e) {
                    CoreTweaks.LOGGER.warn("Failed to write to log file " + this.file);
                    e.printStackTrace();
                    this.failed = true;
                }
            }
        }

        public void clear() {
            this.file.delete();
        }

        public void flush() {
            if (this.failed) {
                return;
            }
            if (this.out != null) {
                try {
                    this.out.flush();
                }
                catch (IOException e) {
                    CoreTweaks.LOGGER.warn("Failed to flush log file " + this.file);
                    e.printStackTrace();
                    this.failed = true;
                }
            }
        }
    }
}

