/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fluids.FluidStack;

class FluidStackSet
implements Set<FluidStack> {
    protected List<FluidStack> itemStacks = new ArrayList<FluidStack>();

    FluidStackSet() {
    }

    public String toString() {
        return this.itemStacks.toString();
    }

    protected FluidStack getExisting(FluidStack stack) {
        for (FluidStack existStack : this.itemStacks) {
            if (!existStack.isFluidEqual(stack)) continue;
            return existStack;
        }
        return null;
    }

    @Override
    public boolean add(FluidStack fluidStack) {
        if (fluidStack != null) {
            FluidStack existing = this.getExisting(fluidStack);
            if (existing == null) {
                return this.itemStacks.add(fluidStack.copy());
            }
            existing.amount += fluidStack.amount;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends FluidStack> collection) {
        boolean addedAll = true;
        for (FluidStack fluidStack : collection) {
            addedAll = this.add(fluidStack) && addedAll;
        }
        return addedAll;
    }

    @Override
    public void clear() {
        this.itemStacks.clear();
    }

    @Override
    public boolean contains(Object object) {
        return object instanceof FluidStack && this.getExisting((FluidStack)object) != null;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        boolean addedAll = true;
        for (Object object : collection) {
            addedAll = addedAll && this.contains(object);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.itemStacks.isEmpty();
    }

    @Override
    public Iterator<FluidStack> iterator() {
        return this.itemStacks.iterator();
    }

    @Override
    public boolean remove(Object object) {
        if (this.contains(object)) {
            FluidStack r = (FluidStack)object;
            FluidStack existing = this.getExisting(r);
            if (existing.amount > r.amount) {
                existing.amount -= r.amount;
            } else {
                this.itemStacks.remove(existing);
            }
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean addedAll = true;
        for (Object object : collection) {
            boolean removed = this.remove(object);
            addedAll = removed && addedAll;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.itemStacks.retainAll(collection);
    }

    @Override
    public int size() {
        return this.itemStacks.size();
    }

    @Override
    public Object[] toArray() {
        return this.itemStacks.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.itemStacks.toArray(array);
    }
}

