/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.minecraft.control;

import binnie.core.BinnieCore;
import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.ITooltip;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.Widget;
import binnie.core.craftgui.WidgetAttribute;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.minecraft.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ControlItemDisplay
extends Control
implements ITooltip {
    public boolean hastooltip = false;
    private ItemStack itemStack = null;
    private boolean rotating = false;

    public ControlItemDisplay(IWidget parent, float x, float y) {
        this(parent, x, y, 16.0f);
    }

    public ControlItemDisplay(IWidget parent, float f, float y, ItemStack stack, boolean tooltip) {
        this(parent, f, y, 16.0f);
        this.setItemStack(stack);
        if (tooltip) {
            this.setTooltip();
        }
    }

    public ControlItemDisplay(IWidget parent, float x, float y, float size) {
        super(parent, x, y, size, size);
    }

    public void setTooltip() {
        this.hastooltip = true;
        this.addAttribute(WidgetAttribute.MOUSE_OVER);
    }

    @Override
    public void onRenderBackground() {
        IPoint relativeToWindow = this.getAbsolutePosition().sub(this.getSuperParent().getPosition());
        if (relativeToWindow.x() > ((Widget)Window.get(this)).getSize().x() + 100.0f || relativeToWindow.y() > ((Widget)Window.get(this)).getSize().y() + 100.0f) {
            return;
        }
        if (this.itemStack == null) {
            return;
        }
        if (this.getSize().x() != 16.0f) {
            GL11.glPushMatrix();
            float scale = this.getSize().x() / 16.0f;
            GL11.glScalef((float)scale, (float)scale, (float)1.0f);
            BinnieCore.proxy.getMinecraftInstance();
            float phase = (float)Minecraft.func_71386_F() / 20.0f;
            CraftGUI.render.item(IPoint.ZERO, this.itemStack, this.rotating);
            GL11.glPopMatrix();
        } else {
            CraftGUI.render.item(IPoint.ZERO, this.itemStack, this.rotating);
        }
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        if (this.hastooltip && this.itemStack != null) {
            tooltip.add(this.itemStack.func_82840_a(((Window)this.getSuperParent()).getPlayer(), false));
        }
        super.getTooltip(tooltip);
    }

    public void setRotating() {
        this.rotating = true;
    }
}

