/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.common.MinecraftForge;
import org.embeddedt.archaicfix.ArchaicLogger;
import org.embeddedt.archaicfix.CommandDebugUpdateQueue;
import org.embeddedt.archaicfix.FixHelper;
import org.embeddedt.archaicfix.LeftClickEventHandler;
import org.embeddedt.archaicfix.asm.EarlyStringPool;
import org.embeddedt.archaicfix.config.ArchaicConfig;
import org.embeddedt.archaicfix.ducks.IAcceleratedRecipe;
import org.embeddedt.archaicfix.proxy.CommonProxy;
import org.embeddedt.archaicfix.recipe.IFasterCraftingManager;
import thaumcraft.api.ThaumcraftApi;

@Mod(modid="archaicfix", version="0.7.6", dependencies="required-after:gtnhmixins@[2.0.0,);required-after:unimixins@[0.1.16,);", guiFactory="org.embeddedt.archaicfix.config.ArchaicGuiConfigFactory")
public class ArchaicFix {
    public static final String MODID = "archaicfix";
    public static final String MODNAME = "ArchaicFix";
    public static final String VERSION = "0.7.6";
    private FixHelper helper;
    public static final SimpleNetworkWrapper NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel("archaicfix");
    public static volatile boolean IS_VANILLA_SERVER = false;
    public static boolean NEI_INSTALLED = false;
    @SidedProxy(clientSide="org.embeddedt.archaicfix.proxy.ClientProxy", serverSide="org.embeddedt.archaicfix.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void onConstruct(FMLConstructionEvent event) {
        try {
            Class.forName("com.gildedgames.util.threadedlighting.asm.TLTransformer");
            ArchaicLogger.LOGGER.fatal("=================== WARNING ===================");
            ArchaicLogger.LOGGER.fatal("A version of GG Util that includes threaded lighting was detected. ArchaicFix has prevented launching to avoid issues. Please download a fixed version of GG Util: https://www.curseforge.com/minecraft/mc-mods/gilded-game-utils-fix.");
            ArchaicLogger.LOGGER.fatal("===============================================");
            throw new UnsupportedOperationException("Please download a fixed version of GG Util: https://www.curseforge.com/minecraft/mc-mods/gilded-game-utils-fix");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        if (Entity.field_70152_a == 0) {
            Entity.field_70152_a = 1;
            ArchaicLogger.LOGGER.info("Fixed MC-111480");
        }
        if (ArchaicConfig.enableHitThroughGrassFix) {
            MinecraftForge.EVENT_BUS.register((Object)new LeftClickEventHandler());
        }
        this.helper = new FixHelper();
        MinecraftForge.EVENT_BUS.register((Object)this.helper);
        FMLCommonHandler.instance().bus().register((Object)this.helper);
        proxy.preinit();
        NEI_INSTALLED = Loader.isModLoaded((String)"NotEnoughItems");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        EarlyStringPool.clear();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandDebugUpdateQueue());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        ((IFasterCraftingManager)CraftingManager.func_77594_a()).clearRecipeCache();
        ArchaicLogger.LOGGER.info("Cleared recipe cache");
    }

    private void printRecipeDebug() {
        if (!ArchaicConfig.cacheRecipes) {
            return;
        }
        HashMap<Class, Integer> recipeTypeMap = new HashMap<Class, Integer>();
        for (IRecipe o : CraftingManager.func_77594_a().func_77592_b()) {
            recipeTypeMap.compute(o.getClass(), (key, oldValue) -> {
                if (oldValue == null) {
                    return 1;
                }
                return oldValue + 1;
            });
        }
        recipeTypeMap.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).forEach(pair -> {
            String acceleratedSuffix = IAcceleratedRecipe.class.isAssignableFrom((Class)pair.getKey()) ? " (accelerated)" : "";
            ArchaicLogger.LOGGER.info("There are " + pair.getValue() + " recipes of type " + ((Class)pair.getKey()).getName() + acceleratedSuffix);
        });
        int totalRecipes = recipeTypeMap.values().stream().reduce(0, Integer::sum);
        int acceleratedRecipes = recipeTypeMap.entrySet().stream().filter(pair -> IAcceleratedRecipe.class.isAssignableFrom((Class)pair.getKey())).map(Map.Entry::getValue).reduce(0, Integer::sum);
        ArchaicLogger.LOGGER.info(acceleratedRecipes + " / " + totalRecipes + " recipes are accelerated!");
    }

    private void removeThaumcraftLeak() {
        if (!Loader.isModLoaded((String)"Thaumcraft")) {
            boolean thaumcraftGhostApiPresent = false;
            try {
                Class.forName("thaumcraft.api.ThaumcraftApi");
                thaumcraftGhostApiPresent = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (thaumcraftGhostApiPresent) {
                try {
                    ArchaicLogger.LOGGER.info("Cleared " + ThaumcraftApi.objectTags.size() + " unused Thaumcraft aspects");
                    ThaumcraftApi.objectTags.clear();
                }
                catch (IncompatibleClassChangeError e) {
                    ArchaicLogger.LOGGER.info("Thaumcraft does not have an objectTags field");
                }
                try {
                    ArchaicLogger.LOGGER.info("Cleared " + ThaumcraftApi.groupedObjectTags.size() + " unused Thaumcraft grouped aspects");
                    ThaumcraftApi.groupedObjectTags.clear();
                }
                catch (IncompatibleClassChangeError e) {
                    ArchaicLogger.LOGGER.info("Thaumcraft does not have a groupedObjectTags field");
                }
            }
        }
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        proxy.loadcomplete();
        this.printRecipeDebug();
        this.removeThaumcraftLeak();
    }

    @NetworkCheckHandler
    public boolean doVersionCheck(Map<String, String> mods, Side side) {
        return true;
    }

    public static boolean isArchaicConnection(NetHandlerPlayServer connection) {
        return FixHelper.unmoddedNetHandlers.contains(connection);
    }
}

