/*
 * Decompiled with CFR 0.152.
 */
package appeng.services;

import appeng.api.AEApi;
import appeng.api.util.DimensionalCoord;
import appeng.services.compass.CompassReader;
import appeng.services.compass.ICompassCallback;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.WorldEvent;

public final class CompassService {
    private static final int CHUNK_SIZE = 16;
    private static final int CLEANUP_TIMEOUT_IN_SECONDS = 60;
    private final Map<World, AutoClosingCompassReader> worldSet = new HashMap<World, AutoClosingCompassReader>(10);
    private final ScheduledExecutorService executor;
    private final File worldCompassFolder;

    public CompassService(@Nonnull File worldCompassFolder, @Nonnull ThreadFactory factory) {
        Preconditions.checkNotNull((Object)worldCompassFolder);
        this.worldCompassFolder = worldCompassFolder;
        this.executor = Executors.newSingleThreadScheduledExecutor(factory);
    }

    public Future<?> getCompassDirection(DimensionalCoord coord, int maxRange, ICompassCallback cc) {
        return this.executor.submit(new CMDirectionRequest(coord, maxRange, cc));
    }

    @SubscribeEvent
    public void unloadWorld(WorldEvent.Unload event) {
        if (Platform.isServer() && this.worldSet.containsKey(event.world)) {
            AutoClosingCompassReader compassReader = this.worldSet.remove(event.world);
            compassReader.close();
        }
    }

    private void cleanUp() {
        for (AutoClosingCompassReader cr : this.worldSet.values()) {
            cr.close();
        }
    }

    public void updateArea(World w, int chunkX, int chunkZ) {
        int x = chunkX << 4;
        int z = chunkZ << 4;
        this.updateArea(w, x, 16, z);
        this.updateArea(w, x, 48, z);
        this.updateArea(w, x, 80, z);
        this.updateArea(w, x, 112, z);
        this.updateArea(w, x, 144, z);
        this.updateArea(w, x, 176, z);
        this.updateArea(w, x, 208, z);
        this.updateArea(w, x, 240, z);
    }

    public Future<?> updateArea(World w, int x, int y, int z) {
        int cx = x >> 4;
        int cdy = y >> 5;
        int cz = z >> 4;
        int low_y = cdy << 5;
        int hi_y = low_y + 32;
        Chunk c = w.func_72938_d(x, z);
        for (Block skyStoneBlock : AEApi.instance().definitions().blocks().skyStone().maybeBlock().asSet()) {
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    for (int k = low_y; k < hi_y; ++k) {
                        Block blk = c.func_150810_a(i, k, j);
                        if (blk != skyStoneBlock || c.func_76628_c(i, k, j) != 0) continue;
                        return this.executor.submit(new CMUpdatePost(w, cx, cz, cdy, true));
                    }
                }
            }
        }
        return this.executor.submit(new CMUpdatePost(w, cx, cz, cdy, false));
    }

    public void kill() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(6L, TimeUnit.MINUTES);
            for (AutoClosingCompassReader cr : this.worldSet.values()) {
                cr.close();
            }
            this.worldSet.clear();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private CompassReader getReader(World w) {
        AutoClosingCompassReader cr = this.worldSet.get(w);
        if (cr == null) {
            CompassReader reader = new CompassReader(w.field_73011_w.field_76574_g, this.worldCompassFolder);
            cr = new AutoClosingCompassReader(reader, this.executor);
            this.worldSet.put(w, cr);
        }
        return cr.get();
    }

    private int dist(int ax, int az, int bx, int bz) {
        int up = (bz - az) * 16;
        int side = (bx - ax) * 16;
        return up * up + side * side;
    }

    private double rad(int ax, int az, int bx, int bz) {
        int up = bz - az;
        int side = bx - ax;
        return Math.atan2(-up, side) - 1.5707963267948966;
    }

    private class CMDirectionRequest
    implements Runnable {
        public final int maxRange;
        public final DimensionalCoord coord;
        public final ICompassCallback callback;

        public CMDirectionRequest(DimensionalCoord coord, int getMaxRange, ICompassCallback cc) {
            this.coord = coord;
            this.maxRange = getMaxRange;
            this.callback = cc;
        }

        @Override
        public void run() {
            int cx = this.coord.x >> 4;
            int cz = this.coord.z >> 4;
            CompassReader cr = CompassService.this.getReader(this.coord.getWorld());
            if (cr.hasBeacon(cx, cz)) {
                this.callback.calculatedDirection(true, true, -999.0, 0.0);
                return;
            }
            for (int offset = 1; offset < this.maxRange; ++offset) {
                int closeness;
                int minX = cx - offset;
                int minZ = cz - offset;
                int maxX = cx + offset;
                int maxZ = cz + offset;
                int closest = Integer.MAX_VALUE;
                int chosen_x = cx;
                int chosen_z = cz;
                for (int z = minZ; z <= maxZ; ++z) {
                    if (cr.hasBeacon(minX, z) && (closeness = CompassService.this.dist(cx, cz, minX, z)) < closest) {
                        closest = closeness;
                        chosen_x = minX;
                        chosen_z = z;
                    }
                    if (!cr.hasBeacon(maxX, z) || (closeness = CompassService.this.dist(cx, cz, maxX, z)) >= closest) continue;
                    closest = closeness;
                    chosen_x = maxX;
                    chosen_z = z;
                }
                for (int x = minX + 1; x < maxX; ++x) {
                    if (cr.hasBeacon(x, minZ) && (closeness = CompassService.this.dist(cx, cz, x, minZ)) < closest) {
                        closest = closeness;
                        chosen_x = x;
                        chosen_z = minZ;
                    }
                    if (!cr.hasBeacon(x, maxZ) || (closeness = CompassService.this.dist(cx, cz, x, maxZ)) >= closest) continue;
                    closest = closeness;
                    chosen_x = x;
                    chosen_z = maxZ;
                }
                if (closest >= Integer.MAX_VALUE) continue;
                this.callback.calculatedDirection(true, false, CompassService.this.rad(cx, cz, chosen_x, chosen_z), CompassService.this.dist(cx, cz, chosen_x, chosen_z));
                return;
            }
            this.callback.calculatedDirection(false, true, -999.0, 999.0);
        }
    }

    private static class AutoClosingCompassReader {
        private final CompassReader cr;
        private final ScheduledExecutorService executorService;
        private final Runnable closeTask = new Runnable(){

            @Override
            public void run() {
                cr.close();
            }
        };
        private ScheduledFuture<?> scheduledCloseTask = null;

        public AutoClosingCompassReader(CompassReader cr, ScheduledExecutorService executorService) {
            this.cr = cr;
            this.executorService = executorService;
        }

        public CompassReader get() {
            if (this.scheduledCloseTask != null) {
                this.scheduledCloseTask.cancel(false);
            }
            this.scheduledCloseTask = this.executorService.schedule(this.closeTask, 60L, TimeUnit.SECONDS);
            return this.cr;
        }

        public void close() {
            if (this.scheduledCloseTask != null) {
                this.scheduledCloseTask.cancel(false);
            }
            this.cr.close();
        }
    }

    private class CMUpdatePost
    implements Runnable {
        public final World world;
        public final int chunkX;
        public final int chunkZ;
        public final int doubleChunkY;
        public final boolean value;

        public CMUpdatePost(World w, int cx, int cz, int dcy, boolean val) {
            this.world = w;
            this.chunkX = cx;
            this.doubleChunkY = dcy;
            this.chunkZ = cz;
            this.value = val;
        }

        @Override
        public void run() {
            CompassReader cr = CompassService.this.getReader(this.world);
            cr.setHasBeacon(this.chunkX, this.chunkZ, this.doubleChunkY, this.value);
        }
    }
}

