/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.INetworkToolItem;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.core.features.AEFeature;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.items.AEBaseItem;
import appeng.items.contents.NetworkToolViewer;
import appeng.items.materials.ItemMultiMaterial;
import appeng.parts.automation.UpgradeInventory;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ToolMemoryCard
extends AEBaseItem
implements IMemoryCard {
    public ToolMemoryCard() {
        this.setFeature(EnumSet.of(AEFeature.Core));
        this.func_77625_d(1);
    }

    @Override
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        lines.add(this.getLocalizedName(this.getSettingsName(stack) + ".name", this.getSettingsName(stack)));
        NBTTagCompound data = this.getData(stack);
        if (data.func_74764_b("tooltip")) {
            lines.add(StatCollector.func_74838_a((String)this.getLocalizedName(data.func_74779_i("tooltip") + ".name", data.func_74779_i("tooltip"))));
        }
        if (data.func_74764_b("freq")) {
            long freq = data.func_74763_f("freq");
            String freqTooltip = String.format("%X", freq).replaceAll("(.{4})", "$0 ").trim();
            String local = ButtonToolTips.P2PFrequency.getLocal();
            lines.add(String.format(local, freqTooltip));
        }
        if (data.func_74764_b("custom_name")) {
            lines.add(data.func_74779_i("custom_name"));
        } else if (data.func_74764_b("display") && data.func_74775_l("display").func_74764_b("Name")) {
            lines.add(data.func_74775_l("display").func_74779_i("Name"));
        }
    }

    private String getLocalizedName(String ... name) {
        for (String n3 : name) {
            String l = StatCollector.func_74838_a((String)n3);
            if (l.equals(n3)) continue;
            return l;
        }
        int n = 0;
        String[] stringArray = name;
        int n2 = stringArray.length;
        if (n < n2) {
            String n3;
            n3 = stringArray[n];
            return n3;
        }
        return "";
    }

    @Override
    public void setMemoryCardContents(ItemStack is, String settingsName, NBTTagCompound data) {
        NBTTagCompound c = Platform.openNbtData(is);
        c.func_74778_a("Config", settingsName);
        c.func_74782_a("Data", (NBTBase)data);
    }

    @Override
    public String getSettingsName(ItemStack is) {
        NBTTagCompound c = Platform.openNbtData(is);
        String name = c.func_74779_i("Config");
        return name == null || name.isEmpty() ? GuiText.Blank.getUnlocalized() : name;
    }

    @Override
    public NBTTagCompound getData(ItemStack is) {
        NBTTagCompound c = Platform.openNbtData(is);
        NBTTagCompound o = c.func_74775_l("Data");
        if (o == null) {
            o = new NBTTagCompound();
        }
        return (NBTTagCompound)o.func_74737_b();
    }

    @Override
    public void notifyUser(EntityPlayer player, MemoryCardMessages msg) {
        if (Platform.isClient()) {
            return;
        }
        switch (msg) {
            case SETTINGS_CLEARED: {
                player.func_145747_a(PlayerMessages.SettingCleared.get());
                break;
            }
            case INVALID_MACHINE: {
                player.func_145747_a(PlayerMessages.InvalidMachine.get());
                break;
            }
            case SETTINGS_LOADED: {
                player.func_145747_a(PlayerMessages.LoadedSettings.get());
                break;
            }
            case SETTINGS_SAVED: {
                player.func_145747_a(PlayerMessages.SavedSettings.get());
                break;
            }
        }
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer player, World w, int x, int y, int z, int side, float hx, float hy, float hz) {
        if (player.func_70093_af() && !w.field_72995_K) {
            if (ForgeEventFactory.onItemUseStart((EntityPlayer)player, (ItemStack)is, (int)1) <= 0) {
                return false;
            }
            IMemoryCard mem = (IMemoryCard)is.func_77973_b();
            mem.notifyUser(player, MemoryCardMessages.SETTINGS_CLEARED);
            is.func_77982_d(null);
            return true;
        }
        return super.func_77648_a(is, player, w, x, y, z, side, hx, hy, hz);
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    public static void setUpgradesInfo(NBTTagCompound data, UpgradeInventory ui) {
        if (ui != null) {
            NBTTagList tagList = new NBTTagList();
            for (int i = 0; i < ui.func_70302_i_(); ++i) {
                ItemStack uis = ui.func_70301_a(i);
                NBTTagCompound newIs = new NBTTagCompound();
                if (uis != null) {
                    uis.func_77955_b(newIs);
                }
                tagList.func_74742_a((NBTBase)newIs);
            }
            if (tagList.func_74745_c() > 0) {
                data.func_74782_a("upgradesList", (NBTBase)tagList);
            }
        }
    }

    public static void insertUpgrades(NBTTagCompound data, EntityPlayer player, UpgradeInventory up) {
        NBTTagList tagList = data.func_150295_c("upgradesList", 10);
        ArrayList<Object> memoryList = new ArrayList<Object>(Collections.nCopies(tagList.func_74745_c(), null));
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            if (up.func_70301_a(i) != null) continue;
            ItemStack item = ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(i));
            memoryList.set(i, item);
        }
        if (!memoryList.stream().allMatch(Objects::isNull)) {
            int resolved = 0;
            block1: for (int j = 0; j < player.field_71071_by.func_70302_i_(); ++j) {
                ItemStack pi = player.field_71071_by.func_70301_a(j);
                if (pi == null) continue;
                if (pi.func_77973_b() instanceof ItemMultiMaterial) {
                    for (ItemStack itemStack : memoryList) {
                        if (itemStack == null || itemStack.field_77994_a <= 0 || !itemStack.func_77969_a(pi)) continue;
                        itemStack.field_77994_a = 0;
                        player.field_71071_by.func_70298_a(j, 1);
                        player.func_70071_h_();
                        ++resolved;
                    }
                    if (resolved != memoryList.size()) continue;
                    break;
                }
                Item item = pi.func_77973_b();
                if (!(item instanceof INetworkToolItem)) continue;
                INetworkToolItem inti = (INetworkToolItem)item;
                NetworkToolViewer ntv = new NetworkToolViewer(pi, null, inti.getInventorySize());
                for (int i = 0; i < ntv.func_70302_i_(); ++i) {
                    ItemStack isv = ntv.func_70301_a(i);
                    if (isv == null) continue;
                    for (ItemStack itemStack : memoryList) {
                        if (itemStack == null || itemStack.field_77994_a <= 0 || !itemStack.func_77969_a(isv)) continue;
                        itemStack.field_77994_a = 0;
                        ++resolved;
                        ntv.func_70298_a(i, 1);
                        ntv.func_70296_d();
                    }
                    if (resolved == memoryList.size()) continue block1;
                }
            }
            for (int i = 0; i < memoryList.size(); ++i) {
                ItemStack is = (ItemStack)memoryList.get(i);
                if (is == null || is.field_77994_a != 0) continue;
                is.field_77994_a = 1;
                up.func_70299_a(i, is);
            }
        }
    }
}

