/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.config.PinsState;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.implementations.ContainerMEMonitorable;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.helpers.IPinsHandler;
import appeng.util.item.AEItemStack;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;

public class PacketPinsUpdate
extends AppEngPacket {
    @Nullable
    private final IAEItemStack[] list;
    @Nullable
    private final PinsState state;

    public PacketPinsUpdate(ByteBuf stream) throws IOException {
        int arrLength = stream.readInt();
        int stateOrdinal = stream.readInt();
        this.state = stateOrdinal >= 0 ? PinsState.values()[stateOrdinal] : null;
        if (arrLength < 0) {
            this.list = null;
            return;
        }
        this.list = new IAEItemStack[arrLength];
        for (int i = 0; i < this.list.length; ++i) {
            if (!stream.readBoolean()) continue;
            this.list[i] = AEItemStack.loadItemStackFromPacket(stream);
        }
    }

    public PacketPinsUpdate(IAEItemStack[] arr, PinsState state) throws IOException {
        this.list = arr;
        this.state = state;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(arr.length);
        data.writeInt(state.ordinal());
        for (IAEItemStack aeItemStack : arr) {
            if (aeItemStack != null) {
                data.writeBoolean(true);
                aeItemStack.writeToPacket(data);
                continue;
            }
            data.writeBoolean(false);
        }
        this.configureWrite(data);
    }

    public PacketPinsUpdate(PinsState state) throws IOException {
        this.state = state;
        this.list = null;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(-1);
        data.writeInt(state.ordinal());
        this.configureWrite(data);
    }

    public PacketPinsUpdate(IAEItemStack[] arr) throws IOException {
        this.list = arr;
        this.state = null;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(arr.length);
        data.writeInt(-1);
        for (IAEItemStack aeItemStack : arr) {
            if (aeItemStack != null) {
                data.writeBoolean(true);
                aeItemStack.writeToPacket(data);
                continue;
            }
            data.writeBoolean(false);
        }
        this.configureWrite(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        GuiScreen gs = Minecraft.func_71410_x().field_71462_r;
        if (gs instanceof IPinsHandler) {
            IPinsHandler iph = (IPinsHandler)gs;
            if (this.list != null) {
                iph.setAEPins(this.list);
            }
        }
    }

    @Override
    public void serverPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        EntityPlayerMP sender = (EntityPlayerMP)player;
        Container container = sender.field_71070_bA;
        if (container instanceof ContainerMEMonitorable) {
            ContainerMEMonitorable container2 = (ContainerMEMonitorable)container;
            if (this.state != null) {
                container2.setPinsState(this.state);
            }
        }
    }
}

