/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.core.AEConfig;
import appeng.core.AEJSONConfig;
import appeng.core.AELog;
import appeng.core.CommonHelper;
import appeng.core.CreativeTab;
import appeng.core.CreativeTabFacade;
import appeng.core.FacadeConfig;
import appeng.core.IMCHandler;
import appeng.core.Registration;
import appeng.core.crash.CrashInfo;
import appeng.core.crash.IntegrationCrashEnhancement;
import appeng.core.crash.ModCrashEnhancement;
import appeng.core.features.AEFeature;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.worlddata.WorldData;
import appeng.hooks.TickHandler;
import appeng.integration.IntegrationRegistry;
import appeng.recipes.CustomRecipeConfig;
import appeng.recipes.CustomRecipeForgeConfiguration;
import appeng.server.AECommand;
import appeng.services.export.ExportConfig;
import appeng.services.export.ExportProcess;
import appeng.services.export.ForgeExportConfig;
import appeng.util.InvTweakSortingModule;
import appeng.util.Platform;
import com.google.common.base.Stopwatch;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="appliedenergistics2", acceptedMinecraftVersions="[1.7.10]", name="Applied Energistics 2", version="rv3-beta-635-GTNH-pre", dependencies="after:appliedenergistics2-core;required-after:Forge@[10.13.4.1614,);required-after:gtnhlib@[0.6.11,)", guiFactory="appeng.client.gui.config.AEConfigGuiFactory")
public final class AppEng {
    public static final String MOD_ID = "appliedenergistics2";
    public static final String MOD_NAME = "Applied Energistics 2";
    public static final String MOD_DEPENDENCIES = "after:appliedenergistics2-core;required-after:Forge@[10.13.4.1614,);required-after:gtnhlib@[0.6.11,)";
    @Nonnull
    private static final AppEng INSTANCE = new AppEng();
    private final Registration registration;
    private File configDirectory;
    private CustomRecipeConfig customRecipeConfig;
    private File recipeDirectory;
    private ExportConfig exportConfig;

    AppEng() {
        FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)new ModCrashEnhancement(CrashInfo.MOD_VERSION));
        this.registration = new Registration();
    }

    @Nonnull
    @Mod.InstanceFactory
    public static AppEng instance() {
        return INSTANCE;
    }

    @Nonnull
    public final Registration getRegistration() {
        return this.registration;
    }

    @Mod.EventHandler
    private void preInit(FMLPreInitializationEvent event) {
        if (!Loader.isModLoaded((String)"appliedenergistics2-core")) {
            CommonHelper.proxy.missingCoreMod();
        }
        Stopwatch watch = Stopwatch.createStarted();
        this.configDirectory = new File(event.getModConfigurationDirectory().getPath(), "AppliedEnergistics2");
        this.recipeDirectory = new File(this.configDirectory, "recipes");
        File configFile = new File(this.configDirectory, "AppliedEnergistics2.cfg");
        File jsonConfigFile = new File(this.configDirectory, "MeteoriteLootTable.json");
        File facadeFile = new File(this.configDirectory, "Facades.cfg");
        File recipeFile = new File(this.configDirectory, "CustomRecipes.cfg");
        Configuration recipeConfiguration = new Configuration(recipeFile);
        AEConfig.instance = new AEConfig(configFile);
        AEJSONConfig.instance = new AEJSONConfig();
        AEJSONConfig.instance.fromFile(jsonConfigFile);
        FacadeConfig.instance = new FacadeConfig(facadeFile);
        this.customRecipeConfig = new CustomRecipeForgeConfiguration(recipeConfiguration);
        this.exportConfig = new ForgeExportConfig(recipeConfiguration);
        AELog.info("Pre Initialization ( started )", new Object[0]);
        CreativeTab.init();
        if (AEConfig.instance.isFeatureEnabled(AEFeature.Facades)) {
            CreativeTabFacade.init();
        }
        if (Platform.isClient()) {
            CommonHelper.proxy.init();
        }
        this.registration.preInitialize(event);
        AELog.info("Pre Initialization ( ended after " + watch.elapsed(TimeUnit.MILLISECONDS) + "ms )", new Object[0]);
    }

    private void startService(String serviceName, Thread thread) {
        thread.setName(serviceName);
        thread.setPriority(1);
        AELog.info("Starting " + serviceName, new Object[0]);
        thread.start();
    }

    @Mod.EventHandler
    private void init(FMLInitializationEvent event) {
        Stopwatch start = Stopwatch.createStarted();
        AELog.info("Initialization ( started )", new Object[0]);
        if (this.exportConfig.isExportingItemNamesEnabled()) {
            ExportProcess process = new ExportProcess(this.recipeDirectory, this.exportConfig);
            Thread exportProcessThread = new Thread(process);
            this.startService("AE2 CSV Export", exportProcessThread);
        }
        if (Platform.isClient()) {
            InvTweakSortingModule.init();
        }
        this.registration.initialize(event, this.recipeDirectory, this.customRecipeConfig);
        IntegrationRegistry.INSTANCE.init();
        AELog.info("Initialization ( ended after " + start.elapsed(TimeUnit.MILLISECONDS) + "ms )", new Object[0]);
    }

    @Mod.EventHandler
    private void postInit(FMLPostInitializationEvent event) {
        Stopwatch start = Stopwatch.createStarted();
        AELog.info("Post Initialization ( started )", new Object[0]);
        this.registration.postInit(event);
        IntegrationRegistry.INSTANCE.postInit();
        FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)new IntegrationCrashEnhancement());
        CommonHelper.proxy.postInit();
        AEConfig.instance.save();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)GuiBridge.GUI_Handler);
        NetworkHandler.instance = new NetworkHandler("AE2");
        AELog.info("Post Initialization ( ended after " + start.elapsed(TimeUnit.MILLISECONDS) + "ms )", new Object[0]);
    }

    @Mod.EventHandler
    private void handleIMCEvent(FMLInterModComms.IMCEvent event) {
        IMCHandler imcHandler = new IMCHandler();
        imcHandler.handleIMCEvent(event);
    }

    @Mod.EventHandler
    private void serverAboutToStart(FMLServerAboutToStartEvent evt) {
        WorldData.onServerAboutToStart();
    }

    @Mod.EventHandler
    private void serverStopping(FMLServerStoppingEvent event) {
        WorldData.instance().onServerStopping();
    }

    @Mod.EventHandler
    private void serverStopped(FMLServerStoppedEvent event) {
        if (WorldData.instance() != null) {
            WorldData.instance().onServerStoppped();
        }
        TickHandler.INSTANCE.shutdown();
    }

    @Mod.EventHandler
    private void serverStarting(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new AECommand(evt.getServer()));
    }
}

