/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.world.gen;

import com.gildedgames.the_aether.world.gen.AetherStructure;
import com.gildedgames.the_aether.world.gen.components.ComponentGoldenDungeon;
import com.gildedgames.the_aether.world.gen.components.ComponentGoldenIsland;
import com.gildedgames.the_aether.world.gen.components.ComponentGoldenIslandStub;
import com.gildedgames.the_aether.world.util.RandomTracker;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenGoldenDungeon
extends MapGenStructure {
    public String func_143025_a() {
        return "aether_legacy:golden_dungeon";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        RandomTracker randomTracker = new RandomTracker();
        if (randomTracker.testRandom(this.field_75038_b, 140) != 0 && randomTracker.testRandom(this.field_75038_b, 170) != 0) {
            return false;
        }
        return chunkX % 10 == 0 && chunkZ % 10 == 0;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    public static class Start
    extends StructureStart {
        private int dungeonDirection;
        private int stubIslandCount;

        public Start() {
        }

        public Start(World worldIn, Random random, int chunkX, int chunkZ) {
            super(chunkX, chunkZ);
            this.create(worldIn, random, chunkX, chunkZ);
        }

        private void create(World worldIn, Random random, int chunkX, int chunkZ) {
            random.setSeed(worldIn.func_72905_C());
            long i = random.nextLong();
            long j = random.nextLong();
            long k = (long)chunkX * i;
            long l = (long)chunkZ * j;
            random.setSeed(k ^ l ^ worldIn.func_72905_C());
            ComponentGoldenIsland dungeon = new ComponentGoldenIsland((chunkX << 4) + 2, (chunkZ << 4) + 2);
            this.dungeonDirection = random.nextInt(4);
            this.stubIslandCount = 8 + random.nextInt(5);
            this.field_75075_a.add(dungeon);
            for (int stubIslands = 0; stubIslands < this.stubIslandCount; ++stubIslands) {
                float f1 = 0.01745329f;
                float f2 = random.nextFloat() * 360.0f;
                float f3 = (random.nextFloat() * 0.125f + 0.7f) * 24.0f;
                int l4 = MathHelper.func_76128_c((double)(Math.cos(f1 * f2) * (double)f3));
                int k5 = -MathHelper.func_76128_c((double)(24.0 * (double)random.nextFloat() * 0.3));
                int i6 = MathHelper.func_76128_c((double)(-Math.sin(f1 * f2) * (double)f3));
                this.field_75075_a.add(new ComponentGoldenIslandStub((chunkX << 4) + 2, (chunkZ << 4) + 2, l4, k5, i6, 8));
            }
            this.field_75075_a.add(new ComponentGoldenDungeon((chunkX << 4) + 2, (chunkZ << 4) + 2, this.dungeonDirection));
            this.customOffset(random);
            this.func_75072_c();
        }

        private void customOffset(Random random) {
            int offset = random.nextInt(64);
            for (Object object : this.field_75075_a) {
                AetherStructure component = (AetherStructure)((Object)object);
                component.func_74874_b().func_78886_a(0, offset, 0);
            }
        }

        public void func_143022_a(NBTTagCompound tagCompound) {
            super.func_143022_a(tagCompound);
            tagCompound.func_74768_a("stubIslandCount", this.stubIslandCount);
            tagCompound.func_74768_a("dungeonDirection", this.dungeonDirection);
        }

        public void func_143017_b(NBTTagCompound tagCompound) {
            super.func_143017_b(tagCompound);
            this.stubIslandCount = tagCompound.func_74762_e("stubIslandCount");
            this.dungeonDirection = tagCompound.func_74762_e("dungeonDirection");
        }
    }
}

