/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.world.dungeon;

import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.entities.bosses.slider.EntitySlider;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.world.dungeon.util.AetherDungeon;
import com.gildedgames.the_aether.world.dungeon.util.PositionData;
import com.gildedgames.the_aether.world.util.RandomTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;

public class BronzeDungeon
extends AetherDungeon {
    private boolean needsCorridor = false;
    private int roomMaximum;
    private int roomCount;

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        this.replaceAir = true;
        this.replaceSolid = true;
        this.roomMaximum = random.nextInt(4) + 2;
        this.roomCount = 0;
        this.generateBossRoom(world, random, i, j, k);
        return true;
    }

    public boolean generateBossRoom(World world, Random random, int i, int j, int k) {
        if (!this.isBoxSolid(world, new PositionData(i, j - 3, k), new PositionData(16, 18, 16)) || !this.isBoxSolid(world, new PositionData(i + 20, j, k + 2), new PositionData(12, 12, 12))) {
            return false;
        }
        RandomTracker randomTracker = new RandomTracker();
        if (randomTracker.testRandom(random, 15) != 0 && randomTracker.testRandom(random, 40) != 0) {
            return false;
        }
        this.setBlocks(this.lockedBlock(), this.lockedLightBlock(), 20);
        this.addHollowBox(world, random, new PositionData(i, j, k), new PositionData(16, 12, 16));
        this.addHollowBox(world, random, new PositionData(i + 6, j - 2, k + 6), new PositionData(4, 4, 4));
        EntitySlider slider = new EntitySlider(world);
        slider.func_70107_b(i + 8, j + 2, k + 8);
        slider.setDungeon(slider.field_70165_t - 8.0, slider.field_70163_u - 2.0, slider.field_70161_v - 8.0);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)slider);
        }
        world.func_147449_b(i + 7, j - 1, k + 7, BlocksAether.treasure_chest);
        this.generateEmptyRoom(world, random, i, j, k);
        return true;
    }

    public boolean generateEmptyRoom(World world, Random random, int i, int j, int k) {
        int x = i;
        int y = j;
        int z = k;
        int rooms = random.nextInt(4);
        switch (rooms) {
            case 0: {
                x = i + 20;
                y = j;
                z = k + 2;
                if (!this.isBoxSolid(world, new PositionData(x, y, z), new PositionData(12, 12, 12))) {
                    return true;
                }
                this.setBlocks(this.mainBlock(), this.mainLightBlock(), 20);
                this.addHollowBox(world, random, new PositionData(x, y, z), new PositionData(12, 12, 12));
                this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                this.addSquareTube(world, random, new PositionData(x - 5, y, z + 3), new PositionData(6, 6, 6), 0);
                for (int p = x + 2; p < x + 10; p += 3) {
                    for (int q = z + 2; q < z + 10; q += 3) {
                        world.func_147465_d(p, j, q, BlocksAether.carved_trap, 0, 2);
                    }
                }
                break;
            }
            case 1: {
                x = i - 16;
                y = j;
                z = k + 2;
                if (!this.isBoxSolid(world, new PositionData(x, y, z), new PositionData(12, 12, 12))) {
                    return true;
                }
                this.setBlocks(this.mainBlock(), this.mainLightBlock(), 20);
                this.addHollowBox(world, random, new PositionData(x, y, z), new PositionData(12, 12, 12));
                this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                this.addSquareTube(world, random, new PositionData(x + 11, y, z + 3), new PositionData(6, 6, 6), 0);
                for (int p = x + 2; p < x + 10; p += 3) {
                    for (int q = z + 2; q < z + 10; q += 3) {
                        world.func_147465_d(p, j, q, BlocksAether.carved_trap, 0, 2);
                    }
                }
                break;
            }
            case 2: {
                x = i + 2;
                y = j;
                z = k + 20;
                if (!this.isBoxSolid(world, new PositionData(x, y, z), new PositionData(12, 12, 12))) {
                    return true;
                }
                this.setBlocks(this.mainBlock(), this.mainLightBlock(), 20);
                this.addHollowBox(world, random, new PositionData(x, y, z), new PositionData(12, 12, 12));
                this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                this.addSquareTube(world, random, new PositionData(x + 3, y, z - 5), new PositionData(6, 6, 6), 2);
                for (int p = x + 2; p < x + 10; p += 3) {
                    for (int q = z + 2; q < z + 10; q += 3) {
                        world.func_147465_d(p, j, q, BlocksAether.carved_trap, 0, 2);
                    }
                }
                break;
            }
            case 3: {
                x = i + 2;
                y = j;
                z = k - 16;
                if (!this.isBoxSolid(world, new PositionData(x, y, z), new PositionData(12, 12, 12))) {
                    return true;
                }
                this.setBlocks(this.mainBlock(), this.mainLightBlock(), 20);
                this.addHollowBox(world, random, new PositionData(x, y, z), new PositionData(12, 12, 12));
                this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                this.addSquareTube(world, random, new PositionData(x + 3, y, z + 11), new PositionData(6, 6, 6), 2);
                for (int p = x + 2; p < x + 10; p += 3) {
                    for (int q = z + 2; q < z + 10; q += 3) {
                        world.func_147465_d(p, j, q, BlocksAether.carved_trap, 0, 2);
                    }
                }
                break;
            }
        }
        if (!this.determineRoomPosition(world, random, new PositionData(x, y, z)) && this.roomCount == 0) {
            return false;
        }
        if (this.needsCorridor) {
            this.endCorridor(world, random, new PositionData(x, y, z));
        }
        return true;
    }

    public boolean determineRoomPosition(World world, Random random, PositionData pos) {
        if (this.roomCount >= this.roomMaximum) {
            this.needsCorridor = true;
            return true;
        }
        ArrayList<Integer> sides = new ArrayList<Integer>();
        sides.add(1);
        sides.add(2);
        sides.add(3);
        sides.add(4);
        Collections.shuffle(sides);
        if (this.generateRoomWithSide(world, random, pos, (Integer)sides.get(0))) {
            return true;
        }
        if (this.generateRoomWithSide(world, random, pos, (Integer)sides.get(1))) {
            return true;
        }
        if (this.generateRoomWithSide(world, random, pos, (Integer)sides.get(2))) {
            return true;
        }
        if (this.generateRoomWithSide(world, random, pos, (Integer)sides.get(3))) {
            return true;
        }
        this.needsCorridor = true;
        return false;
    }

    public boolean generateRoomWithSide(World world, Random random, PositionData pos, int switchCase) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int dir = 0;
        switch (switchCase) {
            case 1: {
                x += 16;
                z += 0;
                dir = 0;
                break;
            }
            case 2: {
                x += 0;
                z += 16;
                dir = 1;
                break;
            }
            case 3: {
                x -= 16;
                z += 0;
                dir = 2;
                break;
            }
            case 4: {
                x += 0;
                z -= 16;
                dir = 3;
            }
        }
        return this.generateNextRoom(world, random, new PositionData(x, y, z), dir);
    }

    public boolean generateNextRoom(World world, Random random, PositionData pos, int dir) {
        int q;
        int p;
        int z;
        int y;
        int x = pos.getX();
        if (!this.isBoxSolid(world, new PositionData(x, y = pos.getY(), z = pos.getZ()), new PositionData(12, 8, 12))) {
            return false;
        }
        this.setBlocks(this.mainBlock(), this.mainLightBlock(), 20);
        this.addHollowBox(world, random, new PositionData(x, y, z), new PositionData(12, 8, 12));
        for (p = x; p < x + 12; ++p) {
            for (q = y; q < y + 8; ++q) {
                for (int r = z; r < z + 12; ++r) {
                    if (world.func_147439_a(p, q, r) != this.mainBlock() || random.nextInt(100) != 0) continue;
                    world.func_147449_b(p, q, r, BlocksAether.carved_trap);
                }
            }
        }
        for (p = x + 2; p < x + 10; p += 7) {
            for (q = z + 2; q < z + 10; q += 7) {
                world.func_147449_b(p, pos.getY(), q, BlocksAether.carved_trap);
            }
        }
        this.addPlaneY(world, random, new PositionData(x + 4, y + 1, z + 4), new PositionData(4, 0, 4));
        int type = random.nextInt(2);
        int p2 = x + 5 + random.nextInt(2);
        int q2 = z + 5 + random.nextInt(2);
        switch (type) {
            case 0: {
                world.func_147449_b(p2, y + 2, q2, BlocksAether.chest_mimic);
                break;
            }
            case 1: {
                if (world.func_147439_a(p2, y + 2, q2) != Blocks.field_150350_a) break;
                world.func_147449_b(p2, y + 2, q2, (Block)Blocks.field_150486_ae);
                TileEntityChest chest = (TileEntityChest)world.func_147438_o(p2, y + 2, q2);
                for (p2 = 0; p2 < 3 + random.nextInt(3); ++p2) {
                    chest.func_70299_a(random.nextInt(chest.func_70302_i_()), this.getNormalLoot(random));
                }
                break;
            }
        }
        this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
        switch (dir) {
            case 0: {
                this.addSquareTube(world, random, new PositionData(x - 5, y, z + 3), new PositionData(6, 6, 6), 0);
                break;
            }
            case 1: {
                this.addSquareTube(world, random, new PositionData(x + 3, y, z - 5), new PositionData(6, 6, 6), 2);
                break;
            }
            case 2: {
                this.addSquareTube(world, random, new PositionData(x + 11, y, z + 3), new PositionData(6, 6, 6), 0);
                break;
            }
            case 3: {
                this.addSquareTube(world, random, new PositionData(x + 3, y, z + 11), new PositionData(6, 6, 6), 2);
            }
        }
        ++this.roomCount;
        if (!this.determineRoomPosition(world, random, new PositionData(x, y, z))) {
            return false;
        }
        return this.determineRoomPosition(world, random, new PositionData(x, y, z));
    }

    public boolean endCorridor(World world, Random random, PositionData pos) {
        ArrayList<Integer> sides = new ArrayList<Integer>();
        sides.add(1);
        sides.add(2);
        sides.add(3);
        sides.add(4);
        Collections.shuffle(sides);
        if (this.generateEndCorridor(world, random, pos, (Integer)sides.get(0))) {
            return true;
        }
        if (this.generateEndCorridor(world, random, pos, (Integer)sides.get(1))) {
            return true;
        }
        if (this.generateEndCorridor(world, random, pos, (Integer)sides.get(2))) {
            return true;
        }
        return this.generateEndCorridor(world, random, pos, (Integer)sides.get(3));
    }

    public boolean generateEndCorridor(World world, Random random, PositionData pos, int switchCase) {
        if (!this.needsCorridor) {
            return false;
        }
        this.replaceAir = false;
        switch (switchCase) {
            case 1: {
                boolean tunnelling = true;
                boolean maxLength = false;
                int x = pos.getX();
                int y = pos.getY();
                int z = pos.getZ();
                if (!this.isBoxSolid(world, new PositionData((x += 11) + 1, y, z += 3), new PositionData(2, 8, 6))) {
                    return false;
                }
                while (tunnelling) {
                    if (this.isBoxEmpty(world, new PositionData(x, y, z), new PositionData(1, 8, 6))) {
                        tunnelling = false;
                    }
                    if (this.hasBlock(world, new PositionData(x + 1, y, z), new PositionData(2, 8, 6), BlocksAether.carved_stone) || this.hasBlock(world, new PositionData(x + 1, y, z), new PositionData(2, 8, 6), BlocksAether.locked_carved_stone)) {
                        tunnelling = false;
                    }
                    if (x - pos.getX() > 100) {
                        maxLength = true;
                        tunnelling = false;
                    }
                    this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                    this.addPlaneX(world, random, new PositionData(x, y, z), new PositionData(0, 8, 6));
                    this.setBlocks(Blocks.field_150350_a, Blocks.field_150350_a, 1);
                    this.addPlaneX(world, random, new PositionData(x, y + 1, z + 1), new PositionData(0, 6, 4));
                    ++x;
                }
                if (maxLength) {
                    return false;
                }
                this.needsCorridor = false;
                return true;
            }
            case 2: {
                boolean tunnelling = true;
                boolean maxLength = false;
                int x = pos.getX();
                int y = pos.getY();
                int z = pos.getZ();
                if (!this.isBoxSolid(world, new PositionData((x += 0) - 1, y, z += 3), new PositionData(1, 8, 6))) {
                    return false;
                }
                while (tunnelling) {
                    if (this.isBoxEmpty(world, new PositionData(x, y, z), new PositionData(1, 8, 6))) {
                        tunnelling = false;
                    }
                    if (this.hasBlock(world, new PositionData(x - 1, y, z), new PositionData(1, 8, 6), BlocksAether.carved_stone) || this.hasBlock(world, new PositionData(x - 1, y, z), new PositionData(1, 8, 6), BlocksAether.locked_carved_stone)) {
                        tunnelling = false;
                    }
                    if (pos.getX() - x > 100) {
                        maxLength = true;
                        tunnelling = false;
                    }
                    this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                    this.addPlaneX(world, random, new PositionData(x, y, z), new PositionData(0, 8, 6));
                    this.setBlocks(Blocks.field_150350_a, Blocks.field_150350_a, 1);
                    this.addPlaneX(world, random, new PositionData(x, y + 1, z + 1), new PositionData(0, 6, 4));
                    --x;
                }
                if (maxLength) {
                    return false;
                }
                this.needsCorridor = false;
                return true;
            }
            case 3: {
                boolean tunnelling = true;
                boolean maxLength = false;
                int x = pos.getX();
                int y = pos.getY();
                int z = pos.getZ();
                if (!this.isBoxSolid(world, new PositionData(x += 3, y, (z += 11) + 1), new PositionData(6, 8, 2))) {
                    return false;
                }
                while (tunnelling) {
                    if (this.isBoxEmpty(world, new PositionData(x, y, z), new PositionData(6, 8, 1))) {
                        tunnelling = false;
                    }
                    if (this.hasBlock(world, new PositionData(x, y, z + 1), new PositionData(6, 8, 2), BlocksAether.carved_stone) || this.hasBlock(world, new PositionData(x, y, z + 1), new PositionData(6, 8, 2), BlocksAether.locked_carved_stone)) {
                        tunnelling = false;
                    }
                    if (z - pos.getZ() > 100) {
                        maxLength = true;
                        tunnelling = false;
                    }
                    this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                    this.addPlaneZ(world, random, new PositionData(x, y, z), new PositionData(6, 8, 0));
                    this.setBlocks(Blocks.field_150350_a, Blocks.field_150350_a, 1);
                    this.addPlaneZ(world, random, new PositionData(x + 1, y + 1, z), new PositionData(4, 6, 0));
                    ++z;
                }
                if (maxLength) {
                    return false;
                }
                this.needsCorridor = false;
                return true;
            }
            case 4: {
                boolean tunnelling = true;
                boolean maxLength = false;
                int x = pos.getX();
                int y = pos.getY();
                int z = pos.getZ();
                if (!this.isBoxSolid(world, new PositionData(x += 3, y, (z += 0) - 1), new PositionData(6, 8, 1))) {
                    return false;
                }
                while (tunnelling) {
                    if (this.isBoxEmpty(world, new PositionData(x, y, z), new PositionData(6, 8, 1))) {
                        tunnelling = false;
                    }
                    if (this.hasBlock(world, new PositionData(x, y, z - 1), new PositionData(6, 8, 1), BlocksAether.carved_stone) || this.hasBlock(world, new PositionData(x, y, z - 1), new PositionData(6, 8, 1), BlocksAether.locked_carved_stone)) {
                        tunnelling = false;
                    }
                    if (pos.getZ() - z > 100) {
                        maxLength = true;
                        tunnelling = false;
                    }
                    this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                    this.addPlaneZ(world, random, new PositionData(x, y, z), new PositionData(6, 8, 0));
                    this.setBlocks(Blocks.field_150350_a, Blocks.field_150350_a, 1);
                    this.addPlaneZ(world, random, new PositionData(x + 1, y + 1, z), new PositionData(4, 6, 0));
                    --z;
                }
                if (maxLength) {
                    return false;
                }
                this.needsCorridor = false;
                return true;
            }
        }
        return false;
    }

    private ItemStack getNormalLoot(Random random) {
        int item = random.nextInt(15);
        switch (item) {
            case 0: {
                return new ItemStack(ItemsAether.zanite_pickaxe);
            }
            case 1: {
                return new ItemStack(ItemsAether.zanite_axe);
            }
            case 2: {
                return new ItemStack(ItemsAether.zanite_sword);
            }
            case 3: {
                return new ItemStack(ItemsAether.zanite_shovel);
            }
            case 4: {
                return new ItemStack(ItemsAether.swet_cape);
            }
            case 5: {
                return new ItemStack(ItemsAether.ambrosium_shard, random.nextInt(10) + 1);
            }
            case 6: {
                return new ItemStack(ItemsAether.dart, random.nextInt(5) + 1, 0);
            }
            case 7: {
                return new ItemStack(ItemsAether.dart, random.nextInt(3) + 1, 1);
            }
            case 8: {
                return new ItemStack(ItemsAether.dart, random.nextInt(3) + 1, 2);
            }
            case 9: {
                if (random.nextInt(20) != 0) break;
                return new ItemStack(ItemsAether.aether_tune);
            }
            case 10: {
                return new ItemStack(ItemsAether.skyroot_bucket, 1, 2);
            }
            case 11: {
                if (random.nextInt(10) != 0) break;
                return new ItemStack(Items.field_151093_ce);
            }
            case 12: {
                if (random.nextInt(4) != 0) break;
                return new ItemStack(ItemsAether.iron_ring);
            }
            case 13: {
                if (random.nextInt(10) != 0) break;
                return new ItemStack(ItemsAether.golden_ring);
            }
        }
        return new ItemStack(BlocksAether.ambrosium_torch);
    }

    public static ItemStack getBronzeLoot(Random random) {
        int item = random.nextInt(10);
        switch (item) {
            case 0: {
                return new ItemStack(ItemsAether.gummy_swet, random.nextInt(7) + 1, random.nextInt(2));
            }
            case 1: {
                return new ItemStack(ItemsAether.phoenix_bow);
            }
            case 2: {
                return new ItemStack(ItemsAether.flaming_sword);
            }
            case 3: {
                return new ItemStack(ItemsAether.notch_hammer);
            }
            case 4: {
                return new ItemStack(ItemsAether.lightning_knife, random.nextInt(20) + 1);
            }
            case 5: {
                return new ItemStack(ItemsAether.valkyrie_lance);
            }
            case 6: {
                return new ItemStack(ItemsAether.agility_cape);
            }
            case 7: {
                return new ItemStack(ItemsAether.sentry_boots);
            }
            case 8: {
                return new ItemStack(ItemsAether.repulsion_shield);
            }
        }
        return new ItemStack(ItemsAether.cloud_staff);
    }

    public Block lockedLightBlock() {
        return BlocksAether.locked_sentry_stone;
    }

    public Block lockedBlock() {
        return BlocksAether.locked_carved_stone;
    }

    public Block mainLightBlock() {
        return BlocksAether.sentry_stone;
    }

    public Block mainBlock() {
        return BlocksAether.carved_stone;
    }

    public Block fillerBlock() {
        return BlocksAether.holystone;
    }

    public Block fillerBlock1() {
        return BlocksAether.mossy_holystone;
    }
}

