/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.world;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.network.AetherNetwork;
import com.gildedgames.the_aether.network.packets.PacketSendTime;
import com.gildedgames.the_aether.player.PlayerAether;
import com.gildedgames.the_aether.world.AetherData;
import com.gildedgames.the_aether.world.ChunkProviderAether;
import com.gildedgames.the_aether.world.WorldChunkManagerAether;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.IRenderHandler;

public class AetherWorldProvider
extends WorldProvider {
    private float[] colorsSunriseSunset = new float[4];
    private boolean eternalDay;
    private boolean shouldCycleCatchup;
    private long aetherTime = 6000L;

    protected void func_76572_b() {
        this.field_76578_c = new WorldChunkManagerAether();
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        int i;
        float f;
        if (!AetherConfig.eternalDayDisabled() && !this.field_76579_a.field_72995_K) {
            AetherData data = AetherData.getInstance(this.field_76579_a);
            if (data.isEternalDay()) {
                if (!data.isShouldCycleCatchup()) {
                    if (data.getAetherTime() != worldTime % 24000L && data.getAetherTime() != worldTime + 1L && data.getAetherTime() != worldTime - 1L) {
                        data.setAetherTime(Math.floorMod(data.getAetherTime() - 1L, 24000L));
                    } else {
                        data.setShouldCycleCatchup(true);
                    }
                } else {
                    data.setAetherTime(worldTime);
                }
                this.aetherTime = data.getAetherTime();
                AetherNetwork.sendToAll(new PacketSendTime(this.aetherTime));
                data.setAetherTime(this.aetherTime);
            } else {
                data.setAetherTime(6000L);
            }
        }
        if ((f = ((float)(i = (int)(AetherConfig.eternalDayDisabled() ? worldTime : this.aetherTime % 24000L)) + partialTicks) / 24000.0f - 0.25f) < 0.0f) {
            f += 1.0f;
        }
        if (f > 1.0f) {
            f -= 1.0f;
        }
        float f1 = 1.0f - (float)((Math.cos((double)f * Math.PI) + 1.0) / 2.0);
        f += (f1 - f) / 3.0f;
        return f;
    }

    public void setIsEternalDay(boolean set) {
        this.eternalDay = set;
    }

    public boolean getIsEternalDay() {
        return this.eternalDay;
    }

    public void setShouldCycleCatchup(boolean set) {
        this.shouldCycleCatchup = set;
    }

    public boolean getShouldCycleCatchup() {
        return this.shouldCycleCatchup;
    }

    public void setAetherTime(long time) {
        this.aetherTime = time;
    }

    public long getAetherTime() {
        return this.aetherTime;
    }

    public float[] func_76560_a(float f, float f1) {
        float f4;
        float f2 = 0.4f;
        float f3 = MathHelper.func_76134_b((float)(f * 3.141593f * 2.0f)) - 0.0f;
        if (f3 >= (f4 = -0.0f) - f2 && f3 <= f4 + f2) {
            float f5 = (f3 - f4) / f2 * 0.5f + 0.5f;
            float f6 = 1.0f - (1.0f - MathHelper.func_76126_a((float)(f5 * 3.141593f))) * 0.99f;
            f6 *= f6;
            this.colorsSunriseSunset[0] = f5 * 0.3f + 0.1f;
            this.colorsSunriseSunset[1] = f5 * f5 * 0.7f + 0.2f;
            this.colorsSunriseSunset[2] = f5 * f5 * 0.7f + 0.2f;
            this.colorsSunriseSunset[3] = f6;
            return this.colorsSunriseSunset;
        }
        return null;
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        return PlayerAether.get((EntityPlayer)player).getBedLocation() == null ? 0 : AetherConfig.getAetherDimensionID();
    }

    public boolean func_76566_a(int i, int j) {
        return false;
    }

    public boolean func_76567_e() {
        return false;
    }

    public IChunkProvider func_76555_c() {
        return new ChunkProviderAether(this.field_76579_a, this.field_76579_a.func_72905_C());
    }

    public boolean canDoLightning(Chunk chunk) {
        return false;
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return false;
    }

    public Vec3 func_76562_b(float f, float f1) {
        int i = 9671612;
        float f2 = MathHelper.func_76134_b((float)(f * 3.141593f * 2.0f)) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        float f3 = (float)(i >> 16 & 0xFF) / 255.0f;
        float f4 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f5 = (float)(i & 0xFF) / 255.0f;
        return Vec3.func_72443_a((double)(f3 *= f2 * 0.94f + 0.06f), (double)(f4 *= f2 * 0.94f + 0.06f), (double)(f5 *= f2 * 0.91f + 0.09f));
    }

    public String getSaveFolder() {
        return "Dim-Aether";
    }

    public double func_76565_k() {
        return 100.0;
    }

    public boolean func_76568_b(int x, int z) {
        return false;
    }

    public boolean func_76561_g() {
        return false;
    }

    public double getHorizon() {
        return 0.0;
    }

    public float func_76571_f() {
        return -5.0f;
    }

    public String func_80007_l() {
        return "the_aether";
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76564_j() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getWeatherRenderer() {
        return new IRenderHandler(){

            public void render(float partialTicks, WorldClient world, Minecraft mc) {
            }
        };
    }
}

