/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.tileentity;

import com.gildedgames.the_aether.api.AetherAPI;
import com.gildedgames.the_aether.api.events.AetherHooks;
import com.gildedgames.the_aether.api.freezables.AetherFreezable;
import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.blocks.container.BlockAetherContainer;
import com.gildedgames.the_aether.tileentity.util.AetherTileEntity;
import com.gildedgames.the_aether.util.FilledList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityFreezer
extends AetherTileEntity {
    public int progress;
    public int ticksRequired;
    public int powerRemaining;
    private final FilledList<ItemStack> frozenItemStacks = new FilledList<Object>(3, null);
    private AetherFreezable currentFreezable;

    public TileEntityFreezer() {
        super("Freezer");
    }

    @Override
    public List<ItemStack> getTileInventory() {
        return this.frozenItemStacks;
    }

    @Override
    public void onSlotChanged(int index) {
    }

    public void func_145845_h() {
        boolean flag = this.isFreezing();
        if (this.powerRemaining > 0) {
            --this.powerRemaining;
            if (this.currentFreezable != null) {
                this.progress = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) == BlocksAether.icestone ? (this.progress += 2) : ++this.progress;
            }
        }
        if (this.currentFreezable != null) {
            if (this.progress >= this.currentFreezable.getTimeRequired()) {
                if (!this.field_145850_b.field_72995_K) {
                    ItemStack result = this.currentFreezable.getOutput().func_77946_l();
                    EnchantmentHelper.func_82782_a((Map)EnchantmentHelper.func_82781_a((ItemStack)this.func_70301_a(0)), (ItemStack)result);
                    if (this.func_70301_a(0).func_77942_o()) {
                        result.func_77982_d(this.func_70301_a(0).func_77978_p());
                    }
                    if (this.func_70301_a(2) != null && this.func_70301_a(2).func_77985_e()) {
                        result.field_77994_a += this.func_70301_a((int)2).field_77994_a;
                        this.func_70299_a(2, result);
                    } else {
                        this.func_70299_a(2, result);
                    }
                    if (this.func_70301_a(0).func_77973_b().hasContainerItem(this.func_70301_a(0))) {
                        this.func_70299_a(0, this.func_70301_a(0).func_77973_b().getContainerItem(this.func_70301_a(0)));
                    } else {
                        this.func_70298_a(0, 1);
                    }
                }
                this.progress = 0;
                AetherHooks.onItemFreeze(this, this.currentFreezable);
            }
            if (this.func_70301_a(0) == null || this.func_70301_a(0) != null && AetherAPI.instance().getFreezable(this.func_70301_a(0)) != this.currentFreezable) {
                this.currentFreezable = null;
                this.progress = 0;
            }
            if (this.powerRemaining <= 0) {
                if (this.func_70301_a(1) != null && AetherAPI.instance().isFreezableFuel(this.func_70301_a(1))) {
                    this.powerRemaining += AetherAPI.instance().getFreezableFuel(this.func_70301_a(1)).getTimeGiven();
                    if (!this.field_145850_b.field_72995_K) {
                        this.func_70298_a(1, 1);
                    }
                } else {
                    this.currentFreezable = null;
                    this.progress = 0;
                }
            }
        } else if (this.func_70301_a(0) != null) {
            ItemStack itemstack = this.func_70301_a(0);
            AetherFreezable freezable = AetherAPI.instance().getFreezable(itemstack);
            if (freezable != null && (this.func_70301_a(2) == null || freezable.getOutput().func_77973_b() == this.func_70301_a(2).func_77973_b() && freezable.getOutput().func_77960_j() == this.func_70301_a(2).func_77960_j() && this.func_70301_a(2).func_77985_e())) {
                this.currentFreezable = freezable;
                this.ticksRequired = this.currentFreezable.getTimeRequired();
                this.addEnchantmentWeight(itemstack);
                this.ticksRequired = AetherHooks.onSetFreezableTime(this, this.currentFreezable, this.ticksRequired);
            }
        }
        if (flag != this.isFreezing()) {
            this.func_70296_d();
            BlockAetherContainer.setState(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.isFreezing());
        }
    }

    public void addEnchantmentWeight(ItemStack stack) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (!enchantments.isEmpty()) {
            Iterator iterator = enchantments.values().iterator();
            while (iterator.hasNext()) {
                int levels = (Integer)iterator.next();
                this.ticksRequired += levels * 1250;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getFreezingProgressScaled(int i) {
        if (this.ticksRequired == 0) {
            return 0;
        }
        return this.progress * i / this.ticksRequired;
    }

    @SideOnly(value=Side.CLIENT)
    public int getFreezingTimeRemaining(int i) {
        return this.powerRemaining * i / 500;
    }

    public boolean isFreezing() {
        return this.powerRemaining > 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.progress = compound.func_74762_e("progress");
        this.powerRemaining = compound.func_74762_e("powerRemaining");
        this.ticksRequired = compound.func_74762_e("ticksRequired");
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("progress", this.progress);
        compound.func_74768_a("powerRemaining", this.powerRemaining);
        compound.func_74768_a("ticksRequired", this.ticksRequired);
    }

    @Override
    public boolean isValidSlotItem(int slot, ItemStack stackInSlot) {
        if (stackInSlot != null) {
            if (AetherAPI.instance().hasFreezable(stackInSlot)) {
                return true;
            }
            if (slot == 1 && AetherAPI.instance().isFreezableFuel(stackInSlot)) {
                return true;
            }
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 2;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 0;
            nArray = nArray3;
            nArray3[1] = 1;
        }
        return nArray;
    }
}

