/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.items.tools;

import com.gildedgames.the_aether.items.util.EnumAetherToolType;
import com.gildedgames.the_aether.registry.creative_tabs.AetherCreativeTabs;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;

public abstract class ItemAetherTool
extends ItemTool {
    private float attackDamage;
    private String toolClass;
    public Random random = new Random();
    public EnumAetherToolType toolType;

    public ItemAetherTool(float damage, Item.ToolMaterial toolMaterial, EnumAetherToolType toolType) {
        super(damage, toolMaterial, toolType.getToolBlockSet());
        this.toolType = toolType;
        if (toolType == EnumAetherToolType.PICKAXE) {
            this.toolClass = "pickaxe";
        } else if (toolType == EnumAetherToolType.AXE) {
            this.toolClass = "axe";
        } else if (toolType == EnumAetherToolType.SHOVEL) {
            this.toolClass = "shovel";
        }
        this.func_77637_a(AetherCreativeTabs.tools);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        int level = super.getHarvestLevel(stack, toolClass);
        if (level == -1 && toolClass != null && toolClass.equals(this.toolClass)) {
            return this.field_77862_b.func_77996_d();
        }
        return level;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return this.toolType.canHarvestBlock(this.field_77862_b, block);
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        for (String type : this.getToolClasses(stack)) {
            if (!block.isToolEffective(type, meta)) continue;
            return this.field_77864_a;
        }
        return this.toolType.getStrVsBlock(stack, block) == 4.0f ? this.field_77864_a : 1.0f;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return this.toolClass != null ? ImmutableSet.of((Object)this.toolClass) : super.getToolClasses(stack);
    }

    public Multimap func_111205_h() {
        Multimap multimap = super.func_111205_h();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.attackDamage, 0));
        return multimap;
    }

    public float getEffectiveSpeed() {
        return this.field_77864_a;
    }
}

