/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.entities.passive;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.entities.ai.SheepuffAIEatAetherGrass;
import com.gildedgames.the_aether.entities.passive.EntityAetherAnimal;
import com.gildedgames.the_aether.items.ItemsAether;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntitySheepuff
extends EntityAetherAnimal {
    private SheepuffAIEatAetherGrass entityAIEatGrass = new SheepuffAIEatAetherGrass(this);
    private int sheepTimer;
    private int amountEaten = 0;

    public EntitySheepuff(World world) {
        super(world);
        this.func_70105_a(0.9f, 1.3f);
        this.setFleeceColor(EntitySheepuff.getRandomFleeceColor(this.field_70146_Z));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, ItemsAether.blueberry, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.entityAIEatGrass);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected void func_70619_bc() {
        this.sheepTimer = this.entityAIEatGrass.getEatingGrassTimer();
        super.func_70619_bc();
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        super.func_70636_d();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(AetherConfig.getSheepuffSpawnrate()) == 0 && super.func_70601_bi();
    }

    protected void func_70628_a(boolean var1, int ammount) {
        if (!this.getSheared()) {
            this.func_70099_a(new ItemStack(Blocks.field_150325_L, 1 + this.field_70146_Z.nextInt(2), this.getFleeceColor()), 0.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.sheepTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        return this.sheepTimer <= 0 ? 0.0f : (this.sheepTimer >= 4 && this.sheepTimer <= 36 ? 1.0f : (this.sheepTimer < 4 ? ((float)this.sheepTimer - p_70894_1_) / 4.0f : -((float)(this.sheepTimer - 40) - p_70894_1_) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float f = ((float)(this.sheepTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.2199115f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.sheepTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public void func_70615_aA() {
        ++this.amountEaten;
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
        this.func_85030_a("mob.sheep.step", 0.15f, 1.0f);
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151097_aZ && !this.getSheared()) {
            if (!this.field_70170_p.field_72995_K) {
                this.setSheared(true);
                this.setPuffed(false);
                int i = 2 + this.field_70146_Z.nextInt(3);
                for (int j = 0; j < i; ++j) {
                    EntityItem entityitem = this.func_70099_a(new ItemStack(Blocks.field_150325_L, 1, this.getFleeceColor()), 1.0f);
                    entityitem.field_70181_x += (double)(this.field_70146_Z.nextFloat() * 0.05f);
                    entityitem.field_70159_w += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
                    entityitem.field_70179_y += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
                }
            }
            itemstack.func_77972_a(1, (EntityLivingBase)player);
        }
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151100_aR && !this.getSheared() && this.getFleeceColor() != itemstack.func_77960_j()) {
            if (this.getPuffed() && itemstack.field_77994_a >= 2) {
                this.setFleeceColor(15 - itemstack.func_77960_j());
                itemstack.field_77994_a -= 2;
            } else if (!this.getPuffed()) {
                this.setFleeceColor(15 - itemstack.func_77960_j());
                --itemstack.field_77994_a;
            }
        }
        return super.func_70085_c(player);
    }

    protected void func_70664_aZ() {
        if (this.getPuffed()) {
            this.field_70181_x = 1.8;
            this.field_70159_w += this.field_70146_Z.nextGaussian() * 0.5;
            this.field_70179_y += this.field_70146_Z.nextGaussian() * 0.5;
        } else {
            this.field_70181_x = 0.42f;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getPuffed()) {
            this.field_70143_R = 0.0f;
            if (this.field_70181_x < -0.05) {
                this.field_70181_x = -0.05;
            }
        }
        if (this.amountEaten >= 2 && !this.getSheared() && !this.getPuffed()) {
            this.setPuffed(true);
            this.amountEaten = 0;
        }
        if (this.amountEaten == 1 && this.getSheared() && !this.getPuffed()) {
            this.setSheared(false);
            this.setFleeceColor(0);
            this.amountEaten = 0;
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Sheared", this.getSheared());
        nbttagcompound.func_74757_a("Puffed", this.getPuffed());
        nbttagcompound.func_74774_a("Color", (byte)this.getFleeceColor());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setSheared(nbttagcompound.func_74767_n("Sheared"));
        this.setPuffed(nbttagcompound.func_74767_n("Puffed"));
        this.setFleeceColor(nbttagcompound.func_74771_c("Color"));
    }

    protected String func_70639_aQ() {
        return "mob.sheep.say";
    }

    protected String func_70621_aR() {
        return "mob.sheep.say";
    }

    protected String func_70673_aS() {
        return "mob.sheep.say";
    }

    public int getFleeceColor() {
        return this.field_70180_af.func_75683_a(16) & 0xF;
    }

    public void setFleeceColor(int i) {
        byte byte0 = this.field_70180_af.func_75683_a(16);
        this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 & 0xF0 | i & 0xF)));
    }

    public boolean getSheared() {
        return this.field_70180_af.func_75683_a(17) == 1;
    }

    public void setSheared(boolean flag) {
        this.field_70180_af.func_75692_b(17, (Object)((byte)(flag ? 1 : 0)));
    }

    public boolean getPuffed() {
        return this.field_70180_af.func_75683_a(18) == 1;
    }

    public void setPuffed(boolean flag) {
        this.field_70180_af.func_75692_b(18, (Object)((byte)(flag ? 1 : 0)));
    }

    public static int getRandomFleeceColor(Random random) {
        int i = random.nextInt(100);
        if (i < 5) {
            return 3;
        }
        if (i < 10) {
            return 9;
        }
        if (i < 15) {
            return 5;
        }
        if (i < 18) {
            return 6;
        }
        return random.nextInt(500) != 0 ? 0 : 10;
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return new EntitySheepuff(this.field_70170_p);
    }
}

