/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.entities.passive;

import com.gildedgames.the_aether.entities.projectile.crystals.EntityCrystal;
import com.gildedgames.the_aether.entities.projectile.crystals.EnumCrystalType;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityMiniCloud
extends EntityFlying
implements IEntityAdditionalSpawnData {
    public EntityPlayer owner;
    public int shotTimer;
    public int lifeSpan;
    public boolean direction;
    public double targetX;
    public double targetY;
    public double targetZ;

    public EntityMiniCloud(World worldObj) {
        super(worldObj);
        this.field_70145_X = true;
        this.lifeSpan = 3600;
        this.field_70144_Y = 1.75f;
        this.func_70105_a(0.5f, 0.45f);
    }

    public EntityMiniCloud(World worldObj, EntityPlayer owner, int direction) {
        this(worldObj);
        this.owner = owner;
        this.direction = direction == 0;
        this.field_70177_z = this.owner.field_70177_z;
        this.field_70125_A = this.owner.field_70125_A;
        this.getTargetPos();
        this.func_70107_b(this.targetX, this.targetY, this.targetZ);
    }

    public boolean func_70112_a(double var1) {
        return true;
    }

    public void getTargetPos() {
        if (this.func_70032_d((Entity)this.owner) > 2.0f) {
            this.targetX = this.owner.field_70165_t;
            this.targetY = this.owner.field_70163_u + 1.1000000014901161;
            this.targetZ = this.owner.field_70161_v;
        } else {
            double var1 = this.owner.field_70177_z;
            var1 = this.direction ? (var1 -= 90.0) : (var1 += 90.0);
            this.targetX = this.owner.field_70165_t + Math.sin(var1 /= -57.29577951308232) * 1.05;
            this.targetY = this.owner.field_70163_u + 1.1000000014901161;
            this.targetZ = this.owner.field_70161_v + Math.cos(var1) * 1.05;
        }
    }

    public boolean atShoulder() {
        double var1 = this.field_70165_t - this.targetX;
        double var3 = this.field_70163_u - this.targetY;
        double var5 = this.field_70161_v - this.targetZ;
        return Math.sqrt(var1 * var1 + var3 * var3 + var5 * var5) < 0.3;
    }

    public void approachTarget() {
        double var1 = this.targetX - this.field_70165_t;
        double var3 = this.targetY - this.field_70163_u;
        double var5 = this.targetZ - this.field_70161_v;
        double var7 = Math.sqrt(var1 * var1 + var3 * var3 + var5 * var5) * 3.25;
        this.field_70159_w = (this.field_70159_w + var1 / var7) / 2.0;
        this.field_70181_x = (this.field_70181_x + var3 / var7) / 2.0;
        this.field_70179_y = (this.field_70179_y + var5 / var7) / 2.0;
        Math.atan2(var1, var5);
    }

    public void func_70014_b(NBTTagCompound var1) {
        super.func_70014_b(var1);
        var1.func_74777_a("LifeSpan", (short)this.lifeSpan);
        var1.func_74777_a("ShotTimer", (short)this.shotTimer);
        var1.func_74757_a("direction", this.direction);
    }

    public void func_70037_a(NBTTagCompound var1) {
        super.func_70037_a(var1);
        this.lifeSpan = var1.func_74765_d("LifeSpan");
        this.shotTimer = var1.func_74765_d("ShotTimer");
        this.direction = var1.func_74767_n("direction");
    }

    public void func_70030_z() {
        super.func_70030_z();
        --this.lifeSpan;
        if (this.lifeSpan <= 0) {
            this.func_70656_aK();
            this.field_70128_L = true;
        } else {
            if (this.owner == null && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                return;
            }
            if (this.shotTimer > 0) {
                --this.shotTimer;
            }
            if (!this.owner.field_70128_L) {
                if (this.field_70170_p.field_72995_K) {
                    return;
                }
                this.getTargetPos();
                if (this.atShoulder()) {
                    this.field_70159_w *= 0.65;
                    this.field_70181_x *= 0.65;
                    this.field_70179_y *= 0.65;
                    this.field_70177_z = this.owner.field_70177_z + (this.direction ? 1.0f : -1.0f);
                    this.field_70125_A = this.owner.field_70125_A;
                    this.field_70759_as = this.owner.field_70759_as;
                    if (this.shotTimer <= 0 && this.owner.field_70733_aJ > 0.0f) {
                        float var7 = this.field_70177_z - (this.direction ? 1.0f : -1.0f);
                        double var1 = this.field_70165_t + Math.sin((double)var7 / -57.29577951308232) * 1.6;
                        double var3 = this.field_70163_u - -1.0;
                        double var5 = this.field_70161_v + Math.cos((double)var7 / -57.29577951308232) * 1.6;
                        EntityCrystal crystal = new EntityCrystal(this.field_70170_p, var1, var3, var5, EnumCrystalType.CLOUD);
                        Vec3 var9 = this.func_70040_Z();
                        crystal.shootingEntity = this.owner;
                        if (var9 != null) {
                            crystal.smotionX = var9.field_72450_a * 1.5;
                            crystal.smotionY = var9.field_72448_b * 1.5;
                            crystal.smotionZ = var9.field_72449_c * 1.5;
                        }
                        crystal.wasHit = true;
                        if (!this.field_70170_p.field_72995_K) {
                            this.field_70170_p.func_72838_d((Entity)crystal);
                        }
                        this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "aether_legacy:aemob.zephyr.shoot", 0.75f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                        this.shotTimer = 40;
                    }
                } else {
                    this.approachTarget();
                }
            } else {
                this.func_70656_aK();
                this.field_70128_L = true;
            }
        }
    }

    public boolean func_70097_a(DamageSource var1, float var2) {
        if (var1.func_76346_g() == this.owner || var1.func_76355_l() == "inWall") {
            return false;
        }
        return super.func_70097_a(var1, var2);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.direction);
        buffer.writeInt(this.owner.func_145782_y());
    }

    public void readSpawnData(ByteBuf buffer) {
        this.direction = buffer.readBoolean();
        this.owner = (EntityPlayer)this.field_70170_p.func_73045_a(buffer.readInt());
    }
}

