/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.entities.bosses.valkyrie_queen;

import com.gildedgames.the_aether.Aether;
import com.gildedgames.the_aether.api.player.util.IAetherBoss;
import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.blocks.dungeon.BlockDungeonBase;
import com.gildedgames.the_aether.client.gui.dialogue.entity.GuiValkyrieDialogue;
import com.gildedgames.the_aether.entities.ai.EntityAIAttackContinuously;
import com.gildedgames.the_aether.entities.ai.valkyrie_queen.ValkyrieQueenAIWander;
import com.gildedgames.the_aether.entities.projectile.crystals.EntityCrystal;
import com.gildedgames.the_aether.entities.util.AetherNameGen;
import com.gildedgames.the_aether.entities.util.EntityAetherItem;
import com.gildedgames.the_aether.entities.util.EntityBossMob;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.player.PlayerAether;
import com.gildedgames.the_aether.registry.achievements.AchievementsAether;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityValkyrieQueen
extends EntityBossMob
implements IAetherBoss {
    private EntityAIAttackContinuously enhancedCombat = new EntityAIAttackContinuously(this, 0.65);
    public int angerLevel;
    public int timeLeft;
    public int timeUntilTeleport = this.field_70146_Z.nextInt(250);
    public int chatTime;
    public int timeUntilTeleportToPlayer;
    public int dungeonX;
    public int dungeonY;
    public int dungeonZ;
    public int dungeonEntranceZ;
    public double safeX;
    public double safeY;
    public double safeZ;
    public float sinage;
    public double lastMotionY;

    public EntityValkyrieQueen(World world) {
        super(world);
        this.registerEntityAI();
        this.field_70180_af.func_75692_b(19, (Object)AetherNameGen.valkGen());
        this.safeX = this.field_70165_t;
        this.safeY = this.field_70163_u;
        this.safeZ = this.field_70161_v;
    }

    public EntityValkyrieQueen(World world, double x, double y, double z) {
        this(world);
        this.safeX = this.field_70165_t = x;
        this.safeY = this.field_70163_u = y;
        this.safeZ = this.field_70161_v = z;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(19, (Object)AetherNameGen.valkGen());
    }

    public void registerEntityAI() {
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)this.enhancedCombat);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new ValkyrieQueenAIWander(this, 0.5));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f, 200.0f));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(28.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.85);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(13.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(500.0);
    }

    protected boolean func_70610_aX() {
        return !this.isBossReady();
    }

    public void func_70024_g(double x, double y, double z) {
        if (this.isBossReady()) {
            super.func_70024_g(x, y, z);
        }
    }

    public void swingArm() {
        if (!this.field_82175_bq) {
            this.field_82175_bq = true;
        }
    }

    private void becomeAngryAt(EntityLivingBase entity) {
        this.func_70784_b((Entity)entity);
        this.angerLevel = 200 + this.field_70146_Z.nextInt(200);
    }

    public void setDungeon(int i, int j, int k) {
        this.dungeonX = i;
        this.dungeonY = j;
        this.dungeonZ = k - 19;
    }

    private void unlockDoor() {
        this.field_70170_p.func_147449_b(this.dungeonX - 1, this.dungeonY, this.dungeonEntranceZ, Blocks.field_150350_a);
        this.field_70170_p.func_147449_b(this.dungeonX - 1, this.dungeonY, this.dungeonEntranceZ + 1, Blocks.field_150350_a);
        this.field_70170_p.func_147449_b(this.dungeonX - 1, this.dungeonY + 1, this.dungeonEntranceZ + 1, Blocks.field_150350_a);
        this.field_70170_p.func_147449_b(this.dungeonX - 1, this.dungeonY + 1, this.dungeonEntranceZ, Blocks.field_150350_a);
    }

    private void unlockTreasure() {
        this.field_70170_p.func_147465_d(this.dungeonX + 16, this.dungeonY + 1, this.dungeonZ + 9, Blocks.field_150415_aT, 3, 2);
        this.field_70170_p.func_147465_d(this.dungeonX + 17, this.dungeonY + 1, this.dungeonZ + 9, Blocks.field_150415_aT, 2, 2);
        this.field_70170_p.func_147465_d(this.dungeonX + 16, this.dungeonY + 1, this.dungeonZ + 10, Blocks.field_150415_aT, 3, 2);
        this.field_70170_p.func_147465_d(this.dungeonX + 17, this.dungeonY + 1, this.dungeonZ + 10, Blocks.field_150415_aT, 2, 2);
        for (int x = this.dungeonX - 27; x < this.dungeonX + 30; ++x) {
            for (int y = this.dungeonY - 1; y < this.dungeonY + 22; ++y) {
                for (int z = this.dungeonZ - 6; z < this.dungeonZ + 26; ++z) {
                    Block block = this.field_70170_p.func_147439_a(x, y, z);
                    if (block != BlocksAether.locked_angelic_stone && block != BlocksAether.locked_light_angelic_stone) continue;
                    this.field_70170_p.func_147449_b(x, y, z, ((BlockDungeonBase)block).getUnlockedBlock());
                }
            }
        }
    }

    private void chatItUp(EntityPlayer player, String s) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (this.chatTime <= 0) {
            if (side.isClient()) {
                Aether.proxy.sendMessage(player, s);
            }
            this.chatTime = 60;
        }
    }

    public void makeHomeShot(int shots, EntityPlayer player) {
        for (int i = 0; i < shots; ++i) {
            EntityCrystal crystal = new EntityCrystal(this.field_70170_p, this.field_70165_t - this.field_70159_w / 2.0, this.field_70163_u, this.field_70161_v - this.field_70179_y / 2.0, (EntityLivingBase)player);
            if (this.field_70170_p.field_72995_K) continue;
            this.field_70170_p.func_72838_d((Entity)crystal);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void displayValkyrieDialogue() {
        if (this.field_70170_p.field_72995_K) {
            FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiValkyrieDialogue(this));
        }
    }

    public boolean func_70085_c(EntityPlayer entityplayer) {
        this.func_70625_a((Entity)entityplayer, 180.0f, 180.0f);
        if (this.isBossReady()) {
            this.chatItUp(entityplayer, StatCollector.func_74838_a((String)"gui.queen.ready"));
        } else if (this.field_70170_p.field_72995_K) {
            this.displayValkyrieDialogue();
            return true;
        }
        return super.func_70085_c(entityplayer);
    }

    public void func_70626_be() {
        super.func_70626_be();
        if (!this.isBossReady()) {
            this.field_70181_x *= 0.5;
            this.field_70701_bs = 0.0f;
            this.field_70702_br = 0.0f;
        } else {
            EntityPlayer target;
            if (this.func_70777_m() != null && this.func_70777_m() instanceof EntityPlayer && (target = (EntityPlayer)this.func_70777_m()) != null) {
                if (target.field_70163_u > this.field_70163_u) {
                    ++this.timeUntilTeleportToPlayer;
                    if (this.timeUntilTeleportToPlayer >= 75 && !this.field_70170_p.field_72995_K) {
                        this.teleportToPlayer();
                    }
                } else {
                    this.timeUntilTeleportToPlayer = 0;
                }
                if (this.timeUntilTeleport++ >= 450) {
                    if (this.field_70122_E && this.field_70146_Z.nextInt(5) == 0) {
                        this.makeHomeShot(1, target);
                    } else {
                        this.teleport(target.field_70165_t, target.field_70163_u, target.field_70161_v, 4);
                    }
                } else if (this.timeUntilTeleport < 446 && (this.field_70163_u <= 0.0 || this.field_70163_u <= this.safeY - 16.0)) {
                    this.timeUntilTeleport = 446;
                } else if (this.timeUntilTeleport % 5 == 0 && !this.func_70685_l((Entity)target)) {
                    this.timeUntilTeleport += 100;
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                for (int k = 2; k < 23; k += 7) {
                    Block state = this.field_70170_p.func_147439_a(this.dungeonX - 1, this.dungeonY, this.dungeonZ + k);
                    if (state == BlocksAether.locked_angelic_stone && state == BlocksAether.locked_light_angelic_stone) continue;
                    this.field_70170_p.func_147449_b(this.dungeonX - 1, this.dungeonY, this.dungeonZ + k, BlocksAether.locked_angelic_stone);
                    this.field_70170_p.func_147449_b(this.dungeonX - 1, this.dungeonY, this.dungeonZ + k + 1, BlocksAether.locked_angelic_stone);
                    this.field_70170_p.func_147449_b(this.dungeonX - 1, this.dungeonY + 1, this.dungeonZ + k + 1, BlocksAether.locked_angelic_stone);
                    this.field_70170_p.func_147449_b(this.dungeonX - 1, this.dungeonY + 1, this.dungeonZ + k, BlocksAether.locked_angelic_stone);
                    this.dungeonEntranceZ = this.dungeonZ + k;
                }
            }
        }
        if (this.func_70777_m() != null && this.func_70777_m().field_70128_L) {
            this.func_70784_b(null);
            this.unlockDoor();
            this.angerLevel = 0;
        }
        if (this.chatTime > 0) {
            --this.chatTime;
        }
    }

    @Override
    public void func_70071_h_() {
        this.lastMotionY = this.field_70181_x;
        super.func_70071_h_();
        if (!this.field_70122_E && this.func_70777_m() != null && this.lastMotionY >= 0.0 && this.field_70181_x < 0.0 && this.func_70032_d(this.func_70777_m()) <= 16.0f && this.func_70685_l(this.func_70777_m())) {
            double a = this.func_70777_m().field_70165_t - this.field_70165_t;
            double b = this.func_70777_m().field_70161_v - this.field_70161_v;
            double angle = Math.atan2(a, b);
            this.field_70159_w = Math.sin(angle) * 0.25;
            this.field_70179_y = Math.cos(angle) * 0.25;
        }
        if (!this.field_70122_E && !this.func_70617_f_() && Math.abs(this.field_70181_x - this.lastMotionY) > 0.07 && Math.abs(this.field_70181_x - this.lastMotionY) < 0.09) {
            this.field_70181_x += (double)0.055f;
            if (this.field_70181_x < (double)-0.275f) {
                this.field_70181_x = -0.275f;
            }
        }
        if (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL && (this.func_70777_m() != null || this.angerLevel > 0)) {
            this.angerLevel = 0;
            this.func_70784_b(null);
        }
        this.sinage = !this.field_70122_E ? (this.sinage += 0.75f) : (this.sinage += 0.15f);
        if (this.sinage > 6.283186f) {
            this.sinage -= 6.283186f;
        }
        if (this.func_110143_aJ() <= 0.0f || this.field_70128_L) {
            if (!this.field_70170_p.field_72995_K) {
                this.unlockDoor();
                this.unlockTreasure();
            }
            if (this.func_70777_m() instanceof EntityPlayer) {
                this.chatItUp((EntityPlayer)this.func_70777_m(), StatCollector.func_74838_a((String)"gui.queen.defeated"));
                ((EntityPlayer)this.func_70777_m()).func_71029_a((StatBase)AchievementsAether.defeat_silver);
                PlayerAether.get((EntityPlayer)this.func_70777_m()).setFocusedBoss(null);
            }
            this.func_70656_aK();
            this.func_70106_y();
        }
        if (!this.otherDimension()) {
            --this.timeLeft;
            if (this.timeLeft <= 0) {
                this.func_70656_aK();
                this.func_70106_y();
            }
        }
    }

    @Override
    protected Entity func_70782_k() {
        return null;
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74777_a("Anger", (short)this.angerLevel);
        nbttagcompound.func_74777_a("TimeLeft", (short)this.timeLeft);
        nbttagcompound.func_74757_a("Duel", this.isBossReady());
        nbttagcompound.func_74768_a("DungeonX", this.dungeonX);
        nbttagcompound.func_74768_a("DungeonY", this.dungeonY);
        nbttagcompound.func_74768_a("DungeonZ", this.dungeonZ);
        nbttagcompound.func_74768_a("DungeonEntranceZ", this.dungeonEntranceZ);
        nbttagcompound.func_74782_a("SafePos", (NBTBase)this.func_70087_a(new double[]{this.safeX, this.safeY, this.safeZ}));
        nbttagcompound.func_74778_a("BossName", this.getName());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.angerLevel = nbttagcompound.func_74765_d("Anger");
        this.timeLeft = nbttagcompound.func_74765_d("TimeLeft");
        this.setBossReady(nbttagcompound.func_74767_n("Duel"));
        this.dungeonX = nbttagcompound.func_74762_e("DungeonX");
        this.dungeonY = nbttagcompound.func_74762_e("DungeonY");
        this.dungeonZ = nbttagcompound.func_74762_e("DungeonZ");
        this.dungeonEntranceZ = nbttagcompound.func_74762_e("DungeonEntranceZ");
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("SafePos", 10);
        this.setBossName(nbttagcompound.func_74779_i("BossName"));
        this.safeX = nbttaglist.func_150309_d(0);
        this.safeY = nbttaglist.func_150309_d(1);
        this.safeZ = nbttaglist.func_150309_d(2);
    }

    @Override
    public boolean func_70097_a(DamageSource ds, float i) {
        if (ds.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)ds.func_76346_g();
            if (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
                this.func_70656_aK();
                this.chatItUp(player, StatCollector.func_74838_a((String)"gui.queen.peaceful"));
                return false;
            }
            if (!this.isBossReady()) {
                this.func_70656_aK();
                int pokey = this.field_70146_Z.nextInt(2);
                if (pokey == 2) {
                    this.chatItUp(player, StatCollector.func_74838_a((String)"gui.queen.peaceful"));
                } else {
                    this.chatItUp(player, StatCollector.func_74838_a((String)"gui.queen.nomedals"));
                }
                return false;
            }
            PlayerAether playerAether = PlayerAether.get(player);
            if (playerAether != null) {
                boolean flag = true;
                if (!player.field_70128_L && flag) {
                    playerAether.setFocusedBoss(this);
                }
                if (this.field_70128_L || this.func_110143_aJ() <= 0.0f) {
                    playerAether.setFocusedBoss(null);
                }
            }
            if (this.func_70777_m() == null) {
                this.chatTime = 0;
                this.chatItUp(player, StatCollector.func_74838_a((String)"gui.queen.fight"));
                if (ds.func_76346_g() instanceof EntityLivingBase) {
                    this.becomeAngryAt((EntityLivingBase)ds.func_76346_g());
                }
            } else {
                this.timeUntilTeleport += 60;
            }
        } else {
            this.func_70066_B();
            return false;
        }
        return super.func_70097_a(ds, i);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        EntityPlayer player;
        boolean flag = false;
        this.swingArm();
        flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 8.0f);
        if (entity != null && this.func_70777_m() != null && entity == this.func_70777_m() && entity instanceof EntityPlayer && ((player = (EntityPlayer)entity).func_110143_aJ() <= 0.0f || player.field_70128_L)) {
            this.func_70784_b(null);
            this.chatTime = 0;
            this.angerLevel = 0;
            this.chatItUp(player, StatCollector.func_74838_a((String)"gui.queen.lost"));
            this.unlockDoor();
        }
        return flag;
    }

    protected void func_70628_a(boolean var1, int var2) {
        this.func_70099_a(new ItemStack(ItemsAether.dungeon_key, 1, 1), 0.5f);
        this.func_145779_a(Items.field_151010_B, 1);
    }

    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (stack.field_77994_a != 0 && stack.func_77973_b() != null) {
            EntityAetherItem entityitem = new EntityAetherItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)offsetY, this.field_70161_v, stack);
            if (this.captureDrops) {
                this.capturedDrops.add(entityitem);
            } else {
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            return entityitem;
        }
        return null;
    }

    public void func_70069_a(float distance) {
    }

    public void teleport(double x, double y, double z, int rad) {
        int a = this.field_70146_Z.nextInt(rad + 1);
        int b = this.field_70146_Z.nextInt(rad / 2);
        int c = rad - a;
        int newX = (int)Math.floor((x += (double)(a *= this.field_70146_Z.nextInt(2) * 2 - 1)) - 0.5);
        int newY = (int)Math.floor((y += (double)(b *= this.field_70146_Z.nextInt(2) * 2 - 1)) - 0.5);
        int newZ = (int)Math.floor((z += (double)(c *= this.field_70146_Z.nextInt(2) * 2 - 1)) - 0.5);
        boolean flag = false;
        for (int q = 0; q < 32 && !flag; ++q) {
            int k;
            int j;
            int i = newX + (this.field_70146_Z.nextInt(rad / 2) - this.field_70146_Z.nextInt(rad / 2));
            if (!this.isAirySpace(i, j = newY + (this.field_70146_Z.nextInt(rad / 2) - this.field_70146_Z.nextInt(rad / 2)), k = newZ + (this.field_70146_Z.nextInt(rad / 2) - this.field_70146_Z.nextInt(rad / 2))) || !this.isAirySpace(i, j + 1, k) || this.isAirySpace(i, j - 1, k) || i <= this.dungeonX || i >= this.dungeonX + 20 || j <= this.dungeonY || j >= this.dungeonY + 12 || k <= this.dungeonZ || k >= this.dungeonZ + 20) continue;
            newX = i;
            newY = j;
            newZ = k;
            flag = true;
        }
        if (!flag) {
            this.timeUntilTeleport -= this.field_70146_Z.nextInt(40) + 40;
            if (this.field_70163_u <= 0.0) {
                this.timeUntilTeleport = 446;
            }
        } else {
            this.func_70656_aK();
            this.enhancedCombat.func_75251_c();
            this.func_70107_b((double)newX + 0.5, (double)newY + 0.5, (double)newZ + 0.5);
            this.field_70703_bu = false;
            this.field_70761_aq = this.field_70146_Z.nextFloat() * 360.0f;
            this.timeUntilTeleport = this.field_70146_Z.nextInt(40);
            this.field_70177_z = 0.0f;
            this.field_70125_A = 0.0f;
            this.field_70702_br = 0.0f;
            this.field_70701_bs = 0.0f;
            this.field_70181_x = this.field_70179_y = (double)0.0f;
            this.field_70159_w = this.field_70179_y;
        }
    }

    public void teleportToPlayer() {
        if (this.func_70777_m() instanceof EntityPlayer) {
            this.func_70656_aK();
            this.enhancedCombat.func_75251_c();
            this.func_70107_b(this.func_70777_m().field_70165_t + 0.5, this.func_70777_m().field_70163_u + 0.5, this.func_70777_m().field_70161_v + 0.5);
            this.field_70703_bu = false;
            this.field_70761_aq = this.field_70146_Z.nextFloat() * 360.0f;
            this.timeUntilTeleportToPlayer = 0;
            this.field_70177_z = 0.0f;
            this.field_70125_A = 0.0f;
            this.field_70702_br = 0.0f;
            this.field_70701_bs = 0.0f;
            this.field_70181_x = this.field_70179_y = (double)0.0f;
            this.field_70159_w = this.field_70179_y;
        }
    }

    public boolean isAirySpace(int x, int y, int z) {
        Block block = this.field_70170_p.func_147439_a(x, y, z);
        return block == Blocks.field_150350_a || block.func_149668_a(this.field_70170_p, x, y, z) == null;
    }

    public boolean otherDimension() {
        return true;
    }

    public boolean func_70692_ba() {
        return false;
    }

    @Override
    public boolean func_70601_bi() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        return this.field_70170_p.func_72829_c(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).size() == 0;
    }

    public int getMedals(EntityPlayer entityplayer) {
        int medals = 0;
        for (ItemStack item : entityplayer.field_71071_by.field_70462_a) {
            if (item == null || item.func_77973_b() != ItemsAether.victory_medal) continue;
            medals += item.field_77994_a;
        }
        return medals;
    }

    public List<?> getPlayersInDungeon() {
        return this.field_70170_p.func_72839_b(this.func_70777_m(), AxisAlignedBB.func_72330_a((double)this.dungeonX, (double)this.dungeonY, (double)this.dungeonZ, (double)this.dungeonX, (double)this.dungeonY, (double)this.dungeonZ).func_72314_b(20.0, 20.0, 20.0));
    }

    @Override
    protected String func_70621_aR() {
        return "game.player.hurt";
    }

    @Override
    protected String func_70673_aS() {
        return "game.player.die";
    }

    public String getName() {
        return this.field_70180_af.func_75681_e(19);
    }

    @Override
    public String getBossName() {
        return this.field_70180_af.func_75681_e(19) + ", " + StatCollector.func_74838_a((String)"title.aether_legacy.valkyrie_queen.name");
    }

    public void setBossName(String name) {
        this.field_70180_af.func_75692_b(19, (Object)name);
    }

    @Override
    public float getBossHealth() {
        return this.func_110143_aJ();
    }

    @Override
    public float getMaxBossHealth() {
        return this.func_110138_aP();
    }

    public void setBossReady(boolean isReady) {
        this.field_70180_af.func_75692_b(18, (Object)new Byte(isReady ? (byte)1 : 0));
    }

    public boolean isBossReady() {
        return this.field_70180_af.func_75683_a(18) == 1;
    }
}

