/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.entities.bosses.sun_spirit;

import com.gildedgames.the_aether.Aether;
import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.api.AetherAPI;
import com.gildedgames.the_aether.api.player.util.IAetherBoss;
import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.blocks.dungeon.BlockDungeonBase;
import com.gildedgames.the_aether.entities.bosses.EntityFireMinion;
import com.gildedgames.the_aether.entities.projectile.crystals.EntityCrystal;
import com.gildedgames.the_aether.entities.projectile.crystals.EnumCrystalType;
import com.gildedgames.the_aether.entities.util.AetherNameGen;
import com.gildedgames.the_aether.entities.util.EntityAetherItem;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.player.PlayerAether;
import com.gildedgames.the_aether.registry.achievements.AchievementsAether;
import com.gildedgames.the_aether.world.AetherData;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntitySunSpirit
extends EntityFlying
implements IMob,
IAetherBoss,
IEntityMultiPart {
    public int originPointX;
    public int originPointY;
    public int originPointZ;
    public int motionTimer;
    public int flameCount;
    public int ballCount;
    public int chatLog;
    public int chatCount;
    public int direction;
    public double rotary;
    public double velocity;
    public EntityDragonPart[] sunSpiritParts;
    public EntityDragonPart SpiritPartHead = new EntityDragonPart((IEntityMultiPart)this, "head", 1.375f, 1.375f);
    public EntityDragonPart SpiritPartShoulder1 = new EntityDragonPart((IEntityMultiPart)this, "shoulder1", 1.375f, 2.0f);
    public EntityDragonPart SpiritPartShoulder2 = new EntityDragonPart((IEntityMultiPart)this, "shoulder2", 1.375f, 2.0f);

    public EntitySunSpirit(World worldIn) {
        super(worldIn);
        this.sunSpiritParts = new EntityDragonPart[]{this.SpiritPartHead, this.SpiritPartShoulder1, this.SpiritPartShoulder2};
        this.func_70105_a(2.5f, 2.8f);
        this.field_70180_af.func_75692_b(20, (Object)AetherNameGen.gen());
    }

    public EntitySunSpirit(World worldIn, int posX, int posY, int posZ, int var6) {
        this(worldIn);
        this.field_70145_X = true;
        this.direction = var6;
        this.rotary = (double)this.field_70146_Z.nextFloat() * 360.0;
        this.field_70759_as = var6 == 3 ? 0.0f : (var6 == 0 ? 90.0f : (var6 == 2 ? 180.0f : 270.0f));
        this.field_70177_z = this.field_70759_as;
        this.func_70107_b((double)posX + 0.5, posY, (double)posZ + 0.5);
        this.setOriginPosition(posX, posY, posZ);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(19, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(20, (Object)AetherNameGen.gen());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
    }

    public boolean func_70687_e(PotionEffect par1PotionEffect) {
        return false;
    }

    public boolean func_70692_ba() {
        return false;
    }

    protected String func_70621_aR() {
        return null;
    }

    protected String func_70673_aS() {
        return null;
    }

    public boolean isDead() {
        return this.func_110143_aJ() <= 0.0f || this.field_70128_L;
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("originPointX", this.originPointX);
        tag.func_74768_a("originPointY", this.originPointY);
        tag.func_74768_a("originPointZ", this.originPointZ);
        tag.func_74768_a("dungeonDirection", this.direction);
        tag.func_74768_a("chatLog", this.getChatLine());
        tag.func_74778_a("bossName", this.getName());
        tag.func_74757_a("isFreezing", this.isFreezing());
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.originPointX = tag.func_74762_e("originPointX");
        this.originPointY = tag.func_74762_e("originPointY");
        this.originPointZ = tag.func_74762_e("originPointZ");
        this.direction = tag.func_74762_e("dungeonDirection");
        this.setChatLine(tag.func_74762_e("chatLog"));
        this.setBossName(tag.func_74779_i("bossName"));
        this.setFreezing(tag.func_74767_n("isFreezing"));
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.setMultiPartLocations();
    }

    private void setMultiPartLocations() {
        if (this.sunSpiritParts == null) {
            this.sunSpiritParts = new EntityDragonPart[]{this.SpiritPartHead, this.SpiritPartShoulder1, this.SpiritPartShoulder2};
        }
        float f = this.field_70177_z * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76126_a((float)f);
        float f2 = MathHelper.func_76134_b((float)f);
        this.SpiritPartHead.func_70071_h_();
        this.SpiritPartHead.func_70012_b(this.field_70165_t, this.field_70163_u + 1.5, this.field_70161_v, 0.0f, 0.0f);
        this.SpiritPartShoulder1.func_70071_h_();
        this.SpiritPartShoulder1.func_70012_b(this.field_70165_t - (double)(f2 * 1.0f), this.field_70163_u - 0.25, this.field_70161_v - (double)(f1 * 1.0f), 0.0f, 0.0f);
        this.SpiritPartShoulder2.func_70071_h_();
        this.SpiritPartShoulder2.func_70012_b(this.field_70165_t + (double)(f2 * 1.0f), this.field_70163_u - 0.25, this.field_70161_v + (double)(f1 * 1.0f), 0.0f, 0.0f);
    }

    public Entity[] func_70021_al() {
        return this.sunSpiritParts;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.velocity = 0.5 - (double)this.func_110143_aJ() / 70.0 * 0.2;
        this.field_70131_O = 2.0f;
        this.field_70130_N = 2.0f;
        if (this.func_70638_az() instanceof EntityPlayer) {
            PlayerAether dungeonPA;
            Entity entity;
            int i;
            List<?> dungeonPlayers = this.getPlayersInDungeon();
            EntityPlayer dungeonTarget = (EntityPlayer)this.func_70638_az();
            PlayerAether playerAether = PlayerAether.get(dungeonTarget);
            for (i = 0; i < dungeonPlayers.size(); ++i) {
                entity = (Entity)dungeonPlayers.get(i);
                if (!(entity instanceof EntityPlayer) || (dungeonPA = PlayerAether.get((EntityPlayer)entity)).getFocusedBoss() == this) continue;
                dungeonPA.setFocusedBoss(this);
            }
            if (dungeonTarget.field_70128_L) {
                for (i = 0; i < dungeonPlayers.size(); ++i) {
                    entity = (Entity)dungeonPlayers.get(i);
                    if (!(entity instanceof EntityPlayer)) continue;
                    dungeonPA = PlayerAether.get((EntityPlayer)entity);
                    dungeonPA.setFocusedBoss(null);
                }
                this.func_70107_b((double)this.originPointX + 0.5, this.originPointY, (double)this.originPointZ + 0.5);
                this.chatLog = 10;
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
                this.chatLine(dungeonTarget, "\u00a7c" + StatCollector.func_74838_a((String)"gui.spirit.playerdied"));
                this.chatCount = 100;
                this.func_70107_b((double)this.originPointX + 0.5, this.originPointY, (double)this.originPointZ + 0.5);
                this.setDoor(Blocks.field_150350_a);
                this.setFreezing(false);
                this.func_70624_b(null);
                this.func_70606_j(this.func_110138_aP());
            } else {
                playerAether.setFocusedBoss(this);
            }
            if (this.isDead()) {
                this.setFreezing(true);
                this.chatLine(dungeonTarget, "\u00a7b" + StatCollector.func_74838_a((String)"gui.spirit.dead"));
                this.chatCount = 100;
                for (i = 0; i < dungeonPlayers.size(); ++i) {
                    entity = (Entity)dungeonPlayers.get(i);
                    if (!(entity instanceof EntityPlayer)) continue;
                    ((EntityPlayer)entity).func_71029_a((StatBase)AchievementsAether.defeat_gold);
                }
                dungeonTarget.func_71029_a((StatBase)AchievementsAether.defeat_gold);
                if (!(AetherConfig.eternalDayDisabled() || this.field_70170_p.field_72995_K || AetherData.getInstance(this.field_70170_p).isEternalDay())) {
                    AetherData.getInstance(this.field_70170_p).setEternalDay(true);
                }
                this.setDoor(Blocks.field_150350_a);
                this.unlockTreasure();
            }
        }
        this.setFreezing(this.field_70737_aN > 0);
        if (this.func_110143_aJ() > 0.0f) {
            double xCoord = this.field_70165_t + (double)((this.field_70146_Z.nextFloat() - 0.5f) * this.field_70146_Z.nextFloat());
            double yCoord = this.field_70121_D.field_72338_b + (double)this.field_70146_Z.nextFloat() - 0.5;
            double zCoord = this.field_70161_v + (double)((this.field_70146_Z.nextFloat() - 0.5f) * this.field_70146_Z.nextFloat());
            this.field_70170_p.func_72869_a("flame", xCoord, yCoord, zCoord, 0.0, (double)-0.075f, 0.0);
            this.burnEntities();
            this.evapWater();
        }
        if (this.chatCount > 0) {
            --this.chatCount;
        }
    }

    protected void func_70626_be() {
        super.func_70626_be();
        if (this.func_70638_az() != null) {
            this.field_70181_x = 0.0;
            this.field_70761_aq = this.field_70177_z;
            this.func_70107_b(this.field_70165_t, this.originPointY, this.field_70161_v);
            boolean changedCourse = false;
            if (this.field_70159_w >= 0.0 && this.field_70165_t > (double)this.originPointX + 8.5) {
                this.rotary = 360.0 - this.rotary;
                changedCourse = true;
            } else if (this.field_70159_w <= 0.0 && this.field_70165_t < (double)this.originPointX - 10.0) {
                this.rotary = 360.0 - this.rotary;
                changedCourse = true;
            }
            if (this.field_70179_y >= 0.0 && this.field_70161_v > (double)this.originPointZ + 10.0) {
                this.rotary = 180.0 - this.rotary;
                changedCourse = true;
            } else if (this.field_70179_y <= 0.0 && this.field_70161_v < (double)this.originPointZ - 9.0) {
                this.rotary = 180.0 - this.rotary;
                changedCourse = true;
            }
            if (this.rotary > 360.0) {
                this.rotary -= 360.0;
            } else if (this.rotary < 0.0) {
                this.rotary += 360.0;
            }
            this.func_70625_a((Entity)this.func_70638_az(), 20.0f, 20.0f);
            double angle = this.rotary / 57.29577951308232;
            this.field_70159_w = Math.sin(angle) * this.velocity;
            this.field_70179_y = Math.cos(angle) * this.velocity;
            ++this.motionTimer;
            if (this.motionTimer >= 20 || changedCourse) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.rotary += (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 60.0;
                }
                this.motionTimer = 0;
            }
            ++this.flameCount;
            if (this.flameCount == 40) {
                this.summonFire();
            } else if ((float)this.flameCount >= 55.0f + this.func_110143_aJ() / 2.0f) {
                this.makeFireBall(1);
                this.flameCount = 0;
            }
        }
    }

    public void func_70619_bc() {
        super.func_70619_bc();
    }

    public void burnEntities() {
        List entityList = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(0.0, 4.0, 0.0));
        for (int ammount = 0; ammount < entityList.size(); ++ammount) {
            Entity entity = (Entity)entityList.get(ammount);
            if (!(entity instanceof EntityLivingBase) || entity.func_70045_F()) continue;
            entity.func_70097_a((DamageSource)new EntityDamageSource("incineration", (Entity)this), 10.0f);
            entity.func_70015_d(15);
        }
    }

    public void evapWater() {
        int var1 = MathHelper.func_76128_c((double)(this.field_70121_D.field_72340_a + (this.field_70121_D.field_72336_d - this.field_70121_D.field_72340_a) / 2.0));
        int var2 = MathHelper.func_76128_c((double)(this.field_70121_D.field_72339_c + (this.field_70121_D.field_72334_f - this.field_70121_D.field_72339_c) / 2.0));
        int radius = 10;
        for (int var4 = var1 - radius; var4 <= var1 + radius; ++var4) {
            for (int var5 = var2 - radius; var5 <= var2 + radius; ++var5) {
                for (int var6 = 0; var6 < 8; ++var6) {
                    int var7 = this.originPointY - 2 + var6;
                    if (this.field_70170_p.func_147439_a(var4, var7, var5).func_149688_o() != Material.field_151586_h) continue;
                    this.field_70170_p.func_147449_b(var4, var7, var5, Blocks.field_150350_a);
                    this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "random.fizz", 2.0f, this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat() * 0.2f + 1.2f);
                    for (int var8 = 0; var8 < 8; ++var8) {
                        this.field_70170_p.func_72869_a("largesmoke", (double)var4 + Math.random(), (double)var7 + 0.75, (double)var5 + Math.random(), 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    public void makeFireBall(int var1) {
        this.field_70170_p.func_72956_a((Entity)this, "mob.ghast.fireball", this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat() * 0.2f + 1.2f, 1.0f);
        boolean shootIceyBall = false;
        ++this.ballCount;
        if (this.ballCount >= 2 + this.field_70146_Z.nextInt(3)) {
            shootIceyBall = true;
            this.ballCount = 0;
        }
        for (int var3 = 0; var3 < var1; ++var3) {
            EntityCrystal crystal = new EntityCrystal(this.field_70170_p, this.field_70165_t - this.field_70159_w / 2.0, this.field_70163_u, this.field_70161_v - this.field_70179_y / 2.0, shootIceyBall ? EnumCrystalType.ICE : EnumCrystalType.FIRE);
            if (this.field_70170_p.field_72995_K) continue;
            this.field_70170_p.func_72838_d((Entity)crystal);
        }
    }

    public void summonFire() {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_147437_c(x, y = this.originPointY - 2, z = MathHelper.func_76128_c((double)this.field_70161_v))) {
            this.field_70170_p.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
        }
    }

    private void chatLine(EntityPlayer player, String s) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if ((this.chatCount <= 0 || !AetherConfig.repeatSunSpiritDialogue() && ((PlayerAether)AetherAPI.get((EntityPlayer)player)).seenSpiritDialog) && side == Side.CLIENT) {
            Aether.proxy.sendMessage(player, s);
        }
    }

    public boolean chatWithMe(EntityPlayer entityPlayer) {
        if (this.chatCount <= 0) {
            if (AetherConfig.repeatSunSpiritDialogue() || !((PlayerAether)AetherAPI.get((EntityPlayer)entityPlayer)).seenSpiritDialog) {
                if (this.getChatLine() == 0) {
                    this.chatLine(entityPlayer, "\u00a7c" + StatCollector.func_74838_a((String)"gui.spirit.line0"));
                    this.setChatLine(1);
                } else if (this.getChatLine() == 1) {
                    this.chatLine(entityPlayer, "\u00a7c" + StatCollector.func_74838_a((String)"gui.spirit.line1"));
                    this.setChatLine(2);
                } else if (this.getChatLine() == 2) {
                    this.chatLine(entityPlayer, "\u00a7c" + StatCollector.func_74838_a((String)"gui.spirit.line2"));
                    this.setChatLine(3);
                } else if (this.getChatLine() == 3) {
                    this.chatLine(entityPlayer, "\u00a7c" + StatCollector.func_74838_a((String)"gui.spirit.line3"));
                    this.setChatLine(4);
                } else if (this.getChatLine() == 4) {
                    this.chatLine(entityPlayer, "\u00a7c" + StatCollector.func_74838_a((String)"gui.spirit.line4"));
                    this.setChatLine(5);
                } else if (this.getChatLine() == 5) {
                    this.chatLine(entityPlayer, "\u00a7c" + StatCollector.func_74838_a((String)"gui.spirit.line5.1"));
                    this.chatLine(entityPlayer, "\u00a7c" + StatCollector.func_74838_a((String)"gui.spirit.line5.2"));
                    this.setChatLine(6);
                } else if (this.getChatLine() == 6) {
                    this.chatLine(entityPlayer, "\u00a7c" + StatCollector.func_74838_a((String)"gui.spirit.line6.1"));
                    this.chatLine(entityPlayer, "\u00a7c" + StatCollector.func_74838_a((String)"gui.spirit.line6.2"));
                    this.setChatLine(7);
                } else if (this.getChatLine() == 7) {
                    this.chatLine(entityPlayer, "\u00a7c" + StatCollector.func_74838_a((String)"gui.spirit.line7.1"));
                    this.chatLine(entityPlayer, "\u00a7c" + StatCollector.func_74838_a((String)"gui.spirit.line7.2"));
                    this.setChatLine(8);
                } else if (this.getChatLine() == 8) {
                    this.chatLine(entityPlayer, "\u00a7c" + StatCollector.func_74838_a((String)"gui.spirit.line8"));
                    this.setChatLine(9);
                } else {
                    if (this.getChatLine() == 9) {
                        this.chatLine(entityPlayer, "\u00a76" + StatCollector.func_74838_a((String)"gui.spirit.line9"));
                        this.setChatLine(10);
                        return true;
                    }
                    if (this.getChatLine() == 10 && this.func_70638_az() == null) {
                        this.chatLine(entityPlayer, "\u00a7c" + StatCollector.func_74838_a((String)"gui.spirit.line10"));
                        this.setChatLine(9);
                    }
                }
            } else if (((PlayerAether)AetherAPI.get((EntityPlayer)entityPlayer)).seenSpiritDialog) {
                this.setChatLine(9);
                if (this.getChatLine() == 9) {
                    this.chatLine(entityPlayer, "\u00a76" + StatCollector.func_74838_a((String)"gui.spirit.line9"));
                    this.setChatLine(10);
                    return true;
                }
                if (this.getChatLine() == 10 && this.func_70638_az() == null) {
                    this.chatLine(entityPlayer, "\u00a7c" + StatCollector.func_74838_a((String)"gui.spirit.line10"));
                    this.setChatLine(9);
                }
            }
        }
        return false;
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (this.chatWithMe(player)) {
            this.rotary = 57.29577951308232 * Math.atan2(this.field_70165_t - player.field_70165_t, this.field_70161_v - player.field_70161_v);
            this.func_70624_b((EntityLivingBase)player);
            this.setDoor(BlocksAether.locked_hellfire_stone);
            return true;
        }
        return false;
    }

    public void func_70024_g(double x, double y, double z) {
    }

    public void func_70653_a(Entity entity, float strength, double xRatio, double zRatio) {
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() instanceof EntityCrystal) {
            if (((EntityCrystal)source.func_76364_f()).getCrystalType() == EnumCrystalType.ICE) {
                this.velocity = 0.5 - (double)this.func_110143_aJ() / 70.0 * 0.2;
                boolean flag = super.func_70097_a(source, amount);
                if (flag) {
                    EntityFireMinion minion = new EntityFireMinion(this.field_70170_p);
                    minion.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                    minion.func_70624_b(this.func_70638_az());
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)minion);
                    }
                }
                return flag;
            }
            return false;
        }
        return false;
    }

    public boolean func_70965_a(EntityDragonPart part, DamageSource source, float damage) {
        return this.func_70097_a(source, damage);
    }

    protected void func_70628_a(boolean var1, int var2) {
        this.func_70099_a(new ItemStack(ItemsAether.dungeon_key, 1, 2), 0.5f);
        this.func_70099_a(new ItemStack(BlocksAether.sun_altar), 0.5f);
    }

    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (stack.field_77994_a != 0 && stack.func_77973_b() != null) {
            EntityAetherItem entityitem = new EntityAetherItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)offsetY, this.field_70161_v, stack);
            if (this.captureDrops) {
                this.capturedDrops.add(entityitem);
            } else {
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            return entityitem;
        }
        return null;
    }

    private void setDoor(Block block) {
        if (this.direction / 2 == 0) {
            for (int y = this.originPointY - 1; y < this.originPointY + 2; ++y) {
                for (int z = this.originPointZ - 1; z < this.originPointZ + 2; ++z) {
                    if (this.field_70170_p.func_147439_a(this.originPointX + (this.direction == 0 ? -13 : 13), y, z) == block) continue;
                    this.field_70170_p.func_147449_b(this.originPointX + (this.direction == 0 ? -13 : 13), y, z, block);
                }
            }
        } else {
            for (int y = this.originPointY - 1; y < this.originPointY + 2; ++y) {
                for (int x = this.originPointX - 1; x < this.originPointX + 2; ++x) {
                    if (this.field_70170_p.func_147439_a(x, y, this.originPointZ + (this.direction == 3 ? 13 : -13)) == block) continue;
                    this.field_70170_p.func_147449_b(x, y, this.originPointZ + (this.direction == 3 ? 13 : -13), block);
                }
            }
        }
    }

    private void unlockTreasure() {
        int x;
        int z;
        int y;
        if (this.direction / 2 == 0) {
            for (y = this.originPointY - 1; y < this.originPointY + 2; ++y) {
                for (z = this.originPointZ - 1; z < this.originPointZ + 2; ++z) {
                    this.field_70170_p.func_147449_b(this.originPointX + (this.direction == 0 ? 13 : -13), y, z, Blocks.field_150350_a);
                }
            }
        } else {
            for (y = this.originPointY - 1; y < this.originPointY + 2; ++y) {
                for (x = this.originPointX - 1; x < this.originPointX + 2; ++x) {
                    this.field_70170_p.func_147449_b(x, y, this.originPointZ + (this.direction == 3 ? -13 : 13), Blocks.field_150350_a);
                }
            }
        }
        for (x = this.originPointX - 20; x < this.originPointX + 20; ++x) {
            for (y = this.originPointY - 3; y < this.originPointY + 6; ++y) {
                for (z = this.originPointZ - 20; z < this.originPointZ + 20; ++z) {
                    Block unlock_block = this.field_70170_p.func_147439_a(x, y, z);
                    if (unlock_block != BlocksAether.locked_hellfire_stone && unlock_block != BlocksAether.locked_light_hellfire_stone) continue;
                    this.field_70170_p.func_147449_b(x, y, z, ((BlockDungeonBase)unlock_block).getUnlockedBlock());
                }
            }
        }
    }

    public List<?> getPlayersInDungeon() {
        return this.field_70170_p.func_72839_b((Entity)this.func_70638_az(), AxisAlignedBB.func_72330_a((double)this.originPointX, (double)this.originPointY, (double)this.originPointZ, (double)this.originPointX, (double)this.originPointY, (double)this.originPointZ).func_72314_b(20.0, 3.0, 20.0));
    }

    public void setOriginPosition(int x, int y, int z) {
        this.originPointX = x;
        this.originPointY = y;
        this.originPointZ = z;
    }

    public int getChatLine() {
        return this.field_70180_af.func_75683_a(18);
    }

    public void setChatLine(int lineNumber) {
        this.chatCount = 100;
        this.field_70180_af.func_75692_b(18, (Object)new Byte((byte)lineNumber));
    }

    public boolean isFreezing() {
        return this.field_70180_af.func_75683_a(19) == 1;
    }

    public void setFreezing(boolean isFreezing) {
        this.field_70180_af.func_75692_b(19, (Object)new Byte(isFreezing ? (byte)1 : 0));
    }

    public void setBossName(String name) {
        this.field_70180_af.func_75692_b(20, (Object)name);
    }

    public String getName() {
        return this.field_70180_af.func_75681_e(20);
    }

    @Override
    public String getBossName() {
        return this.field_70180_af.func_75681_e(20) + ", " + StatCollector.func_74838_a((String)"title.aether_legacy.sun_spirit.name");
    }

    @Override
    public float getBossHealth() {
        return this.func_110143_aJ();
    }

    @Override
    public float getMaxBossHealth() {
        return this.func_110138_aP();
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }
}

