/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.entities.bosses.slider;

import com.gildedgames.the_aether.Aether;
import com.gildedgames.the_aether.api.player.util.IAetherBoss;
import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.blocks.dungeon.BlockDungeonBase;
import com.gildedgames.the_aether.entities.util.AetherNameGen;
import com.gildedgames.the_aether.entities.util.EntityAetherItem;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.player.PlayerAether;
import com.gildedgames.the_aether.registry.achievements.AchievementsAether;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntitySlider
extends EntityFlying
implements IAetherBoss {
    private int dungeonX;
    private int dungeonY;
    private int dungeonZ;
    private int[] doorStart = new int[3];
    private int[] doorEnd = new int[3];
    public float hurtAngle;
    public float hurtAngleX;
    public float hurtAngleZ;
    public int chatTime;
    public int moveTime;
    public boolean crushedBlock;
    public float velocity;
    public EnumFacing direction;

    public EntitySlider(World world) {
        super(world);
        this.field_70125_A = 0.0f;
        this.field_70177_z = 0.0f;
        this.func_70105_a(2.0f, 2.0f);
        this.field_70180_af.func_75692_b(19, (Object)AetherNameGen.gen());
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(19, (Object)AetherNameGen.gen());
        this.field_70180_af.func_75682_a(20, (Object)new Byte(0));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(500.0);
    }

    protected String func_70639_aQ() {
        return "ambient.cave.cave";
    }

    protected String func_70621_aR() {
        return "step.stone";
    }

    protected String func_70673_aS() {
        return null;
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74768_a("dungeonX", this.dungeonX);
        nbttagcompound.func_74768_a("dungeonY", this.dungeonY);
        nbttagcompound.func_74768_a("dungeonZ", this.dungeonZ);
        nbttagcompound.func_74783_a("doorStart", this.doorStart);
        nbttagcompound.func_74783_a("doorEnd", this.doorEnd);
        nbttagcompound.func_74757_a("isAwake", this.isAwake());
        nbttagcompound.func_74778_a("bossName", this.getName());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.dungeonX = nbttagcompound.func_74762_e("dungeonX");
        this.dungeonY = nbttagcompound.func_74762_e("dungeonY");
        this.dungeonZ = nbttagcompound.func_74762_e("dungeonZ");
        this.doorStart = nbttagcompound.func_74759_k("doorStart");
        this.doorEnd = nbttagcompound.func_74759_k("doorEnd");
        this.setAwake(nbttagcompound.func_74767_n("isAwake"));
        this.setBossName(nbttagcompound.func_74779_i("bossName"));
    }

    public boolean criticalCondition() {
        return this.func_110143_aJ() <= 80.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.hurtAngle > 0.01f) {
            this.hurtAngle *= 0.8f;
        }
        if (this.chatTime > 0) {
            --this.chatTime;
        }
        this.field_70177_z = 0.0f;
        this.field_70125_A = 0.0f;
        this.field_70761_aq = 0.0f;
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    public void func_70626_be() {
        if (!this.isAwake()) {
            this.func_70624_b(null);
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() == null || this.func_70638_az().field_70128_L || this.func_70638_az().func_110143_aJ() <= 0.0f) {
                this.reset();
                return;
            }
            if (this.isMoving()) {
                if (this.field_70132_H) {
                    double x = this.field_70165_t - 0.5;
                    double y = this.field_70121_D.field_72338_b + 0.75;
                    double z = this.field_70161_v - 0.5;
                    this.crushedBlock = false;
                    if (y > 4.0) {
                        if (this.direction == EnumFacing.UP) {
                            for (int i = 0; i < 25; ++i) {
                                double a = (double)(i / 5 - 2) * 0.75;
                                double b = (double)(i % 5 - 2) * 0.75;
                                this.destroyBlock(x + a, y + 1.5, z + b);
                            }
                        } else if (this.direction == EnumFacing.DOWN) {
                            for (int i = 0; i < 25; ++i) {
                                double a = (double)(i / 5 - 2) * 0.75;
                                double b = (double)(i % 5 - 2) * 0.75;
                                this.destroyBlock(x + a, y - 1.5, z + b);
                            }
                        } else if (this.direction == EnumFacing.EAST) {
                            for (int i = 0; i < 25; ++i) {
                                double a = (double)(i / 5 - 2) * 0.75;
                                double b = (double)(i % 5 - 2) * 0.75;
                                this.destroyBlock(x + 1.5, y + a, z + b);
                            }
                        } else if (this.direction == EnumFacing.WEST) {
                            for (int i = 0; i < 25; ++i) {
                                double a = (double)(i / 5 - 2) * 0.75;
                                double b = (double)(i % 5 - 2) * 0.75;
                                this.destroyBlock(x - 1.5, y + a, z + b);
                            }
                        } else if (this.direction == EnumFacing.SOUTH) {
                            for (int i = 0; i < 25; ++i) {
                                double a = (double)(i / 5 - 2) * 0.75;
                                double b = (double)(i % 5 - 2) * 0.75;
                                this.destroyBlock(x + a, y + b, z + 1.5);
                            }
                        } else if (this.direction == EnumFacing.NORTH) {
                            for (int i = 0; i < 25; ++i) {
                                double a = (double)(i / 5 - 2) * 0.75;
                                double b = (double)(i % 5 - 2) * 0.75;
                                this.destroyBlock(x + a, y + b, z - 1.5);
                            }
                        }
                    }
                    if (this.crushedBlock) {
                        this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "random.explode", 3.0f, (0.625f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                        this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "aether_legacy:aeboss.slider.collide", 2.5f, 1.0f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                    }
                    this.stop();
                } else {
                    if (this.velocity < 2.0f) {
                        this.velocity += this.criticalCondition() ? 0.07f : 0.035f;
                    }
                    this.field_70179_y = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70159_w = 0.0;
                    if (this.direction == EnumFacing.UP) {
                        this.field_70181_x = this.velocity;
                        if (this.field_70121_D.field_72338_b > this.func_70638_az().field_70121_D.field_72338_b + 0.35) {
                            this.stop();
                            this.moveTime = this.criticalCondition() ? 4 : 8;
                        }
                    } else if (this.direction == EnumFacing.DOWN) {
                        this.field_70181_x = -this.velocity;
                        if (this.field_70121_D.field_72338_b < this.func_70638_az().field_70121_D.field_72338_b - 0.25) {
                            this.stop();
                            this.moveTime = this.criticalCondition() ? 4 : 8;
                        }
                    } else if (this.direction == EnumFacing.EAST) {
                        this.field_70159_w = this.velocity;
                        if (this.field_70165_t > this.func_70638_az().field_70165_t + 0.125) {
                            this.stop();
                            this.moveTime = this.criticalCondition() ? 4 : 8;
                        }
                    } else if (this.direction == EnumFacing.WEST) {
                        this.field_70159_w = -this.velocity;
                        if (this.field_70165_t < this.func_70638_az().field_70165_t - 0.125) {
                            this.stop();
                            this.moveTime = this.criticalCondition() ? 4 : 8;
                        }
                    } else if (this.direction == EnumFacing.SOUTH) {
                        this.field_70179_y = this.velocity;
                        if (this.field_70161_v > this.func_70638_az().field_70161_v + 0.125) {
                            this.stop();
                            this.moveTime = this.criticalCondition() ? 4 : 8;
                        }
                    } else if (this.direction == EnumFacing.NORTH) {
                        this.field_70179_y = -this.velocity;
                        if (this.field_70161_v < this.func_70638_az().field_70161_v - 0.125) {
                            this.stop();
                            this.moveTime = this.criticalCondition() ? 4 : 8;
                        }
                    }
                }
            } else if (this.moveTime > 0) {
                --this.moveTime;
                if (this.criticalCondition() && this.field_70146_Z.nextInt(2) == 0) {
                    --this.moveTime;
                }
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
            } else {
                if (this.func_70638_az() == null) {
                    return;
                }
                double a = Math.abs(this.field_70165_t - this.func_70638_az().field_70165_t);
                double b = Math.abs(this.field_70121_D.field_72338_b - this.func_70638_az().field_70121_D.field_72338_b);
                double c = Math.abs(this.field_70161_v - this.func_70638_az().field_70161_v);
                if (a > c) {
                    this.direction = EnumFacing.EAST;
                    if (this.field_70165_t > this.func_70638_az().field_70165_t) {
                        this.direction = EnumFacing.WEST;
                    }
                } else {
                    this.direction = EnumFacing.SOUTH;
                    if (this.field_70161_v > this.func_70638_az().field_70161_v) {
                        this.direction = EnumFacing.NORTH;
                    }
                }
                if (b > a && b > c || b > 0.25 && this.field_70146_Z.nextInt(5) == 0) {
                    this.direction = EnumFacing.UP;
                    if (this.field_70163_u > this.func_70638_az().field_70163_u) {
                        this.direction = EnumFacing.DOWN;
                    }
                }
                this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "aether_legacy:aeboss.slider.move", 2.5f, 1.0f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                this.setMoving(true);
            }
        }
    }

    private void destroyBlock(double x, double y, double z) {
        Block block = this.field_70170_p.func_147439_a((int)x, (int)y, (int)z);
        int metadata = this.field_70170_p.func_72805_g((int)x, (int)y, (int)z);
        if (block == Blocks.field_150350_a || block instanceof BlockDungeonBase || block.func_149712_f(this.field_70170_p, (int)x, (int)y, (int)z) < 0.0f) {
            return;
        }
        for (int j = 0; j < 4; ++j) {
            for (int k = 0; k < 4; ++k) {
                for (int l = 0; l < 4; ++l) {
                    double d0 = ((double)j + 0.5) / 4.0;
                    double d1 = ((double)k + 0.5) / 4.0;
                    double d2 = ((double)l + 0.5) / 4.0;
                    this.field_70170_p.func_72869_a("blockcrack_" + Block.func_149682_b((Block)block) + "_" + metadata, x + d0, y + d1, z + d2, d0 - 0.5, d1 - 0.5, d2 - 0.5);
                }
            }
        }
        block.func_149749_a(this.field_70170_p, (int)x, (int)y, (int)z, block, metadata);
        block.func_149697_b(this.field_70170_p, (int)x, (int)y, (int)z, metadata, 0);
        this.field_70170_p.func_147468_f((int)x, (int)y, (int)z);
        this.crushedBlock = true;
        double a = x + 0.5 + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.375;
        double b = y + 0.5 + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.375;
        double c = z + 0.5 + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.375;
        this.field_70170_p.func_72869_a("smoke", a, b, c, 0.0, 0.0, 0.0);
    }

    private boolean checkIsAir(int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayList blockList = Lists.newArrayListWithCapacity((int)9);
        for (int x = x1; x < x2 + 1; ++x) {
            for (int z = z1; z < z2 + 1; ++z) {
                for (int y = y1; y < y2 + 1; ++y) {
                    blockList.add(this.field_70170_p.func_147439_a(x, y, z));
                }
            }
        }
        HashSet blockSet = new HashSet(blockList);
        if (blockSet.size() == 1) {
            return blockList.get(1) == Blocks.field_150350_a;
        }
        return false;
    }

    private void openDoor() {
        for (int x = this.doorStart[0]; x < this.doorEnd[0] + 1; ++x) {
            for (int y = this.doorStart[1]; y < this.doorEnd[1] + 1; ++y) {
                for (int z = this.doorStart[2]; z < this.doorEnd[2] + 1; ++z) {
                    this.field_70170_p.func_147449_b(x, y, z, Blocks.field_150350_a);
                }
            }
        }
    }

    private void closeDoor() {
        block9: {
            block11: {
                block10: {
                    block8: {
                        if (!this.checkIsAir(this.dungeonX + 15, this.dungeonY + 1, this.dungeonZ + 6, this.dungeonX + 15, this.dungeonY + 4, this.dungeonZ + 9)) break block8;
                        this.doorStart = new int[]{this.dungeonX + 15, this.dungeonY + 1, this.dungeonZ + 6};
                        this.doorEnd = new int[]{this.dungeonX + 15, this.dungeonY + 4, this.dungeonZ + 9};
                        int x = this.dungeonX + 15;
                        for (int y = this.dungeonY + 1; y < this.dungeonY + 8; ++y) {
                            for (int z = this.dungeonZ + 5; z < this.dungeonZ + 11; ++z) {
                                this.field_70170_p.func_147449_b(x, y, z, BlocksAether.locked_carved_stone);
                            }
                        }
                        break block9;
                    }
                    if (!this.checkIsAir(this.dungeonX, this.dungeonY + 1, this.dungeonZ + 6, this.dungeonX, this.dungeonY + 4, this.dungeonZ + 9)) break block10;
                    this.doorStart = new int[]{this.dungeonX, this.dungeonY + 1, this.dungeonZ + 6};
                    this.doorEnd = new int[]{this.dungeonX, this.dungeonY + 4, this.dungeonZ + 9};
                    int x = this.dungeonX;
                    for (int y = this.dungeonY + 1; y < this.dungeonY + 8; ++y) {
                        for (int z = this.dungeonZ + 5; z < this.dungeonZ + 11; ++z) {
                            this.field_70170_p.func_147449_b(x, y, z, BlocksAether.locked_carved_stone);
                        }
                    }
                    break block9;
                }
                if (!this.checkIsAir(this.dungeonX + 6, this.dungeonY + 1, this.dungeonZ + 15, this.dungeonX + 9, this.dungeonY + 4, this.dungeonZ + 15)) break block11;
                this.doorStart = new int[]{this.dungeonX + 6, this.dungeonY + 1, this.dungeonZ + 15};
                this.doorEnd = new int[]{this.dungeonX + 9, this.dungeonY + 4, this.dungeonZ + 15};
                int z = this.dungeonZ + 15;
                for (int y = this.dungeonY + 1; y < this.dungeonY + 8; ++y) {
                    for (int x = this.dungeonX + 5; x < this.dungeonX + 11; ++x) {
                        this.field_70170_p.func_147449_b(x, y, z, BlocksAether.locked_carved_stone);
                    }
                }
                break block9;
            }
            if (!this.checkIsAir(this.dungeonX + 6, this.dungeonY + 1, this.dungeonZ, this.dungeonX + 9, this.dungeonY + 4, this.dungeonZ)) break block9;
            this.doorStart = new int[]{this.dungeonX + 6, this.dungeonY + 1, this.dungeonZ};
            this.doorEnd = new int[]{this.dungeonX + 9, this.dungeonY + 4, this.dungeonZ};
            int z = this.dungeonZ;
            for (int y = this.dungeonY + 1; y < this.dungeonY + 8; ++y) {
                for (int x = this.dungeonX + 5; x < this.dungeonX + 11; ++x) {
                    this.field_70170_p.func_147449_b(x, y, z, BlocksAether.locked_carved_stone);
                }
            }
        }
    }

    public void func_70108_f(Entity entity) {
        boolean flag;
        if (this.isAwake() && this.isMoving() && (flag = entity.func_70097_a((DamageSource)new EntityDamageSource("crush", (Entity)this), 6.0f)) && entity instanceof EntityLivingBase) {
            EntityLivingBase collidedEntity = (EntityLivingBase)entity;
            collidedEntity.func_70024_g(collidedEntity.field_70181_x, 0.35, collidedEntity.field_70179_y);
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "aether_legacy:aeboss.slider.collide", 2.5f, 1.0f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.stop();
        }
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        this.func_145779_a(Item.func_150898_a((Block)BlocksAether.carved_stone), 7 + this.field_70146_Z.nextInt(3));
        this.func_70099_a(new ItemStack(ItemsAether.dungeon_key), 0.5f);
    }

    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (stack.field_77994_a != 0 && stack.func_77973_b() != null) {
            EntityAetherItem entityitem = new EntityAetherItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)offsetY, this.field_70161_v, stack);
            if (this.captureDrops) {
                this.capturedDrops.add(entityitem);
            } else {
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            return entityitem;
        }
        return null;
    }

    public void stop() {
        this.setMoving(false);
        this.moveTime = 12;
        this.direction = EnumFacing.UP;
        this.velocity = 0.0f;
        this.field_70181_x = this.field_70179_y = (double)0.0f;
        this.field_70159_w = this.field_70179_y;
    }

    private void sendMessage(EntityPlayer player, String s) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (this.chatTime <= 0) {
            if (side.isClient()) {
                Aether.proxy.sendMessage(player, s);
            }
            this.chatTime = 60;
        }
    }

    public boolean func_70097_a(DamageSource ds, float var2) {
        double c;
        double a;
        if (ds.func_76346_g() == null || !(ds.func_76346_g() instanceof EntityPlayer) || ds.func_76352_a() || ds.func_82725_o() || ds.func_94541_c() || ds.func_76347_k()) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)ds.func_76346_g();
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        if (stack.func_77973_b() == Items.field_151034_e) {
            this.sendMessage(player, StatCollector.func_74838_a((String)"gui.slider.apple"));
            return false;
        }
        if (!((EntityPlayer)ds.func_76346_g()).field_71075_bZ.field_75098_d && ds.func_76364_f().func_70011_f(this.field_70165_t, this.field_70163_u, this.field_70161_v) > 6.0 && !this.isAwake()) {
            this.sendMessage(player, StatCollector.func_74838_a((String)"gui.slider.far"));
            return false;
        }
        boolean isTCPickaxe = stack.func_77973_b().getClass().getName().equals("tconstruct.items.tools.Pickaxe");
        if (!stack.func_77973_b().canHarvestBlock(Blocks.field_150348_b, stack) && !isTCPickaxe) {
            this.sendMessage(player, StatCollector.func_74838_a((String)"gui.slider.notpickaxe"));
            return false;
        }
        boolean flag = super.func_70097_a(ds, Math.max(0.0f, var2));
        if (flag) {
            for (int size = 0; size < (this.func_110143_aJ() <= 0.0f ? 2 : 4); ++size) {
                double a2 = this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 1.5;
                double b = this.field_70121_D.field_72338_b + 1.75;
                double c2 = this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 1.5;
                if (this.func_110143_aJ() <= 0.0f) {
                    this.field_70170_p.func_72869_a("explode", a2, b, c2, 0.0, 0.0, 0.0);
                }
                for (int j = 0; j < 4; ++j) {
                    for (int k = 0; k < 4; ++k) {
                        for (int l = 0; l < 4; ++l) {
                            double d0 = ((double)j + 0.5) / 4.0;
                            double d1 = ((double)k + 0.5) / 4.0;
                            double d2 = ((double)l + 0.5) / 4.0;
                            this.field_70170_p.func_72869_a("blockcrack_" + Blocks.field_150348_b + "_0", a2 + d0, b + d1, c2 + d2, d0 - 0.5, d1 - 0.5, d2 - 0.5);
                        }
                    }
                }
            }
            if (this.func_110143_aJ() <= 0.0f || this.field_70128_L) {
                this.openDoor();
                this.unlockBlock(this.dungeonX, this.dungeonY, this.dungeonZ);
                this.field_70170_p.func_147465_d(this.dungeonX + 7, this.dungeonY + 1, this.dungeonZ + 7, Blocks.field_150415_aT, 3, 2);
                this.field_70170_p.func_147465_d(this.dungeonX + 8, this.dungeonY + 1, this.dungeonZ + 7, Blocks.field_150415_aT, 2, 2);
                this.field_70170_p.func_147465_d(this.dungeonX + 7, this.dungeonY + 1, this.dungeonZ + 8, Blocks.field_150415_aT, 3, 2);
                this.field_70170_p.func_147465_d(this.dungeonX + 8, this.dungeonY + 1, this.dungeonZ + 8, Blocks.field_150415_aT, 2, 2);
                PlayerAether.get(player).setFocusedBoss(null);
                List<?> dungeonPlayers = this.getPlayersInDungeon(player);
                for (int i = 0; i < dungeonPlayers.size(); ++i) {
                    Entity entity = (Entity)dungeonPlayers.get(i);
                    if (!(entity instanceof EntityPlayer)) continue;
                    ((EntityPlayer)entity).func_71029_a((StatBase)AchievementsAether.defeat_bronze);
                }
                player.func_71029_a((StatBase)AchievementsAether.defeat_bronze);
                this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "aether_legacy:aeboss.slider.death", 2.5f, 1.0f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                this.func_70106_y();
            }
            if (!this.isAwake()) {
                this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "aether_legacy:aeboss_slider.awaken", 2.5f, 1.0f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                this.func_70624_b((EntityLivingBase)player);
                this.closeDoor();
                this.setAwake(true);
            }
            if (this.isMoving()) {
                this.velocity *= 0.75f;
            }
        }
        if ((a = Math.abs(this.field_70165_t - player.field_70165_t)) > (c = Math.abs(this.field_70161_v - player.field_70161_v))) {
            this.hurtAngleZ = 1.0f;
            this.hurtAngleX = 0.0f;
            if (this.field_70165_t > player.field_70165_t) {
                this.hurtAngleZ = -1.0f;
            }
        } else {
            this.hurtAngleX = 1.0f;
            this.hurtAngleZ = 0.0f;
            if (this.field_70161_v > player.field_70161_v) {
                this.hurtAngleX = -1.0f;
            }
        }
        this.hurtAngle = 0.7f - this.func_110143_aJ() / 875.0f;
        PlayerAether.get(player).setFocusedBoss(this);
        return flag;
    }

    private void unlockBlock(int x, int y, int z) {
        Block block = this.field_70170_p.func_147439_a(x, y, z);
        if (block == BlocksAether.locked_carved_stone || block == BlocksAether.locked_sentry_stone) {
            this.field_70170_p.func_147449_b(x, y, z, ((BlockDungeonBase)block).getUnlockedBlock());
            this.unlockBlock(x + 1, y, z);
            this.unlockBlock(x - 1, y, z);
            this.unlockBlock(x, y + 1, z);
            this.unlockBlock(x, y - 1, z);
            this.unlockBlock(x, y, z + 1);
            this.unlockBlock(x, y, z - 1);
        }
    }

    protected void func_85033_bc() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b((double)0.2f, 0.0, (double)0.2f));
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                this.func_70108_f(entity);
            }
        }
    }

    public boolean func_70692_ba() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70024_g(double d, double d1, double d2) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
    }

    public void func_70653_a(Entity par1Entity, float par2, double par3, double par5) {
    }

    public void reset() {
        this.moveTime = 0;
        this.stop();
        this.openDoor();
        this.setAwake(false);
        this.func_70624_b(null);
        this.func_70606_j(this.func_110138_aP());
        this.func_70634_a(this.dungeonX + 8, this.dungeonY + 2, this.dungeonZ + 8);
    }

    public List<?> getPlayersInDungeon(EntityPlayer player) {
        return this.field_70170_p.func_72839_b((Entity)player, AxisAlignedBB.func_72330_a((double)this.dungeonX, (double)this.dungeonY, (double)this.dungeonZ, (double)this.dungeonX, (double)this.dungeonY, (double)this.dungeonZ).func_72314_b(10.0, 10.0, 10.0));
    }

    public void setDungeon(double posX, double posY, double posZ) {
        this.dungeonX = (int)posX;
        this.dungeonY = (int)posY;
        this.dungeonZ = (int)posZ;
    }

    public void setAwake(boolean isAwake) {
        this.field_70180_af.func_75692_b(18, (Object)new Byte(isAwake ? (byte)1 : 0));
    }

    public boolean isAwake() {
        return this.field_70180_af.func_75683_a(18) == 1;
    }

    public void setMoving(boolean moving) {
        this.field_70180_af.func_75692_b(20, (Object)new Byte(moving ? (byte)1 : 0));
    }

    public boolean isMoving() {
        return this.field_70180_af.func_75683_a(20) == 1;
    }

    public String getName() {
        return this.field_70180_af.func_75681_e(19);
    }

    public void setBossName(String name) {
        this.field_70180_af.func_75692_b(19, (Object)name);
    }

    @Override
    public String getBossName() {
        return this.field_70180_af.func_75681_e(19) + ", " + StatCollector.func_74838_a((String)"title.aether_legacy.slider.name");
    }

    @Override
    public float getBossHealth() {
        return this.func_110143_aJ();
    }

    @Override
    public float getMaxBossHealth() {
        return this.func_110138_aP();
    }

    public boolean func_90999_ad() {
        return false;
    }
}

