/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.client.renders.entity;

import com.gildedgames.the_aether.Aether;
import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.client.models.entities.OldZephyrModel;
import com.gildedgames.the_aether.client.models.entities.ZephyrModel;
import com.gildedgames.the_aether.entities.hostile.EntityZephyr;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class ZephyrRenderer
extends RenderLiving {
    private static final ResourceLocation TEXTURE = Aether.locate("textures/entities/zephyr/zephyr_main.png");
    private static final ResourceLocation TEXTURE_ADDON = Aether.locate("textures/entities/zephyr/zephyr_layer.png");
    private static final ResourceLocation TEXTURE_OLD = Aether.locate("textures/entities/zephyr/zephyr_old.png");

    public ZephyrRenderer() {
        super(AetherConfig.oldMobsEnabled() ? new OldZephyrModel() : new ZephyrModel(), 0.5f);
    }

    protected void renderZephyrMovement(EntityZephyr zephyr, float partialTickTime) {
        float f1 = ((float)zephyr.prevAttackCounter + (float)(zephyr.attackCounter - zephyr.prevAttackCounter) * partialTickTime) / 20.0f;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        f1 = 1.0f / (f1 * f1 * f1 * f1 * f1 * 2.0f + 1.0f);
        float f2 = (8.0f + f1) / 2.0f;
        float f3 = (8.0f + 1.0f / f1) / 2.0f;
        GL11.glScalef((float)f3, (float)f2, (float)f3);
        GL11.glTranslated((double)0.0, (double)0.5, (double)0.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (AetherConfig.oldMobsEnabled()) {
            GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
            GL11.glTranslated((double)0.0, (double)-0.1, (double)0.0);
        }
    }

    protected int renderLayers(EntityZephyr entity, int pass, float particleTicks) {
        if (entity.func_82150_aj()) {
            return 0;
        }
        if (pass == 1) {
            GL11.glEnable((int)2977);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (this.field_77046_h != this.field_77045_g) {
                this.func_77042_a(this.field_77045_g);
            }
            this.func_110776_a(TEXTURE_ADDON);
            return 1;
        }
        return -1;
    }

    protected int func_77032_a(EntityLivingBase entity, int pass, float particleTicks) {
        return this.renderLayers((EntityZephyr)entity, pass, particleTicks);
    }

    protected void func_77041_b(EntityLivingBase zephyr, float partialTickTime) {
        this.renderZephyrMovement((EntityZephyr)zephyr, partialTickTime);
    }

    protected ResourceLocation func_110775_a(Entity zephyr) {
        return AetherConfig.oldMobsEnabled() ? TEXTURE_OLD : TEXTURE;
    }
}

