/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.client.renders.entity;

import com.gildedgames.the_aether.Aether;
import com.gildedgames.the_aether.client.models.entities.MoaModel;
import com.gildedgames.the_aether.entities.passive.mountable.EntityMoa;
import com.gildedgames.the_aether.entities.util.AetherMoaTypes;
import com.gildedgames.the_aether.player.PlayerAether;
import com.gildedgames.the_aether.player.perks.util.DonatorMoaSkin;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class MoaRenderer
extends RenderLiving {
    private static final ResourceLocation TEXTURE_OUTSIDE = Aether.locate("textures/entities/moa/canvas/moa_outside.png");
    private static final ResourceLocation TEXTURE_EYE = Aether.locate("textures/entities/moa/canvas/moa_eye.png");
    private static final ResourceLocation TEXTURE_BODY = Aether.locate("textures/entities/moa/canvas/moa_body.png");
    private static final ResourceLocation TEXTURE_MARKINGS = Aether.locate("textures/entities/moa/canvas/moa_markings.png");
    private static final ResourceLocation TEXTURE_WING = Aether.locate("textures/entities/moa/canvas/moa_wing.png");
    private static final ResourceLocation TEXTURE_WING_MARKINGS = Aether.locate("textures/entities/moa/canvas/moa_wing_markings.png");
    private static final ResourceLocation TEXTURE_UNCHANGED = Aether.locate("textures/entities/moa/canvas/moa_unchanged.png");
    private static final ResourceLocation SADDLE = Aether.locate("textures/entities/moa/moa_saddle.png");
    private static final ResourceLocation BLACK_SADDLE = Aether.locate("textures/entities/moa/black_moa_saddle.png");
    private static final ResourceLocation MOS = new ResourceLocation("aether_legacy", "textures/entities/moa/mos.png");
    private static final ResourceLocation RAPTOR = new ResourceLocation("aether_legacy", "textures/entities/moa/raptor.png");

    public MoaRenderer() {
        super((ModelBase)new MoaModel(0.0f), 1.0f);
        this.func_77042_a(new MoaModel(0.5f));
    }

    protected void func_77036_a(EntityLivingBase entity, float p_77036_2_, float p_77036_3_, float p_77036_4_, float p_77036_5_, float p_77036_6_, float p_77036_7_) {
        EntityMoa moa = (EntityMoa)entity;
        if (!entity.func_82150_aj()) {
            if (!(moa.field_70153_n instanceof EntityPlayer)) {
                this.func_110776_a(this.func_110775_a((Entity)entity));
                this.field_77045_g.func_78088_a((Entity)moa, p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_);
            } else {
                PlayerAether playerAether = PlayerAether.get((EntityPlayer)moa.field_70153_n);
                if (playerAether.donatorMoaSkin != null && !playerAether.donatorMoaSkin.shouldUseDefualt()) {
                    DonatorMoaSkin skin = playerAether.donatorMoaSkin;
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                    this.func_110776_a(TEXTURE_UNCHANGED);
                    this.field_77045_g.func_78088_a((Entity)moa, p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_);
                    this.func_110776_a(TEXTURE_WING_MARKINGS);
                    GL11.glColor3f((float)MoaRenderer.r(skin.getWingMarkingColor()), (float)MoaRenderer.g(skin.getWingMarkingColor()), (float)MoaRenderer.b(skin.getWingMarkingColor()));
                    this.field_77045_g.func_78088_a((Entity)moa, p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_);
                    this.func_110776_a(TEXTURE_WING);
                    GL11.glColor3f((float)MoaRenderer.r(skin.getWingColor()), (float)MoaRenderer.g(skin.getWingColor()), (float)MoaRenderer.b(skin.getWingColor()));
                    this.field_77045_g.func_78088_a((Entity)moa, p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_);
                    this.func_110776_a(TEXTURE_MARKINGS);
                    GL11.glColor3f((float)MoaRenderer.r(skin.getMarkingColor()), (float)MoaRenderer.g(skin.getMarkingColor()), (float)MoaRenderer.b(skin.getMarkingColor()));
                    this.field_77045_g.func_78088_a((Entity)moa, p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_);
                    this.func_110776_a(TEXTURE_BODY);
                    GL11.glColor3f((float)MoaRenderer.r(skin.getBodyColor()), (float)MoaRenderer.g(skin.getBodyColor()), (float)MoaRenderer.b(skin.getBodyColor()));
                    this.field_77045_g.func_78088_a((Entity)moa, p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_);
                    this.func_110776_a(TEXTURE_EYE);
                    GL11.glColor3f((float)MoaRenderer.r(skin.getEyeColor()), (float)MoaRenderer.g(skin.getEyeColor()), (float)MoaRenderer.b(skin.getEyeColor()));
                    this.field_77045_g.func_78088_a((Entity)moa, p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_);
                    this.func_110776_a(TEXTURE_OUTSIDE);
                    GL11.glColor3f((float)MoaRenderer.r(skin.getOutsideColor()), (float)MoaRenderer.g(skin.getOutsideColor()), (float)MoaRenderer.b(skin.getOutsideColor()));
                    this.field_77045_g.func_78088_a((Entity)moa, p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_);
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    this.func_110776_a(this.func_110775_a((Entity)entity));
                    this.field_77045_g.func_78088_a((Entity)moa, p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_);
                }
            }
        } else {
            this.field_77045_g.func_78087_a(p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_, (Entity)entity);
        }
    }

    protected int renderLayer(EntityMoa entity, int pass, float particleTicks) {
        if (pass == 0 && entity.isSaddled()) {
            GL11.glTranslatef((float)0.0f, (float)0.02f, (float)0.0f);
            this.func_110776_a(entity.getMoaType() == AetherMoaTypes.black ? BLACK_SADDLE : SADDLE);
            return 1;
        }
        return -1;
    }

    protected int func_77032_a(EntityLivingBase entity, int pass, float particleTicks) {
        return this.renderLayer((EntityMoa)entity, pass, particleTicks);
    }

    protected float getWingRotation(EntityMoa moa, float f) {
        float f1 = moa.prevWingRotation + (moa.wingRotation - moa.prevWingRotation) * f;
        float f2 = moa.prevDestPos + (moa.destPos - moa.prevDestPos) * f;
        return (MathHelper.func_76126_a((float)f1) + 1.0f) * f2;
    }

    protected float func_77044_a(EntityLivingBase entityliving, float f) {
        return this.getWingRotation((EntityMoa)entityliving, f);
    }

    protected void scaleMoa(EntityMoa entityMoa) {
        float moaScale = entityMoa.func_70631_g_() ? 1.0f : 1.8f;
        GL11.glScalef((float)moaScale, (float)moaScale, (float)moaScale);
    }

    protected void func_77041_b(EntityLivingBase entityliving, float f) {
        this.scaleMoa((EntityMoa)entityliving);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        PlayerAether player;
        EntityMoa moa = (EntityMoa)entity;
        if (moa.field_70153_n instanceof EntityPlayer && (player = PlayerAether.get((EntityPlayer)moa.field_70153_n)) != null && !player.donatorMoaSkin.shouldUseDefualt()) {
            return null;
        }
        if (moa.func_94056_bM() && "Mos".equals(moa.func_94057_bL()) && moa.getMoaType() == AetherMoaTypes.orange) {
            return MOS;
        }
        if (moa.func_94056_bM() && "Raptor__".equals(moa.func_94057_bL()) && moa.getMoaType() == AetherMoaTypes.blue) {
            return RAPTOR;
        }
        return moa.getMoaType().getTexture(moa.isSaddled(), moa.field_70153_n != null);
    }

    private static float r(int r) {
        return (float)(r >> 16 & 0xFF) / 255.0f;
    }

    private static float g(int g) {
        return (float)(g >> 8 & 0xFF) / 255.0f;
    }

    private static float b(int b) {
        return (float)(b & 0xFF) / 255.0f;
    }
}

